//======================================================================
/**
 * @file	seqeditor.cpp
 * @brief	SequenceEditort@Cǂݍ
 * @author	ariizumi
 * @data	11/8/1
 */
//======================================================================

#include <gflib.h>
#include "tool/seqeditor/seq_editor.h"
#include "tool/seqeditor/seq_file.h"

namespace tool
{
namespace seqeditor
{

SeqSystem::SeqSystem( const InitParam &param )
:mHeapMem( param.heapMem )
,mCommandArr(param.commandArr)
,mCommandNum(param.commandNum)
{
  
}

SeqFile* SeqSystem::LoadFile( gfl::fs::ArcFile *arc , gfl::fs::ArcFile::ARCDATID arcId )
{
  SeqFile *file = GFL_NEW(mHeapMem) SeqFile(this,mHeapMem,arc,arcId);
  
  mFileList.push_back( file );
  
  return file;
}

SeqFile* SeqSystem::LoadPcFile( wchar_t *path )
{
  SeqFile *file = GFL_NEW(mHeapMem) SeqFile(this,mHeapMem,path);

  mFileList.push_back( file );
  
  return file;
}

void SeqSystem::UnLoad( SeqFile* file )
{
  
}

void SeqSystem::UnLoadAll(void)
{
}

void SeqSystem::UpdateFrame( const int step )
{
  for( int i=0;i<step;i++ )
  {
    for (SeqFileList::Iterator it = mFileList.begin(); it != mFileList.end();)
    {
      SeqFileList::Iterator currIt = it++;
      SeqFile *node = &(*currIt);
      node->UpdateFrame();
    }
  }
}
  
};
};
