//======================================================================
/**
 * @file  ari_seq_test.h
 * @brief LeXgFog
 * @author  ariizumi
 * @data  11/05/16
 */
//======================================================================

#include <gflib.h>

#include "ari_seq_test.h"



namespace test
{
namespace ariizumi
{

void CommandCallback01( tool::seqeditor::SeqFile *file , void *userWork , const tool::seqeditor::CommandParam &param );

void CommandCallback01( tool::seqeditor::SeqFile *file , void *userWork , const tool::seqeditor::CommandParam &param )
{
  int val;
  file->LoadDataInt( &val );
  
  GFL_PRINT("CommandCallBack [%d]-[%d][%d]\n",param.startFrame,param.endFrame,val);
}

static const tool::seqeditor::SEQEDITOR_COMMAND_FUNC comArr[] =
{
  CommandCallback01,
};

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SequenceEditorTestProc::InitFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );
  
  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

#if GFL_HIO_ENABLE
  gfl::fs::FileSystem::InitializeHio( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ) );
#endif
  
  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_TEST_ARIIZUMI    , 0x500000  , gfl::heap::HEAP_TYPE_EXP );
  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_TEST_ARIIZUMI_DEV, 0x500000 , gfl::heap::HEAP_TYPE_EXP );


  tool::seqeditor::InitParam initParam =
  {
    mHeapMem,
    comArr,
    sizeof(comArr)
  };

  mSeqSys = GFL_NEW(mHeapMem)tool::seqeditor::SeqSystem(initParam);
  mSeqSys->LoadPcFile( L"C:/home/xy_tools/SequenceEditor/project/vs2008/test.bseq" );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result SequenceEditorTestProc::EndFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );

  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SequenceEditorTestProc::UpdateFunc(gfl::proc::Manager* pManager)
{
  static int step = 0;
  GFL_PRINT("[%d]------------------\n",step);
  step++;
  mSeqSys->UpdateFrame();

 return gfl::proc::RES_CONTINUE;
}

void SequenceEditorTestProc::DrawFunc(gfl::proc::Manager* pManager)
{


}
  
  
}//namespace test
}//namespace ariizumi
