//======================================================================
/**
 * @file	seqfile.h
 * @brief	SequenceEditorXNvgt@C
 * @author	ariizumi
 * @data	11/8/1
 */
//======================================================================

#ifndef __SEQFILE_H__
#define __SEQFILE_H__

#include <gflib.h>

namespace tool
{
namespace seqeditor
{

class SeqSystem;

class SeqFile
{
public:
  SeqFile( SeqSystem *system , gfl::heap::HeapBase *heapMem , gfl::fs::ArcFile *arc , gfl::fs::ArcFile::ARCDATID arcId );
  SeqFile( SeqSystem *system , gfl::heap::HeapBase *heapMem , wchar_t *path );
  
  ~SeqFile();
  
  void UpdateFrame();

  //f[^擾n
  void LoadDataInt( int *data , bool isStep = true );
  void LoadDatau16( u16 *data , bool isStep = true );
  
  //[U[[NZbg
  void SetUserWork( void *work ){ mUserWork = work; }
  
  //FX肻Ȃ̂public
  nw::ut::LinkListNode mNode;
private:

  void InitLoadData(void);
  void LoadHeader(void);

  void *mSeqData;
  char *mLoadPos;

  int mFrame;
  bool mIsFinish;
  
  SeqSystem *mSystem;
  void *mUserWork;
  
};

  
};
};

#endif //__SEQFILE_H__

