//======================================================================
/**
 * @file	seqeditor.h
 * @brief	SequenceEditort@Cǂݍ
 * @author	ariizumi
 * @data	11/8/1
 */
//======================================================================

#ifndef __SEQEDITOR_H__
#define __SEQEDITOR_H__

#include <gflib.h>
#include "tool/seqeditor/seq_file.h"


#if defined(DEBUG_ONLY_FOR_ariizumi_nobuhiko)
#define SEQ_EDITOR_DEBUG 1
#else
#define SEQ_EDITOR_DEBUG 0
#endif

namespace tool
{
namespace seqeditor
{

typedef nw::ut::LinkList<SeqFile,offsetof(SeqFile,mNode)> SeqFileList;

typedef struct
{
  int startFrame;
  int endFrame;
  int groupNo;
}CommandParam;
  
typedef void(*SEQEDITOR_COMMAND_FUNC)( SeqFile *file , void *userWork , const CommandParam &param );

typedef struct
{
  gfl::heap::HeapBase *heapMem;
  const SEQEDITOR_COMMAND_FUNC *commandArr;
  int commandNum;

}InitParam;

class SeqSystem
{
public:
  SeqSystem( const InitParam &param );
  
  SeqFile* LoadFile( gfl::fs::ArcFile *arc , gfl::fs::ArcFile::ARCDATID arcId );
  SeqFile* LoadPcFile( wchar_t *path );

  void UnLoad( SeqFile* file );
  void UnLoadAll(void);
  
  void UpdateFrame( const int step = 1 );
  
  //R}he[uƌ
  const SEQEDITOR_COMMAND_FUNC* GetCommandTable(void){return mCommandArr;}
  int GetCommandNum(void){return mCommandNum;}
  
private:
  gfl::heap::HeapBase *mHeapMem;
  
  //R}he[uƌ
  const SEQEDITOR_COMMAND_FUNC *mCommandArr;
  int mCommandNum;
  
  SeqFileList mFileList;

};

  
};
};

#endif //__SEQEDITOR_H__

