#include "GLWidget.h"

// -----------------------------------------------------------------------------
// Construct
// -----------------------------------------------------------------------------
kawaigari::GLWidget::GLWidget( QWidget* parent )
: gfl::qt::GLWidget( parent ), m_ObjectShow( 0 ) { }

// -----------------------------------------------------------------------------
// Destruct
// -----------------------------------------------------------------------------
kawaigari::GLWidget::~GLWidget( ) { }

#if 0 // 
//==============================================================================
//==============================================================================
void kawaigari::GLWidget::keyPressEvent( QKeyEvent* ky )
{
	s32 id;
	switch( ky->key( ) ){
	case Qt::Key_D:
		id = proj::motion::LoveBase::LOVE_DELIGHT;
		break;
	case Qt::Key_L:
		id = proj::motion::LoveBase::LOVE_LISTEN;
		break;
	case Qt::Key_S:
		id = proj::motion::LoveBase::LOVE_SLEEP;
		break;
	case Qt::Key_N:
		id = proj::motion::LoveBase::LOVE_NOIDEA;
		break;
	case Qt::Key_H:
		id = proj::motion::LoveBase::LOVE_HATE;
		break;
	case Qt::Key_P:
		id = proj::motion::LoveBase::LOVE_PURU;
		break;
	case Qt::Key_Delete:
		Player::GetInstance( )->DestroyLove( );
	default:
		return;
	}
	Player::GetInstance( )->CreateLove( id );
}
#endif

// ---------------------------------------------------------------------------
// Render
// ---------------------------------------------------------------------------
void kawaigari::GLWidget::Render( const GLenum mode )
{
	if( mode == GL_SELECT ){
		return;
	}

	PawnTask::GetInstance( )->Update( );
	MotionProc::MainFunc( ); // ɁI

	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	SetLight( );

	MainWindow* main_win = MainWindow::GetInstance( );
	// FPS ̍XV
	main_win->_pFPS->setText( QString( "FPS %1" ).arg( _CurrentFPS ) );

	// J]
	//	if( main_win->_pAutoCamera->checkState( ) ){
	//		( ( Camera* )GetCamera( ) )->AutoCamera( );
	//	}

	glLoadMatrixf( GetCamera( )->_Matrix.Get( ) ); // J̃}gbNX[h

	gfl::qt::Render::Axis( METER( 1.0f ) );

	proj::motion::Terrain::GetInstance( )->Render( );

	// [VXV
	kawaigari::MotionProc::MainFunc( );

	if( m_ObjectShow ){
		glPushMatrix( );
		glTranslatef( m_ObjectPosition.GetX( ), m_ObjectPosition.GetY( ), m_ObjectPosition.GetZ( ) );
		glutWireSphere( METER( 0.07f ) * m_ObjectScale, 16, 8 );
		glPopMatrix( );
	}

	//	GetCamera()->_Trans.PrintConsole("trans");

	kawaigari::Player* pl = kawaigari::Player::GetInstance( );
	
	if(!pl) return ;
	
	proj::motion::Joint* jnt = pl->GetJoint<proj::motion::Joint*>( 1 );
	const size_t ofs = GFL_OFFSET_OF( proj::motion::Joint, _Matrix );
	for( s32 i = 1; i < pl->GetJointCount( ); ++i, ++jnt ){
		//		if( mode == GL_SELECT ){
		//			name->_JointId = i;
		//			glLoadName( name->_Name );
		//		}

		glPushMatrix( );

		glMultMatrixf( ( f32* )GFL_GET_POINTER_BY_OFFSET( jnt, gfl::core::Matrix, ofs ) );

		// 
		f32 len = jnt->_Length;

		Bone bone;
		bone.SetSize( len, len * 0.2f, len * 0.15f ); // {͏݂̂łǁc
		bone.Render( );
		//		Ex::Render::Bone( len, len * 0.2f, len * 0.15f, type, jnt->_IkType ? Ex::Render::PCOL_BLUE : Ex::Render::PCOL_WHITE );

		// 
		//		Ex::Render::Axis( METER( 0.1f ) );

		glPopMatrix( );
	}
}
void kawaigari::GLWidget::mousePressEvent( QMouseEvent *event )
{
	Player* pl = Player::GetInstance( );
	pl->SetTouch( true );
	pl->SetTouching( true );
	pl->SetReleased( false );
	gfl::qt::GLWidget::mousePressEvent( event );
}
void kawaigari::GLWidget::mouseMoveEvent( QMouseEvent *event )
{
	Player* pl = Player::GetInstance( );
	pl->SetTouchX(event->x());
	pl->SetTouchY(event->y());
}
void kawaigari::GLWidget::mouseReleaseEvent( QMouseEvent *event )
{
	Player* pl = Player::GetInstance( );
	pl->SetTouch( false );
	pl->SetTouching( false );
	pl->SetReleased( true );

	gfl::qt::GLWidget::mouseReleaseEvent( event );
}
