//======================================================================
/**
 * @file	kimura_main.cpp
 * @brief	ؑeXgC
 * @author	kimura
 * @data	11/01/27
 */
//======================================================================

gfl::proc::Result kawaigari::MainProc::InitFunc( gfl::proc::Manager* )
{
	gfl::heap::NwAllocator* heap_allocator;
	gfl::heap::NwAllocator* device_allocator;

	Graphic::CreateAllocator( &heap_allocator, &device_allocator );

	gfl::heap::HeapBase* heap = heap_allocator->GetHeapBase( );

	Graphic* gra = Graphic::CreateInstance( heap );
	gra->SetHeapAllocator( heap_allocator );
	gra->SetDeviceAllocator( device_allocator );
	gra->InitFunc( );
	proj::motion::Terrain::CreateInstance( heap )->Load( "kawaigari/collision02.col", heap );
	MotionProc::InitFunc( ); // ɁI

	PawnTask* pt = PawnTask::CreateInstance( heap );
#if GFL_PAWN_DEBUG
//	pt->CreateHost( heap );
#    endif

#    if 1 //def DEBUG_ONLY_FOR_kimura_shin
	size_t size;
	void* data = gfl::core::File::Load( "kawaigari/Love.amx", heap, &size );
	pt->Load( data, size );
#    endif

	return gfl::proc::RES_FINISH;
}
/**
 * C֐
 * @param pManager
 * @return
 */
gfl::proc::Result kawaigari::MainProc::UpdateFunc( gfl::proc::Manager* )
{
	PawnTask* tp = PawnTask::GetInstance( );
	switch( m_EndStep ){
	case END_NONE:
		if(tp){
			tp->Update( );
		}
		MotionProc::MainFunc( ); // ɁI
		Graphic::GetInstance( )->MainFunc( );

		if( Player::GetInstance()->m_pButton->IsTrigger(gfl::ui::BUTTON_Y) ){
			m_EndStep = END_REQUEST;
		}
		break;
#if GFL_PAWN_DEBUG
	case END_REQUEST:
		if( tp->GetHost( )->GetHostWrite( )->SendTerminationToClient( ) ){
			proj::motion::Terrain::DestroyInstance( );
			MotionProc::EndFunc( );
			m_EndStep = END_WAIT;
		}
		break;
	case END_WAIT:
		if( tp->GetHost( )->IsTerminated( ) ){
//			tp->GetHost( )->Finalize();
			GFL_DELETE [] tp->GetBuffer();
			PawnTask::DestroyInstance();
			return gfl::proc::RES_FINISH;
		}
#    else // 
	case END_REQUEST:
		proj::motion::Terrain::DestroyInstance( );
		MotionProc::EndFunc( );
		GFL_DELETE [] tp->GetBuffer();
		PawnTask::DestroyInstance();
		return gfl::proc::RES_FINISH;
#    endif
	}

	return gfl::proc::RES_CONTINUE;
}
void kawaigari::MainProc::DrawFunc( gfl::proc::Manager* )
{
	Graphic::GetInstance( )->DrawFunc( );
}
/**
 * I
 * @param pManager
 * @return
 */
gfl::proc::Result kawaigari::MainProc::EndFunc( gfl::proc::Manager* )
{
	Graphic* gra = Graphic::GetInstance( );
	gra->EndFunc( );
	// 
	{
		gfl::heap::NwAllocator* ha = gra->GetHeapAllocator();
		gfl::heap::NwAllocator* da = gra->GetDeviceAllocator();
		
		Graphic::DestroyInstance();
		
		gfl::heap::HeapBase* local_heap_memory = ha->GetHeapBase( );
		gfl::heap::HeapBase* local_device_memory = da->GetHeapBase( );

		// AP[^
		GFL_DELETE da;
		GFL_DELETE ha;

		gfl::heap::Manager::DeleteHeap( local_device_memory );
		gfl::heap::Manager::DeleteHeap( local_heap_memory );
	}

	// Y`FbN
	Graphic::DumpMemory( "[The End Of Love]" );

	return gfl::proc::RES_FINISH;
}
