#ifndef __GFLLLLLL_
#define __GFLLLLLL_
//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		GflG3dSimple.h
 *	@brief  gflibg3dCu͂߂̈
 *	@author	Koji Kawada
 *	@date		2011.02.07
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>
#include <gfl_Heap.h>
#include <gfl_Base.h>
#include <gfl_debug.h>
#include <ui/ctr/gfl_UI_CTR_DeviceManager.h>
#include <gfl_Grp.h>

// xy_project

#define USE_DEBUG_PAD 0 //  DEBUG_ONLY_FOR_kimura_shin

// `
#define GFL_G3D_SIMPLE_USE_DEBUG_CAMERA (1)   // 0̂ƂfobOJgȂA1̂ƂfobOJg

GFL_NAMESPACE_BEGIN( kawaigari )

//-----------------------------------------------------------------------------
/**
 *					NX錾
 */
//-----------------------------------------------------------------------------

//-------------------------------------
///	PROCNX
//=====================================

class Graphic {

	GFL_SINGLETON( Graphic )
public:
	enum {
		TEX_EYE,
		TEX_MOUTH,
		TEX_MAX
	};

	explicit Graphic( gfl::heap::HeapBase* ) : m_heap_allocator( 0 ), m_resource_model( 0 ), m_DisplayMode(-1), m_ChangeCharacterId( 0 ), m_ChangeLoveId( 0 ) {
	}

	static void CreateAllocator( gfl::heap::NwAllocator **heap_allocator, gfl::heap::NwAllocator **device_allocator );
	void CreateCharacter( const u32 id );
	void DestroyCharacter( void );

	//------------------------------------------------------------------
	/**
	 * @brief	  PROC̏s֐
	 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
	 */
	//------------------------------------------------------------------
	gfl::proc::Result InitFunc( void );
	//------------------------------------------------------------------
	/**
	 * @brief	  PROC̃Cs֐
	 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
	 */
	//------------------------------------------------------------------
	gfl::proc::Result MainFunc( void );
	void DrawFunc( void );
	//------------------------------------------------------------------
	/**
	 * @brief	  PROC̏Is֐
	 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
	 */
	//------------------------------------------------------------------
	gfl::proc::Result EndFunc( void );

	gfl::heap::NwAllocator* GetHeapAllocator( ) const {
		return m_heap_allocator;
	}

	gfl::ui::CTR_DeviceManager* GetUiDeviceManager( ) const {
		return m_device_manager;
	}

	gfl::debug::DebugG3dStereoCameraChase* GetCamera( ) const {
		return m_camera;
	}

	void SetReloadCharacterId( s32 ReloadCharacterId ) {
		this->m_ReloadCharacterId = ReloadCharacterId;
	}

	s32 GetReloadCharacterId( ) const {
		return m_ReloadCharacterId;
	}

	void SetTextureAnimation( const s32 id ) {
		if( m_pTexAnime[id] ){
			m_pModel->ChangeAnimation( m_heap_allocator, m_pTexAnime[id], 0, id );
			m_pModel->SetAnimationLoop( false, id );
			m_pModel->SetAnimationEndFrame( 0.0f, id );
		}
	}

	void SetTextureAnimationFrame( const s32 id, const f32 frame ) {
		if( m_pTexAnime[id] ){
			m_pModel->SetAnimationEndFrame( frame, id );
			m_pModel->SetAnimationFrame( frame, id );
		}
	}

	void BlinkOpen( void ) {
		SetTextureAnimationFrame( TEX_EYE, (m_CharacterId == ID_PikachuTa) ? 0.0f : 0.0f );
	}

	void BlinkHalfOpen( void ) {
		SetTextureAnimationFrame( TEX_EYE, (m_CharacterId == ID_PikachuTa) ? 10.0f : 107.0f );
	}

	void BlinkClose( void ) {
		SetTextureAnimationFrame( TEX_EYE, (m_CharacterId == ID_PikachuTa) ? 20.0f : 110.0f );
	}

	void MouthOpen( void ) {
		SetTextureAnimationFrame( TEX_MOUTH, 10.0f );
	}
#if 0 // 

	void MouthHalfOpen( void ) {
		SetTextureAnimationFrame( TEX_MOUTH, 10.0f );
	}
#endif

	void MouthClose( void ) {
		SetTextureAnimationFrame( TEX_MOUTH, 0.0f );
	}

	void SetObjectPosition( const s32 id, const s32 num, const gfl::core::Vector3& pos );
	void ShowObject( const s32 id, const s32 num = 0, const bool flag = true );
	void SetBallScale( const f32 scl );

	gfl::grp::g3d::Model* GetModel( ) const {
		return m_pModel;
	}

    void SetDeviceAllocator( gfl::heap::NwAllocator* device_allocator ) {
    	this->m_device_allocator = device_allocator;
    }

    gfl::heap::NwAllocator* GetDeviceAllocator( void ) {
    	return m_device_allocator;
    }

   void SetHeapAllocator( gfl::heap::NwAllocator* heap_allocator ) {
    	this->m_heap_allocator = heap_allocator;
    }

    gfl::heap::HeapBase* GetHeapBase( ) const {
    	return m_heap_allocator->GetHeapBase();
    }

    s32 GetDisplayMode( ) const {
    	return m_DisplayMode;
    }

#if USE_NW_ANIM
	void InitializeAnimation( void );
	void SetAnimation( gfl::grp::g3d::Model* model, const s32 motnum );

	b32 m_NW;
#endif

	// Y`FbN
	static void DumpMemory( const char* message ); // s͂Ȃł

private:
	// AP[^
	gfl::heap::NwAllocator* m_heap_allocator;
	gfl::heap::NwAllocator* m_device_allocator;

	// ui
	gfl::ui::CTR_DeviceManager* m_device_manager;

	// OtBbNXVXe
	gfl::grp::GraphicsSystem* m_graphics_system;

	// g3d
	gfl::grp::g3d::System* m_system;
	gfl::grp::g3d::Scene* m_scene;
#if GFL_G3D_SIMPLE_USE_DEBUG_CAMERA
	//			gfl::debug::DebugG3dStereoCamera* m_camera;
	gfl::debug::DebugG3dStereoCameraChase* m_camera;
#else
	gfl::grp::g3d::StereoCamera* m_camera;
#endif
	//	gfl::grp::g3d::Camera* m_camera_control;
	gfl::grp::g3d::Resource* m_resource_array;
	gfl::grp::g3d::Resource* m_resource_model;

	gfl::grp::g3d::Model* m_pModel;

	gfl::grp::g3d::Resource* m_resource_texanime[TEX_MAX];
	gfl::grp::g3d::ResAnim *m_pTexAnime[TEX_MAX];

	// ȈՕ`
	void* m_font_data; // tHg̃oCi

	enum {
		ANIM_WALK,
		ANIM_IDLE,
		ANIM_RUN,
		ANIM_MAX,
	};
	//			gfl::grp::g3d::ResAnim* m_pAnim[ANIM_MAX];

	s32 m_ReloadCharacterId;
	s32 m_DisplayMode;
public: // fobOpȂ̂ŗǂ
	s32 m_ChangeCharacterId;
	s32 m_ChangeLoveId;
	s32 m_CharacterId;
};

GFL_NAMESPACE_END( kawaigari )

#endif
