//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		GflG3dSimple.cpp
 *	@brief  gflibg3dCu͂߂̈
 *	@author	Koji Kawada
 *	@date		2011.02.07
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>
#include <gfl_Heap.h>
#include <gfl_Base.h>
#include <gfl_debug.h>
#include <ui/ctr/gfl_UI_CTR_DeviceManager.h>
#include <gfl_Grp.h>

// xy_project
#include <system/main.h>           // HEAP_DEFINE

#include "Graphic.h"
#include <gamesystem/GameManager.h>

#define USE_TERRAIN 1
#define USE_BALL 0

namespace kawaigari {

	GFL_SINGLETON_SUBSTANCE( Graphic )

	// \[X
	enum {
		//			RESOURCE_MODEL,
		//			RESOURCE_ANIME0,
		//			RESOURCE_ANIME1,
		//			RESOURCE_ANIME2,
		RESOURCE_LIGHT,
		RESOURCE_SCENE_ENVIRONMENT_SETTING,
#if USE_TERRAIN
		RESOURCE_TERRAIN,
#endif
#if USE_BALL
		RESOURCE_BALL,
#endif
		RESOURCE_DISH,
		RESOURCE_FOOD,
		RESOURCE_BUTTON,
		//			RESOURCE_TERRAIN_TEXTURE,
		RESOURCE_MAX
	};

	static const char* RESOURCE_MODEL_FILES[ID_MAX] = {
#define SET_CHARA(name,txt) #name,
#include "../Character.h"
	};

	static const char* RESOURCE_FILES[RESOURCE_MAX] = {
		//			"rom:/""kawada/pokabuta_texconb_onlyp_toon2_1/pokabuta_texconb_onlyp.bcres",
		"rom:/g3d_sample_data/FragmentLight.bcenv",
		"rom:/g3d_sample_data/SceneEnvironmentSetting.bcenv",
#if USE_TERRAIN
		"rom:/kawaigari/collision02.bcmdl",
#endif
#if USE_BALL
		"rom:/kawaigari/Ball.bcmdl",
#endif
		"rom:/kawaigari/Ball.bcmdl",
		"rom:/kawaigari/Pofin.bcmdl",
		"rom:/kawaigari/Button_eat.bcmdl",
		//			"rom:/kawaigari/xy_testmap_tex.bcmdl",
	};
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::CreateAllocator( gfl::heap::NwAllocator** heap_allocator, gfl::heap::NwAllocator** device_allocator )
{
	//	if( !GetHeapAllocator( ) ){
	// 
	gfl::heap::HeapBase* heap_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
	gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

	gfl::heap::HeapBase* local_heap_memory = gfl::heap::Manager::CreateHeap(
																			 heap_memory, HEAPID_KIMURATEST_HEAP,
																			 /*0x700000*/
																			 heap_memory->GetTotalAllocatableSize( ) - ( 1024 * 1024 )
																			 , gfl::heap::HEAP_TYPE_EXP );
	gfl::heap::HeapBase* local_device_memory = gfl::heap::Manager::CreateHeap(
																			 device_memory, HEAPID_KIMURATEST_DEVICE,
																			 /*0x2800000*/
																			 device_memory->GetTotalAllocatableSize( ) - ( 1024 * 1024 )
																			 , gfl::heap::HEAP_TYPE_EXP );

#if GFL_HIO_ENABLE
	//ʗ̈悩HEAPmہBȂȂςĂB
	gfl::fs::FileSystem::InitializeHio( gfl::heap::Manager::GetHeapByHeapId( HEAPID_DEVICE ) );
	//gfl::hio::Host::InitializeHio( local_device_memory );
#endif

	// AP[^
	*heap_allocator = GFL_NEW( local_heap_memory ) gfl::heap::NwAllocator( local_heap_memory );
	*device_allocator = GFL_NEW( local_device_memory ) gfl::heap::NwAllocator( local_device_memory );
	//	}
}

#if USE_NW_ANIM
void kawaigari::Graphic::InitializeAnimation( void )
{
	// Aj[Vfɓo^
	for( s32 i = 0; i < ANIM_MAX; ++i ){
		gfl::grp::g3d::ResAnim* ResAnim = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::ResAnim( );
		m_pAnim[i] = ResAnim;
		ResAnim->Create( m_heap_allocator, &m_resource_array[RESOURCE_ANIME0 + i], 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
	}
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::SetAnimation( gfl::grp::g3d::Model* model, const s32 motnum )
{
	model->ChangeAnimation( m_heap_allocator, m_pAnim[motnum] );
	model->SetAnimationLoop( true );
}

#endif

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result kawaigari::Graphic::InitFunc( void )
{
	SetReloadCharacterId( ID_MAX );
	// Y`FbN
	DumpMemory( "[Start]" );

	// ui
	m_device_manager = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::ui::CTR_DeviceManager( m_heap_allocator->GetHeapBase( ) );

	// OtBbNXVXe
	//	gfl::grp::GraphicsSystemSetUp setup = gfl::grp::GraphicsSystemSetupDefault;
	//	setup.useUpperRight = true; // ̎
	//	setup.stereoOn = true;
	//	m_graphics_system = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::GraphicsSystem( m_heap_allocator, m_device_allocator, &setup );
	m_graphics_system = gamesystem::GameManager::GetInstance( )->GetGraphicsSystem( );
	m_graphics_system->InitializeApplicationMemory( m_device_allocator );

	// g3d
	m_system = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::System( m_heap_allocator, m_device_allocator );
	gfl::grp::g3d::Scene::Description sceneDesc;
	sceneDesc.scene_draw_group_num = 3;
	m_scene = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Scene( m_device_allocator, &sceneDesc );

	gfl::grp::RenderTarget::Description upperdRtDesc, lowerRtDesc;
	lowerRtDesc.color_area = gfl::grp::MEMORY_AREA_VRAMB;
	lowerRtDesc.depth_area = gfl::grp::MEMORY_AREA_VRAMB;
	m_scene->CreateEdgeMapSystem( m_heap_allocator, m_device_allocator, 1, &upperdRtDesc, &lowerRtDesc );

	gfl::grp::g3d::G3DPostEffectSystem::Description EffDesc;
	EffDesc.edge_draw_group_id = 2;
	EffDesc.bloom_filter_enable = false;
	EffDesc.edge_enable = true;
	EffDesc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DEFAULT_EDGE;
	m_scene->CreatePostEffectSystem( m_heap_allocator, m_device_allocator, &EffDesc );

	// J
#if GFL_G3D_SIMPLE_USE_DEBUG_CAMERA 
	m_camera = GFL_NEW( m_device_allocator->GetHeapBase( ) ) gfl::debug::DebugG3dStereoCameraChase( );
#else
	m_camera = GFL_NEW( m_device_allocator->GetHeapBase( ) ) gfl::grp::g3d::StereoCamera( );
#endif 
	m_camera->Create(
					 m_device_allocator,
					 gfl::math::VEC3( 0.0f, 0.0f, 500.0f ),
					 gfl::math::VEC3( 0.0f, 10.0f, 0.0f )
					 );
	m_camera->SetParameterRotate( gfl::math::VEC3( -26.0f, 0.0f, 0.0f ) );
	m_camera->SetParameterTargetDistance( 200.0f );
	m_camera->SetParameterTargetOffsetY( 0.0f );
	m_scene->AddSceneNode( m_camera );

	// \[X
	m_resource_array = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Resource[RESOURCE_MAX];
	for( s32 i = 0; i < RESOURCE_MAX; ++i ){
		m_resource_array[i].LoadAndSetup( m_device_allocator, RESOURCE_FILES[i] );
	}
	for( s32 i = 0; i < RESOURCE_MAX; ++i ){
		m_scene->BuildSceneUsingResource( m_device_allocator, m_device_allocator, &( m_resource_array[i] ) );
	}

	m_scene->SwitchEdgeMapModel( m_scene->GetOwnModel( m_resource_array[RESOURCE_DISH].GetId( ), 0 ), true );
	m_scene->SwitchEdgeMapModel( m_scene->GetOwnModel( m_resource_array[RESOURCE_FOOD].GetId( ), 0 ), true );
	m_scene->SwitchEdgeMapModel( m_scene->GetOwnModel( m_resource_array[RESOURCE_FOOD].GetId( ), 1 ), true );
	m_scene->SwitchEdgeMapModel( m_scene->GetOwnModel( m_resource_array[RESOURCE_FOOD].GetId( ), 2 ), true );

	ShowObject( OBJ_DISH, 0, false );
	ShowObject( OBJ_FOOD, 0, false );
	ShowObject( OBJ_BUTTON, 0, false );

	// 
	m_scene->Initialize( );

	// Jʒu𐢊EWɂ邽߂ɈxXVĂ
	m_scene->Calculate( );

	// V[ݒ
	m_scene->SetSceneEnvironmentUsingOwnObject( );

	// Jݒ
	gfl::grp::g3d::Camera::SetCameraAspectRatio( m_camera->GetBaseCamera( )->GetNwCamera( ), 400.0f / 240.0f );

	m_camera->SetPivotDirection( gfl::math::PIVOT_UPSIDE_TO_TOP );
	//	m_camera->SetAspect( 320.0f / 240.0f );

	CreateCharacter( ID_PikachuTa );
	//	CreateCharacter( ID_xy_heroine001 );

#if USE_NW_ANIM
	InitializeAnimation( );
	m_NW = true;
#endif
	//ʏōs܂̂GraphcsSystemʉĂAriizumi11/06/02
	//	gfl::grp::util::DrawUtil::Initialize( m_graphics_system, m_heap_allocator, m_device_allocator );

	//ʏōs܂Ariizumi11/06/02
	/*
		{
			gfl::fs::RomFile file;
			bool open_result = file.Open( L"rom:/cbf_std.bcfnt", gfl::fs::OPEN_MODE_READ );
			GFL_ASSERT( open_result ); // t@CI[vɎs
			size_t file_size = file.GetSize( );
			m_font_data = m_device_allocator->Alloc( file_size, 128 );
			size_t read_size = file.Read( m_font_data, file_size );
			GFL_ASSERT( read_size == file_size ); // ǂݍ݂Ɏs
			file.Close( );
		}
	 */
	//ʏōs܂̂GraphcsSystemʉĂAriizumi11/06/02
	//	gfl::grp::util::DrawUtil::SetFontResource( m_font_data );
	return gfl::proc::RES_FINISH;
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::CreateCharacter( const u32 id )
{
	// f\[X
	m_resource_model = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Resource;
	c8 fname[0x100];
	strcpy( fname, "rom:/kawaigari/" );
	strcat( fname, RESOURCE_MODEL_FILES[id] );
	strcat( fname, ".bcmdl" );
	m_resource_model->LoadAndSetup( m_device_allocator, fname );

	// [V
	strcpy( fname, "kawaigari/" );
	strcat( fname, RESOURCE_MODEL_FILES[id] );
	strcat( fname, ".gmp" );
	Player* pl = Player::CreateInstance( m_heap_allocator->GetHeapBase( ) );
	pl->Initialize( id, fname, m_heap_allocator->GetHeapBase( ) );

	static const c8 * const TEX_TBL[] = {
		"_eye",
		"_mouth"
	};

	// eNX`[Aj[V
	if( id == ID_PikachuTa ){
#if 0 // 
		for( s32 i = 0; i < TEX_MAX; ++i ){
			m_resource_texanime[i] = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Resource;
			strcpy( fname, "rom:/kawaigari/" );
			strcat( fname, RESOURCE_MODEL_FILES[id] );
			strcat( fname, TEX_TBL[i] );
			strcat( fname, ".bcmtsa" );
			m_resource_texanime[i]->LoadAndSetup( m_device_allocator, fname );
			gfl::grp::g3d::ResAnim* ResAnim = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::ResAnim( );
			m_pTexAnime[i] = ResAnim;
			ResAnim->Create( m_heap_allocator, m_resource_texanime[i], 0, gfl::grp::g3d::ResAnim::TYPE_MATERIAL );
		}
#else // 
		for( s32 i = 0; i < TEX_MAX; ++i ){
			m_resource_texanime[i] = 0;
			m_pTexAnime[i] = 0;
		}
#endif
		pl->m_LoveCoe = 1.0f;
		pl->m_LoveLimitCoe = 1.0f;

		//		GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 100.0f, 85.0f ), gfl::math::VEC3( 0.0f, 38.0f, 0.0f ) );
		GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 97.0f, 173.0f ), gfl::math::VEC3( 0.0f, 30.0f, 0.0f ) );
	} else if( id == 0 ){
		for( s32 i = 0; i < TEX_MAX; ++i ){
			m_resource_texanime[i] = 0;
			m_pTexAnime[i] = 0;
		}

		pl->m_LoveCoe = 1.65f;
		pl->m_LoveLimitCoe = 0.7f;

		GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 65.0f, 81.0f ), gfl::math::VEC3( 0.0f, 40.0f, 0.0f ) );
	} else {
		s32 i = 0;
		m_resource_texanime[i] = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Resource;
		strcpy( fname, "rom:/kawaigari/" );
		strcat( fname, RESOURCE_MODEL_FILES[id] );
		strcat( fname, TEX_TBL[i] );
		strcat( fname, ".bcmtsa" );
		m_resource_texanime[i]->LoadAndSetup( m_device_allocator, fname );
		gfl::grp::g3d::ResAnim* ResAnim = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::ResAnim( );
		m_pTexAnime[i] = ResAnim;
		ResAnim->Create( m_heap_allocator, m_resource_texanime[i], 0, gfl::grp::g3d::ResAnim::TYPE_MATERIAL );

		m_pTexAnime[TEX_MOUTH] = 0;

		pl->m_LoveCoe = 1.65f;
		pl->m_LoveLimitCoe = 0.7f;

		GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 235.0f, 261.0f ), gfl::math::VEC3( 0.0f, 99.0f, 0.0f ) );
	}
	// f̈ʒuύX
	//	m_pModel =  m_scene->GetOwnModel( m_resource_model->GetId( ), 0 );
	m_pModel = GFL_NEW( m_heap_allocator->GetHeapBase( ) ) gfl::grp::g3d::Model;
	m_pModel->Create( m_heap_allocator, m_device_allocator, m_resource_model, 0 );
	m_pModel->SetTranslate( 0.0f, 0.0f, 0.0f );
	// V[ݒ
	m_scene->AddSceneNode( m_pModel );
	m_scene->SwitchEdgeMapModel( m_pModel, true );
	m_scene->Initialize( );
	m_scene->SetSceneEnvironmentUsingOwnObject( );

	for( s32 i = 0; i < TEX_MAX; ++i ){
		SetTextureAnimation( i );
	}

	m_CharacterId = id;
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::DestroyCharacter( void )
{
	if( m_resource_model ){
		m_scene->RemoveSceneNode( m_pModel );
		m_scene->Initialize( );
		GFL_DELETE m_pModel;
		GFL_DELETE m_resource_model;
		m_resource_model = 0;
	}
	Player::DestroyInstance( );
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result kawaigari::Graphic::MainFunc( void )
{
	//	do{

	// ui
	m_device_manager->Main( );

	if( GetReloadCharacterId( ) != ID_MAX ){
		DestroyCharacter( );
		CreateCharacter( GetReloadCharacterId( ) );
		SetReloadCharacterId( ID_MAX );
	}

	// J̍XV
	PlayerCamera* cam = PlayerCamera::GetInstance( );
	Player* pl = Player::GetInstance( );

	// J
#if GFL_G3D_SIMPLE_USE_DEBUG_CAMERA
#    if 0 //!USE_DEBUG_PAD
	if( 1/*cam->IsControllable( ) && pl->m_pButton->GetHold()*/ ){
		cam->Update( );
		//			cam->_Interest.PrintConsole("int");
		gfl::math::VEC3 tag( cam->_Interest.GetX( ), cam->_Interest.GetY( ), cam->_Interest.GetZ( ) );
		//gfl::math::VEC3 tag;
		//GetCamera( )->GetTargetPosition( tag );
		m_camera->Control( m_device_manager, tag );
	}
#    endif
#else //
#    if USE_DEBUG_PAD
	m_camera->SetCameraAndTargetPosition(
										 gfl::math::VEC3( cam->_Trans.GetX( ), cam->_Trans.GetY( ), cam->_Trans.GetZ( ) ),
										 gfl::math::VEC3( cam->_Interest.GetX( ), cam->_Interest.GetY( ), cam->_Interest.GetZ( ) )
										 );
#    endif
#endif 
	//		gfl::grp::g3d::Model* model = m_scene->GetOwnModel( m_resource_model->GetId(), 0 );

#if USE_NW_ANIM
	//		gfl::core::Matrix* mp = pl->GetMotion( )->GetJoint<Joint*>( )->GetMatrix( );

	if( m_NW ){
		Joint* jnt = GetMoveJoint( );
		gfl::core::Matrix* mmp = jnt->GetMatrix( );

		//			bool changed = false;
		static s32 old_num = -1;
		s32 num = pl->GetMotionNumber( ) - c000_walk;
		if( old_num != num ){
			if( old_num == -1 ){ // oỎ
				SetAnimation( model, 0 );
				old_num = 0;
			} else {
				SetAnimation( model, num );
				old_num = num;
			}
			//				changed = true;
		}

#    if 0 //
		static gfl::core::Vector3 v;
		if( !changed && num != ANIM_IDLE ){
			gfl::core::Matrix rot_mat;
			rot_mat.SetRotateZYX( *pl->GetRootRotation( ) );
			rot_mat.Apply( &v, *jnt->GetMotionMatrix( )->GetTrans( ) );
		}
		gfl::core::Debug::PrintConsole( "%d %f %f %f - %f %f\n", num, GetFrame( ), mmp->GetTransX( ), mmp->GetTransZ( ), v.GetX( ), v.GetZ( ) );

		model->SetTranslate( mmp->GetTransX( ) - v.GetX( ),
							 pl->GetYPos( mmp->GetTransX( ), mmp->GetTransZ( ) ),
							 mmp->GetTransZ( ) - v.GetZ( )
							 );
#    else //
		model->SetTranslate( mmp->GetTransX( ),
							 pl->GetYPos( mmp->GetTransX( ), mmp->GetTransZ( ) ),
							 mmp->GetTransZ( )
							 );
#    endif
		model->SetRotateMatrix(
							 mmp->Get( 0, 0 ),
							 mmp->Get( 1, 0 ),
							 mmp->Get( 2, 0 ),
							 mmp->Get( 0, 1 ),
							 mmp->Get( 1, 1 ),
							 mmp->Get( 2, 1 ),
							 mmp->Get( 0, 2 ),
							 mmp->Get( 1, 2 ),
							 mmp->Get( 2, 2 )
							 );


		model->SetAnimationFrame( GetFrame( ) );
	}
#endif

	if( pl && pl->GetValue( ) ){
#if 0 //USE_BALL
		gfl::grp::g3d::Model* ball_model = m_scene->GetOwnModel( m_resource_array[RESOURCE_BALL].GetId( ), 0 );
		ball_model->SetTranslate( pl->GetInterestPosition( )->GetX( )
								 , pl->GetInterestPosition( )->GetY( )
								 , pl->GetInterestPosition( )->GetZ( ) );
#endif
#if 0 // 
		if( pl->GetTouch( ) ){

			gfl::math::VEC3 cam_pos, int_pos;
			m_camera->GetCameraAndTargetPosition( cam_pos, int_pos );
			cam_pos.Report( true, "camera" );
			int_pos.Report( true, "interest" );

#    if 0 // 		
			gfl::core::Vector3 cp, ip;
			cp.FromVEC3( cam_pos );
			ip.FromVEC3( int_pos );

			pl->GetJointByName<proj::motion::Joint*>( "J_head" )->GetMatrix( )->GlobalToLocal( &cp, cp );
			pl->GetJointByName<proj::motion::Joint*>( "J_head" )->GetMatrix( )->GlobalToLocal( &ip, ip );
			cp.PrintConsole( "cam" );
			ip.PrintConsole( "int" );
#    endif
			//				pl->SetInterest( pl->GetMotion( )->IsLooking( ) ? 0 : pl->GetInterestPosition( ) );
			//#else // 
			//				gfl::math::VEC3 cam_pos;
			//				m_camera->GetCameraPosition( cam_pos );
			//				pl->SetInterest( gfl::core::Vector3( cam_pos.x, cam_pos.y, cam_pos.z ) );
		}
#endif

		// V[XV܂B
		m_scene->Calculate( );

		// V[̍XV̌ザȂƑʖ
#if USE_NW_ANIM
		if( !m_NW ){
#endif
			pl->ToModel( m_pModel );
#if USE_NW_ANIM
		}
#endif
	} else {
		m_scene->Calculate( );
	}
	// _ɈˑXVRenderQueue̍\zs
	m_scene->SubmitView( m_camera );
	m_scene->SubmitViewOfEdge( m_camera );

	return gfl::proc::RES_CONTINUE;
}
void kawaigari::Graphic::DrawFunc( void )
{
	//	m_graphics_system->StartRendering( );

#if 0 // 
	// 
	gfl::grp::RenderTarget* upper_frame_buffer = m_graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
	m_graphics_system->BindCurrentCommandList( upper_frame_buffer );
	gfl::grp::util::DrawUtil::BeginRender( upper_frame_buffer );
	gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4( 1.0f, 0.5f, 0.0f, 1.0f ) );
	gfl::grp::util::DrawUtil::SetTextScale( 1.0f, 1.0f );
	//		gfl::grp::util::DrawUtil::DrawText( 50, 50, L"`[gA%d", 6 );
	static const wchar_t* const CharNameTable[] = {
#    define SET_CHARA(name,text) L ## text,
#    include "../Character.h"
	};
	gfl::grp::util::DrawUtil::DrawText( 50, 50, CharNameTable[m_ChangeCharacterId] );
	static const wchar_t* const LoveNameTable[] = {
#    define SET_LOVE(name,text) L ## text,
#    include "../LoveDef.h"
	};

	gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4( 1.0f, 1.0f, 1.0f, 1.0f ) );
	gfl::grp::util::DrawUtil::DrawText( 50, 100, LoveNameTable[m_ChangeLoveId] );
	gfl::grp::util::DrawUtil::EndRender( );
#endif
	//		m_scene->GetNwRenderContext( )->ResetState( );

	kawaigari::PawnTask* pt = kawaigari::PawnTask::GetInstance( );
	Player* pl = Player::GetInstance( );
	if( pt && pt->IsAvailable( ) ){
		s32 pawn_mode = pt->GetGlobalParameterInteger( "p_DisplayMode" );
		if( m_DisplayMode != pawn_mode ){ // ʃ`FW
			m_DisplayMode = pawn_mode;
			if( pawn_mode == DISPLAY_UPPER ){
				GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 97.0f, 173.0f ), gfl::math::VEC3( 0.0f, 30.0f, 0.0f ) );
				//				GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 50.0f, 73.0f ), gfl::math::VEC3( 0.0f, 10.0f, 0.0f ) );
				// ʕ`
				m_camera->SetAspect( 400.0f / 240.0f );
				pl->GetRootPosition( )->SetZ( METER( -0.5f ) );
			} else {
				// ʕ`
				GetCamera( )->SetCameraAndTargetPosition( gfl::math::VEC3( 0.0f, 67.0f, 70.0f ), gfl::math::VEC3( 0.0f, 48.0f, 0.0f ) );
				m_camera->SetAspect( 320.0f / 240.0f );
				pl->GetRootPosition( )->SetZ( 0.0f );
				m_scene->GetOwnModel( m_resource_array[RESOURCE_BUTTON].GetId( ), 0 )->SetTranslate(
																									 -22.0f, 66.0f, 0.0f
																									 //				pt->GetGlobalParameterFloat( "p_DebugFloat0" ),
																									 //				pt->GetGlobalParameterFloat( "p_DebugFloat1" ),
																									 //				pt->GetGlobalParameterFloat( "p_DebugFloat2" )
																									 );
			}
			pl->GetRootPosition( )->SetX( 0.0f );
			pl->ResetSpring( );
		}

		gfl::grp::DisplayType mode;
		if( pawn_mode == DISPLAY_UPPER ){
			mode = gfl::grp::DISPLAY_UPPER;
		} else {
			mode = gfl::grp::DISPLAY_LOWER;
			if( pt->GetGlobalParameterInteger( "g_LoveMainMode" ) == MM_L_IDLE ){
				ShowObject( OBJ_BUTTON, 0, true );
			} else {
				ShowObject( OBJ_BUTTON, 0, false );
			}
		}

		m_scene->EdgeMapDraw( m_graphics_system, mode, m_camera );
		m_scene->Draw( m_graphics_system, mode, m_camera );
		m_scene->PostEffectDraw( m_graphics_system, mode, m_camera );
	}
	//		m_scene->StereoDraw( m_graphics_system, m_camera );

	// GL `łB
	nngxUpdateState( NN_GX_STATE_ALL );
#if 0 //
	u8 buffer_id[] = {
		gfl::grp::DISPLAY_UPPER,
		gfl::grp::DISPLAY_UPPER_RIGHT,
		gfl::grp::DISPLAY_LOWER
	};
	for( int i = 0; i < 3; ++i ){
		gfl::grp::RenderTarget* p_frame_buffer = m_graphics_system->GetCurrentFrameBuffer( ( gfl::grp::DisplayType )buffer_id[i] );
		const nw::gfx::FrameBufferObject& obj = p_frame_buffer->GetNWRenderTarget( )->GetBufferObject( );

		glBindFramebuffer( GL_FRAMEBUFFER, obj.GetFboID( ) );

		pl->GetGrid( )->Render( );
	}
#else //
	//		pl->GetGrid( )->Render( );
#endif
	//	m_graphics_system->EndRendering( );
	// `XV
	//	m_graphics_system->SwapBuffer( );

	//	nngxWaitVSync( NN_GX_DISPLAY_BOTH );

	// obt@Xbv
	//	m_graphics_system->VSyncAfter( );
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result kawaigari::Graphic::EndFunc( void )
{
	//	DestroyCharacter( );
	// g3d
	m_scene->DestroyOwnObject( );
	m_scene->RemoveAllSceneNodes( );
	GFL_DELETE_ARRAY m_resource_array;
	GFL_DELETE m_pModel;
	GFL_DELETE m_resource_model;
	for( s32 i = 0; i < TEX_MAX; ++i ){
		GFL_DELETE m_resource_texanime[i];
		GFL_DELETE m_pTexAnime[i];
	}
	GFL_DELETE m_camera;
	GFL_DELETE m_scene;
	GFL_DELETE m_system;

	// OtBbNXVXe
	//	GFL_DELETE m_graphics_system;
	m_graphics_system->FinalizeApplicationMemory( );
	// ui
	GFL_DELETE m_device_manager;

	return gfl::proc::RES_FINISH;
}

// Y`FbN
void kawaigari::Graphic::DumpMemory( const char* message ) // s͂Ȃł
{
	// 
	gfl::heap::HeapBase* heap_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
	gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

	// Y`FbN
	GFL_PRINT( "%s\n", message );
	GFL_PRINT( "heap_memory\n" );
	heap_memory->Dump( );
	GFL_PRINT( "\n" );
	GFL_PRINT( "device_memory\n" );
	device_memory->Dump( );
	GFL_PRINT( "\n" );
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::SetObjectPosition( const s32 id, const s32 num, const gfl::core::Vector3 & pos )
{
	gfl::grp::g3d::Model* model = m_scene->GetOwnModel( m_resource_array[RESOURCE_DISH + id].GetId( ), num );
	if( model ){
		model->SetTranslate( pos.GetX( ), pos.GetY( ), pos.GetZ( ) );
	}
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::ShowObject( const s32 id, const s32 num, const bool flag )
{
	gfl::grp::g3d::Model* model = m_scene->GetOwnModel( m_resource_array[RESOURCE_DISH + id].GetId( ), num );
	if( model ){
		model->SetVisible( flag );
	}
}

//==============================================================================
//==============================================================================
void kawaigari::Graphic::SetBallScale( const f32 scl )
{
	gfl::grp::g3d::Model* ball_model = m_scene->GetOwnModel( m_resource_array[RESOURCE_DISH].GetId( ), 0 );
	if( ball_model ){
		ball_model->SetScale( 1.0f, scl, 1.0f );
	}
}
