
#include "PlayerCamera.h"
#include "Player.h"
GFL_SINGLETON_SUBSTANCE( kawaigari::PlayerCamera )

//==============================================================================
//==============================================================================
kawaigari::PlayerCamera::PlayerCamera( gfl::heap::HeapBase* )
: _OffsetY( CENTI(20.0f) ), m_Controllable( true ) {
	_Interest.SetUnit();
	SetTransByInterest();
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::PlayerCamera::Update( void )
{
	Player* pl = Player::GetInstance( );

	if( !pl || !pl->GetData( ) ){
		return;
	}
#if USE_DEBUG_PAD
	nn::hid::DebugPadStatus* stat = pl->GetPadStatus( );

	_ControlRotationX += stat->rightStickY * 0.03f;
	_ControlRotationY -= stat->rightStickX * 0.03f;
	if( stat->hold & nn::hid::DEBUG_PAD_TRIGGER_R ){
		_ControlDistance += 0.5f;
	} else if( stat->hold & nn::hid::DEBUG_PAD_TRIGGER_L ){
		_ControlDistance -= 0.5f;
	}

	if( stat->hold & nn::hid::DEBUG_PAD_TRIGGER_ZR ){
		_OffsetY -= 0.1f;
	} else if( stat->hold & nn::hid::DEBUG_PAD_TRIGGER_ZL ){
		_OffsetY += 0.1f;
	}
#endif

	// mutex ?
	gfl::core::Matrix* mat = pl->GetMoveJoint( )->GetMatrix( );
	const f32 cx = mat->GetTransX( );
	const f32 cz = mat->GetTransZ( );

	const f32 cy = pl->GetYPos( cx, cz );
	_Interest.Set( cx, cy + _OffsetY, cz );
	SetTransByInterest( );
}
