/* 
 * File:   Player.h
 * Author: kimura_shin
 *
 * Created on 2010/12/09, 16:21
 */

#ifndef PLAYER_H
#define	PLAYER_H

#include "BaseCommandCharacter.h"
#include "PlayerCamera.h"

GFL_NAMESPACE_BEGIN( kawaigari )

class Player : public BaseCommandCharacter {
	GFL_SINGLETON( Player )
public:
	explicit Player(gfl::heap::HeapBase*){}
	virtual ~Player(void){}
	
	void Initialize( const u32 id, const c8 * const motname, gfl::heap::HeapBase* heap );
	void Update( void );

	enum {
		// Action_Run step
		ACT_RUN_INIT = 0,
		ACT_RUN_LOOP,
		ACT_RUN_END_WAIT,
		ACT_RUN_END
	};
	gfl::core::Vector3* GetInterestPosition( ) {
		return &_InterestPosition;
	}

protected:
	void SetLeverByVector( const f32 x, const f32 z );
	void SetLeverOff( void );
	void SetLeverDirection( void );
	void CheckLeverCommand( void );
	void AdjustRotationByLever( const f32 adjust_rate );
	void CommonAdjust( const u32 com );
	void AdjustControl( void );
	void CommonAction( const u32 com );
	void ActionControl( void );
	void Action_Run( void );
	bool CheckObstacle( void );
	void TestInterest( void );

private:
	gfl::core::Vector3 _InterestPosition; // test
	f32 _GlobalLeverRotation; // o[̐ΊpxOQ
	f32 _LeverRotation; // vC[݂Ẵo[̊pxOQ
	f32 _LeverRotationTarget; // Ȕꍇ̖ڕWpx@UɃo[̑ΊpxςĂ܂̂
	f32 _LeverSize; // o[X̑傫
	f32 _AdjustRotationRate;

	s32 _LeverOnFrame; // Oƃo[ĂȂ

	u16 _xxxx;
	u8 _Lever4Direction; // o[SɂȂl Gr::Utility::GR_DIR4_* Q
	u8 _Lever4DirectionTarget; // o[SɂȂl Gr::Utility::GR_DIR4_* Q Up
};

GFL_NAMESPACE_END( kawaigari )

#endif	/* PLAYER_H */
