#include "Player.h"
GFL_SINGLETON_SUBSTANCE( kawaigari::Player )

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::Player::Initialize( const u32 id, const c8 * const motname, gfl::heap::HeapBase* heap )
{
	// Init for motion
	InitializeMotion( gfl::core::File::Load( motname, heap ), heap );
	InitializeCommand( id ); // player must be 0

#ifdef USE_BONE_MODEL
	Joint* jnt = GetJoint<Joint*>( );
	for( s32 i = 0; i < GetJointCount( ); ++i, ++jnt ){
		const f32 len = jnt->_Length;
		jnt->_Bone.SetSize( len, len * 0.2f, len * 0.15f );
	}
#endif

	SetLeverOff( );

	_AdjustRotationRate = 0.2f;
}

// -----------------------------------------------------------------------------
// Set Lever Direction
// -----------------------------------------------------------------------------
void kawaigari::Player::SetLeverByVector( const f32 x, const f32 z )
{
	// o[̓͊px
	f32 y_ang = gfl::core::Math::FATan2( x, z );
	if( y_ang < 0.0f ){
		y_ang += gfl::core::Math::TWO_PI;
	}
	_GlobalLeverRotation = y_ang;

	//gfl::core::Motion* bd = GetMotion( );
	const f32 dir = gfl::core::Math::AddRadian( GetRootRotation( )->GetY( ),
											 GetMotionRotY( ) );

	f32 player_y_ang = gfl::core::Math::AddRadian( y_ang, -dir );
	if( player_y_ang < 0.0f ){
		player_y_ang += gfl::core::Math::TWO_PI;
	}

	_LeverRotation = player_y_ang;
	_Lever4Direction = ( u8 )gfl::core::Math::RoundRadianStep( player_y_ang, 4 );
	//	gfl::core::Debug::PrintConsole( "%f(%d,%d) %d\n", player_y_ang,GetPad()->GetAnalogData(0,0), GetPad()->GetAnalogData(0,1),_Lever4Direction );

	++_LeverOnFrame;
}

// -----------------------------------------------------------------------------
// Lever off
// -----------------------------------------------------------------------------
void kawaigari::Player::SetLeverOff( void )
{
	_LeverOnFrame = 0;
	_LeverRotation = 0.0f;
	_Lever4Direction = /*_Lever8Direction =*/ 0; //gfl::core::Pad::B_DIR4_FRONT;
}

// -----------------------------------------------------------------------------
// Set Lever Direction
// -----------------------------------------------------------------------------
void kawaigari::Player::SetLeverDirection( void )
{
#ifdef GFL_PLATFORM_PC
#    if 0 //
	gfl::core::Pad* pd = GetPad( );

	f32 x = ( f32 )pd->GetAnalogData( gfl::core::Pad::ANA_L, gfl::core::Pad::ANA_X );
	f32 y = ( f32 ) - pd->GetAnalogData( gfl::core::Pad::ANA_L, gfl::core::Pad::ANA_Y );
#    else //
	f32 x = 0.0f;
	f32 y = 0.0f;
#    endif
#elif USE_DEBUG_PAD
	nn::hid::DebugPadStatus* stat = GetPadStatus( );

	const f32 x = stat->leftStickX;
	const f32 y = -stat->leftStickY;
#else //
	const f32 x = m_pVector->GetX( );
	const f32 y = -m_pVector->GetY( );
#endif
	const f32 lever_size = gfl::core::Math::FSqrt( x * x + y * y );
	_LeverSize = lever_size;
	//	gfl::core::Debug::PrintConsole( "lev %f %f = %f %d\n", x, y, lever_size, _LeverOnFrame );

	//	if( _AnalogRange < lever_size ){
	if( 0.2f < lever_size ){
		gfl::core::Vector3 v;

#ifdef GFL_PLATFORM_PC
#elif USE_DEBUG_PAD
		v.Sub( PlayerCamera::GetInstance( )->_Trans, PlayerCamera::GetInstance( )->_Interest );
#else //
		gfl::math::VEC3 ct, it;
		Graphic::GetInstance( )->GetCamera( )->GetCameraAndTargetPosition( ct, it );
		ct -= it;
		v.Set( ct.x, ct.y, ct.z );
#endif

		//		f32 len = v.MagnitudeXZRecip( );
		f32 len = v.MagnitudeXZ( );
		if( len < CENTI( 1.0f ) ){
			SetLeverByVector( 0.0f, 1.0f );
			return;
		}
		len = gfl::core::Math::FRecip( len );
		f32 s = v.GetX( ) * len;
		f32 c = v.GetZ( ) * len;

		f32 vx = gfl::core::Math::GetX_RotateY_SinCosXZ( s, c, x, y );
		f32 vz = gfl::core::Math::GetZ_RotateY_SinCosXZ( s, c, x, y );

		SetLeverByVector( vx, vz );
		//			gfl::core::Debug::PrintConsole( "%f %f => %f %f %d\n", x, y, vx, vz, lever8 );
		//			gfl::core::Debug::PrintConsole( "lever(%d) %d %d\n", (s32)gfl::core::Math::RadianToDegree(player_y_ang) ,lever4, lever8 );
	} else {
		SetLeverOff( );
	}
}

// -----------------------------------------------------------------------------
// o[R}h`FbN
// -----------------------------------------------------------------------------
void kawaigari::Player::CheckLeverCommand( void )
{
	u32 tbl = _CurrentCommand.GetTable( );
	//	u32 motkind = GetMotionKind( );
	if( _LeverOnFrame ){ // o[Ă
		if( tbl != Command::TBL_RUN_BEGIN && CheckObstacle( ) ){
			_RequestCommand.SetCommand( Command::COM_IDLE );
			return;
		} else {
			const u32 com = _CurrentCommand.GetCommand( );
			u32 flag = 0;
			// ^[̏ꍇ̓[VIĂ瑖
			if( com == Command::COM_TURN && !CheckMotionStatus( M_MTS_CHANGEABLE ) ){
				return;
				// I肩isɏQ
			} else {
				// 蒆ɔΕ̃o[ꂽ瑖^[o
#if 0
				gfl::core::Debug::PrintConsole( "[%d]rot %f lever %f %d==%d %d==%d %d<%d\n", Gr::System::GetInstance( )->GetPowerOnFrames( ), GetRootRotationY( ), _LeverRotation,
											 _Lever4Direction, Gr::Utility::GR_B_DIR4_BACK,
											 Command::TBL_RUN_1, tbl,
											 _AnalogRange_Run0, _LeverSize );
#endif
				//				if( CheckTurnCommand( Command::TBL_TURN_90_L, Command::TBL_TURN_90_R, Command::TBL_TURN_180_L, Command::TBL_TURN_180_R ) ){
				//					return;
				//				}

				// o[ꂽ΂łȂAĂĂʂɋ߂ꍇ
				//				if( _LeverSize < _AnalogRange_Run0 ){ // x
				u32 new_tbl = (
#ifdef GFL_PLATFORM_PC
					1
#elif USE_DEBUG_PAD
					GetPadStatus( )->hold & nn::hid::DEBUG_PAD_BUTTON_B
#else //
					m_pButton->IsHold( gfl::ui::BUTTON_B )
#endif
					) ? Command::TBL_RUN_1 : Command::TBL_RUN_0;
				//				} else { // n
				//					tbl = Command::TBL_RUN_BEGIN;
				//				}
				if( com == Command::COM_RUN && tbl != new_tbl ){ // ̑̈ڍs
					flag = Command::CMF_NOT_CLEAR_STEP | Command::CMF_NOT_CLEAR_FRAME;
				}
				tbl = new_tbl;
			}

			_RequestCommand.SetCommandTable( Command::COM_RUN, tbl, flag );
		}
#if 0 // gf
	} else if( Command::TBL_RUN_1 == tbl ){
		if( _ActionStep == ACT_RUN_LOOP ){ // t[x点@^[̏
			_ActionStep = ACT_RUN_END_WAIT;
		} else {
			_RequestCommand.SetCommandTable( Command::COM_RUN_END, Command::TBL_RUN_END );
		}
#endif
		//	} else if( CheckMotionStatus( M_MTS_MOTION_END ) || ( motkind & MotionPara::M_MK_IDLE ) || ( ( motkind & MotionPara::M_MK_MOVING ) && ( motkind & MotionPara::M_MK_CHANGEABLE ) ) ){
	} else if( CheckMotionStatus( M_MTS_MOTION_END | M_MTS_CHANGEABLE ) ){
		_RequestCommand.SetCommand( Command::COM_IDLE );
	}
}

// -----------------------------------------------------------------------------
// Adjust Direction by Lever
// -----------------------------------------------------------------------------
void kawaigari::Player::AdjustRotationByLever( const f32 adjust_rate )
{
	if( _LeverOnFrame ){
#if 1 // ŏ\
		//		if( _CurrentCommand.GetFlag( ) & Command::CMF_FIRST_ATTACK ){
		//			_CurrentCommand.SetFlagOff( Command::CMF_FIRST_ATTACK );
		if( CheckCommandStatus( M_CMS_FIRST_ATTACK ) ){
			SetCommandStatusOff( M_CMS_FIRST_ATTACK );
			SetRootRotationY( _GlobalLeverRotation );
		} else {
			SetRootRotationY( gfl::core::Math::AdjustRadianGradually(
																	 GetRootRotationY( ),
																	 gfl::core::Math::AddRadian( _GlobalLeverRotation, -GetMotionRotY( ) ), adjust_rate
																	 /*,Gr::Math::ONE_PI * 0.1f*/ ) );
		}
#else // mH
		if( _CurrentCommand.GetFlag( ) & Command::CMF_FIRST_ATTACK ){
			_CurrentCommand.SetFlagOff( Command::CMF_FIRST_ATTACK );
			SetRootRotationY( _GlobalLeverRotation );
		} else {
			Gr::Quaternion tag, cur;
			tag.RadianYToQuaternion( _GlobalLeverRotation );
			cur.RadianYToQuaternion( GetRootRotationY( ) );
			cur.Slerp( tag, adjust_rate );
			SetRootRotationY( cur.QuaternionToRadianY( ) );
		}
#endif
	}
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
#define RUN_ADJ_RATE 0.2f
void kawaigari::Player::CommonAdjust( const u32 com )
{
	switch( com ){
	case Command::COM_RUN:
		//		if( CheckMotionKind( MotionPara::M_MK_RUN ) ){ // 胋[vő̂X邽߂̏
#if 0 //
	{
		const f32 old_y = GetRootRotationY( );
		AdjustRotationByLever( _AdjustRotateRate );
		const f32 old_diff = _DamageAdjustRotationY;
		// Õt[̑̂̌̍XɌXɉZ
		_DamageAdjustRotationY = Gr::Math::AddRadian( Gr::Math::AddRadian( ( Gr::Math::AddRadian( GetRootRotationY( ), -old_y ) ), -old_diff ) * RUN_ADJ_RATE, old_diff );
	} else {
		}
#endif
		AdjustRotationByLever( _AdjustRotationRate );
		//		}
		//		}
		break;
#if 0 //
	case Command::COM_STEP:
		AdjustRotationToOpponent( _AdjustRotateRate );
		break;
	case Command::COM_DAMAGE:
	case Command::COM_DOWN:
		if( !_ActionStep ){
			SetRootRotationY( Gr::Math::AddRadian( GetRootRotationY( ), _DamageAdjustRotationY ) );
			//			AdjustRotationToOpponent( );
		}
		break;
	case Command::COM_ATTACK_EX:
#    if 0 // like sneak kill version
		if( !_ActionStep ){
			AdjustPositionAndRotationToActionTarget( );
		}
#    else
		if( !_ActionStep ){
			AdjustRotationToActionTarget( 1.0f ); // PDÓAȂƂ
		}
#    endif
		break;
	case Command::COM_CHARGE:
		AdjustRotation( _AdjustRotateRate, _AdjustRotateRate );
		break;
	case Command::COM_ATTACK:
	case Command::COM_ATTACK_SHIFT:
		if( !CheckMotionStatus( M_MTS_CHANGEABLE ) && !_CurrentCommand.CheckFlag( Command::CMF_NOT_ADJUST_YANG )
			&& CheckJustFrameOrLess( GetFrame( ), _ColliBeginFrame ) ){
			//			AdjustRotation( 1.0f, _AttackAdjustRotateRate );
			if( _LeverOnFrame && !GetOpponent( ) ){
				AdjustRotationByLever( _AttackAdjustRotateRate );
			} else {
				AdjustRotationToAttackOpponent( );
			}
		}
		break;

	case Command::COM_IDLE:
		//		if( _CurrentCommand.GetTable( ) != Command::TBL_LOCK_IDLE || CheckStatusFlag( M_STF_TAR | M_STF_SMOKE ) ){
		if( !GetOpponent( ) ){
			break;
		}
		// through ...
	case Command::COM_MOVE:
#    ifndef TEST_JUST_GUARD
	case Command::COM_GUARD:
#    endif
		AdjustRotationToOpponent( _AdjustRotateRate );
		break;
	case Command::COM_JUMP:
		if( _CurrentCommand.GetTable( ) == Command::TBL_RUN_JUMP_END_RUN ){
			AdjustRotationByLever( _AdjustRotateRate );
		} else if( CheckMotionKind( MotionPara::M_MK_IGNORE_TRANS_Y )
			&& !CheckStatusFlag( M_STF_FALL ) ){ // o[ɂ鐧
			SetJumpSpeedXZ_ByLever( );
		}
		break;
	case Command::COM_HOLD:
		if( !CheckStatusFlag( M_STF_TOUCH ) && !_ActionStep ){
			TaskKbCharacterBase* op = GetActionTarget( );
			if( op ){
				SetRootPositionXZ( op->getPos( ), NOT_ROOT_TRANS_SMOOTH );
				AdjustRotationToPosition( reinterpret_cast < const Gr::Vector3& >( op->getPos( ) ), 1.0f );
			}
			//			AdjustRotationToActionTarget( 0.2f );
		}
		break;
	case Command::COM_TAR_MOVE:
		AdjustRotationByLever( _AdjustRotateRate * _TarMoveAdjustRate );
		SetNextCommandTable( Command::TBL_TAR_MOVE_LOOP );
		break;
#endif
	}
}

// -----------------------------------------------------------------------------
// Update Action
// -----------------------------------------------------------------------------
void kawaigari::Player::AdjustControl( void )
{
	// 󒆍W
	//	AirControl();

	CommonAdjust( _CurrentCommand.GetCommand( ) );
#if 0 //
	// ]␳
	CharacteristicAdjust( GetCurrentCommand( )->GetCommand( ) );

	// _Eɖ@ɑ̂̌X킹
	if( !AdjustRotationXZ_Down( ) && !CheckStatusFlag( M_STF_NOT_CLEAR_ROTATION_XZ ) ){
		SetRootRotationX( 0.0f );
		SetRootRotationZ( 0.0f );
	}
	//	if(!_Id)	GetRootRotation( )->PrintConsole( "rot" );
#endif
}

// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
void kawaigari::Player::Action_Run( void )
{
	//	gfl::core::Debug::PrintConsole( "run(%d) %d next %d (%f/%f)\n", _ActionStep, _CurrentCommand.GetTable( ),
	//								 _NextCommandTable, GetFrame( ), GetFrameCount( ) );
	//	SetMotionStatusOn( M_MTS_NO_IK_SLIDE_Y );
	SetAttributeOn( proj::motion::Motion::M_ATTR_NOT_SLIDE_Y );
	switch( _ActionStep ){
	case ACT_RUN_INIT:
	{
		const u32 tbl = _CurrentCommand.GetTable( );
		// ƂႪ݈ȊO̓Xebvi܂
#if 0 // gf
		if( tbl != Command::TBL_RUN_0 && tbl != Command::TBL_HOLD_MOVE_LOOP ){
			SetNextCommandTable( tbl + 1 );
			_ActionStep = ACT_RUN_LOOP;
		}
		SetCommandStatusOff( M_CMS_NOT_ADJUST_IK );
#else //
		SetCommandStatusOff( M_CMS_NOT_ADJUST_IK );
#endif
		//		_DamageAdjustRotationY = 0.0f;
		break;
	}
	case ACT_RUN_LOOP:
#if 0 //
		if( CheckMotionKind( MotionPara::M_MK_RUN ) ){
			RunDecline( _DamageAdjustRotationY * _RunDeclineScale ); //Gr::Math::OptimizeRadian( _RunAdjustRotationY * ( -5.0f ) );
		}
#endif
	case ACT_RUN_END_WAIT: // run_turn ̂ŕKv
		if( !_NextCommandTable ){
			u32 tbl = _CurrentCommand.GetTable( );
			if( tbl == Command::TBL_RUN_TURN ){
				_ActionStep = ACT_RUN_LOOP;
				tbl = Command::TBL_RUN_1;
			}
			SetNextCommandTable( tbl );
		}
	}
}

// -----------------------------------------------------------------------------
// Update Action
// -----------------------------------------------------------------------------
void kawaigari::Player::CommonAction( const u32 com )
{
	switch( com ){
	case Command::COM_IDLE:
		//		SetMotionStatusOff( M_MTS_NO_IK_SLIDE_Y );
		//		Action_
		break;
	case Command::COM_RUN:
		Action_Run( );
		break;
	}
}

// -----------------------------------------------------------------------------
// Update Action
// -----------------------------------------------------------------------------
void kawaigari::Player::ActionControl( void )
{
	const u32 com = _CurrentCommand.GetCommand( );
	if( com < Command::COM_COMMON_END ){
		CommonAction( com );
		//	} else {
		//		CharacteristicAction( com );
	}
}

//==============================================================================
//==============================================================================
void kawaigari::Player::TestInterest( void )
{
	static f32 x = 0.0f;
	static f32 y = 50.0f;
	static f32 z = 100.0f;
	static f32 spd_x = 2.0f;
	static f32 spd_y = 1.0f;
	static f32 spd_z = 1.0f;
	static s32 x_timer = 0;
	f32 lim_x = 100.0f;

	if( 30 < ++x_timer ){
		spd_x = -spd_x;
		x_timer = 0;
	}

	x += spd_x;
	if( lim_x < x ){
		spd_x = -spd_x;
		x = lim_x;
	} else if( x < -lim_x ){
		spd_x = -spd_x;
		x = -lim_x;
	}

	f32 lim_z = 100.0f;
	f32 lim_z_low = -70.0f;
	z += spd_z;
	if( lim_z < z ){
		spd_z = -spd_z;
		z = lim_z;
	} else if( z < lim_z_low ){
		spd_z = -spd_z;
		z = lim_z_low;
	}

	f32 lim_y = 80.0f;
	y += spd_y;
	if( lim_y < y ){
		spd_y = -spd_y;
		y = lim_y;
	} else {
		f32 lim_y_low = GetYPos( x, z );
		if( y < lim_y_low ){
			spd_y = -spd_y;
			y = lim_y_low;
		}
	}

	_InterestPosition.Set( x, y, z );
	//	SetInterest( &_InterestPosition );
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::Player::Update( void )
{
#if USE_DEBUG_PAD
	nn::hid::DebugPadStatus* stat = GetPadStatus( );
#    if 0 //
	if( stat->hold & nn::hid::DEBUG_PAD_BUTTON_PLUS ){
		if( CheckCommandStatus( BaseCommandCharacter::M_CMS_PAUSE ) ){
			SetCommandStatusOff( BaseCommandCharacter::M_CMS_PAUSE );
			gfl::core::Debug::PrintConsole( "Pause off\n" );
		} else {
			SetCommandStatusOn( BaseCommandCharacter::M_CMS_PAUSE );
			gfl::core::Debug::PrintConsole( "Pause on\n" );
		}
	}
#    else
	if( stat->hold & nn::hid::DEBUG_PAD_BUTTON_PLUS ){
		SetCommandStatusOn( BaseCommandCharacter::M_CMS_PAUSE );
	}
	if( stat->hold & nn::hid::DEBUG_PAD_BUTTON_MINUS ){
		SetCommandStatusOff( BaseCommandCharacter::M_CMS_PAUSE );
	}
#    endif
#elif  USE_NW_ANIM // Ƃ肠A{^ŔCVEFAƓƎ[`؂ւ
	if( m_pButton->IsTrigger( gfl::ui::BUTTON_A ) ){
		Graphic::GetInstance( )->m_NW ^= 1;
	}
#endif
	//	if( CheckCommandStatus( BaseCommandCharacter::M_CMS_PAUSE ) ){
#if GFL_PAWN_DEBUG
	if( PawnTask::GetInstance( ) && PawnTask::GetInstance( )->GetPause( ) ){
		return;
	}
#endif

#if 0 //  USE_DEBUG_PAD
	if( stat->hold & nn::hid::DEBUG_PAD_BUTTON_A ){
		SetFrameSpeed( GetFrameSpeed( ) + 0.01f );
	} else if( stat->hold & nn::hid::DEBUG_PAD_BUTTON_B ){
		SetFrameSpeed( GetFrameSpeed( ) - 0.01f );
	}
#endif

	//	GetRootPosition()->PrintConsole("root pos");
	//	GetRootRotation()->PrintConsole("root ang");

//	SetLeverDirection( );
	CheckLeverCommand( );
	CommandControl( );
	AdjustControl( );
	ActionControl( );

//	SetInterest(0);
//	SetAttributeOn( M_ATTR_STOP_SPRING );
//	TestInterest( ); // just test
	//	gfl::core::Debug::PrintConsole( "req %d %d\n", _RequestCommand.GetCommand(), _RequestCommand.GetTable() );
	//	gfl::core::Debug::PrintConsole( "cur %d %d\n", _CurrentCommand.GetCommand(), _CurrentCommand.GetTable() );
	//	gfl::core::Debug::PrintConsole( "mot[%d] %f/%f\n", GetMotionNumber( ), GetFrame( ), GetFrameCount( ) );

#if 0 //
	// fp
	Joint* jnt = GetJoint<Joint*>( );
	for( s32 i = 0; i < GetJointCount( ); ++i, ++jnt ){
		jnt->_OrgMatrix.Set( jnt->_Matrix );
	}
#endif

	//	GetRootPosition( )->PrintConsole( "pos" );
	//	GetJoint<Joint*>( Motion::JOINT_ROOT )->GetMatrix( )->GetTrans( )->PrintConsole( "jnt" );
	//	if( !CheckCommandStatus( M_CMS_NOT_ADJUST_IK ) )
	//	if( !( stat->hold & nn::hid::DEBUG_PAD_BUTTON_X ) ){
	//	} else {
	//		GetRootPosition( )->SetY( GetYPos( *GetJoint<Joint*>( Motion::JOINT_ROOT )->GetMatrix( )->GetTrans( ) ) );
	//	}

	UpdateMotion( );

	if( QueryEnd( ) ){
		// Ƃ肠c
//		if( CheckAttribute( proj::motion::Motion::M_ATTR_IDLE ) ){
//		if( _CurrentCommand.GetCommand() == Command::COM_IDLE ){
//			Repeat( );
//		}
		SetMotionStatusOn( M_MTS_CHANGEABLE|M_MTS_MOTION_END );
//		SetMotionStatusOn( M_MTS_MOTION_END );
	}
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
bool kawaigari::Player::CheckObstacle( void )
{
	//	gfl::core::Vector4* v = GetJoint<Joint*>( Motion::JOINT_ROOT )->GetMatrix( )->GetTrans( );
	//	return !Grid::GetInstance( )->CheckIn( v->GetX( ), v->GetZ( ), METER( -1.0f ) );
	return false;
}
