//==============================================================================
/**
 * @file	PawnTask.h
 * @brief	
 * @author	kimura_shin
 * @data	2011/06/07, 16:26
 */
// =============================================================================

#ifndef PAWNTASK_H
#define	PAWNTASK_H

#include <gflib.h>
#include <gfl_Pawn.h>

GFL_NAMESPACE_BEGIN( kawaigari )

class PawnTask : public gfl::pawn::Pawn {
public:
	GFL_SINGLETON( PawnTask )

	void Load( const void* buffer, const size_t size );
	
	PawnTask(gfl::heap::HeapBase* heap=0) : gfl::pawn::Pawn(heap), m_CameraStep(0) {}

	virtual ~PawnTask( void ) {
	}
	void Update( void );

	gfl::core::Vector3 m_CameraPosition;
	gfl::core::Vector3 m_InterestPosition;

	gfl::core::Vector3 m_CameraVelocity;
	gfl::core::Vector3 m_InterestVelocity;

	s32 m_CameraFrame;
	s32 m_CameraStep;

	enum {
		CAM_NONE,
		CAM_PUSH,
		CAM_PUSHED,
		CAM_POP,

		CAM_SMOOTH_FRAME = 16
	};
};

GFL_NAMESPACE_END( kawaigari )

#endif	/* PAWNTASK_H */

