//==============================================================================
/**
 * @file	PawnTask.cpp
 * @brief	
 * @author	kimura_shin
 * @data	2011/06/07, 16:28
 */
// =============================================================================

#include "PawnTask.h"
#include <sound/SEController.h>

GFL_SINGLETON_SUBSTANCE( kawaigari::PawnTask )

GFL_NAMESPACE_BEGIN( kawaigari )

static cell AMX_NATIVE_CALL GetCurrentHour( AMX *, const cell * )
{
	return 12;
}
static cell AMX_NATIVE_CALL GetLeaveTime( AMX *, const cell * )
{
	return 12;
}
static cell AMX_NATIVE_CALL SetLoveCommand( AMX *, const cell *val )
{
	// ͂Pn܂
	s32 mm = val[1];
	s32 sm = val[2];
	Player* pl = Player::GetInstance( );

	u8 tbl = 0;
	switch( mm ){
	case MM_U_IDLE:
	{
		static const u8 PawnLoveIdToCLoveId[] = {
			LoveBase::LOVE_NONE,
			LoveBase::LOVE_CAMERA,
			LoveBase::LOVE_WALK
		};
		if(!sm){
			gfl::core::Vector3 pos;
			LoveBase::GetCameraPosition(&pos);
			pos.GetRefY() -= METER(1.5f);
			pl->SetInterest( pos);
		}else if(sm == SM_UI_WALK){
			pl->SetInterest( 0 );
		}

		tbl = PawnLoveIdToCLoveId[sm];
		break;
	}
	case MM_U_BACK:
	{
		static const u8 PawnLoveIdToCLoveId[] = {
			LoveBase::LOVE_NONE,
			LoveBase::LOVE_LISTEN,
			LoveBase::LOVE_CAMERA,
			LoveBase::LOVE_CAMERA,
			LoveBase::LOVE_TURN,
			LoveBase::LOVE_WALK
		};
		if( !sm ){
			pl->SetRootRotationY( gfl::core::Math::ONE_PI );
		}
		tbl = PawnLoveIdToCLoveId[sm];
		break;
	}
	case MM_U_ROW:
		tbl = LoveBase::LOVE_ROW;
		break;
	case MM_U_SLEEP:
		tbl = LoveBase::LOVE_SLEEP;
		break;
	case MM_L_IDLE:
	{
		static const u8 PawnLoveIdToCLoveId[] = {
			LoveBase::LOVE_NONE,
			LoveBase::LOVE_LOOK,
		};

		tbl = PawnLoveIdToCLoveId[sm];

		break;
	}
	case MM_L_PEEP:
		tbl = LoveBase::LOVE_PEEP;
		break;
	case MM_L_TOUCH:
		tbl = (sm != SM_LT_NOIDEA)?LoveBase::LOVE_TOUCH:LoveBase::LOVE_NOIDEA;
		break;
	case MM_L_EAT:
	{
		static const u8 PawnLoveIdToCLoveId[] = {
			LoveBase::LOVE_EAT_IDLE,
			LoveBase::LOVE_EAT,
			LoveBase::LOVE_HATE,
			LoveBase::LOVE_DELIGHT,
			LoveBase::LOVE_NOIDEA,
		};

		tbl = PawnLoveIdToCLoveId[sm];

		break;
	}
	case MM_L_LOOK:
	{
		static const u8 PawnLoveIdToCLoveId[] = {
			LoveBase::LOVE_LOOK,
			LoveBase::LOVE_HAND,
			LoveBase::LOVE_DELIGHT,
			LoveBase::LOVE_NOIDEA,
		};

		tbl = PawnLoveIdToCLoveId[sm];

		break;
	}
	}
	if( tbl ){
		pl->CreateLove( tbl );
	} else {
		pl->DestroyLove( );
		pl->SetForceCommand( Command::COM_IDLE );
	}
	return sm;
}
static cell AMX_NATIVE_CALL CheckLoveCommand( AMX *, const cell * )
{
	return( cell )Player::GetInstance( )->GetLove( );
}
static cell AMX_NATIVE_CALL CheckTouch( AMX *, const cell * )
{
	return( cell )Player::GetInstance( )->GetTouch( );
}
static cell AMX_NATIVE_CALL CheckTouching( AMX *, const cell * )
{
	return( cell )Player::GetInstance( )->GetTouching( );
}
static cell AMX_NATIVE_CALL GetTouchX( AMX *, const cell * )
{
	return( cell )Player::GetInstance( )->GetTouchX( );
}
static cell AMX_NATIVE_CALL GetTouchY( AMX *, const cell * )
{
	return( cell )Player::GetInstance( )->GetTouchY( );
}
static cell AMX_NATIVE_CALL SetAdjustAngle( AMX *, const cell *para )
{
	LoveTouch* lt = dynamic_cast < LoveTouch* >( Player::GetInstance( )->GetLove( ) );
	if( lt ){
		lt->SetAdjustAngle( amx_ctof( para[1] ) );
	}
	return 0;
}
static cell AMX_NATIVE_CALL SetFace( AMX *, const cell *para )
{
	Player* lb = Player::GetInstance( );
	if( lb ){
		switch( para[1] ){
		case MOUTH_OPEN:
			lb->MouthOpen( );
			break;
		case MOUTH_CLOSE:
			lb->MouthClose( );
			break;
		case EYES_OPEN:
			lb->BlinkOpen( );
			break;
		case EYES_HALF_OPEN:
			lb->BlinkHalfOpen( );
			break;
		case EYES_CLOSE:
			lb->BlinkClose( );
			break;
		}
	}
	return 0;
}
static cell AMX_NATIVE_CALL SetTouchPosition( AMX *, const cell *para )
{
	LoveLookBase* lb = dynamic_cast < LoveLookBase* >( Player::GetInstance( )->GetLove( ) );
	if( lb ){
		lb->SetTouchPosition( para[1], para[2] );
	}
	return 0;
}
static cell AMX_NATIVE_CALL ShowObject( AMX *, const cell *para )
{
	LoveBase::ShowObject( para[1], para[2], para[3] );
	return 0;
}
/*
static cell AMX_NATIVE_CALL SetDirection( AMX *, const cell *val )
{
	Player* pl = Player::GetInstance( );
	pl->SetRootRotationY( ( val[1] == DIR_BACK ) ? gfl::core::Math::ONE_PI : 0.0f );
	return val[1];
}
 */
static cell AMX_NATIVE_CALL Random( AMX *, const cell *val )
{
#ifdef GFL_PLATFORM_3DS
	return xy_system::GflUse::GetPublicRand( val[1] );
#else // 
	return gfl::core::Math::Random( val[1] );
#endif
}
static cell AMX_NATIVE_CALL FinishLoveCommand( AMX *, const cell * )
{
	LoveBase* lb = Player::GetInstance( )->GetLove( );
	if( lb ){
		lb->SetStep( LoveBase::STEP_END );
	}
	return 0;
}
static cell AMX_NATIVE_CALL PlaySE( AMX *, const cell *val )
{
#ifdef GFL_PLATFORM_3DS
	snd::SEController::PlaySE( val[1] );
//	gamesystem::GameManager::GetInstance( )->GetSoundSystem( )->Play( val[1], val[2], val[3] );
#else // 
	//	QSound::play("mysounds/bells.wav");
#endif
	return 0;
}
static cell AMX_NATIVE_CALL PushCamera( AMX *, const cell *val )
{
	PawnTask* pt = PawnTask::GetInstance( );

	if( pt->m_CameraStep != PawnTask::CAM_NONE ){
		return false;
	}

	LoveBase::GetCameraPosition( &pt->m_CameraPosition );
	LoveBase::GetInterestPosition( &pt->m_InterestPosition );

#if 0 // 
	gfl::core::Vector3 pos( amx_ctof( val[1] ), amx_ctof( val[2] ), amx_ctof( val[3] ) );
	LoveBase::SetCameraPosition( pos );

	pos.SetX( 0.0f );
	pos.GetRefY( ) += pos.GetZ( ) * gfl::core::Math::FTan( gfl::core::Math::DegreeToRadian( amx_ctof( val[4] ) ) );
	pos.SetZ( 0.0f );
	LoveBase::SetInterestPosition( pos );
#else // 
	gfl::core::Vector3 pos( amx_ctof( val[1] ), amx_ctof( val[2] ), amx_ctof( val[3] ) );

	const f32 div = 1.0f / ( f32 )PawnTask::CAM_SMOOTH_FRAME;
	pt->m_CameraVelocity.Set( pos - pt->m_CameraPosition );
	pt->m_CameraVelocity.Mul( div );

	pos.SetX( 0.0f );
	pos.GetRefY( ) += pos.GetZ( ) * gfl::core::Math::FTan( gfl::core::Math::DegreeToRadian( amx_ctof( val[4] ) ) );
	pos.SetZ( 0.0f );

	pt->m_InterestVelocity.Set( pos - pt->m_InterestPosition );
	pt->m_InterestVelocity.Mul( div );

	pt->m_CameraFrame = PawnTask::CAM_SMOOTH_FRAME;
	pt->m_CameraStep = PawnTask::CAM_PUSH;
#endif
	return true;
}
static cell AMX_NATIVE_CALL PopCamera( AMX *, const cell * )
{
#if 0 // 
	LoveBase::SetCameraPosition( PawnTask::GetInstance( )->m_CameraPosition );
	LoveBase::SetInterestPosition( PawnTask::GetInstance( )->m_InterestPosition );
#else // 
	PawnTask* pt = PawnTask::GetInstance( );
	if( pt->m_CameraStep != PawnTask::CAM_PUSHED ){
		return false;
	}

	pt->m_CameraFrame = PawnTask::CAM_SMOOTH_FRAME;
	pt->m_CameraStep = PawnTask::CAM_POP;
	return true;
#endif
}
static const GFL_PAWN_FUNC_TABLE s_FuncTable[] = {
	GFL_PAWN_FUNC( GetCurrentHour )
	GFL_PAWN_FUNC( GetLeaveTime )
	GFL_PAWN_FUNC( SetLoveCommand )
	GFL_PAWN_FUNC( CheckLoveCommand )
	GFL_PAWN_FUNC( FinishLoveCommand )
	GFL_PAWN_FUNC( CheckTouch )
	GFL_PAWN_FUNC( CheckTouching )
	GFL_PAWN_FUNC( GetTouchX )
	GFL_PAWN_FUNC( GetTouchY )
	GFL_PAWN_FUNC( SetAdjustAngle )
	GFL_PAWN_FUNC( SetFace )
	GFL_PAWN_FUNC( SetTouchPosition )
	GFL_PAWN_FUNC( ShowObject )
	GFL_PAWN_FUNC( Random )
	GFL_PAWN_FUNC( PlaySE )
	GFL_PAWN_FUNC( PushCamera )
	GFL_PAWN_FUNC( PopCamera )
	//	GFL_PAWN_FUNC( SetCameraPosition )
	//	GFL_PAWN_FUNC( SetInterestPosition )
	GFL_PAWN_FUNC_END
};
GFL_NAMESPACE_END( kawaigari )

//==============================================================================
//==============================================================================
void kawaigari::PawnTask::Load( const void* buffer, const size_t size )
{
	gfl::pawn::Pawn::Load( buffer, size );
	RegisterPawnFunction( s_FuncTable );
//	gfl::core::Debug::PrintConsole( "loaded \n" );
}

//==============================================================================
//==============================================================================
void kawaigari::PawnTask::Update( void )
{
	switch( m_CameraStep ){
	case CAM_PUSH:
		if( 0 <=  --m_CameraFrame ){
			m_CameraPosition.Add( m_CameraVelocity );
			LoveBase::SetCameraPosition( m_CameraPosition );
			m_InterestPosition.Add( m_InterestVelocity );
			LoveBase::SetInterestPosition( m_InterestPosition );
		} else { // over
			m_CameraStep = CAM_PUSHED;
		}
		break;
	case CAM_POP:
		if( 0 <= --m_CameraFrame ){
			m_CameraPosition.Sub( m_CameraVelocity );
			LoveBase::SetCameraPosition( m_CameraPosition );
			m_InterestPosition.Sub( m_InterestVelocity );
			LoveBase::SetInterestPosition( m_InterestPosition );
		} else { // over
			m_CameraStep = CAM_NONE;
		}
	}
	gfl::pawn::Pawn::Update( );
}
