//==============================================================================
/**
 * @file	Love.h
 * @brief	
 * @author	kimura_shin
 * @data	2011/04/26, 12:39
 */
// =============================================================================

#ifndef LOVE_H
#define	LOVE_H

GFL_NAMESPACE_BEGIN( kawaigari )

#define TEST_LOVE 1
#define FINISH_TO_DELETE 1

class BaseCommandCharacter;

/**
 * ̊NX
 */
class LoveBase {
	//	GFL_RTTI_ROOT( LoveBase )

public:

	enum {
#define SET_LOVE(name,label) LOVE_ ## name,
#include "LoveDef.h"
		LOVE_MAX,

		STEP_INIT = 0,
		STEP_BASE_MAX,

		STEP_END = 99
	};

	LoveBase( BaseCommandCharacter* mot, const c8 * const name = "" );

	virtual ~LoveBase( void ) {
		BlinkOpen( );
		//		MouthClose( );
	}

	/**
	 * XV
	 * @return UȂI
	 */
	virtual bool Update( void ) {
		return false;
	}

	void Revert( void );

	void BlinkOpen( void );
	void BlinkHalfOpen( void );
	void BlinkClose( void );
	void MouthOpen( void );
	//	void MouthHalfOpen( void );
	void MouthClose( void );
	void SetObjectPosition( const s32 id, const s32 num, const gfl::core::Vector3& pos );
	void SetObjectScale( const f32 scl );
	static void ShowObject( const s32 id, const s32 num, const bool flag = true );
	void ShowCharacter( const bool flag = true );
	bool CheckCameraSide( void );
	static void GetCameraPosition( gfl::core::Vector3* pos );
	static void GetInterestPosition( gfl::core::Vector3* pos );
	static void SetCameraPosition( const gfl::core::Vector3& pos );
	static void SetInterestPosition( const gfl::core::Vector3& pos );
	static void GetCameraMatrix( gfl::core::Matrix* mat );
	void StoreAndSetUpCamera( gfl::core::Vector3* cam_pos, gfl::core::Vector3* cam_int );
	void GetTouchPositionByXY( gfl::core::Vector3* pos, const u16 touchx, const u16 touchy, const f32 z = METER( 0.2f ) );

	bool DecreaseFrame( f32* fp ) const;

	// pawn
	static s32 GetBiteCount( void );

	f32 GetLimitSpineCoe( const f32 coe ) const {
		return (coe < 1.0f) ? coe * 0.2f : coe;
	}

	f32 GetLimitChestCoe( const f32 coe ) const {
		return (coe < 1.0f) ? coe * 0.5f : coe;
	}

	f32 GetLimitArmCoe( const f32 coe ) const {
		return (coe < 1.0f) ? coe * 0.05f : coe;
	}

    void SetStep( s32 Step ) {
    	this->m_Step = Step;
    }

#if TEST_LOVE
	virtual void Test( void );
#endif	
protected:
	BaseCommandCharacter* m_pMotion;
	proj::motion::Joint* m_pJoint;
	s32 m_Step;
};

/**
 * ̒ڊNX
 */

class LoveLookBase : public LoveBase {
	//	GFL_RTTI_SUPER( LoveLookBase, LoveBase )
public:
	LoveLookBase( BaseCommandCharacter* mot, const c8* name = "" );

	virtual ~LoveLookBase( void );

	void SetTouchPosition( const u32 x, const u32 y ) {
		m_TouchX = x;
		m_TouchY = y;
	}

protected:
	bool Look( void );

	void GetTouchPosition( gfl::core::Vector3* pos, const f32 z = METER( 0.2f ) ) {
		GetTouchPositionByXY( pos, m_TouchX, m_TouchY, z );
	}

	u16 m_TouchX;
	u16 m_TouchY;
};

/**
 * px𐧌NX
 */
class VelocityLimit {
	//	GFL_RTTI_ROOT( VelocityLimit )

	f32 AdjustGradually( void );

public:

	enum {
		TYPE_COS,
		TYPE_COS_CEIL,
		TYPE_SIN,
		TYPE_SIN_CEIL,
	};

	void Initialize( const f32 frame_max, const f32 lim, const f32 lim_low = 0.0f, const s32 type = TYPE_COS_CEIL ) {
		m_Frame = 0.0f;
		m_FrameMax = frame_max;
		m_Limit = lim;
		m_LimitLow = lim_low;
		m_Type = type;
		m_BoundCount = 0;
	}

	/**
	 * ÅԂs
	 * @return WA
	 */
	f32 Bound( void );
	/**
	 * ōs
	 * @return WA
	 */
	f32 Ceil( void );

	/**
	 * ÅԂs
	 * @return WA
	 */
	f32 BoundRadian( void );
	/**
	 * ōs
	 * @return WA
	 */
	f32 CeilRadian( void );

	void ResetFrame( void ) {
		m_Frame = 0.0f;
		m_BoundCount = 0;
	}

	f32 GetLimit( ) const {
		return m_Limit;
	}

	bool IsLimit( void ) const {
		return 1.0f - gfl::core::Math::EPSILON <= m_Frame;
	}

	u16 GetBoundCount( ) const {
		return m_BoundCount;
	}

	f32 GetFrame( ) const {
		return m_Frame;
	}

	void SetLimit( f32 Limit ) {
		this->m_Limit = Limit;
	}

private:
	f32 m_Frame;
	f32 m_FrameMax;
	f32 m_Limit;
	f32 m_LimitLow;

	u16 m_Type;
	u16 m_BoundCount;
};

/**
 * ̊
 */

class LoveDelight : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveDelight, LoveBase )

public:

	LoveDelight( BaseCommandCharacter* mot );

	virtual ~LoveDelight( void ) {
		MouthClose( );
	}

	virtual bool Update( void );

#if TEST_LOVE

	virtual void Test( void ) {
		m_VelocityLimit.ResetFrame( );
		LoveBase::Test( );
	}
#endif
private:
	proj::motion::Joint* m_pJointArmLeft;
	proj::motion::Joint* m_pJointArmRight;

	VelocityLimit m_VelocityLimit;
	VelocityLimit m_VelocityLimitArm;
};

/**
 * ̕
 */

class LoveListen : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveListen, LoveBase )

public:

	LoveListen( BaseCommandCharacter* mot );

	virtual ~LoveListen( void ) {
	}

	virtual bool Update( void );

private:

	enum {
		TYPE_NONE,
		TYPE_EAR,
		TYPE_HEAD,

		STEP_OPEN = STEP_BASE_MAX,
		STEP_STOP,
		STEP_CLOSE,
	};

	VelocityLimit m_VelocityLimit;
	f32 m_Offset;
	s32 m_Type;
};

/**
 * ̐
 */

class LoveSleep : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveSleep, LoveBase )

public:

	LoveSleep( BaseCommandCharacter* mot );

	virtual ~LoveSleep( void ) {
	}

	virtual bool Update( void );

#if TEST_LOVE

	virtual void Test( void ) {
		m_VelocityLimit.ResetFrame( );
		LoveBase::Test( );
	}
#endif
private:

	enum {
		STEP_PIKU = STEP_BASE_MAX,
		STEP_WAIT,
		STEP_WAKEUP
	};

	VelocityLimit m_VelocityLimit;

	f32 m_Frame;
	f32 m_PikuAngle;
};

#if 0 // 

/**
 * ̋N
 */

class LoveWakeUp : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveWakeUp, LoveBase )

public:

	enum {
		STEP_PIKU = STEP_BASE_MAX,
		STEP_WAIT,
		STEP_WAKEUP
	};

	LoveWakeUp( BaseCommandCharacter* mot );

	virtual ~LoveWakeUp( void ) {
	}

	virtual bool Update( void );

private:
	VelocityLimit m_VelocityLimit;

	f32 m_Frame;
	f32 m_PikuAngle;
};
#endif

/**
 * ̑D
 */

class LoveRow : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveRow, LoveBase )

public:

	LoveRow( BaseCommandCharacter* mot );

	virtual ~LoveRow( void ) {
	}

	virtual bool Update( void );

private:

	enum {
		STEP_SWING = STEP_BASE_MAX,
		STEP_STOP,
		STEP_PIKU,
		STEP_WAKEUP
	};

	VelocityLimit m_VelocityLimit;
	VelocityLimit m_VelocityLimitBig;

	f32 m_Angle;
	f32 m_PikuAngle;
	f32 m_WakeUpRate;
};

/**
 * ̕svc
 */

class LoveNoIdea : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveNoIdea, LoveBase )

public:

	LoveNoIdea( BaseCommandCharacter* mot );

	virtual ~LoveNoIdea( void ) {
	}

	virtual bool Update( void );
#if TEST_LOVE

//	virtual void Test( void ) {
//		m_VelocityLimit_Z.ResetFrame( );
//		m_VelocityLimit.ResetFrame( );
//		LoveBase::Test( );
//	}
#endif
private:

	enum {
		STEP_Z_WAIT = STEP_BASE_MAX,
		STEP_WAIT,
		STEP_PURU
	};

//	VelocityLimit m_VelocityLimit;
//	VelocityLimit m_VelocityLimit_Z;
//	f32 m_Frame;
};

/**
 * ̂₢
 */

class LoveHate : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveHate, LoveLookBase )
public:

	enum {
		STEP_MOVE = STEP_BASE_MAX,
		STEP_LIMIT,
		STEP_AVOID,
	};

	LoveHate( BaseCommandCharacter* mot );

	virtual ~LoveHate( void ) {
	}

	virtual bool Update( void );
private:
//	proj::motion::Joint* m_pJointHead;
//	VelocityLimit m_VelocityLimit_Z;
	VelocityLimit m_VelocityLimit_Y;
	gfl::core::Vector3 m_FoodPosition;
	f32 m_Limit;
	f32 m_Angle;
	s32 m_Side;

	bool CheckFoodSide( void );
};

/**
 * ̃vc[
 */

class LovePuru : public LoveBase {
	// 	GFL_RTTI_SUPER( LovePuru, LoveBase )

public:

	LovePuru( BaseCommandCharacter* mot );

	virtual ~LovePuru( void ) {
		MouthClose( );
	}

	virtual bool Update( void );
private:
	VelocityLimit m_VelocityLimit_Z;
	VelocityLimit m_VelocityLimit_Y;
};

/**
 * ̊{
 */

class LoveChin : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveChin, LoveBase )

public:

	LoveChin( BaseCommandCharacter* mot );

	virtual ~LoveChin( void ) {
		MouthClose( );
	}

	virtual bool Update( void );
private:
	VelocityLimit m_VelocityLimit_Z;
	VelocityLimit m_VelocityLimit_Y;
	proj::motion::Joint* m_pJointChest;
	proj::motion::Joint* m_pJointArmLeft;
	proj::motion::Joint* m_pJointArmRight;
};

/**
 * ̐H
 */

class LoveEatIdle : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveEatIdle, LoveLookBase )

public:

	LoveEatIdle( BaseCommandCharacter* mot );

	virtual ~LoveEatIdle( void ) {
	}

	virtual bool Update( void );

private:
	gfl::core::Vector3 m_DishPosition;
	gfl::core::Vector3 m_FoodPosition;
	f32 m_FallSpeed;
};

/**
 * ̐H
 */

class LoveEat : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveEat, LoveLookBase )

public:

	LoveEat( BaseCommandCharacter* mot );

	virtual ~LoveEat( void );

	virtual bool Update( void );

private:
	u16 m_OldTouchX;
	u16 m_OldTouchY;
};

#if 0 // 

/**
 * ̐H
 */

class LoveEat : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveEat, LoveBase )

public:

	LoveEat( BaseCommandCharacter* mot );

	virtual ~LoveEat( void ) {
		ShowObject( false );
	}

	virtual bool Update( void );

private:
	VelocityLimit m_VelocityLimit;
	f32 m_ObjectScale;
	f32 m_OldFrame;

	f32 m_ScaleRate;
	f32 m_OffsetX;
	f32 m_OffsetY;
	f32 m_OffsetZ;
};
#endif

/**
 * ̃wfBO
 */

class LoveHeading : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveHeading, LoveBase )

public:

	LoveHeading( BaseCommandCharacter* mot );

	virtual ~LoveHeading( void ) {
		//		ShowObject( false );
	}

	virtual bool Update( void );

private:

	enum {
		STEP_WAIT_SPINE = STEP_BASE_MAX,
		STEP_WAIT_CHEST,
		STEP_WAIT_HEAD,
		STEP_GO_SPINE,
		STEP_GO_CHEST,
		STEP_GO_HEAD,
		STEP_LIMIT_SPINE,
		STEP_LIMIT_CHEST,
		STEP_LIMIT_HEAD,
		STEP_REVERT_SPINE,
		STEP_REVERT_CHEST,
		STEP_REVERT_HEAD,
		STEP_FINISHED
	};

	VelocityLimit m_VelocityLimit;
	gfl::core::Vector3 m_Position;
	gfl::core::Vector3 m_Velocity;
	proj::motion::Joint* m_pJointChest;
	proj::motion::Joint* m_pJointHead;
	proj::motion::Joint* m_pJointArmLeft;
	proj::motion::Joint* m_pJointArmRight;

	f32 m_SpineAngle;
	f32 m_ChestAngle;
	f32 m_HeadAngle;
	f32 m_ArmAngle;

	f32 m_WaitFrame;
	f32 m_WaitAngle;
	f32 m_HitFrame;
	f32 m_HitAngle;
	f32 m_RevertFrame;
	f32 m_RevertCoe;

	f32 m_Frame;
	f32 m_Wait;
};

/**
 * ̃Jڐ
 */

class LoveCamera : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveCamera, LoveBase )

public:

	LoveCamera( BaseCommandCharacter* mot );

	virtual ~LoveCamera( void );

	virtual bool Update( void );
private:
	LoveBase* m_pLoveInternal;

	enum {
		STEP_LISTEN = STEP_BASE_MAX,
		STEP_WAIT,
		STEP_CAMERA,
		STEP_NO_ACTION
	};
};

/**
 * ̃mD]DLD
 */

class LovePeep : public LoveBase {
	// 	GFL_RTTI_SUPER( LovePeep, LoveBase )

public:

	LovePeep( BaseCommandCharacter* mot );

	virtual ~LovePeep( void );

	virtual bool Update( void );
private:

	enum {
		STEP_WAIT = STEP_BASE_MAX,
		STEP_MOVE,
		STEP_WAIT2,
		STEP_MOVE2,
		STEP_REVERT,
	};

	VelocityLimit m_VelocityLimit;
	gfl::core::Vector3 m_CameraPosition;
	gfl::core::Vector3 m_InterestPosition;
	f32 m_Frame;
	f32 m_OrgYPos;
};

/**
 * ̃Xb
 */

class LoveSuri : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveSuri, LoveBase )

public:

	LoveSuri( BaseCommandCharacter* mot );

	virtual ~LoveSuri( void );

	virtual bool Update( void );
private:

	enum {
		STEP_WAIT = STEP_BASE_MAX,
		STEP_HIDE,
		STEP_SURI,
		STEP_NIYA,
		STEP_REVERT,
	};

	VelocityLimit m_VelocityLimit;
	gfl::core::Vector3 m_CameraPosition;
	gfl::core::Vector3 m_InterestPosition;

	f32 m_Frame;
	f32 m_OrgYPos;
	f32 m_InterestYPos;
	s32 m_InterestFrame;
};

/**
 * ̓˂
 */

class LoveButt : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveButt, LoveBase )

public:

	LoveButt( BaseCommandCharacter* mot );

	virtual ~LoveButt( void );

	virtual bool Update( void );
private:

	enum {
		STEP_WAIT = STEP_BASE_MAX,
		STEP_CLOSE,
		STEP_HIT,
		STEP_NIYA,
		STEP_REVERT,
	};

	VelocityLimit m_VelocityLimit;
	gfl::core::Vector3 m_CameraPosition;
	gfl::core::Vector3 m_InterestPosition;
	gfl::core::Vector3 m_Velocity;
	gfl::core::Vector3 m_RootPosition;
	f32 m_Frame;
	f32 m_InterestYPos;
	f32 m_InterestZPos;
	f32 m_CameraYPos;
	s32 m_InterestFrame;
};

/**
 * ̂
 */

class LovePicky : public LoveBase {
	// 	GFL_RTTI_SUPER( LovePicky, LoveBase )
public:
	LovePicky( BaseCommandCharacter* mot );

	virtual ~LovePicky( void ) {
		//		ShowObject( false );
	}

	virtual bool Update( void );
private:
	VelocityLimit m_VelocityLimit;
};

/**
 * ̕s
 */

class LoveWalk : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveWalk, LoveBase )
public:
	LoveWalk( BaseCommandCharacter* mot );

	virtual ~LoveWalk( void ) {
	}

	virtual bool Update( void );

private:
	s32 m_WalkCount;
};

/**
 * ̐U
 */

class LoveTurn : public LoveBase {
	// 	GFL_RTTI_SUPER( LoveTurn, LoveBase )
public:
	LoveTurn( BaseCommandCharacter* mot );

	virtual ~LoveTurn( void ) {
	}
	virtual bool Update( void );
};

/**
 * ̕ŕ
 */

class LoveTouch : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveTouch, LoveLookBase )
public:
	LoveTouch( BaseCommandCharacter* mot );

	virtual ~LoveTouch( void ) {
		MouthClose( );
	}

	virtual bool Update( void );

	void SetAdjustAngle( f32 AdjustAngle ) {
		this->m_AdjustAngle = AdjustAngle;
	}

private:
	f32 m_AdjustAngle;
	f32 m_SmoothFrame;
	u16 m_OldTouchX;
	u16 m_OldTouchY;
};

/**
 * ̒
 */

class LoveLook : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveLook, LoveLookBase )
public:
	LoveLook( BaseCommandCharacter* mot );

	virtual ~LoveLook( void ) {
	}
	virtual bool Update( void );
};

/**
 * ̒
 */
#if 0 // 
class LoveDownCast : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveLook, LoveLookBase )
public:
	LoveDownCast( BaseCommandCharacter* mot );

	virtual ~LoveDownCast( void ) {
	}
	virtual bool Update( void );
};
#endif

/**
 * ̂܂
 */

class LoveHand : public LoveLookBase {
	// 	GFL_RTTI_SUPER( LoveHand, LoveLookBase )
public:
	LoveHand( BaseCommandCharacter* mot );

	virtual ~LoveHand( void ) {
	}

	virtual bool Update( void );

private:

	enum {
		//		STEP_INIT,
		STEP_BEGIN,
	};
	f32 m_SmoothFrame;
	static const f32 s_cSmoothFrame;
};

GFL_NAMESPACE_END( kawaigari )

#endif	/* LOVE_H */
