//==============================================================================
/**
 * @file	Love.cpp
 * @brief	
 * @author	kimura_shin
 * @data	2011/04/26, 12:48
 */
// =============================================================================

//==============================================================================
// vpeBe[u
//==============================================================================
GFL_NAMESPACE_BEGIN( kawaigari )

#ifndef GFL_PLATFORM_3DS
#    include "Love.inc"
#endif

#if 0 // 
GFL_RTTI_ROOT_INSTANCE( LoveBase )

GFL_RTTI_ROOT_INSTANCE( VelocityLimit )
GFL_RTTI_TABLE_BEGIN( VelocityLimit )
GFL_RTTI_LABEL( m_FrameMax, "t[" )
GFL_RTTI_LABEL( m_Limit, "" )
GFL_RTTI_LABEL( m_LimitLow, "" )
GFL_RTTI_LABEL( m_Type, "^Cv" )
GFL_RTTI_TABLE_END


GFL_RTTI_SUPER_INSTANCE( LoveDelight )
GFL_RTTI_TABLE_BEGIN( LoveDelight )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_LABEL( m_VelocityLimitArm, "萧" )
GFL_RTTI_TABLE_END

#    if 1 // 
GFL_RTTI_SUPER_INSTANCE( LoveListen )
GFL_RTTI_TABLE_BEGIN( LoveListen )
//GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_LABEL( m_Offset, "͂" )
GFL_RTTI_TABLE_END

GFL_RTTI_SUPER_INSTANCE( LoveSleep )
GFL_RTTI_TABLE_BEGIN( LoveSleep )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_TABLE_END

#        if 0 // 
GFL_RTTI_SUPER_INSTANCE( LoveWakeUp )
GFL_RTTI_TABLE_BEGIN( LoveWakeUp )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
//GFL_RTTI_LABEL( m_PikuAngle, "sNpx" )
GFL_RTTI_TABLE_END
#        endif

GFL_RTTI_SUPER_INSTANCE( LoveNoIdea )
GFL_RTTI_TABLE_BEGIN( LoveNoIdea )
GFL_RTTI_LABEL( m_VelocityLimit_Z, "Z" )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_TABLE_END

#        if 0 // 
GFL_RTTI_SUPER_INSTANCE( LoveHate )
GFL_RTTI_TABLE_BEGIN( LoveHate )
GFL_RTTI_LABEL( m_VelocityLimit_Z, "Z" )
GFL_RTTI_LABEL( m_VelocityLimit_Y, "Y" )
GFL_RTTI_TABLE_END
#        endif

GFL_RTTI_SUPER_INSTANCE( LovePicky )
GFL_RTTI_TABLE_BEGIN( LovePicky )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_TABLE_END

GFL_RTTI_SUPER_INSTANCE( LovePuru )
GFL_RTTI_TABLE_BEGIN( LovePuru )
GFL_RTTI_LABEL( m_VelocityLimit_Z, "Z" )
GFL_RTTI_LABEL( m_VelocityLimit_Y, "Y" )
GFL_RTTI_TABLE_END

GFL_RTTI_SUPER_INSTANCE( LoveChin )
GFL_RTTI_TABLE_BEGIN( LoveChin )
GFL_RTTI_LABEL( m_VelocityLimit_Z, "Z" )
GFL_RTTI_LABEL( m_VelocityLimit_Y, "Y" )
GFL_RTTI_TABLE_END

GFL_RTTI_SUPER_INSTANCE( LoveHeading )
GFL_RTTI_TABLE_BEGIN( LoveHeading )
GFL_RTTI_LABEL( m_WaitFrame, "̂t[" )
GFL_RTTI_LABEL( m_WaitAngle, "̂px" )
GFL_RTTI_LABEL( m_HitFrame, "qbgt[" )
GFL_RTTI_LABEL( m_HitAngle, "qbgpx" )
GFL_RTTI_LABEL( m_RevertFrame, "Nオt[" )
GFL_RTTI_LABEL( m_RevertCoe, "NオW" )
GFL_RTTI_TABLE_END

GFL_RTTI_SUPER_INSTANCE( LoveCamera )

GFL_RTTI_SUPER_INSTANCE( LovePeep )

GFL_RTTI_SUPER_INSTANCE( LoveSuri )

GFL_RTTI_SUPER_INSTANCE( LoveButt )

GFL_RTTI_SUPER_INSTANCE( LoveRow )
GFL_RTTI_TABLE_BEGIN( LoveRow )
GFL_RTTI_LABEL( m_VelocityLimit, "" )
GFL_RTTI_LABEL( m_VelocityLimitBig, "吧" )
GFL_RTTI_LABEL( m_WakeUpRate, "Nオ葬x" )
GFL_RTTI_TABLE_END
#    endif

#endif
GFL_NAMESPACE_END( kawaigari )

//==============================================================================
//==============================================================================
kawaigari::LoveBase::LoveBase( BaseCommandCharacter* mot, const c8* name )
: m_pMotion( mot ),
m_pJoint( mot->GetJointByName<proj::motion::Joint*>( name ) ),
m_Step( 0 )
{
	BlinkOpen( );
	//	MouthClose( );
}


//==============================================================================
//==============================================================================
void kawaigari::LoveBase::Revert( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	m_pMotion->CalculateMatrix( jnt, jnt->_ChildCount );
}

#if TEST_LOVE
//==============================================================================
//==============================================================================
void kawaigari::LoveBase::Test( void )
{
	Revert( );
	m_pMotion->ResetSpring( );
	m_Step = 0;
}
#endif

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::BlinkOpen( void )
{
#ifdef GFL_PLATFORM_3DS
	m_pMotion->BlinkOpen( );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::BlinkHalfOpen( void )
{
#ifdef GFL_PLATFORM_3DS
	m_pMotion->BlinkHalfOpen( );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::BlinkClose( void )
{
#ifdef GFL_PLATFORM_3DS
	m_pMotion->BlinkClose( );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::MouthOpen( void )
{
	m_pMotion->MouthOpen( );
}

//==============================================================================
//==============================================================================
#if 0 // 
void kawaigari::LoveBase::MouthHalfOpen( void )
{
#    ifdef GFL_PLATFORM_3DS
	m_pMotion->MouthHalfOpen( );
#    endif
}
#endif

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::MouthClose( void )
{
	m_pMotion->MouthClose( );
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::GetCameraPosition( gfl::core::Vector3* pos )
{
#ifdef GFL_PLATFORM_3DS
	gfl::math::VEC3 v;
	Graphic::GetInstance( )->GetCamera( )->GetCameraPosition( v );
	pos->FromVEC3( v );
#else // 
	pos->Set( MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( )->_Trans );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::GetInterestPosition( gfl::core::Vector3* pos )
{
#ifdef GFL_PLATFORM_3DS
	gfl::math::VEC3 v;
	Graphic::GetInstance( )->GetCamera( )->GetTargetPosition( v );
	pos->FromVEC3( v );
#else // 
	pos->Set( MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( )->_Trans );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::SetCameraPosition( const gfl::core::Vector3& pos )
{
#ifdef GFL_PLATFORM_3DS
	gfl::math::VEC3 v;
	pos.ToVEC3( &v );
	Graphic::GetInstance( )->GetCamera( )->SetCameraPosition( v );
#else // 
	gfl::core::Camera* cam = MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( );
	cam->_Trans.Set( pos, 1.0f );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::SetInterestPosition( const gfl::core::Vector3& pos )
{
#ifdef GFL_PLATFORM_3DS
	gfl::math::VEC3 v;
	pos.ToVEC3( &v );
	Graphic::GetInstance( )->GetCamera( )->SetTargetPosition( v );
#else // 
	gfl::core::Camera* cam = MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( );
	cam->_Interest.Set( pos, 1.0f );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::GetCameraMatrix( gfl::core::Matrix* mat )
{
#ifdef GFL_PLATFORM_3DS
	//	gfl::math::MTX34 n_mat;
	//	Graphic::GetInstance( )->GetCamera( )->GetWorldMatrix( &n_mat );
	//	mat->FromSOA( n_mat );
	gfl::math::VEC3 p, i;
	Graphic::GetInstance( )->GetCamera( )->GetCameraAndTargetPosition( p, i );

	gfl::core::Vector3 cam_int;
	cam_int.FromVEC3( i );

	mat->SetUnit( );
	mat->SetTrans( p.x, p.y, p.z );
	mat->AimYX( cam_int );
#else // 
	mat->Set( MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( )->_Matrix );
	mat->Trans( MainWindow::GetInstance( )->GetGLWidget( )->GetCamera( )->_Trans );
	//	PlayerCamera* cam = PlayerCamera::GetInstance( );
	//	mat->SetRotateZYX(cam->_Rotation);
	//	mat->SetTrans( cam->_Trans );
#endif
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveBase::CheckCameraSide( void )
{
	if( m_pJoint ){
		gfl::core::Vector3 cam;
		GetCameraPosition( &cam );
		return m_pMotion->GetGlobalRootMatrix( ).IsPositionLeft( cam );
	}
	return true;
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::SetObjectPosition( const s32 id, const s32 num, const gfl::core::Vector3& pos )
{
#ifdef GFL_PLATFORM_3DS
	Graphic::GetInstance( )->SetObjectPosition( id, num, pos );
#else // 
	MainWindow::GetInstance( )->GetGLWidget( )->m_ObjectPosition.Set( pos );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::ShowObject( const s32 id, const s32 num, const bool flag )
{
#ifdef GFL_PLATFORM_3DS
	Graphic::GetInstance( )->ShowObject( id, num, flag );
#else // 
	MainWindow::GetInstance( )->GetGLWidget( )->m_ObjectShow = flag;
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::SetObjectScale( const f32 scl )
{
#ifdef GFL_PLATFORM_3DS
	Graphic::GetInstance( )->SetBallScale( scl );
#else // 
	MainWindow::GetInstance( )->GetGLWidget( )->m_ObjectScale = scl;
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::ShowCharacter( const bool flag )
{
#ifdef GFL_PLATFORM_3DS
	Graphic::GetInstance( )->GetModel( )->SetVisible( flag );
#endif
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveBase::DecreaseFrame( f32* fp ) const
{
	const f32 frame = *fp - m_pMotion->GetFrameSpeed( );
	*fp = frame;
	return(frame < 0.0f );
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::StoreAndSetUpCamera( gfl::core::Vector3* cam_pos, gfl::core::Vector3* cam_int )
{
	GetCameraPosition( cam_pos );
	GetInterestPosition( cam_int );

	gfl::core::Vector3 cp, ip;
	if( m_pMotion->GetCharacterId( ) == ID_PikachuTa ){
		m_pJoint->GetMatrix( )->Trans( &cp, CENTI( 66.0f ), CENTI( -4.75f ), CENTI( 5.0f ) );
		m_pJoint->GetMatrix( )->Trans( &ip, CENTI( 9.5f ), CENTI( 19.0f ), CENTI( 3.2f ) );
	} else {
		m_pJoint->GetMatrix( )->Trans( &cp, CENTI( 48.0f ), CENTI( 26.0f ), CENTI( 0.0f ) );
		m_pJoint->GetMatrix( )->TransX( &ip, CENTI( -15.0f ) );
	}

	SetCameraPosition( cp );
	SetInterestPosition( ip );

	m_pMotion->ResetSpring( );
}
//==============================================================================
//==============================================================================
s32 kawaigari::LoveBase::GetBiteCount( void )
{
	return PawnTask::GetInstance( )->GetGlobalParameterInteger( "p_BiteCount" );
}

//==============================================================================
//==============================================================================
kawaigari::LoveLookBase::LoveLookBase( BaseCommandCharacter* mot, const c8* name ) : LoveBase( mot, name )
{
	if( mot->GetTouching( ) ){
		m_TouchX = mot->GetTouchX( );
		m_TouchY = mot->GetTouchY( );
	}
}

//==============================================================================
//==============================================================================
kawaigari::LoveLookBase::~LoveLookBase( void )
{
	m_pMotion->SetInterest( 0 );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveLookBase::Look( void )
{
	gfl::core::Vector3 pos;
	GetTouchPosition( &pos );
	m_pMotion->SetInterest( pos );
	return true;
}

//==============================================================================
//==============================================================================
f32 kawaigari::VelocityLimit::AdjustGradually( void )
{
	const f32 frame = m_Frame + 1.0f / m_FrameMax;
	m_Frame = frame;

#if 0 // 
	const f32 coe = gfl::core::Math::FSin( frame * gfl::core::Math::HALF_PI );
	if( m_LimitLow == 0.0f ){
		if( 2.0f - gfl::core::Math::EPSILON <= frame ){
			m_Frame = 0.0f;
			return 0.0f;
		}
		return m_Limit * coe;
	} else if( frame < 2.0f ){
		return m_Limit * coe;
	} else if( 4.0f - gfl::core::Math::EPSILON <= frame ){
		m_Frame = 0.0f;
	}
	return m_LimitLow * -coe;

	/////
	f32 coe = gfl::core::Math::FCos( frame * gfl::core::Math::HALF_PI );
	if( frame < 1.0f ){
		coe = 1.0f - coe;
	} else if( frame < 3.0f ){
		coe = 1.0f + coe;
	} else {
		coe = 1.0f - coe;
		if( 4.0f - gfl::core::Math::EPSILON <= frame ){
			m_Frame = 0.0f;
		}
	}
	//	gfl::core::Debug::PrintConsole( "coe(%f) %f\n",frame,coe);
	if( m_LimitLow == 0.0f ){
		if( 2.0f - gfl::core::Math::EPSILON <= frame ){
			m_Frame = 0.0f;
			return 0.0f;
		}
		return m_Limit * coe;
	} else if( frame < 2.0f ){
		return m_Limit * coe;
	}
	return m_LimitLow * -coe;
#else // 
	f32 coe = ( m_Type != TYPE_COS ) ? gfl::core::Math::HALF_PI : gfl::core::Math::QUARTER_PI;

	if( m_Type < TYPE_SIN ){ // cos cos_ceil
		coe = gfl::core::Math::FCos( frame * coe );
		if( frame < 2.0f ){
			coe = 1.0f - coe;
		} else {
			coe = 1.0f + coe;
		}
	} else {
		coe = gfl::core::Math::FSin( frame * coe );
	}
	//	gfl::core::Debug::PrintConsole( "coe(%d)(%f) %f\n",m_Type, frame, coe );
	if( m_Type == TYPE_COS_CEIL || m_Type == TYPE_SIN_CEIL ){
		if( 2.0f - gfl::core::Math::EPSILON <= frame ){
			m_Frame = 0.0f;
			return 0.0f;
		}
		return m_Limit * coe;
	} else if( frame < 2.0f ){
		return m_Limit * coe;
	} else if( 4.0f - gfl::core::Math::EPSILON <= frame ){
		m_Frame = 0.0f;
		++m_BoundCount;
	}
	return m_LimitLow * -coe;
#endif
}

//==============================================================================
//==============================================================================
inline f32 kawaigari::VelocityLimit::Bound( void )
{
	return AdjustGradually( );
}

//==============================================================================
//==============================================================================
inline f32 kawaigari::VelocityLimit::Ceil( void )
{
	return( m_Frame < 1.0f ) ? AdjustGradually( ) : m_Limit;
}

//==============================================================================
//==============================================================================
inline f32 kawaigari::VelocityLimit::BoundRadian( void )
{
	// x烉WAĕԂ
	return gfl::core::Math::DegreeToRadian( Bound( ) );
}

//==============================================================================
//==============================================================================
f32 kawaigari::VelocityLimit::CeilRadian( void )
{
	return gfl::core::Math::DegreeToRadian( Ceil( ) );
}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// {̉肪n܂c
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#if 0 // 
//==============================================================================
//==============================================================================
kawaigari::LoveDelight::LoveDelight( BaseCommandCharacter* mot ) : LoveBase( mot, "J_spine" ),
m_pJointArmLeft( mot->GetJointByName<proj::motion::Joint*>( "J_arm_L" ) ),
m_pJointArmRight( mot->GetJointByName<proj::motion::Joint*>( "J_arm_R" ) )
{
	mot->SetForceCommand( Command::COM_IDLE );
	m_VelocityLimit.Initialize( 25.0f * mot->m_LoveCoe, 7.0f * GetLimitSpineCoe( mot->m_LoveLimitCoe ), 0.0f, VelocityLimit::TYPE_SIN );
	m_VelocityLimitArm.Initialize( 25.0f * mot->m_LoveCoe, 42.0f * GetLimitArmCoe( mot->m_LoveLimitCoe ), 0.0f, VelocityLimit::TYPE_SIN );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveDelight::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	if( m_VelocityLimit.GetBoundCount( ) && m_Step ){
		MouthClose( );
		return false;
	}

	jnt->GetMatrix( )->RotateZ( m_VelocityLimit.BoundRadian( ) );

	f32 ang = m_VelocityLimitArm.BoundRadian( );
	if( m_pJointArmRight ){
		m_pJointArmRight->GetRot( )->GetRefY( ) += ang;
	}
	if( m_pJointArmLeft ){
		m_pJointArmLeft->GetRot( )->GetRefY( ) -= ang;
	}
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	if( !m_Step ){
		MouthOpen( );
		m_Step = 1;
	} else {
		m_pMotion->BlinkControl( );
	}
	return true;
}
#else // 
kawaigari::LoveDelight::LoveDelight( BaseCommandCharacter* mot ) : LoveBase( mot )
{
	m_pMotion->SetForceCommandTable( Command::COM_HOLD, Command::TBL_LOCK_IDLE );
	MouthOpen( );
}
bool kawaigari::LoveDelight::Update( void )
{
	return !m_pMotion->CheckMotionEnd( );
}
#endif

//==============================================================================
//==============================================================================
kawaigari::LoveListen::LoveListen( BaseCommandCharacter* mot ) : LoveBase( mot, "J_earB_R" ),
m_Offset( 20.0f )
{
	if( m_pJoint ){
		m_Type = TYPE_EAR;
	} else {
		m_pJoint = mot->GetJointByName<proj::motion::Joint*>( "J_head" );
		m_Type = ( m_pJoint ) ? TYPE_HEAD : TYPE_NONE;
	}
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveListen::Update( void )
{
	if( m_Type == TYPE_EAR ){
		if( !m_Step ){
			m_pJoint->GetMatrix( )->GetTrans( )->GetRefZ( ) += CENTI( m_Offset );
			m_Step = 1;
		} else {
			return false;
		}
	} else if( m_Type == TYPE_HEAD ){
		switch( m_Step ){
		case STEP_INIT:
			m_VelocityLimit.Initialize( GFL_SECOND( 0.35f ), 20.0f );
			MouthOpen( );
			m_Step = STEP_OPEN;
		case STEP_OPEN:
		{
			proj::motion::Joint* jnt = m_pJoint;
			jnt->GetMatrix( )->RotateZ( m_VelocityLimit.CeilRadian( ) );
			m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

			if( m_VelocityLimit.IsLimit( ) ){
				MouthClose( );

				m_Offset = GFL_SECOND( 1.0f );
				m_Step = STEP_STOP;
			}
			break;
		}
		case STEP_STOP:
		{
			proj::motion::Joint* jnt = m_pJoint;
			jnt->GetMatrix( )->RotateZ( m_VelocityLimit.CeilRadian( ) );
			m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
			if( DecreaseFrame( &m_Offset ) ){
				m_VelocityLimit.Initialize( GFL_SECOND( 1.0f ), 20.0f );
				m_Step = STEP_CLOSE;
			}
			break;
		}
		case STEP_CLOSE:
		{
			proj::motion::Joint* jnt = m_pJoint;
			jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( m_VelocityLimit.GetLimit( ) ) - m_VelocityLimit.CeilRadian( ) );
			m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

			if( m_VelocityLimit.IsLimit( ) ){
				m_Step = STEP_END;
			}
			break;
		}
#if FINISH_TO_DELETE
		case STEP_END:
			if( m_pMotion->m_MouthStep == BaseCommandCharacter::MOUTH_NO_CONTROL ){
				return false;
			}
#endif
		}
	} else {
		return false;
	}

	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LoveSleep::LoveSleep( BaseCommandCharacter * mot ) : LoveBase( mot, "J_chest" )
{
	m_VelocityLimit.Initialize( 40.0f * mot->m_LoveCoe, 45.0f * GetLimitChestCoe( mot->m_LoveLimitCoe ) );
	BlinkClose( );
	m_pMotion->SetTouch( false );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveSleep::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}
	switch( m_Step ){
	case STEP_INIT:
		jnt->GetMatrix( )->RotateZ( -m_VelocityLimit.CeilRadian( ) );

		if( DecreaseFrame( &m_pMotion->m_BlinkFrame ) ){
			proj::motion::Joint* e_jnt = m_pMotion->GetJointByName<proj::motion::Joint*>( "J_earB_R" );
			if( e_jnt ){
				e_jnt->GetMatrix( )->GetTrans( )->GetRefZ( ) += CENTI( 10.0f );
			}
			m_pMotion->m_BlinkFrame = 7.0f * gfl::motion::Fcurve::ONE_FRAME + gfl::core::Math::Random( 5.0f * gfl::motion::Fcurve::ONE_FRAME );
		}

		if( m_VelocityLimit.IsLimit( ) && m_pMotion->GetTouch( ) ){
			m_VelocityLimit.Initialize( 40.0f * m_pMotion->m_LoveCoe, 45.0f * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
			m_PikuAngle = 1.0f;
			m_pMotion->SetFrameSpeed( 0.0f );
			m_Step = STEP_PIKU;
			m_pMotion->SetTouch( false );
		}
		break;
	case STEP_PIKU:
		jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -m_VelocityLimit.GetLimit( ) + m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) );
		BlinkHalfOpen( );
		m_PikuAngle += 1.0f;

		if( 5.0f < m_PikuAngle ){
			m_Frame = GFL_SECOND( 1.0f );
			m_Step = STEP_WAIT;
		}
		break;
	case STEP_WAIT:
		jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -m_VelocityLimit.GetLimit( ) + m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) );
		m_Frame -= 1.0f; // [VXs[hOȂ̂ DecreaseFrame gȂ
		if( m_Frame < 0.0f ){
			BlinkOpen( );
			m_Step = STEP_WAKEUP;
		}
		break;
	case STEP_WAKEUP:
	{
		const f32 ang = gfl::core::Math::DegreeToRadian( m_VelocityLimit.GetLimit( ) - m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) - m_VelocityLimit.CeilRadian( );
		jnt->GetMatrix( )->RotateZ( -ang );
		if( m_VelocityLimit.IsLimit( ) ){
			m_pMotion->SetFrameSpeed( 1.0f );
			return false;
		}
		break;
	}
	}
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	return true;
}

#if 0 // 
//==============================================================================
//==============================================================================
kawaigari::LoveWakeUp::LoveWakeUp( BaseCommandCharacter * mot ) : LoveBase( mot, "J_chest" ) { }

//==============================================================================
//==============================================================================
bool kawaigari::LoveWakeUp::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	switch( m_Step ){
	case STEP_INIT:
		m_VelocityLimit.Initialize( 40.0f * m_pMotion->m_LoveCoe, 45.0f * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
		m_PikuAngle = 3.0f;
		m_Frame = GFL_SECOND( 1.0f );
		m_pMotion->SetFrameSpeed( 0.0f );
	case STEP_PIKU:
		jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -m_VelocityLimit.GetLimit( ) + m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) );
		++m_Step;
		break;
	case STEP_WAIT:
		jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -m_VelocityLimit.GetLimit( ) + m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) );
		m_Frame -= 1.0f; // [VXs[hOȂ̂ DecreaseFrame gȂ
		if( m_Frame < 0.0f ){
			m_Step = STEP_WAKEUP;
		}
		break;
	case STEP_WAKEUP:
	{
		const f32 ang = gfl::core::Math::DegreeToRadian( m_VelocityLimit.GetLimit( ) - m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) ) - m_VelocityLimit.CeilRadian( );
		jnt->GetMatrix( )->RotateZ( -ang );
		if( m_VelocityLimit.IsLimit( ) ){
			m_pMotion->SetFrameSpeed( 1.0f );
			//			return false;
		}
		break;
	}
	}
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	return true;
}
#endif

//==============================================================================
//==============================================================================
kawaigari::LoveRow::LoveRow( BaseCommandCharacter * mot ) : LoveBase( mot, "J_chest" ),
m_WakeUpRate( 0.95f )
{
	m_VelocityLimit.Initialize( 35.0f * mot->m_LoveCoe, 17.5f * GetLimitChestCoe( mot->m_LoveLimitCoe ), -18.0f * GetLimitChestCoe( mot->m_LoveLimitCoe ), VelocityLimit::TYPE_COS );
	m_VelocityLimitBig.Initialize( 28.0f * mot->m_LoveCoe, 45.0f * GetLimitChestCoe( mot->m_LoveLimitCoe ), -50.0 * GetLimitChestCoe( mot->m_LoveLimitCoe ), VelocityLimit::TYPE_COS );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveRow::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	f32 ang;
	switch( m_Step ){
	case STEP_INIT:
		BlinkClose( );
		m_Step = STEP_SWING;

	case STEP_SWING:
		if( m_VelocityLimit.GetBoundCount( ) < 2 ){
			ang = m_VelocityLimit.BoundRadian( );
		} else {
			ang = m_VelocityLimitBig.BoundRadian( );

			if( m_VelocityLimitBig.GetBoundCount( ) ){
				m_VelocityLimit.ResetFrame( );
				m_VelocityLimitBig.ResetFrame( );
			}
		}
		m_Angle = ang;

		if( m_pMotion->GetTouch( ) ){
			m_Step = STEP_STOP;
		}

		break;
	case STEP_STOP:
		BlinkOpen( );
		ang = m_Angle;
		m_PikuAngle = 1.0f;
		m_Step = STEP_PIKU;
		break;
	case STEP_PIKU:
		ang = m_Angle + gfl::core::Math::DegreeToRadian( m_PikuAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
		BlinkHalfOpen( );
		m_PikuAngle += 1.0f;

		if( 5.0f < m_PikuAngle ){
			m_Step = STEP_WAKEUP;
		}
		break;
	case STEP_WAKEUP:
		ang = m_Angle * m_WakeUpRate;
		m_Angle = ang;
		m_pMotion->BlinkControl( );

		if( gfl::core::Math::FAbs( ang ) <= 0.001f ){
			return false;
		}
	}

	//	gfl::core::Debug::PrintConsole( "ang %f\n", ang );
	jnt->GetMatrix( )->RotateZ( -ang );
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LoveNoIdea::LoveNoIdea( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" )
{
	//	m_VelocityLimit_Z.Initialize( 30.0f * mot->m_LoveCoe, 20.0f * mot->m_LoveLimitCoe );
	//	m_VelocityLimit.Initialize( 40.0f * mot->m_LoveCoe, 30.0f * mot->m_LoveLimitCoe, 0.0, VelocityLimit::TYPE_SIN_CEIL );
	mot->SetForceCommandTable( Command::COM_HOLD, Command::TBL_GUARD );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveNoIdea::Update( void )
{
#if 0 // 
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	jnt->GetMatrix( )->RotateZ( -m_VelocityLimit_Z.CeilRadian( ) );
	switch( m_Step ){
	case STEP_INIT:
		m_pMotion->ResetSpring( );
		m_Step = STEP_Z_WAIT;
		break;
	case STEP_Z_WAIT:
		if( m_VelocityLimit_Z.IsLimit( ) ){
			m_Step = STEP_WAIT;
			m_Frame = GFL_SECOND( 1.0f );
		}
		break;
	case STEP_WAIT:
		if( DecreaseFrame( &m_Frame ) ){
			m_Step = STEP_PURU;
		}
		break;
	case STEP_PURU:
		jnt->GetMatrix( )->RotateX( m_VelocityLimit.CeilRadian( ) );

		if( m_VelocityLimit.IsLimit( ) ){
			return false;
		}
	}
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	m_pMotion->BlinkControl( );
	return true;
#else // 
	return !m_pMotion->CheckMotionEnd( );
#endif
}

//==============================================================================
//==============================================================================
kawaigari::LoveHate::LoveHate( BaseCommandCharacter * mot ) : LoveLookBase( mot, "J_head" )
/*,m_pJointHead( mot->GetJointByName<proj::motion::Joint*>( "J_head" ) )*/ { }

//==============================================================================
//==============================================================================
bool kawaigari::LoveHate::CheckFoodSide( void )
{
	u16 x = m_TouchX;
	u16 y = m_TouchY;
	if( x == 0 && y == 0 ){
		x = FOOD_X;
		y = FOOD_Y;
	}
	//	gfl::core::Debug::PrintConsole( "touch %d %d\n", x, y );
	GetTouchPositionByXY( &m_FoodPosition, x, y, METER( 0.3f ) );
	return m_pMotion->GetGlobalRootMatrix( ).IsPositionLeft( m_FoodPosition );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveHate::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	s32 side = CheckFoodSide( );
	SetObjectPosition( OBJ_FOOD, PawnTask::GetInstance( )->GetGlobalParameterInteger( "p_BiteCount" ), m_FoodPosition );

	if( !m_Step ){
		BaseCommandCharacter* mot = m_pMotion;
		//		m_VelocityLimit_Z.Initialize( 30.0f * mot->m_LoveCoe, 10.0f * GetLimitChestCoe( mot->m_LoveLimitCoe ), 0.0, VelocityLimit::TYPE_SIN_CEIL );
		m_Side = side;
		m_VelocityLimit_Y.Initialize( 30.0f * mot->m_LoveCoe, ( ( side ) ? -45.0f : 45.0f ) * mot->m_LoveLimitCoe, 0.0, VelocityLimit::TYPE_SIN_CEIL );
		m_Step = STEP_MOVE;
		//		m_pMotion->ResetSpring( );
		m_Limit = 0.0f;
	} else if( STEP_END <= m_Step ){
		f32 ang = m_Angle * 0.95f;
		jnt->GetMatrix( )->RotateY( ang );
		m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
		m_Angle = ang;
		if( gfl::core::Math::FAbs( ang ) < 0.01f ){
			return false;
		}
		return true;
	}

	//	jnt->GetMatrix( )->RotateZ( m_VelocityLimit_Z.CeilRadian( ) );
	//	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	//	jnt = m_pJointHead;

	f32 ang;
	if( m_Step <= STEP_MOVE ){
		ang = m_VelocityLimit_Y.CeilRadian( );
	} else {
		ang = m_Limit + m_VelocityLimit_Y.CeilRadian( );
		if( m_VelocityLimit_Y.IsLimit( ) ){
			m_VelocityLimit_Y.SetLimit( gfl::core::Math::RadianToDegree( ang ) );
			m_Step = STEP_MOVE;
		}
	}
	jnt->GetMatrix( )->RotateY( ang );
	m_Angle = ang;

	if( m_VelocityLimit_Y.IsLimit( ) && m_Step != STEP_AVOID ){
		if( side != m_Side ){
			m_Side = side;
			f32 lim = m_VelocityLimit_Y.GetLimit( );
			m_Limit = gfl::core::Math::DegreeToRadian( lim );
			m_VelocityLimit_Y.Initialize( 20.0f * m_pMotion->m_LoveCoe, lim*-2.0f, 0.0, VelocityLimit::TYPE_SIN_CEIL );
			m_Step = STEP_AVOID;
		}
	}
	//	gfl::core::Debug::PrintConsole( "%d %f\n",m_Step,ang);

	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	//	m_pMotion->BlinkControl( );
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LovePicky::LovePicky( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" )
{
	//	ShowObject( );

	gfl::core::Vector3 v;
	m_pJoint->GetMatrix( )->TransX( &v, CENTI( 16.0f ) );
	//	SetObjectPosition( v );
}

//==============================================================================
//==============================================================================
bool kawaigari::LovePicky::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	if( !m_Step ){
		BaseCommandCharacter* mot = m_pMotion;
		m_VelocityLimit.Initialize( 20.0f * mot->m_LoveCoe, 45.0f * mot->m_LoveLimitCoe, 0.0, VelocityLimit::TYPE_SIN_CEIL );
		m_Step = 1;
	}

	jnt->GetMatrix( )->RotateY( m_VelocityLimit.CeilRadian( ) );
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

#if FINISH_TO_DELETE
	if( m_pMotion->GetTouch( ) ){
		return false;
	}
#endif

	m_pMotion->BlinkControl( );
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LovePuru::LovePuru( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" )
{
	m_VelocityLimit_Z.Initialize( 30.0f * mot->m_LoveCoe, 20.0f * mot->m_LoveLimitCoe );
	m_VelocityLimit_Y.Initialize( 10.0f * mot->m_LoveCoe, 20.0f * mot->m_LoveLimitCoe, -20.0f * mot->m_LoveLimitCoe, VelocityLimit::TYPE_SIN );
	BlinkClose( );
}

//==============================================================================
//==============================================================================
bool kawaigari::LovePuru::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	jnt->GetMatrix( )->RotateY( m_VelocityLimit_Y.BoundRadian( ) );
	jnt->GetMatrix( )->RotateZ( -m_VelocityLimit_Z.CeilRadian( ) );
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LoveChin::LoveChin( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" ),
m_pJointChest( mot->GetJointByName<proj::motion::Joint*>( "J_chest" ) ),
m_pJointArmLeft( mot->GetJointByName<proj::motion::Joint*>( "J_arm_L" ) ),
m_pJointArmRight( mot->GetJointByName<proj::motion::Joint*>( "J_arm_R" ) )
{
	m_VelocityLimit_Z.Initialize( 30.0f * mot->m_LoveCoe, GetLimitArmCoe( 20.0f * mot->m_LoveLimitCoe ) );
	m_VelocityLimit_Y.Initialize( 10.0f * mot->m_LoveCoe, 5.0f * mot->m_LoveLimitCoe, -5.0f * mot->m_LoveLimitCoe, VelocityLimit::TYPE_SIN );
	BlinkClose( );
	MouthOpen( );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveChin::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	const f32 ang = m_VelocityLimit_Y.BoundRadian( );
	jnt->GetRot( )->GetRefY( ) += ang;
	jnt->GetRot( )->GetRefZ( ) += m_VelocityLimit_Z.CeilRadian( );

	if( m_pJointArmRight ){
		m_pJointArmRight->GetRot( )->GetRefY( ) += ang;
	}
	if( m_pJointArmLeft ){
		m_pJointArmLeft->GetRot( )->GetRefY( ) -= ang;
	}

	jnt = m_pJointChest;
	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	return true;
}

#if 0 // 
//==============================================================================
//==============================================================================
kawaigari::LoveEat::LoveEat( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" )
, m_OldFrame( 0.0f ), m_ScaleRate( 0.2f )
, m_OffsetX( CENTI( 16.0f ) ), m_OffsetY( CENTI( 0.0f ) ), m_OffsetZ( CENTI( 0.0f ) )
{
	m_VelocityLimit.Initialize( 7.0f * mot->m_LoveCoe, 4.0f * mot->m_LoveLimitCoe, -10.0f * mot->m_LoveLimitCoe, VelocityLimit::TYPE_SIN );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveEat::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	switch( m_Step ){ // au
	case 0:
		//		jnt->GetMatrix( )->Trans( &v, CENTI( 18.0f ), CENTI( -5.0f ), 0.0f );
		ShowObject( );
		BlinkOpen( );
		m_ObjectScale = 1.0f;
		m_Step = 1;
		//		break;
	case 1:
		if( m_VelocityLimit.GetFrame( ) <= 0.0f ){
			MouthOpen( );
		} else if( m_OldFrame <= 3.0f && 3.0f < m_VelocityLimit.GetFrame( ) ){
			f32 scl = m_ObjectScale - m_ScaleRate;
			m_ObjectScale = scl;
			//		gfl::core::Debug::PrintConsole( "scl %f\n", scl );
			SetObjectScale( scl );
			MouthClose( );
			if( scl < 0.1f ){
				m_ObjectScale = 0.0f;
				ShowObject( false );
				//				m_Step = 2;
				return false;
			}
		}
		break;
		//	case 2:
		//		return true;
	}

	m_OldFrame = m_VelocityLimit.GetFrame( );
	jnt->GetMatrix( )->RotateZ( m_VelocityLimit.BoundRadian( ) );

	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	gfl::core::Vector3 v;
	jnt->GetMatrix( )->TransX( &v, m_OffsetX * m_pMotion->m_LoveCoe );
	SetObjectPosition( v );

	m_pMotion->BlinkControl( );
	return true;
}
#else // 
//==============================================================================
//==============================================================================
kawaigari::LoveEatIdle::LoveEatIdle( BaseCommandCharacter * mot ) : LoveLookBase( mot, "J_head" )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( jnt ){
#    if 0 // 
		gfl::core::Vector3 pos;
		jnt->GetMatrix( )->TransX( &pos, CENTI( 16.0f ) );
		mot->SetInterest( pos );
		SetObjectPosition( OBJ_DISH, pos );
		SetObjectPosition( OBJ_FOOD, pos );
#    else // 
		GetTouchPositionByXY( &m_FoodPosition, FOOD_X, FOOD_Y, METER( 0.3f ) );
		SetObjectPosition( OBJ_FOOD, GetBiteCount( ), m_FoodPosition );
		m_pMotion->SetInterest( m_FoodPosition );

		m_TouchX = FOOD_X;
		m_TouchY = FOOD_Y;

		m_DishPosition.Set( m_FoodPosition );

		//		GetTouchPositionByXY( &m_DishPosition, FOOD_X, FOOD_Y + 15, METER( 0.3f ) );
		//		SetObjectPosition( OBJ_DISH, 0, m_DishPosition );
		//		SetObjectScale( 0.1f );
#    endif
	}

	m_pMotion->SetForceCommand( Command::COM_IDLE );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveEatIdle::Update( void )
{
	cell* mode = PawnTask::GetInstance( )->GetGlobalParameterPointer( "p_FoodMoveMode" );
	
	if(!mode){
		return false;
	}

	switch( *mode ){
	case FM_NONE:
		GetTouchPositionByXY( &m_FoodPosition, FOOD_X, FOOD_Y, METER( 0.3f ) );
		SetObjectPosition( OBJ_FOOD, GetBiteCount( ), m_FoodPosition );
		m_pMotion->SetInterest( m_FoodPosition );

		//		GetTouchPositionByXY( &m_DishPosition, m_TouchX, 220 );
		//		SetObjectPosition( OBJ_DISH, m_DishPosition );
		m_FallSpeed = 0.0f;
		break;

	case FM_MOVE:
		GetTouchPosition( &m_FoodPosition, METER( 0.3f ) );
		SetObjectPosition( OBJ_FOOD, GetBiteCount( ), m_FoodPosition );
		m_pMotion->SetInterest( m_FoodPosition );

		//		GetTouchPositionByXY( &m_DishPosition, m_TouchX, 220 );
		//		SetObjectPosition( OBJ_DISH, m_DishPosition );
		m_FallSpeed = 0.0f;
		break;

	case FM_FALL:
	{
		m_FallSpeed += gfl::physic::DEFAULT_GRAVITY;
		f32 y = m_FoodPosition.GetY( );
		y -= m_FallSpeed;
		const f32 dy = m_DishPosition.GetY( );
		if( dy < y ){
			m_FoodPosition.SetY( y );
		} else {
			//			m_FoodPosition.Set( m_DishPosition );
			//			m_FoodPosition.SetY( y + CENTI(3.0f) );
			*mode = FM_NONE; // pawn ̃p[^[
		}
		m_pMotion->SetInterest( m_FoodPosition );
		SetObjectPosition( OBJ_FOOD, GetBiteCount( ), m_FoodPosition );
	}
	}
	return true;
}
//==============================================================================
//==============================================================================
kawaigari::LoveEat::LoveEat( BaseCommandCharacter * mot ) : LoveLookBase( mot )
{
	m_pJoint = m_pMotion->GetJoint<proj::motion::Joint*>( ); // move
	m_pMotion->SetForceCommandTable( Command::COM_HOLD, Command::TBL_HOLD_MOVE_LOOP );
	MouthOpen( );
}
//==============================================================================
//==============================================================================
kawaigari::LoveEat::~LoveEat( void ) { }

//==============================================================================
//==============================================================================
bool kawaigari::LoveEat::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	gfl::core::Vector3 pos;

	u16 x = m_TouchX;
	u16 y = m_TouchY;
	if( x == 0 && y == 0 ){
		x = m_OldTouchX;
		y = m_OldTouchY;
	} else {
		m_OldTouchX = x;
		m_OldTouchY = y;
	}
	//	gfl::core::Debug::PrintConsole( "touch %d %d\n", x, y );

	GetTouchPositionByXY( &pos, x, y, METER( 0.3f ) );
	SetObjectPosition( OBJ_FOOD, GetBiteCount( ), pos );

	gfl::core::Matrix mat;

	mat.SetUnit( );
	//	mat.SetTrans( *m_pMotion->GetRootPosition( ) );
	mat.SetTrans( *jnt->GetMatrix( )->GetTrans( ) );
	mat.AimYX( pos );

	gfl::core::Vector3 ang;
	mat.GetRadianYXZ( &ang );
	ang.SetX( 0.0f );
	ang.SetZ( 0.0f );

	//	mat.PrintConsole("mat");

	//	jnt->GetMatrix()->Set(mat);
	//	m_pMotion->CalculateMatrixByLocalQuat( jnt+1, m_pMotion->GetJointCount( )-1 );
	m_pMotion->UpdateGlobalMatrix( m_pMotion->GetRootPosition( ), &ang );

	//	m_pMotion->SetGlobalRotation( jnt, mat, m_pMotion->GetJointCount( ) );

	//	jnt->GetMatrix( )->AimXZ( pos, true );
	//	pos.PrintConsole( "food" );
	//	jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -30.0f ) );
	//	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	if( ( s32 )m_pMotion->GetFrame( ) == 15 ){
		MouthClose( );
	}

	return !m_pMotion->CheckMotionEnd( );
}
#endif

//==============================================================================
//==============================================================================
kawaigari::LoveHeading::LoveHeading( BaseCommandCharacter * mot ) : LoveBase( mot, "J_spine" ),
m_pJointChest( mot->GetJointByName<proj::motion::Joint*>( "J_chest" ) ),
m_pJointHead( mot->GetJointByName<proj::motion::Joint*>( "J_head" ) ),
m_pJointArmLeft( mot->GetJointByName<proj::motion::Joint*>( "J_arm_L" ) ),
m_pJointArmRight( mot->GetJointByName<proj::motion::Joint*>( "J_arm_R" ) ),
m_WaitFrame( 5.0f ),
m_WaitAngle( 4.0f ),
m_HitFrame( 1.0f ),
m_HitAngle( 7.0f ),
m_RevertFrame( 2.0f ),
m_RevertCoe( 0.9f )
{
	SetObjectScale( 1.0f );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveHeading::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	switch( m_Step ){
	case STEP_INIT:
	{
		m_VelocityLimit.Initialize( m_WaitFrame * m_pMotion->m_LoveCoe, m_WaitAngle * GetLimitSpineCoe( m_pMotion->m_LoveLimitCoe ) );
		m_Position.Set( 0.0f, CENTI( 10.0f ), CENTI( 150.0f ) );

		gfl::core::Vector3 v;

		m_pJointHead ->GetMatrix( )->Trans( &v, CENTI( 13.0f ), CENTI( -7.0f ), 0.0f );
		v.Sub( m_Position );
		// Qb{Ă铮t[iwAAj
		const f32 frame = GFL_SECOND( 2.0f ) + m_HitFrame * 3.0f * m_pMotion->m_LoveCoe;
		m_Frame = frame;
		// SpeedX * t = Vx
		// SpeedY * t - (1/2)*g*t^2 = Vy
		// SpeedZ * t = Vz
		v.Mul( gfl::core::Math::FRecip( frame ) );
		v.GetRefY( ) += ( gfl::physic::DEFAULT_GRAVITY * 0.5f ) * frame;
		m_Velocity.Set( v );
		//		SetObjectPosition( m_Position );
		//		ShowObject( );

		m_SpineAngle = m_ChestAngle = m_HeadAngle = m_ArmAngle = 0.0f;

		BlinkOpen( );
		m_Step = 1;
	}
		// through...
	case STEP_WAIT_SPINE:
	{
		const f32 ang = m_VelocityLimit.CeilRadian( );
		m_SpineAngle = ang;
		jnt->GetMatrix( )->RotateZ( ang );

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_WaitFrame * m_pMotion->m_LoveCoe, m_WaitAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
			m_Step = STEP_WAIT_CHEST;
		}

		break;
	}
	case STEP_WAIT_CHEST:
	{
		jnt->GetMatrix( )->RotateZ( m_SpineAngle );

		const f32 ang = m_VelocityLimit.CeilRadian( );
		m_ChestAngle = ang;
		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += ang;
		}
		m_ArmAngle = ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= ang;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_WaitFrame * m_pMotion->m_LoveCoe, m_WaitAngle * m_pMotion->m_LoveLimitCoe );
			m_Step = STEP_WAIT_HEAD;
		}

		break;
	}
	case STEP_WAIT_HEAD:
	{
		jnt->GetMatrix( )->RotateZ( m_SpineAngle );

		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += m_ChestAngle;
		}

		const f32 ang = m_VelocityLimit.CeilRadian( );
		m_HeadAngle = ang;
		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += ang;
		}
		f32 a_ang;
		if( !m_VelocityLimit.IsLimit( ) ){
			a_ang = ang + m_ArmAngle;
			m_ArmAngle = a_ang;
		} else {
			a_ang = m_ArmAngle;
		}
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		if( m_Frame <= m_HitFrame * 3.0f ){ // wAAłR{
			m_VelocityLimit.Initialize( m_HitFrame * m_pMotion->m_LoveCoe, m_HitAngle * GetLimitSpineCoe( m_pMotion->m_LoveLimitCoe ) );
			BlinkHalfOpen( );
			m_Step = STEP_GO_SPINE;
		}

		break;
	}
	case STEP_GO_SPINE:
	{
		const f32 ang = m_SpineAngle - m_VelocityLimit.CeilRadian( );
		m_SpineAngle = ang;
		jnt->GetMatrix( )->RotateZ( ang );

		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += m_ChestAngle;
		}

		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += m_HeadAngle;
		}
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += m_ArmAngle;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= m_ArmAngle;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_HitFrame * m_pMotion->m_LoveCoe, m_HitAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
			m_Step = STEP_GO_CHEST;
		}

		break;
	}
	case STEP_GO_CHEST:
	{
		f32 ang = m_VelocityLimit.CeilRadian( );

		const f32 s_ang = m_SpineAngle - ang;
		m_SpineAngle = s_ang;
		jnt->GetMatrix( )->RotateZ( s_ang );

		if( m_pJointChest ){
			const f32 c_ang = m_ChestAngle - ang;
			m_ChestAngle = c_ang;
			m_pJointChest->GetRot( )->GetRefZ( ) += c_ang;
		}

		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += m_HeadAngle;
		}

		const f32 a_ang = m_ArmAngle - ang;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_HitFrame * m_pMotion->m_LoveCoe, m_HitAngle * m_pMotion->m_LoveLimitCoe );
			m_Step = STEP_GO_HEAD;
		}

		break;
	}
	case STEP_GO_HEAD:
	{
		f32 ang = m_VelocityLimit.CeilRadian( );

		const f32 s_ang = m_SpineAngle - ang;
		m_SpineAngle = s_ang;
		jnt->GetMatrix( )->RotateZ( s_ang );

		if( m_pJointChest ){
			const f32 c_ang = m_ChestAngle - ang;
			m_ChestAngle = c_ang;
			m_pJointChest->GetRot( )->GetRefZ( ) += c_ang;
		}

		if( m_pJointHead ){
			const f32 h_ang = m_HeadAngle - ang;
			m_HeadAngle = h_ang;
			m_pJointHead->GetRot( )->GetRefZ( ) += h_ang;
		}
		const f32 a_ang = m_ArmAngle - ang;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_HitFrame * m_pMotion->m_LoveCoe, m_HitAngle * GetLimitSpineCoe( m_pMotion->m_LoveLimitCoe ) );
			m_Step = STEP_LIMIT_SPINE;
		}

		break;
	}
	case STEP_LIMIT_SPINE:
	{
		jnt->GetMatrix( )->RotateZ( m_SpineAngle );

		f32 ang = m_VelocityLimit.CeilRadian( );
		if( m_pJointChest ){
			const f32 c_ang = m_ChestAngle - ang;
			m_ChestAngle = c_ang;
			m_pJointChest->GetRot( )->GetRefZ( ) += c_ang;
		}

		if( m_pJointHead ){
			const f32 h_ang = m_HeadAngle - ang;
			m_HeadAngle = h_ang;
			m_pJointHead->GetRot( )->GetRefZ( ) += h_ang;
		}
		const f32 a_ang = m_ArmAngle - ang;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_VelocityLimit.Initialize( m_HitFrame * m_pMotion->m_LoveCoe, m_HitAngle * GetLimitChestCoe( m_pMotion->m_LoveLimitCoe ) );
			m_Step = STEP_LIMIT_CHEST;
		}

		break;
	}
	case STEP_LIMIT_CHEST:
	{
		jnt->GetMatrix( )->RotateZ( m_SpineAngle );

		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += m_ChestAngle;
		}

		f32 ang = m_VelocityLimit.CeilRadian( );
		if( m_pJointHead ){
			const f32 h_ang = m_HeadAngle - ang;
			m_HeadAngle = h_ang;
			m_pJointHead->GetRot( )->GetRefZ( ) += h_ang;
		}
		const f32 a_ang = m_ArmAngle - ang;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		if( m_VelocityLimit.IsLimit( ) ){
			m_Wait = GFL_FPS;
			m_Step = STEP_LIMIT_HEAD;
		}

		break;
	}
	case STEP_LIMIT_HEAD:
	{
		jnt->GetMatrix( )->RotateZ( m_SpineAngle );

		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += m_ChestAngle;
		}

		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += m_HeadAngle;
		}
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += m_ArmAngle;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= m_ArmAngle;
		}

		const f32 wait = m_Wait - m_pMotion->GetFrameSpeed( );
		if( -gfl::core::Math::EPSILON < wait ){
			m_Wait = wait;
		} else {
			m_Wait = m_RevertFrame;
			m_Step = STEP_REVERT_SPINE;
		}

		break;
	}
	case STEP_REVERT_SPINE:
	{
		const f32 ang = m_SpineAngle * m_RevertCoe;
		m_SpineAngle = ang;
		jnt->GetMatrix( )->RotateZ( ang );

		if( m_pJointChest ){
			m_pJointChest->GetRot( )->GetRefZ( ) += m_ChestAngle;
		}

		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += m_HeadAngle;
		}
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += m_ArmAngle;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= m_ArmAngle;
		}

		const f32 wait = m_Wait - m_pMotion->GetFrameSpeed( );
		if( -gfl::core::Math::EPSILON < wait ){
			m_Wait = wait;
		} else {
			m_Wait = m_RevertFrame;
			m_Step = STEP_REVERT_CHEST;
		}

		break;
	}
	case STEP_REVERT_CHEST:
	{
		const f32 ang = m_SpineAngle * m_RevertCoe;
		m_SpineAngle = ang;
		jnt->GetMatrix( )->RotateZ( ang );

		if( m_pJointChest ){
			const f32 c_ang = m_ChestAngle * m_RevertCoe;
			m_ChestAngle = c_ang;
			m_pJointChest->GetRot( )->GetRefZ( ) += c_ang;
		}

		if( m_pJointHead ){
			m_pJointHead->GetRot( )->GetRefZ( ) += m_HeadAngle;
		}
		const f32 a_ang = m_ArmAngle * m_RevertCoe;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}

		const f32 wait = m_Wait - m_pMotion->GetFrameSpeed( );
		if( -gfl::core::Math::EPSILON < wait ){
			m_Wait = wait;
		} else {
			//			m_Wait = GFL_FPS;
			m_Step = STEP_REVERT_HEAD;
			BlinkOpen( );
		}

		break;
	}
	case STEP_REVERT_HEAD:
	{
		const f32 ang = m_SpineAngle * m_RevertCoe;
		m_SpineAngle = ang;
		jnt->GetMatrix( )->RotateZ( ang );

		if( m_pJointChest ){
			const f32 c_ang = m_ChestAngle * m_RevertCoe;
			m_ChestAngle = c_ang;
			m_pJointChest->GetRot( )->GetRefZ( ) += c_ang;
		}

		if( m_pJointHead ){
			const f32 h_ang = m_HeadAngle * m_RevertCoe;
			m_HeadAngle = h_ang;
			m_pJointHead->GetRot( )->GetRefZ( ) += h_ang;
		}
		const f32 a_ang = m_ArmAngle * m_RevertCoe;
		m_ArmAngle = a_ang;
		if( m_pJointArmRight ){
			m_pJointArmRight->GetRot( )->GetRefY( ) += a_ang;
		}
		if( m_pJointArmLeft ){
			m_pJointArmLeft->GetRot( )->GetRefY( ) -= a_ang;
		}
		break;
	}
	}

	// {[̓
	m_Position.Add( m_Velocity );
	m_Velocity.GetRefY( ) -= gfl::physic::DEFAULT_GRAVITY;

	if( m_Position.GetY( ) <= 0.0f ){
		m_Velocity.SetY( -m_Velocity.GetY( ) );
	}

	//	gfl::core::Debug::PrintConsole( "%d(%f) %f\n", m_Step, m_Frame, m_ArmAngle );

	//	SetObjectPosition( m_Position );

	if( DecreaseFrame( &m_Frame ) ){
		m_pJointHead ->GetMatrix( )->ApplyX( &m_Velocity, m_Velocity.Magnitude( ) );
	}

	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LoveCamera::LoveCamera( BaseCommandCharacter * mot ) : LoveBase( mot ) { }
//==============================================================================
//==============================================================================
kawaigari::LoveCamera::~LoveCamera( void )
{
	//	m_pMotion->SetInterest( 0 );
	MouthClose( );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveCamera::Update( void )
{
#if 0 // 
	switch( m_Step ){
	case STEP_INIT:
		m_pLoveInternal = GFL_NEW( m_pMotion->GetHeapBase( ) ) LoveListen( m_pMotion );
		m_pMotion->ResetSpring( );
		m_Step = STEP_LISTEN;
		break;

	case STEP_LISTEN:
		if( !m_pLoveInternal->Update( ) ){
			GFL_DELETE m_pLoveInternal;
			m_Step = STEP_WAIT;
		}
		break;

	case STEP_WAIT:
		if( m_pMotion->GetTouch( ) ){
			gfl::core::Vector3 cam;
			GetCameraPosition( &cam );
			m_pMotion->SetInterest( cam );
			m_Step = STEP_CAMERA;
		}
		break;
	case STEP_CAMERA:
		if( m_pMotion->GetTouch( ) ){
			m_pMotion->SetInterest( 0 );
			m_pMotion->ResetSpring( );
			m_Step = STEP_NO_ACTION;
		}
		break;
	case STEP_NO_ACTION:
		m_pMotion->ResetSpring( );
		if( m_pMotion->GetTouch( ) ){
			m_pMotion->SetInterest( 0 );
			m_Step = STEP_INIT;
		}
		break;
	}
#else // 
	switch( m_Step ){
	case STEP_INIT:
	{
		gfl::core::Vector3 cam;
		GetCameraPosition( &cam );
		m_pMotion->SetInterest( cam );
		m_Step = STEP_CAMERA;
	}
		break;
	}
#endif
	m_pMotion->BlinkControl( );
	return true;
}
//==============================================================================
//==============================================================================
kawaigari::LovePeep::LovePeep( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" )
{
	mot->SetForceCommand( Command::COM_IDLE );
	ShowCharacter( false );
}
//==============================================================================
//==============================================================================
kawaigari::LovePeep::~LovePeep( void ) {
	//	m_pMotion->SetInterest( 0 );
}

//==============================================================================
//==============================================================================
bool kawaigari::LovePeep::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	m_pMotion->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	//		f32 adj1 = PawnTask::GetInstance()->GetGlobalParameterFloat("p_DebugFloat1");

	switch( m_Step ){
	case STEP_INIT:
	{
		//		StoreAndSetUpCamera( &m_CameraPosition, &m_InterestPosition );
		//		m_CameraPosition.Set( 0.0f, 67.0f, 70.0f );
		//		m_InterestPosition.Set( 0.0f, 48.0f, 0.0f );

		m_CameraPosition.Set( 0.0f, CENTI( 62.618f ), CENTI( 57.874f ) );
		m_InterestPosition.Set( 0.0f, CENTI( 50.0f ), 0.0f );


		//		gfl::core::Debug::PrintConsole( "adj %f %f\n",adj,adj1);
		//		m_pMotion->GetRootPosition( )->GetRefY( ) -= METER( 1.0f );
		//		const f32 ypos = m_pMotion->GetRootPosition( )->GetY( ) - METER( 0.5f );
		const f32 ypos = CENTI( -40.0f );
		m_pMotion->GetRootPosition( )->SetY( ypos );
		m_OrgYPos = ypos;

		m_pMotion->ResetSpring( );
		m_Frame = GFL_SECOND( 2.0f );
		PlayerCamera::GetInstance( )->SetControllable( false );
		m_Step = STEP_WAIT;
		ShowCharacter( false );
		break;
	}
	case STEP_WAIT:
		m_pMotion->ResetSpring( );
		if( DecreaseFrame( &m_Frame ) ){
			m_VelocityLimit.Initialize( 20.0f, CENTI( 47.3f * 0.7f ) );
			ShowCharacter( true );
			m_Frame = GFL_SECOND( 3.0f );
			MouthOpen( );
			m_Step = STEP_MOVE;
		}
		break;
	case STEP_MOVE:
		if( !DecreaseFrame( &m_Frame ) ){
			m_pMotion->GetRootPosition( )->SetY( m_OrgYPos + m_VelocityLimit.Ceil( ) );
		} else {
			m_OrgYPos = m_pMotion->GetRootPosition( )->GetY( );
			m_Frame = GFL_SECOND( 2.0f );
			//			MouthClose( );
			m_Step = STEP_WAIT2;
		}
		break;
	case STEP_WAIT2:
		if( DecreaseFrame( &m_Frame ) ){
			m_VelocityLimit.Initialize( 20.0f, CENTI( 47.3f * 0.3f ) );
			//			ShowCharacter( true );
			m_Frame = GFL_SECOND( 3.0f );
			//			MouthOpen( );
			m_Step = STEP_MOVE2;
		}
		break;
	case STEP_MOVE2:
		if( !DecreaseFrame( &m_Frame ) ){
			m_pMotion->GetRootPosition( )->SetY( m_OrgYPos + m_VelocityLimit.Ceil( ) );
		} else {
			m_Frame = GFL_SECOND( 1.0f );
			MouthClose( );
			m_Step = STEP_REVERT;
		}
		break;
	case STEP_REVERT:
		if( !DecreaseFrame( &m_Frame ) ){
			gfl::core::Vector3 cam_pos( m_CameraPosition );
			gfl::core::Vector3 cam_int( m_InterestPosition );
			gfl::core::Vector3 cur_pos, cur_int;

			GetCameraPosition( &cur_pos );
			GetInterestPosition( &cur_int );

			f32 rate = m_Frame / GFL_SECOND( 1.0f );
			cam_pos.Lerp( cur_pos, rate );
			cam_int.Lerp( cur_int, rate );

			SetCameraPosition( cam_pos );
			SetInterestPosition( cam_int );
			m_pMotion->SetAttributeOff( proj::motion::Motion::M_ATTR_NO_IK );
		} else {
			PlayerCamera* cam = PlayerCamera::GetInstance( );
			//			gfl::core::Vector3 cur_int;
			//			GetInterestPosition( &cur_int );
			//			cam->_Interest.Set( cur_int, 0.0f );
			cam->SetControllable( true );
			//			m_Step = STEP_END;
			return false;
		}
	}
	return true;
}
//==============================================================================
//==============================================================================
kawaigari::LoveSuri::LoveSuri( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" ) { }
//==============================================================================
//==============================================================================
kawaigari::LoveSuri::~LoveSuri( void ) {
	//	m_pMotion->SetInterest( 0 );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveSuri::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	m_pMotion->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	m_pMotion->BlinkControl( );

	switch( m_Step ){
	case STEP_INIT:
	{
		StoreAndSetUpCamera( &m_CameraPosition, &m_InterestPosition );

		//		m_pMotion->GetRootPosition( )->GetRefY( ) -= METER( 1.0f );
		m_pMotion->ResetSpring( );
		m_Frame = GFL_SECOND( 2.0f );
		PlayerCamera::GetInstance( )->SetControllable( false );
		m_Step = STEP_WAIT;
		break;
	}
	case STEP_WAIT:
		m_pMotion->ResetSpring( );
		if( DecreaseFrame( &m_Frame ) ){
			m_OrgYPos = m_pMotion->GetRootPosition( )->GetY( );
			m_VelocityLimit.Initialize( 20.0f, METER( 0.5f ) );
			m_Frame = GFL_SECOND( 2.0f );
			MouthOpen( );
			m_Step = STEP_HIDE;
		}
		break;
	case STEP_HIDE:
		if( !DecreaseFrame( &m_Frame ) ){
			m_pMotion->GetRootPosition( )->SetY( m_OrgYPos - m_VelocityLimit.Ceil( ) );
		} else {
			m_Step = STEP_SURI;

			gfl::core::Vector3 v;
			GetInterestPosition( &v );
			m_InterestYPos = v.GetY( );
			m_InterestFrame = 0;

			//			ShowCharacter( false );
		}
		break;
	case STEP_SURI:
	{
		static const f32 s_InterestOffset[] = {
			CENTI( 0.5f ),
			CENTI( 1.0f ),
			CENTI( 1.5f ),
			CENTI( 2.0f ),
			CENTI( 2.5f ),
			CENTI( 3.0f ),
			CENTI( 3.5f ),
			CENTI( 4.0f ),
			CENTI( 4.5f ),
			CENTI( 5.0f ),
			CENTI( 5.5f ),
			CENTI( 6.0f ),
			CENTI( 6.5f ),
			CENTI( 7.0f ),
			CENTI( 7.5f ),
			CENTI( 8.0f ),
			CENTI( 8.5f ),
			CENTI( 9.0f ),
			CENTI( 9.5f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 9.5f ),
			CENTI( 9.0f ),
			CENTI( 8.5f ),
			CENTI( 8.0f ),
			CENTI( 7.5f ),
			CENTI( 7.0f ),
			CENTI( 6.5f ),
			CENTI( 6.0f ),
			CENTI( 5.5f ),
			CENTI( 5.0f ),
			CENTI( 4.5f ),
			CENTI( 4.0f ),
			CENTI( 4.5f ),
			CENTI( 5.0f ),
			CENTI( 5.5f ),
			CENTI( 6.0f ),
			CENTI( 6.5f ),
			CENTI( 7.0f ),
			CENTI( 7.5f ),
			CENTI( 8.0f ),
			CENTI( 8.5f ),
			CENTI( 9.0f ),
			CENTI( 9.5f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 9.5f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 8.5f ),
			CENTI( 8.0f ),
			CENTI( 7.5f ),
			CENTI( 7.0f ),
			CENTI( 6.5f ),
			CENTI( 6.0f ),
			CENTI( 5.5f ),
			CENTI( 5.0f ),
			CENTI( 4.5f ),
			CENTI( 4.0f ),
			CENTI( 3.5f ),
			CENTI( 3.0f ),
			CENTI( 2.5f ),
			CENTI( 2.0f ),
			CENTI( 1.5f ),
			CENTI( 1.0f ),
			CENTI( 0.5f ),
			CENTI( 0.0f ),
		};
		gfl::core::Vector3 v;
		GetInterestPosition( &v );
		const f32 ofs = s_InterestOffset[m_InterestFrame++];
		v.SetY( m_InterestYPos + ofs );
		SetInterestPosition( v );

		if( ofs == 0.0f ){
			m_OrgYPos = m_pMotion->GetRootPosition( )->GetY( );
			//			ShowCharacter( true );
			m_pMotion->ResetSpring( );
			m_Step = STEP_NIYA;
			m_VelocityLimit.Initialize( 20.0f, METER( 0.5f ) );
			m_Frame = GFL_SECOND( 3.0f );
		}
		break;
	}
	case STEP_NIYA:
		m_pMotion->GetRootPosition( )->SetY( m_OrgYPos + m_VelocityLimit.Ceil( ) );
		if( DecreaseFrame( &m_Frame ) ){
			MouthClose( );
			m_Frame = GFL_SECOND( 5.0f );
			m_Step = STEP_REVERT;
		}
		break;
	case STEP_REVERT:
		if( !DecreaseFrame( &m_Frame ) ){
			gfl::core::Vector3 cam_pos( m_CameraPosition );
			gfl::core::Vector3 cam_int( m_InterestPosition );
			gfl::core::Vector3 cur_pos, cur_int;

			GetCameraPosition( &cur_pos );
			GetInterestPosition( &cur_int );

			const f32 rate = m_Frame / GFL_SECOND( 5.0f );
			cam_pos.Lerp( cur_pos, rate );
			cam_int.Lerp( cur_int, rate );

			SetCameraPosition( cam_pos );
			SetInterestPosition( cam_int );
		} else {
			PlayerCamera* cam = PlayerCamera::GetInstance( );
			//			gfl::core::Vector3 cur_int;
			//			GetInterestPosition( &cur_int );
			//			cam->_Interest.Set( cur_int, 0.0f );
			cam->SetControllable( true );
			m_Step = STEP_END;
		}
	}
	return true;
}

//==============================================================================
//==============================================================================
kawaigari::LoveButt::LoveButt( BaseCommandCharacter * mot ) : LoveBase( mot, "J_head" ) { }
//==============================================================================
//==============================================================================
kawaigari::LoveButt::~LoveButt( void ) {
	//	m_pMotion->SetInterest( 0 );
}

//==============================================================================
//==============================================================================
bool kawaigari::LoveButt::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	m_pMotion->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	m_pMotion->BlinkControl( );

	switch( m_Step ){
	case STEP_INIT:
	{
		StoreAndSetUpCamera( &m_CameraPosition, &m_InterestPosition );

		m_Frame = GFL_SECOND( 2.0f );
		PlayerCamera::GetInstance( )->SetControllable( false );
		m_Step = STEP_WAIT;
		break;
	}
	case STEP_WAIT:
		m_pMotion->ResetSpring( );
		if( DecreaseFrame( &m_Frame ) ){
			m_Frame = GFL_SECOND( 0.6f );

			gfl::core::Vector3 v;
			GetCameraPosition( &v );

			v.Sub( *jnt->GetMatrix( )->GetTrans( ) );
			const f32 len = v.Magnitude( );
			v.Mul( ( ( len - CENTI( ( m_pMotion->GetCharacterId( ) == ID_PikachuTa ) ? 15.0f : 25.0f ) ) / len ) / m_Frame );
			m_Velocity.Set( v );

			m_RootPosition.Set( *m_pMotion->GetRootPosition( ) );

			MouthOpen( );
			m_Step = STEP_CLOSE;
		}
		break;
	case STEP_CLOSE:
		if( !DecreaseFrame( &m_Frame ) ){
			m_pMotion->GetRootPosition( )->Add( m_Velocity );
		} else {
			m_Step = STEP_HIT;

			gfl::core::Vector3 v;
			GetInterestPosition( &v );
			m_InterestYPos = v.GetY( );
			m_InterestZPos = v.GetZ( );

			GetCameraPosition( &v );
			m_CameraYPos = v.GetY( );

			m_InterestFrame = 0;
			ShowCharacter( false );
		}
		break;
	case STEP_HIT:
	{
		static const f32 s_InterestOffset[] = {
			CENTI( 0.5f ),
			CENTI( 1.0f ),
			CENTI( 1.5f ),
			CENTI( 2.0f ),
			CENTI( 2.5f ),
			CENTI( 3.0f ),
			CENTI( 3.5f ),
			CENTI( 4.0f ),
			CENTI( 4.5f ),
			CENTI( 5.0f ),
			CENTI( 5.5f ),
			CENTI( 6.0f ),
			CENTI( 6.5f ),
			CENTI( 7.0f ),
			CENTI( 7.5f ),
			CENTI( 8.0f ),
			CENTI( 8.5f ),
			CENTI( 9.0f ),
			CENTI( 9.5f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 9.5f ),
			CENTI( 9.0f ),
			CENTI( 8.5f ),
			CENTI( 8.0f ),
			CENTI( 7.5f ),
			CENTI( 7.0f ),
			CENTI( 6.5f ),
			CENTI( 6.0f ),
			CENTI( 5.5f ),
			CENTI( 5.0f ),
			CENTI( 4.5f ),
			CENTI( 4.0f ),
			CENTI( 4.5f ),
			CENTI( 5.0f ),
			CENTI( 5.5f ),
			CENTI( 6.0f ),
			CENTI( 6.5f ),
			CENTI( 7.0f ),
			CENTI( 7.5f ),
			CENTI( 8.0f ),
			CENTI( 8.5f ),
			CENTI( 9.0f ),
			CENTI( 9.5f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 10.0f ),
			CENTI( 9.5f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 9.0f ),
			CENTI( 8.5f ),
			CENTI( 8.0f ),
			CENTI( 7.5f ),
			CENTI( 7.0f ),
			CENTI( 6.5f ),
			CENTI( 6.0f ),
			CENTI( 5.5f ),
			CENTI( 5.0f ),
			CENTI( 4.5f ),
			CENTI( 4.0f ),
			CENTI( 3.5f ),
			CENTI( 3.0f ),
			CENTI( 2.5f ),
			CENTI( 2.0f ),
			CENTI( 1.5f ),
			CENTI( 1.0f ),
			CENTI( 0.5f ),
			CENTI( 0.0f ),
		};
		gfl::core::Vector3 v;
		GetInterestPosition( &v );
		f32 ofs = s_InterestOffset[m_InterestFrame++];
		v.SetZ( m_InterestZPos + ofs );
		ofs *= 10.0f;
		v.SetY( m_InterestYPos + ofs );

		SetInterestPosition( v );

		GetCameraPosition( &v );
		v.SetY( m_CameraYPos + ofs );
		SetCameraPosition( v );

		if( ofs == 0.0f ){
			//			m_pMotion->ResetSpring( );
			m_Step = STEP_NIYA;
			m_Frame = GFL_SECOND( 3.0f );

			v.Sub( m_RootPosition, *m_pMotion->GetRootPosition( ) );
			const f32 len = v.Magnitude( );
			v.Div( m_Frame );
			m_Velocity.Set( v );
			ShowCharacter( true );
		}
		break;
	}
	case STEP_NIYA:
		m_pMotion->GetRootPosition( )->Add( m_Velocity );
		if( DecreaseFrame( &m_Frame ) ){
			MouthClose( );
			m_Frame = GFL_SECOND( 5.0f );
			m_Step = STEP_REVERT;
		}
		break;
	case STEP_REVERT:
		if( !DecreaseFrame( &m_Frame ) ){
			gfl::core::Vector3 cam_pos( m_CameraPosition );
			gfl::core::Vector3 cam_int( m_InterestPosition );
			gfl::core::Vector3 cur_pos, cur_int;

			GetCameraPosition( &cur_pos );
			GetInterestPosition( &cur_int );

			const f32 rate = m_Frame / GFL_SECOND( 5.0f );
			cam_pos.Lerp( cur_pos, rate );
			cam_int.Lerp( cur_int, rate );

			SetCameraPosition( cam_pos );
			SetInterestPosition( cam_int );
		} else {
			PlayerCamera* cam = PlayerCamera::GetInstance( );
			//			gfl::core::Vector3 cur_int;
			//			GetInterestPosition( &cur_int );
			//			cam->_Interest.Set( cur_int, 0.0f );
			cam->SetControllable( true );
			m_Step = STEP_END;
		}
	}
	return true;
}

//==============================================================================
//==============================================================================
void kawaigari::LoveBase::GetTouchPositionByXY( gfl::core::Vector3* pos, const u16 touchx, const u16 touchy, const f32 z )
{
#ifdef GFL_PLATFORM_3DS
	gfl::debug::DebugG3dStereoCameraChase* cam = Graphic::GetInstance( )->GetCamera( );

	gfl::math::MTX34 view_matrix;
	gfl::math::MTX44 projection_matrix;

	cam->GetViewAndProjectionMatrix( &view_matrix, &projection_matrix );

	const f32 tx = ( f32 )touchx;
	const f32 ty = ( f32 )touchy;

	//		gfl::core::Debug::PrintConsole( "x %f y %f => ", tx, ty );

	f32 y = ( tx - 160 ) / -160;
	f32 x = ( ty - 120 ) / -120;

	//		gfl::core::Debug::PrintConsole( "x %f y %f\n", x, y );

	gfl::math::VEC4 vv = gfl::math::MathUtil::GetRayVector( &view_matrix, &projection_matrix, x, y );

	//		gfl::core::Matrix mat;
	//		LoveBase::GetCameraMatrix( &mat );

	gfl::core::Vector3 tri[3];

	Player* pl = ( Player* )m_pMotion;
	pl->GetGlobalRootMatrix( ).Trans( &tri[0], 0.0f, METER( 20.0f ), z );
	pl->GetGlobalRootMatrix( ).Trans( &tri[1], METER( 20.0f ), METER( -10.0f ), z );
	pl->GetGlobalRootMatrix( ).Trans( &tri[2], METER( -20.0f ), METER( -10.0f ), z );

	gfl::math::VEC3 cam_pos;
	cam->GetCameraPosition( cam_pos );
	vv *= 100.0f;

	gfl::math::VEC4 tri_[3], cam_pos4( cam_pos ), hit;
	tri[0].ToVEC4( &tri_[0] );
	tri_[0].w = 0.0f;
	tri[1].ToVEC4( &tri_[1] );
	tri_[1].w = 0.0f;
	tri[2].ToVEC4( &tri_[2] );
	tri_[2].w = 0.0f;

	if( gfl::math::MathUtil::RayPickPolygon( &hit, cam_pos4, vv, tri_[0], tri_[1], tri_[2] ) ){
		pos->FromVEC4( hit );
		//			gfl::core::Debug::PrintConsole( "hit %f %f %f\n", hit.x, hit.y, hit.z );
	}
#else // 
	pos->Set( METER( 2.0f ), METER( 0.3f ), METER( 2.0f ) );
#endif
}

#if 0 // 
//==============================================================================
//==============================================================================
bool kawaigari::LoveTouch::Update( void )
{
#    if 0 // 
	switch( m_Step ){
	case STEP_INIT:
		if( m_pMotion->GetTouch( ) ){
			if( m_pMotion->GetTouchY( ) < 150 ){
				m_pLoveInternal = GFL_NEW( m_pMotion->GetHeapBase( ) ) LovePuru( m_pMotion );
			} else {
				m_pLoveInternal = GFL_NEW( m_pMotion->GetHeapBase( ) ) LoveChin( m_pMotion );
			}
			m_Step = STEP_TOUCHING;
		}
		break;
	case STEP_TOUCHING:
		if( m_pMotion->GetTouching( ) ){
			m_pLoveInternal->Update( );
		} else {
			GFL_DELETE m_pLoveInternal;
			m_Step = STEP_INIT;
			BlinkOpen( );
			MouthClose( );
		}
	}
#    else //
	gfl::core::Vector3 pos;
	GetTouchPositionByXY( &pos, m_pMotion->GetTouchX( ), m_pMotion->GetTouchY( ) );
#    endif
	return true;
}
#endif
//==============================================================================
//==============================================================================
kawaigari::LoveTurn::LoveTurn( BaseCommandCharacter* mot ) : LoveBase( mot )
{
	m_pMotion->SetForceCommandTable( Command::COM_TURN, Command::TBL_TURN_180_R );
	// temp
	m_pMotion->SetRootRotationY( 0.0f );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveTurn::Update( void )
{
	return !m_pMotion->CheckMotionEnd( );
}
//==============================================================================
//==============================================================================
kawaigari::LoveTouch::LoveTouch( BaseCommandCharacter* mot ) : LoveLookBase( mot, "J_head" )
, m_AdjustAngle( 0.0f ), m_SmoothFrame( proj::motion::Motion::DEFAULT_SMOOTH_FRAME )
{
	mot->SetForceCommand( Command::COM_IDLE );
	m_TouchX = mot->GetTouchX( );
	m_TouchY = mot->GetTouchY( );
	BlinkClose( );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveTouch::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	// GĂȂ̂ŏI
	if( m_Step ){
		f32 end = m_SmoothFrame;

		if( end == proj::motion::Motion::DEFAULT_SMOOTH_FRAME ){
			m_OldTouchX = m_TouchX;
			m_OldTouchY = m_TouchY;
		}

		end -= m_pMotion->GetFrameSpeed( );
		if( end <= 0.0f ){
			return false;
		}
		m_SmoothFrame = end;
		const f32 div = gfl::core::Math::FRecip( ( f32 )proj::motion::Motion::DEFAULT_SMOOTH_FRAME );

		m_AdjustAngle *= end*div;

		const f32 x = ( f32 )m_OldTouchX;
		const f32 y = ( f32 )m_OldTouchY;

		m_TouchX = m_OldTouchX = ( u16 )( x + ( 200.0f - x ) * div );
		m_TouchY = m_OldTouchY = ( u16 )( y + ( 120.0f - y ) * div );
		//		gfl::core::Debug::PrintConsole( "t(%f)div%f %f %f => %d %d\n",end,div,x,y,m_TouchX,m_TouchY);
	}
	gfl::core::Vector3 pos;
	GetTouchPosition( &pos );
	pos.SetX( -pos.GetX( ) ); // Ό

	jnt->GetMatrix( )->AimYZ( pos );
	jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( m_AdjustAngle ) );

	m_pMotion->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );

	return true;
}
//==============================================================================
//==============================================================================
kawaigari::LoveLook::LoveLook( BaseCommandCharacter* mot ) : LoveLookBase( mot )
{
	mot->SetForceCommand( Command::COM_IDLE );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveLook::Update( void )
{
	return Look( );
}
#if 0 // 
//==============================================================================
//==============================================================================
kawaigari::LoveDownCast::LoveDownCast( BaseCommandCharacter* mot ) : LoveLookBase( mot )
{
	mot->SetForceCommand( Command::COM_IDLE );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveDownCast::Update( void )
{
	gfl::core::Vector3 pos;
	GetTouchPositionByXY( &pos, 200, 240 );
	m_pMotion->SetInterest( pos );
	return true;
}
#endif
//==============================================================================
//==============================================================================
const f32 kawaigari::LoveHand::s_cSmoothFrame = proj::motion::Motion::DEFAULT_SMOOTH_FRAME; //5 * GFL_FPS;
kawaigari::LoveHand::LoveHand( BaseCommandCharacter* mot ) : LoveLookBase( mot, "J_spine" ), m_SmoothFrame( 0.0f/*s_cSmoothFrame*/ )
{
	//	mot->SetForceCommandTable( Command::COM_HOLD, Command::TBL_HOLD_IDLE );
	//Look();
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return;
	}
	mot->MatrixToQuaternion( jnt + 1, jnt->_ChildCount - 1 );
	mot->QuaternionToLocalRadian( jnt + 1, jnt->_ChildCount - 1 );
	mot->GetInterest( )->ForceToFinish( );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveHand::Update( void )
{
	proj::motion::Joint* jnt = m_pJoint;
	if( !jnt ){
		return false;
	}

	gfl::core::Vector3 pos;
	GetTouchPosition( &pos );

	BaseCommandCharacter* mot = m_pMotion;
	//	gfl::core::Debug::PrintConsole( "%d(%d) %d\n", mot->GetMotionNumber( ), ( s32 )mot->GetFrame( ), m_Step );

	f32 smooth = m_SmoothFrame - mot->GetFrameSpeed( );
#if 1 // 
	if( 0.0f < smooth ){
		//		gfl::core::Matrix mat;
#    if 1 // 
		f32 rate;
		if( m_Step == STEP_BEGIN ){
			//			mat.Set( *jnt->GetOldMatrix( ) );
			rate = smooth / s_cSmoothFrame;
		} else {
			//			mat.Set( *jnt->GetMatrix( ) );
			rate = 1.0f - smooth / proj::motion::Motion::DEFAULT_SMOOTH_FRAME;
		}
#    endif
		gfl::core::Matrix mat( *jnt->GetMatrix( ) );
		mat.AimXZ( pos, true );
		mat.RotateZ( gfl::core::Math::DegreeToRadian( -30.0f ) );
		gfl::core::Quaternion new_qt;
		mat.MatrixToQuaternion( &new_qt );
		//		new_qt.Slerp( *jnt->GetQuat( ), ( m_Step == STEP_BEGIN ) ?
		//							 ( smooth / s_cSmoothFrame ) : ( 1.0f - smooth / proj::motion::Motion::DEFAULT_SMOOTH_FRAME ) );
		new_qt.Slerp( *jnt->GetQuat( ), rate );
		new_qt.QuaternionToMatrix( jnt->GetMatrix( ) );

		//		jnt->GetMatrix( )->GetRadian( &ang );
		//		ang.PrintConsoleDegree( "aft" );

		m_SmoothFrame = smooth;
	} else {
		if( m_Step == STEP_END ){
			return false;
		} else if( !mot->GetTouching( ) ){
			m_SmoothFrame = proj::motion::Motion::DEFAULT_SMOOTH_FRAME;
			m_Step = STEP_END;
		}
		jnt->GetMatrix( )->AimXZ( pos, true );
		jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -30.0f ) );
		jnt->GetQuat( )->MatrixToQuaternion( *jnt->GetMatrix( ) );
	}
#else // 
	jnt->GetMatrix( )->AimXZ( pos, true );
	jnt->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -30.0f ) );
	jnt->GetQuat( )->MatrixToQuaternion( *jnt->GetMatrix( ) );
#endif

	mot->CalculateMatrix( jnt + 1, jnt->_ChildCount - 1 );
	mot->MatrixToQuaternion( jnt + 1, jnt->_ChildCount - 1 );
	//	mot->QuaternionToLocalRadian(jnt + 1, jnt->_ChildCount - 1 );

	if( mot->CheckAttribute( proj::motion::Motion::M_ATTR_IDLE ) ){
		if( smooth <= 0.0f ){
			mot->SetForceCommandTable( Command::COM_HOLD, Command::TBL_HOLD_IDLE );
		}
	} else if( mot->CheckMotionEnd( ) ){
		mot->SetForceCommandTable( Command::COM_HOLD, Command::TBL_HOLD_IDLE );
	}
	return true;
}
//==============================================================================
//==============================================================================
kawaigari::LoveWalk::LoveWalk( BaseCommandCharacter* mot ) : LoveBase( mot ), m_WalkCount( 0 )
{
	mot->SetForceCommandTable( Command::COM_HOLD, Command::TBL_RUN_0 );
}
//==============================================================================
//==============================================================================
bool kawaigari::LoveWalk::Update( void )
{
	BaseCommandCharacter* mot = m_pMotion;
	gfl::core::Vector3 v;
	GetCameraPosition( &v );
	v.GetRefZ( ) -= CENTI( 0.5f );
	SetCameraPosition( v );
	mot->GetRootPosition( )->GetRefZ( ) += CENTI( 0.5f );

	if( mot->CheckMotionEnd( ) ){
		if( m_WalkCount ){
			mot->ResetSpring( );
			return false;
		} else {
			m_WalkCount = 1;
			mot->Repeat( );
		}
	}
	return true;
}
