/* 
 * File:   BaseCommandCharacter.h
 * Author: kimura_shin
 *
 * Created on 2010/12/09, 17:07
 */

#ifndef BASECOMMANDCHARACTER_H
#define	BASECOMMANDCHARACTER_H

#include <system/motion/BaseMotionCharacter.h>
#include "commandTable.h"
#include "commandClass.h"
#include "Love.h"

GFL_NAMESPACE_BEGIN( kawaigari )

class BaseCommandCharacter : public proj::motion::BaseMotionCharacter {
protected:
	u32 CommandToCommonMotionNumber( const u32 tbl );
	u32 CommandToCharacteristicMotionNumber( const u32 tbl );
	u32 CommandToMotionNumber( const u32 tbl );

	void CommonCommand( const u32 com, u32 tbl, u32 flag );

	//  ----------------------------------------------------------------------------
	//! @brief  \R}h
	//! @param  flag tO
	//! @return Ȃ
	//  ----------------------------------------------------------------------------
	virtual void Command_Idle( const u32 flag );

	// ---------------------------------------------------------------------
	//! @brief  R}hݒ肷
	//! @param  Ȃ
	//! @return Ȃ
	//! @remark NGXĝR}hݒB
	// ---------------------------------------------------------------------
	virtual void SetCommand( const u32 com, u32 tbl, u32 flag );

public:

	enum {
#define SET_CMS(name,txt) B_CMS_ ## name ,
#include "commandStatus.h"
#define SET_CMS(name,txt) M_CMS_ ## name = ( 1 << B_CMS_ ## name ) ,
#include "commandStatus.h"
		B_CMS_END // avoid warning
	};

	// MotionStatus@̓[VςƃNA

	enum {
#define SET_MTS(name) B_MTS_ ## name ,
#include "MotionStatus.h"
#define SET_MTS(name) M_MTS_ ## name = ( 1 << B_MTS_ ## name ) ,
#include "MotionStatus.h"
		B_MTS_CHARACTER = 16 // LLȃrbg錾͂
	};

	BaseCommandCharacter( void );

	virtual ~BaseCommandCharacter( void ) {
		GFL_DELETE m_pLove;
		GFL_DELETE [] GetData(); // { MotionBase ̊NXŏǁB
	}

	void InitializeCommand( const u32 motion_id );
	void ResetCommand( void );
	void ResetToIdleCommand( void );
	void SetMotion( const u32 num );
	void SetMotionByCommand( const u32 tbl );
	void SetAndClearRequest( const u32 flag );
	// R}hRg[
	void CommandControl( void );
	// Xe[^XtO
	void UpdatePadStatus( void );

	inline u32 GetCommandStatus( void ) {
		return _CommandStatus;
	}

	inline u32 CheckCommandStatus( const u32 stat ) {
		return _CommandStatus & stat;
	}

	inline void SetCommandStatus( const u32 stat ) {
		_CommandStatus = stat;
	}

	inline void SetCommandStatusOn( const u32 stat ) {
		_CommandStatus |= stat;
	}

	inline void SetCommandStatusOff( const u32 stat ) {
		_CommandStatus &= ~stat;
	}

	inline void SetCommandStatusOnAndOff( const u32 on, const u32 off ) {
		u32 flag = GetCommandStatus( );
		flag &= ~off;
		flag |= on;
		SetCommandStatus( flag );
	}

	bool CheckForceCommand( const u32 com );

	inline void SetForceCommand( const u32 com ) {
		if( CheckForceCommand( com ) ){
			_ForceCommand.SetCommand( com );
		}
	}

	inline void SetForceCommandTable( const u32 com, const u32 tbl ) {
		if( CheckForceCommand( com ) ){
			_ForceCommand.SetCommandTable( com, tbl );
		}
	}

	inline void SetForceCommandTable( const u32 com, const u32 tbl, const u32 flag ) {
		if( CheckForceCommand( com ) ){
			_ForceCommand.SetCommandTable( com, tbl, flag );
		}
	}
#if USE_DEBUG_PAD

	inline nn::hid::DebugPadStatus* GetPadStatus( void ) {
		return _pDebugPadStatus;
	}
#endif

	void SetNextCommandTable( const u32 num ) {
		_NextCommandTable = num;
	}

	inline u32 GetMotionStatus( void ) const {
		return _MotionStatus;
	}

	inline u32 CheckMotionStatus( const u32 stat ) const {
		return _MotionStatus & stat;
	}

	inline void SetMotionStatus( const u32 stat ) {
		_MotionStatus = (u8) stat;
	}

	inline void SetMotionStatusOn( const u32 stat ) {
		_MotionStatus |= stat;
	}

	inline void SetMotionStatusOff( const u32 stat ) {
		_MotionStatus &= ~stat;
	}

	inline u32 CheckMotionEnd( void ) {
		return CheckMotionStatus( BaseCommandCharacter::M_MTS_MOTION_END );
	}

	// [Vf[^Xe[^XȂǂݒ
	void SetMotionStatus( void );

#ifdef GFL_PLATFORM_PC
	QWidget* CreateLove( const u32 id, QWidget* parent=0 );
#else
	void CreateLove( const u32 id );
#endif
	void DestroyLove( void );
	void CheckLove( void );

	LoveBase* GetLove( ) const {
		return m_pLove;
	} // need mutex ?

	virtual void ProgramControl( void );
	void BlinkControl( void );

	void BlinkOpen( void ) {
#ifdef GFL_PLATFORM_3DS
		Graphic::GetInstance( )->BlinkOpen( );
#endif
	}

	void BlinkHalfOpen( void ) {
#ifdef GFL_PLATFORM_3DS
		Graphic::GetInstance( )->BlinkHalfOpen( );
#endif
	}

	void BlinkClose( void ) {
#ifdef GFL_PLATFORM_3DS
		Graphic::GetInstance( )->BlinkClose( );
#endif
	}

	void MouthOpen( void );
	void MouthClose( void );
	void MouthControl( void );

	void DebugPadControl( void );

	u8 GetReleased( ) const {
		return m_Released;
	}

	u8 GetTouching( ) const {
		return m_Touching;
	}

	u8 GetTouch( ) const {
		return m_Touch;
	}

	u16 GetTouchY( ) const {
		return m_TouchY;
	}

	u16 GetTouchX( ) const {
		return m_TouchX;
	}

	void SetReleased( u8 Released ) {
		this->m_Released = Released;
	}

	void SetTouching( u8 Touching ) {
		this->m_Touching = Touching;
	}

	void SetTouch( u8 Touch ) {
		this->m_Touch = Touch;
	}

	void SetTouchY( u16 TouchY ) {
		this->m_TouchY = TouchY;
	}

	void SetTouchX( u16 TouchX ) {
		this->m_TouchX = TouchX;
	}

	u16 GetCharacterId( ) const {
		return m_CharacterId;
	}

	u16 GetMotionId( ) const {
		return m_MotionId;
	}

	void SetLoveId( u8 LoveId ) {
		this->m_LoveId = LoveId;
	}

	u8 GetLoveId( ) const {
		return m_LoveId;
	}
#ifdef GFL_PLATFORM_3DS

	gfl::ui::VectorDevice* GetStick( ) const {
		return m_pStick;
	}
#endif
	// ̂̂x]̐ݒ

	// ̂̂x]̎擾

	f32 GetRootRotationY( void ) const {
		return GetRootRotation( )->GetY( );
	}

	void SetRootRotationY( const f32 rad ) {
		GetRootRotation( )->SetY( rad );
	}

	//protected:
public: // Ƃ肠
#ifdef GFL_PLATFORM_3DS
#if USE_DEBUG_PAD
	nn::hid::DebugPadStatus* _pDebugPadStatus;
#else
	gfl::ui::Button* m_pButton;
	gfl::ui::VectorDevice* m_pVector;
	gfl::ui::VectorDevice* m_pCross;
	gfl::ui::VectorDevice* m_pStick;
#endif
#endif
	Command _ForceCommand; // R}h
	Command _RequestCommand; // NGXgR}h
	Command _CurrentCommand; // ݂̃R}h
	VelocityLimit m_MouthVelocity;

	LoveBase* m_pLove;
	proj::motion::Joint* m_pJointMouth;

	u16* _pCommandToMotionNumberTable; // R}h烂[Vԍ擾e[u|C^
	u16* _pCommandToCharacteristicMotionNumberTable; // R}hLL[Vԍ擾e[u|C^

	f32 m_BlinkFrame; // ܂΂^C}[
	f32 m_LoveCoe; // ̌W
	f32 m_LoveLimitCoe; // ̌EW

	u32 _MotionStatus; // [VςƃNAtO ʂPUrbg͋ʁ@ʂPUrbg̓LŗL
	u32 _CommandStatus; // Xe[^XtO
	u16 _NextCommandTable; // ݂̃[VIƂ̃R}he[uIɍĐ
	u8 _ActionStep; // ANVXebv@R}h̍s̃Xebv
	u8 _NoUse_BaseCommandCharacter;

	enum {
		MOUTH_NO_CONTROL,
		MOUTH_OPEN,
		MOUTH_CLOSE,
	};

	u8 m_MouthStep;

private:

	f32 m_OldStickX;
	f32 m_OldStickY;

	u16 m_MotionId;
	u16 m_CharacterId;

	u16 m_TouchX;
	u16 m_TouchY;
	u8 m_Touch;
	u8 m_Touching;
	u8 m_Released;
	u8 m_LoveId;

	u32 m_On;
	u32 m_Off;
	u32 m_Old;
	u32 m_Now;
};

GFL_NAMESPACE_END( kawaigari )

#endif	/* BASECOMMANDCHARACTER_H */
