#include "BaseCommandCharacter.h"
kawaigari::BaseCommandCharacter::BaseCommandCharacter( void )
: m_pLove( 0 ), m_pJointMouth( 0 ), m_BlinkFrame( 0.0f ), m_MouthStep( 0 ), m_LoveId( 0 ),
m_On( 0 ), m_Off( 0 ), m_Old( 0 ), m_Now( 0 ) { }

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::InitializeCommand( const u32 mot_id )
{
	m_MotionId = m_CharacterId = mot_id; // {̓LID͈Ⴄ͂
	// ӁIe[uȂ̂łƂ肠
	_pCommandToMotionNumberTable = CommandTable::_spCommandToMotionNumberTable[0][CommandTable::MOT_COMMON];
	_pCommandToCharacteristicMotionNumberTable = CommandTable::_spCommandToMotionNumberTable[0][CommandTable::MOT_CHARACTERISTIC];
	ResetToIdleCommand( );
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::ResetCommand( void )
{
	_CommandStatus = 0;
	_NextCommandTable = 0;
}

// -----------------------------------------------------------------------------
//@\Ԃɖ߂
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::ResetToIdleCommand( void )
{
	//	InterruptCommand( );
	ResetCommand( );
	_ForceCommand.SetCommandTable( Command::COM_IDLE, 0, Command::CMF_SMOOTH_OFF );
}

// -----------------------------------------------------------------------------
// Command to MotionNumber
// -----------------------------------------------------------------------------
u32 kawaigari::BaseCommandCharacter::CommandToCommonMotionNumber( const u32 tbl )
{
	return _pCommandToMotionNumberTable[tbl - 1];
}

// -----------------------------------------------------------------------------
// Command to MotionNumber
// -----------------------------------------------------------------------------
u32 kawaigari::BaseCommandCharacter::CommandToCharacteristicMotionNumber( const u32 tbl )
{
	return _pCommandToCharacteristicMotionNumberTable[tbl - Command::TBL_COMMON_END - 1];
}

// -----------------------------------------------------------------------------
// Command to MotionNumber
// -----------------------------------------------------------------------------
u32 kawaigari::BaseCommandCharacter::CommandToMotionNumber( const u32 tbl )
{
	return( tbl < Command::TBL_COMMON_END ) ?
		CommandToCommonMotionNumber( tbl ) :
		CommandToCharacteristicMotionNumber( tbl );
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::SetMotionStatus( void )
{
	// MPI ̃|C^ݒ
	//	u32* data = SetMotionAttribute( );

	// {IMotionStatus ̓[VɂONA
	SetMotionStatus( CheckAttribute( proj::motion::Motion::M_ATTR_CHANGEABLE ) ? M_MTS_CHANGEABLE : 0 );
}

// -----------------------------------------------------------------------------
// SetMotion
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::SetMotion( const u32 num )
{
	Change( num );
	//	SetFrameSpeed( 1.0f );
	SetMotionAttribute( );
	SetMotionStatus( );
}

// -----------------------------------------------------------------------------
// SetMotionByCommand
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::SetMotionByCommand( const u32 tbl )
{
	SetMotion( CommandToMotionNumber( tbl ) );
}

// -----------------------------------------------------------------------------
// SetAndClearRequest
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::SetAndClearRequest( const u32 flag )
{
	_CurrentCommand = _RequestCommand;
	if( !( flag & Command::CMF_NOT_CLEAR_STEP ) ){
		_ActionStep = 0;
	}
	if( !( flag & Command::CMF_NOT_CLEAR_NEXT_COMMAND_TABLE ) ){
		_NextCommandTable = 0;
	}
	_RequestCommand.Clear( );
}

// -----------------------------------------------------------------------------
// Command_Idle
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::Command_Idle( const u32 flag )
{
	u32 tbl;

	tbl = Command::TBL_IDLE;
	//	SetStatusFlagOff( M_STF_NOT_ADJUST_IK ); // for safe

	if( _CurrentCommand.GetTable( ) == tbl ){
		if( !CheckMotionStatus( M_MTS_MOTION_END ) ){
			return;
		}
	}

	_RequestCommand.SetTable( tbl );

	SetAndClearRequest( flag );
	SetMotionByCommand( tbl );
}

// -----------------------------------------------------------------------------
// Common Command
// -----------------------------------------------------------------------------
inline void kawaigari::BaseCommandCharacter::CommonCommand( const u32 com, u32 tbl, u32 flag )
{
	switch( com ){
	case Command::COM_ATTACK_SHIFT:
		if( flag & Command::CMF_FIRST_ATTACK ){
			//			_pLastAttackTarget = 0;
			//			_StatusFlag |= M_STF_FIRST_ATTACK;
		}

		SetAndClearRequest( flag );
		//		SetAttackMotionByCommand( tbl );
		break;

	case Command::COM_TURN:
		if( _CurrentCommand.GetCommand( ) != com ){ // ^[łȂ
			//			_LeverRotationTarget = _LeverRotation;
			//			_Lever4DirectionTarget = _Lever4Direction;

			SetAndClearRequest( flag );
			SetMotionByCommand( tbl );
		}
		break;

	case Command::COM_IDLE:
		Command_Idle( flag );
		break;

	case Command::COM_DUMMY: // not set
		break;

	case Command::COM_GUARD:
		if( _CurrentCommand.GetCommand( ) == com && _ActionStep ){
			break;
		}
		// through
	case Command::COM_HOLD:
	case Command::COM_MOVE:
	case Command::COM_RUN:
		if( _CurrentCommand.GetTable( ) == tbl ){
			if( !CheckMotionStatus( M_MTS_MOTION_END ) ){
				break;
			}
		}
		// through
	default:
		SetAndClearRequest( flag );
		SetMotionByCommand( tbl );
		break;
	}
}

// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::SetCommand( const u32 com, u32 tbl, u32 flag )
{
	if( com < Command::COM_COMMON_END ){
		CommonCommand( com, tbl, flag );
	} else { // LL̃[VZbg
		SetAndClearRequest( flag );
		SetMotionByCommand( tbl );
	}
}

// -----------------------------------------------------------------------------
// Command Control
// -----------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::CommandControl( void )
{
	// pbhɂR}h𔭍s
	//	PadControl( );

	Command* force = &_ForceCommand;
	Command* req = &_RequestCommand;

	if( force->GetCommand( ) ){
		*req = *force;
		force->Clear( );
	} else if( !CheckMotionStatus( M_MTS_CHANGEABLE ) ){
		return;
	}

	u32 com = req->GetCommand( );
	u32 flag = req->GetFlag( );
	u32 tbl = req->GetTable( );

	//if(!_Id)	Gr::Debug::PrintConsole( "com %d %d\n", com, tbl );

	// t[ێꍇ
	f32 frame = 0.0f;
	f32 frame_max = 0.0f;
	if( flag & Command::CMF_NOT_CLEAR_FRAME ){
		frame = GetFrame( );
		frame_max = GetFrameCount( );
	}

	// ꂼ̃L̃R}hZbg
	SetCommand( com, tbl, flag );

	// [Vς
	if( GetChanged( ) ){
		// X[YIt̏ꍇ
		if( flag & Command::CMF_SMOOTH_OFF ){
			SetSmoothFrameBefore( 0.0f );
		}
		if( !( flag & Command::CMF_NOT_CLEAR_FRAME ) ){
			SetBeginningFrame( 0.0f );
		} else {
			// [Vt[ʒuVK̃[Vɍ킹
			frame *= GetFrameCount( ) / frame_max;

			SetBeginningFrame( frame );
			SetFrameAndClear( frame );
			GetFcurve( )->GetValueByFrame( GetValue( ), frame );
			// ړʒuɕssN̂ŖςĂȂƂɂB
			//			SetChanged( false );
		}
	}
}

// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
void kawaigari::BaseCommandCharacter::UpdatePadStatus( void )
{
#ifdef GFL_PLATFORM_3DS
	kawaigari::Graphic* gra = kawaigari::Graphic::GetInstance( );
#    if USE_DEBUG_PAD
	//	nn::hid::DebugPadReader pad;
	//	pad.ReadLatest( &_DebugPadStatus );
	_pDebugPadStatus = gra->GetUiDeviceManager( )->GetDebugPadStatus( );
#    else // ͖t[KvȂ̂H
	gfl::ui::DeviceManager* pDeviceManager;
	if( gra ){
		pDeviceManager = gra->GetUiDeviceManager( );
	} else {
		return;
	}
	m_pButton = pDeviceManager->GetButton( 0 );
	m_pVector = pDeviceManager->GetStick( 0 );
	m_pCross = pDeviceManager->GetCrossKey( 0 );
	m_pStick = pDeviceManager->GetStick( 0 );

	gfl::ui::TouchPanel* tp = pDeviceManager->GetTouchPanel( 0 );
	m_Touch = tp->IsTouchTrigger( );
	m_Touching = tp->IsTouch( );
	m_Released = tp->IsTouchRelease( );
	tp->GetXY( &m_TouchX, &m_TouchY );
	//	if( m_TouchX | m_TouchY )
	//		gfl::core::Debug::PrintConsole( "touch %d %d\n", m_TouchX, m_TouchY );
#    endif
#elif 0 // 
	const QPoint& pos = MainWindow::GetInstance( )->GetGLWidget( )->GetMousePos( );
	m_TouchX = pos.x( );
	m_TouchY = pos.y( );
#endif

//	DebugPadControl( );
}

//==============================================================================
//==============================================================================
template<typename T>
static void SetTriggerReleaseOldStatus( T* on, T* off, T* old, const T now )
{
	T o = *old;
	*on = now & ( ~o );
	*off = ( ~now ) & o;
	*old = now;
}
void kawaigari::BaseCommandCharacter::DebugPadControl( )
{
#ifdef GFL_PLATFORM_3DS
	gfl::ui::VectorDevice* stick = GetStick( );
	//	u32 on = stick->GetTrigger( );

	Graphic* gra = Graphic::GetInstance( );
	const f32 x = stick->GetX( );
	const f32 y = stick->GetY( );

	u32 now = 0;
	if( 0.5f < x ){
		now |= gfl::ui::DIR_RIGHT;
	} else if( x<-0.5f ){
		now |= gfl::ui::DIR_LEFT;
	}
	if( 0.5f < y ){
		now |= gfl::ui::DIR_UP;
	} else if( y<-0.5f ){
		now |= gfl::ui::DIR_DOWN;
	}
	SetTriggerReleaseOldStatus( &m_On, &m_Off, &m_Old, now );

	u32 on = m_On;
	//	if( on )
	//		gfl::core::Debug::PrintConsole( "on 0x%x %f %f \n", on, x, y );

	if( ( on & gfl::ui::DIR_RIGHT ) && y < 0.5f ){
		if( LoveBase::LOVE_MAX <= ++gra->m_ChangeLoveId ){
			gra->m_ChangeLoveId = 0;
		}
	} else if( ( on & gfl::ui::DIR_LEFT ) && y < 0.5f ){
		if( --gra->m_ChangeLoveId < 0 ){
			gra->m_ChangeLoveId = LoveBase::LOVE_MAX - 1;
		}
	}
	if( ( on & gfl::ui::DIR_UP ) && x < 0.5f ){
		if( ID_MAX <= ++gra->m_ChangeCharacterId ){
			gra->m_ChangeCharacterId = 0;
		}
	} else if( ( on & gfl::ui::DIR_DOWN ) && x < 0.5f ){
		if( --gra->m_ChangeCharacterId < 0 ){
			gra->m_ChangeCharacterId = ID_MAX - 1;
		}
	}

	on = m_pButton->GetTrigger( );

	if( on & gfl::ui::BUTTON_A ){
		s32 para = gra->m_ChangeLoveId;
		CreateLove( para );
		SetLoveId( para );
	} else if( on & gfl::ui::BUTTON_B ){
		gra->SetReloadCharacterId( gra->m_ChangeCharacterId );
	}
#endif
}
//		gfl::core::Debug::PrintConsole( "%d %d\n", pl->GetChangeCharacterId( ), pl->GetChangeLoveId( ) );

//==============================================================================
//==============================================================================
#ifdef GFL_PLATFORM_PC
QWidget * kawaigari::BaseCommandCharacter::CreateLove( const u32 id, QWidget * parent )
#else // 
void kawaigari::BaseCommandCharacter::CreateLove( const u32 id )
#endif
{
	// ܂ł͖̈Yāc
	DestroyLove( );

	gfl::heap::HeapBase* heap = m_pHeapBase;

	// VȈ̎n܂
	switch( id ){
	case LoveBase::LOVE_LISTEN:
		m_pLove = GFL_NEW( heap ) LoveListen( this );
		break;
	case LoveBase::LOVE_SLEEP:
		m_pLove = GFL_NEW( heap ) LoveSleep( this );
		break;
#if 0 // 
	case LoveBase::LOVE_WAKEUP:
		m_pLove = GFL_NEW( heap ) LoveWakeUp( this );
		break;
#endif
	case LoveBase::LOVE_ROW:
		m_pLove = GFL_NEW( heap ) LoveRow( this );
		break;
	case LoveBase::LOVE_DELIGHT:
		m_pLove = GFL_NEW( heap ) LoveDelight( this );
		break;
	case LoveBase::LOVE_NOIDEA:
		m_pLove = GFL_NEW( heap ) LoveNoIdea( this );
		break;
	case LoveBase::LOVE_HATE:
		m_pLove = GFL_NEW( heap ) LoveHate( this );
		break;
#if 0 // 
	case LoveBase::LOVE_PURU:
		m_pLove = GFL_NEW( heap ) LovePuru( this );
		break;
	case LoveBase::LOVE_CHIN:
		m_pLove = GFL_NEW( heap ) LoveChin( this );
		break;
#else // 
	case LoveBase::LOVE_TOUCH:
		m_pLove = GFL_NEW( heap ) LoveTouch( this );
		break;
#endif
	case LoveBase::LOVE_EAT:
		m_pLove = GFL_NEW( heap ) LoveEat( this );
		break;
	case LoveBase::LOVE_EAT_IDLE:
		m_pLove = GFL_NEW( heap ) LoveEatIdle( this );
		break;
	case LoveBase::LOVE_HEADING:
		m_pLove = GFL_NEW( heap ) LoveHeading( this );
		break;
	case LoveBase::LOVE_CAMERA:
		m_pLove = GFL_NEW( heap ) LoveCamera( this );
		break;
	case LoveBase::LOVE_PEEP:
		m_pLove = GFL_NEW( heap ) LovePeep( this );
		break;
	case LoveBase::LOVE_SURI:
		m_pLove = GFL_NEW( heap ) LoveSuri( this );
		break;
	case LoveBase::LOVE_BUTT:
		m_pLove = GFL_NEW( heap ) LoveButt( this );
		break;
	case LoveBase::LOVE_PICKY:
		m_pLove = GFL_NEW( heap ) LovePicky( this );
		break;
	case LoveBase::LOVE_WALK:
		m_pLove = GFL_NEW( heap ) LoveWalk( this );
		break;
	case LoveBase::LOVE_TURN:
		m_pLove = GFL_NEW( heap ) LoveTurn( this );
		break;
	case LoveBase::LOVE_LOOK:
		m_pLove = GFL_NEW( heap ) LoveLook( this );
		break;
	case LoveBase::LOVE_HAND:
		m_pLove = GFL_NEW( heap ) LoveHand( this );
		break;
//	case LoveBase::LOVE_DOWNCAST:
//		m_pLove = GFL_NEW( heap ) LoveDownCast( this );
//		break;
	default:
#ifdef GFL_PLATFORM_PC
		return 0;
#else // 
		return;
#endif
	}
#ifdef GFL_PLATFORM_PC
	return  0;//m_pLove->CreateGui( parent );
#endif
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::DestroyLove( void )
{
#if 0 // def GFL_PLATFORM_PC
	if( m_pLove ){
		m_pLove->DestroyGui( );
	}
#endif
	GFL_DELETE m_pLove;
	m_pLove = 0;

//	SetInterest( 0 );
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::CheckLove( void )
{
	if( GetTouch( ) ){
		CreateLove( GetLoveId( )
#ifdef GFL_PLATFORM_PC
			, 0
#endif
			);
	}
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::ProgramControl( void )
{
	if( m_pLove ){ // 킢ꒆ
		if( !m_pLove->Update( ) ){
			DestroyLove( );
		}
		if( m_MouthStep != MOUTH_NO_CONTROL ){
			MouthControl( );
		}
	} else {
//		CheckLove( ); // Pawn ֈڍs

		BlinkControl( );
	}
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::BlinkControl( void )
{
	const f32 frame_speed = GetFrameSpeed( );
	const f32 frame = m_BlinkFrame - frame_speed;
	if( frame < 0.0f ){
		BlinkClose( );

		if( frame < -frame_speed * 5.0f ){
			m_BlinkFrame = 3.0f * gfl::motion::Fcurve::ONE_FRAME + gfl::core::Math::Random( 1.5f * gfl::motion::Fcurve::ONE_FRAME );
		} else {
			m_BlinkFrame = frame;
		}
	} else {
		BlinkOpen( );
		m_BlinkFrame = frame;
	}
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::MouthOpen( void )
{
	//	if( m_MouthStep == MOUTH_OPEN ){
	//		return;
	//	}

	proj::motion::Joint* jaw;
	m_pJointMouth = jaw = GetJointByName<proj::motion::Joint*>( "J_jaw" );
	if( jaw ){
		if( m_MouthStep != MOUTH_OPEN ){
			m_MouthVelocity.Initialize( 5.0f, 30.0f );
			m_MouthStep = MOUTH_OPEN;
		}
	} else {
#ifdef GFL_PLATFORM_3DS
		Graphic::GetInstance( )->MouthOpen( );
#endif
	}
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::MouthClose( void )
{
	//	if( m_MouthStep == MOUTH_CLOSE ){
	//		return;
	//	}

	proj::motion::Joint* jaw;
	m_pJointMouth = jaw = GetJointByName<proj::motion::Joint*>( "J_jaw" );
	if( jaw ){
		if( m_MouthStep != MOUTH_CLOSE ){
			m_MouthVelocity.Initialize( 5.0f, 30.0f );
			m_MouthStep = MOUTH_CLOSE;
		}
	} else {
#ifdef GFL_PLATFORM_3DS
		Graphic::GetInstance( )->MouthClose( );
#endif
	}
}

//==============================================================================
//==============================================================================
void kawaigari::BaseCommandCharacter::MouthControl( void )
{
	proj::motion::Joint* jaw;
	m_pJointMouth = jaw = GetJointByName<proj::motion::Joint*>( "J_jaw" );
	if( jaw ){
		if( m_MouthStep == MOUTH_OPEN ){
			jaw->GetMatrix( )->RotateZ( -m_MouthVelocity.CeilRadian( ) );
		} else if( m_MouthStep == MOUTH_CLOSE ){
			jaw->GetMatrix( )->RotateZ( gfl::core::Math::DegreeToRadian( -m_MouthVelocity.GetLimit( ) ) + m_MouthVelocity.CeilRadian( ) );
			if( m_MouthVelocity.IsLimit( ) ){
				m_MouthStep = MOUTH_NO_CONTROL;
			}
		}
	}
}
// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
bool kawaigari::BaseCommandCharacter::CheckForceCommand( const u32 com )
{
	// O͊Ɏł
	if( _CurrentCommand.GetCommand( ) == Command::COM_DEAD && com != Command::COM_DEAD ){
		return false;
	}

#define COMMAND_TO_PRIORITY(com) (( com <= Command::COM_DEAD ) ? com : Command::COM_ATTACK)
	const u32 force_com = _ForceCommand.GetCommand( );
	if( force_com ){
		return(COMMAND_TO_PRIORITY( force_com ) <= COMMAND_TO_PRIORITY( com ) );
	}
	return true;
}
