#pragma once

#include <gflib.h>

#include "strinput_heap.h"
#include "strinput_def.h"


namespace app {
namespace strinput {

class KeyMap {
private:
	typedef struct {
		u16	w;
		u16	h;
		gfl::str::STRCODE	code;
	}KEY_DATA;

	typedef struct {
		KEY_DATA * key[INPUT_TYPE_MAX];
	}KEYMAP_DATA;

public:
	KeyMap( Heap * heap );
	~KeyMap(void);

	gfl::str::STRCODE & GetKeyCode( u32 mode, u32 type, u32 id );

private:
	void CreateKeyMap( Heap * heap );
	void DeleteKeyMap(void);

	KEYMAP_DATA	dat;
};


}	// strinput
}	// app
