
#include "strinput_data.h"
#include "strinput_data.gaix"



namespace app {
namespace strinput {

/*
static const u32 KeyMapDataTable[] = {
}
*/


KeyMap::KeyMap( Heap * heap )
{
	CreateKeyMap( heap );
}

KeyMap::~KeyMap(void)
{
	DeleteKeyMap();
}

gfl::str::STRCODE & KeyMap::GetKeyCode( u32 mode, u32 type, u32 id )
{
	KEY_DATA * key_data = dat.key[type];
	return key_data[id].code;
}

void KeyMap::CreateKeyMap( Heap * heap )
{
	gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_STRINPUT_DATA );

	for( int i=0; i<INPUT_TYPE_MAX; i++ ){
		size_t siz = af->GetDataSize( GARC_strinput_data_keymap_abc_DAT+i ) / sizeof(KEY_DATA);
		dat.key[i] = GFL_NEW( heap->Get() ) KEY_DATA[siz];
		af->LoadData( GARC_strinput_data_keymap_abc_DAT+i, dat.key[i] );
	}

	GFL_DELETE af;
}

void KeyMap::DeleteKeyMap(void)
{
	for( int i=0; i<INPUT_TYPE_MAX; i++ ){
		GFL_DELETE []dat.key[i];
	}
}




}	// strinput
}	// app
