###############################################################################
#
#  kujira zufRo[^[
#
#     ruby buildmodel.rb text option outputdir [-M=modeldir] [headers]
#
#     text      : XLS2TABRo[^[ŏo͂eLXgf[^
#     option    : AREATEX   GAƂ̃eNX`f[^o
#                 BMDAT     GAƂ̔zuff[^o
#     outputdir : f[^o͐
#     modeldir  : ff[^͐
#     [headers] : CN[hwb_[Xg
#
#
# tomoya takahashi    2011.07/30
#
###############################################################################

#GAIXReader̓ǂݍ
require "#{ENV["PROJECT_ROOT"]}tools/headerdata.rb"


###############################################################################
###############################################################################
class DataFormatError < Exception; end


def debug_puts str
  #puts str
end


###############################################################################
# 萔
###############################################################################
BMID_INDEX        =  0        #zufID
FILENAME_INDEX    =  1        #t@C
COMMENT_INDEX     =  2        #TvERg
WIDTH_INDEX       =  3        #iXj
DEPTH_INDEX       =  4        #cij
HEIGHT_INDEX      =  5        #ij
MEMORY_INDEX      =  6        #풓
ATTR_INDEX        =  7        #attr
ANIME_FLAG_INDEX  =  8        #Ajw
ROOPANIME_INDEX   =  9        #[vAj
EVENTANIME_INDEX  = 10        #CxgAj
TIMEANIME_INDEX   = 11        #^CAj
PROGRAM_INDEX     = 12        #vOw
CHILDMODEL_INDEX  = 13        #]fw
CHILD_OFS_X_INDEX = 14        #]Xʒu
CHILD_OFS_Y_INDEX = 15        #]Yʒu
CHILD_OFS_Z_INDEX = 16        #]Zʒu

#Aj[Vf[^Ȃ
ANIME_NONE  = 0xffff
BMID_NONE   = 0xffff


###############################################################################
# A[JCut@CԂ֐
###############################################################################
def CreateGarcName filename

  #gq擾
  ext = File.extname(filename)

  #x[X擾
  base = File.basename(filename, ext)

  ext = ext.sub(/\./,"")
  ext = ext.upcase

  return "#{base}_B#{ext}"
end


###############################################################################
# zufNX
###############################################################################
class BMData

  attr :bmid
  attr :filename
  attr :width
  attr :depth
  attr :height
  attr :attr_data
  attr :anime_flag
  attr :roopanime
  attr :eventanime
  attr :timeanime
  attr :program
  attr :childmodel
  attr :child_ofs_x
  attr :child_ofs_y
  attr :child_ofs_z

  def initialize line
    column = line.split

    @bmid			    = column[BMID_INDEX]
    @filename     = column[FILENAME_INDEX]
    @width			  = column[WIDTH_INDEX]
    @depth			  = column[DEPTH_INDEX]
    @height			  = column[HEIGHT_INDEX]
    @attr_data	  = column[ATTR_INDEX]
    @anime_flag 	= column[ANIME_FLAG_INDEX]
    @roopanime	  = column[ROOPANIME_INDEX]
    @eventanime	  = column[EVENTANIME_INDEX]
    @timeanime	  = column[TIMEANIME_INDEX]
    @program		  = column[PROGRAM_INDEX]
    @childmodel	  = column[CHILDMODEL_INDEX]
    @child_ofs_x	= column[CHILD_OFS_X_INDEX]
    @child_ofs_y	= column[CHILD_OFS_Y_INDEX]
    @child_ofs_z	= column[CHILD_OFS_Z_INDEX]

    debug_puts("----------BMDATA------------")
    debug_puts( "bmid       :#{@bmid}" )
    debug_puts( "filename   :#{@filename}" )
    debug_puts( "width      :#{@width}" )  
    debug_puts( "depth      :#{@depth}" )  
    debug_puts( "height     :#{@height}" )	  
    debug_puts( "attr_data  :#{@attr_data}" ) 
    debug_puts( "anime_flag :#{@anime_flag}" )
    debug_puts( "roopanime  :#{@roopanime}" )
    debug_puts( "eventanime :#{@eventanime}" ) 
    debug_puts( "timeanime  :#{@timeanime	}" )
    debug_puts( "program    :#{@program}" )
    debug_puts( "childmodel :#{@childmodel}" )  
    debug_puts( "child_ofs_x:#{@child_ofs_x}" )
    debug_puts( "child_ofs_y:#{@child_ofs_y}" )
    debug_puts( "child_ofs_z:#{@child_ofs_z}" )
  end

  def dumpBinary headerArray, bmArray
    output = ""
    
    output += [@bmid.to_i].pack( "S" )
    
    output += [headerArray.search("GARC_field_bm_mdl_#{@filename}_BCMDL", "ft@C")].pack( "S" )
    
    if @program == "~" then
      output += [0].pack( "S" )
    else
      output += [headerArray.search(@program, "vO")].pack( "S" )
    end

    if @anime_flag == "~" then
      output += [0].pack( "S" )
    else 
      output += [1].pack( "S" )
    end

    if @roopanime == "[" then
      output += [ANIME_NONE].pack("S")
    else 
      filename = CreateGarcName( @roopanime )
      output += [headerArray.search("GARC_field_bm_anm_#{filename}", "[vAj[V")].pack("S")
    end
    
    if @eventanime == "[" then
      output += [ANIME_NONE].pack("S")
    else 
      filename = CreateGarcName( @roopanime )
      output += [headerArray.search("GARC_field_bm_anm_#{filename}", "CxgAj[V")].pack("S")
    end

    if @timeanime == "[" then
      output += [ANIME_NONE].pack("S")
    else 
      filename = CreateGarcName( @timeanime )
      output += [headerArray.search("GARC_field_bm_anm_#{filename}", "ԑуAj[V")].pack("S")
    end

    if @childmodel == "~" then
      output += [BMID_NONE].pack("S")
      output += [0].pack("s")
      output += [0].pack("s")
      output += [0].pack("s")
    else
      output += [bmArray.GetBMID(@childmodel)].pack("S")
      output += [@child_ofs_x.to_i].pack("s")
      output += [@child_ofs_y.to_i].pack("s")
      output += [@child_ofs_z.to_i].pack("s")
    end
    
    return output
  end
end
  
  

###############################################################################
# zufzǗNX
###############################################################################
class BMArray

  attr :objs
  attr :count
  
  def initialize stream
    @count = 0
    @objs = Array.new
    while line = stream.gets
      column = line.split
      if column[0] == "END" then
        break
      else
        @objs << BMData.new( line )
        @count = @count + 1
      end
    end
  end

  #ǉ
  def add data
    @objs << data
    @count = @count + 1
  end

  #t@CBMID̎擾
  def GetBMID filename

    @objs.each do |bmdata|
      if bmdata.filename == filename then
        return bmdata.bmid
      end
    end

    #ȂB
    raise DataFormatError, "#{filename}܂B"
  end


  #t@C̃f[^_v擾
  def GetBMDataDump filename, headerArray

    output = ""

    @objs.each do |bmdata|
      if bmdata.filename == filename then
        return bmdata.dumpBinary( headerArray, self )
      end
    end

    #ȂB
    raise DataFormatError, "#{filename}܂B"
  end
end


###############################################################################
# GAAzt@C
###############################################################################
class AreaBMData

  attr :bmArray
  attr :name
  attr :filenames
  attr :count

  def initialize stream, array

    @bmArray = array
    @count = 0
    @filenames = Array.new
    @name = "error"

    while line = stream.gets
      column = line.split
      if column[0] == "AREANAME" then
        @name = column[1] #GAt@C
      elsif column[0] == "END" then
        break
      elsif column[0] =~ /[0-1]+/
        @filenames << column[1]
        @count += 1
      end
    end

    debug_puts("------AREA------")
    debug_puts("name      :#{@name}")
    debug_puts("filenames :#{@filenames}")
  end


  #GAƂBMf[^zt@Co
  def WriteBinary dirname, headerArray

    output = ""

    @filenames.each {|modelname|
      output += @bmArray.GetBMDataDump( modelname, headerArray )
    }
    
    File.open("#{dirname}/#{name}.dat", "wb"){|file|
      file.write [ @count ].pack("I")
      file.write output
    }
  end
  
end


###############################################################################
# CMDLNX
###############################################################################
class CmdlData

  attr :texcount
  attr :texfilenames

  def initialize stream
    @texcount = 0
    @texfilenames = Array.new
    
    while line = stream.gets

      #eNX`QƏ̍sTB
      if line =~ /TextureReference/ then

        line = line.sub(/[\s\t]+/,"")
        line = line.sub(/\<TextureReference\>/,"")
        line = line.sub(/\<\/TextureReference\>/,"")
        line = line.sub(/Textures\[[^\]]+\]@file:/,"")
        line = line.sub(/\r\n/,"")
        line = line.sub(/\n/,"")

        debug_puts("array in texture #{line}")

        #f[^`FbN
        in_index = 0
        for in_index in 0..@texcount
          if @texcount != in_index
            if @texfilenames[in_index] == line then
              break
            end
          else

            #t@Ci[
            @texfilenames[@texcount] = line
            @texcount += 1

          end
        end
      end
      
    end
    
  end
  
end


###############################################################################
# GAƂ̔zuff[^zo
###############################################################################
def outputBMData dirname, file, headerArray, bmArray

  areaDataArray = Array.new

  debug_puts("outputBMData")
  while 1 do
    obj = AreaBMData.new( file, bmArray )
    if obj.name == "error" then
      debug_puts("AreaBMData input Error")
      break;
    end

    #GA񐶐
    areaDataArray << obj

    obj.WriteBinary( dirname, headerArray )

  end
end


###############################################################################
# GAƂ̃eNX`f[^𐶐
###############################################################################
def createAreaTexFolder dirname, inputdir, file, bmArray

  areaDataArray = Array.new

  debug_puts("createAreaTexFolder")
  while 1 do
    obj = AreaBMData.new( file, bmArray )
    if obj.name == "error" then
      debug_puts("AreaBMData input Error")
      break;
    end

    #GA񐶐
    areaDataArray << obj

    #GAtH_΁A
    if File.exist?("#{dirname}/#{obj.name}") == false then
      Dir.mkdir("#{dirname}/#{obj.name}")
    end

    #tH_̃eNX`Xg
    in_folder_files = Dir.glob("#{dirname}/#{obj.name}/*.cmdl")

    #GA̔zufQƂeNX`^CX^v݂ȂRs[B
    #AKv̂ȂeNX`́AjB
    obj.filenames.each{|filename|
      File.open( "#{inputdir}/#{filename}.cmdl", "r" ){ |infile|
        
        #cmdlT[`AKvȃeNX`Xg擾
        model = CmdlData.new( infile ) 

        #eNX`镪ARs[`FbNB
        model.texfilenames.each{|texfilename|

          #Textures/
          copy_texfilename = texfilename.sub(/Textures\//,"")

          #Rs[邩H
          is_copy = true

          #܂ÃeNX`邩`FbN
          if File.exist?("#{inputdir}/#{texfilename}") == false then
            raise DataFormatError, "#{inputdir}/#{texfilename}܂B"
          end

          #Rs[悪̂ł΁A
          if File.exist?( "#{dirname}/#{obj.name}/#{copy_texfilename}" ) then
            #Rs[̂قÂ̂ł΃Rs[ȂB
            if File.mtime( "#{dirname}/#{obj.name}/#{copy_texfilename}" ) > File.mtime( "#{inputdir}/#{texfilename}" )
              is_copy = false
            end
          end

          #Rs[B
          if is_copy then

            #Rs[
            File.open( "#{inputdir}/#{texfilename}", "r" ){|in_texfile|
              File.open( "#{dirname}/#{obj.name}/#{copy_texfilename}", "w" ){|out_texfile|
                out_texfile.write(in_texfile.read)
              }
            }

          end

          #Rs[Kv̂ŁAXgj
          for folder_count in 1..in_folder_files.size
            if in_folder_files[folder_count-1] == copy_texfilename then
              in_folder_files[folder_count-1] = "none"
              break
            end
          end
          
        }

      }

      #KvȂeNX`jB
      for folder_count in 1..in_folder_files.size
        if in_folder_files[folder_count-1] != "none" then
          #t@C̔j
          File.Delete( "#{dirname}/#{obj.name}/#{in_folder_files[folder_count-1]}" )
        end
      end

    }
    
  end
  
end


#------------------------------------------------------------------------------
#	C
#------------------------------------------------------------------------------
begin

  if ARGV.size < 3 then
    raise DataFormatError, "G["
  end
  

  #`FbN
  ifilename = ""
  option    = ""
  outputdir = ""
  modeldir  = ""
  headerArray = HeaderDataArray.new()
  arg_count = 0

  ARGV.each { |arg|

    if arg_count == 0 then
      ifilename = arg
    elsif arg_count == 1 then
      option = arg
    elsif arg_count == 2 then
      outputdir = arg
    elsif arg =~ /-M=/ then
      modeldir = arg.sub(/-M=/,"")
    else
      
      headerArray.load( arg )
    end
    arg_count += 1
  }
  
  #t@Cǂݍ
  debug_puts(ifilename)
  ifile = open( ifilename, "r" ) 

  #BMArray
  bmArray = BMArray.new( ifile )

  #s
  if option == "BMDAT" then
   outputBMData( outputdir, ifile, headerArray, bmArray )

  elsif option == "AREATEX"
  
    createAreaTexFolder( outputdir, modeldir, ifile, bmArray )
    
  end

  ifile.close

end
