//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldSubWindowTimeChangeProc.cpp
 *	@brief  ԑтύX鉺
 *	@author	Koji Kawada
 *	@date		2011.06.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "FieldSubWindowTimeChangeProc.h"

#include "field/event/EventPlayerView.h"

// arc
#include "arc/arc_def.h"           // ARCID_ 
#include "arc/time_change.gaix"


namespace field {

// lyt
#include "time_change.h"
#include "time_change_pane.h"


//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	ԑтύX鉺ʃNX
//=====================================

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowTimeChangeProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  {
    field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
    field::Graphics*         graphics         = p_fieldmap->GetGraphics();
    gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

    gfl::heap::HeapBase*     heap_memory      = this->GetSubWindowHeap();
    gfl::heap::HeapBase*     device_memory    = this->GetSubWindowDevice();
    gfl::heap::NwAllocator*  heap_allocator   = this->GetSubWindowHeapAllocator();
    gfl::heap::NwAllocator*  device_allocator = this->GetSubWindowDeviceAllocator();

    static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup = {
        gfl::math::VEC3(0,-290,0),  // pos 
        gfl::math::VEC2(1,1),       // scale
        gfl::math::VEC3(0,0,0),     // rotate
        0,                          // priority
        0                           // groupID
    };

    m_lyt_file   = GFL_NEW(heap_memory) gfl::fs::ArcFile( ARCID_TIME_CHANGE );
    m_lyt_res_id = lyt_sys->LoadLytRes( device_allocator, m_lyt_file, GARC_time_change_time_change_LYTDAT );
    lyt_sys->TransferAllTexture( m_lyt_res_id, gfl::grp::MEMORY_AREA_FCRAM );
    m_lyt_wk = lyt_sys->CreateLytWk( m_lyt_res_id, LYTRES_TIME_CHANGE_TIME_CHANGE_BCLYT, NULL, 0, 0, &lyt_wk_setup, false );
  }

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃CXVs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowTimeChangeProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  if( this->IsReqEnd() ){
    return gfl::proc::RES_FINISH;
  }

  // 
  {
    field::Fieldmap*         p_fieldmap = this->GetFieldmap();
    gamesystem::GameManager* gmgr       = p_fieldmap->GetGameManager();

    const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
    const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
    const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
    const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

    //if( touch_panel->IsTouchRelease() )  // @todo ReleaseœW(0,0)̂ƂgȂ
    if( touch_panel->IsTouchTrigger() )
    {
      u16 x;
      u16 y;
      //touch_panel->GetPrevXY(&x, &y);  // @todo ReleasePrevW𓾂̂ƂvႤ悤
      touch_panel->GetXY(&x, &y);  // ReleasePrevW𓾂

      //GFL_PRINT("%d, %d\n", x, y);

      enum
      {
        BUTTON_PICTURE_MORNING,
        BUTTON_PICTURE_DAYTIME,
        BUTTON_PICTURE_EVENING,
        BUTTON_PICTURE_NIGHT,

        BUTTON_PICTURE_MAX,

        BUTTON_PICTURE_NOT_TOUCH
      };
      struct Circle
      {
        gfl::math::VEC2 center;
        f32             radius;
      };
      static const f32 BUTTON_PICTURE_SCALE_NOT_TOUCH = 0.8f;
      static const f32 TOUCH_BUTTON_PICTURE_LARGER = 1.2f / 0.8f;  // wŃ^b`Ղ悤Ƀ^b`͈͂͌ڂ傫Ă
      static const Circle button_picture[BUTTON_PICTURE_MAX] =
      {
        { gfl::math::VEC2( -116.0f, -54.0f ), 32.0f },
        { gfl::math::VEC2(  -40.0f, -54.0f ), 32.0f },
        { gfl::math::VEC2(   40.0f, -54.0f ), 32.0f },
        { gfl::math::VEC2(  116.0f, -54.0f ), 32.0f },
      };

      u32 touch_button_picture = BUTTON_PICTURE_NOT_TOUCH;
      for( u32 i=0; i<BUTTON_PICTURE_MAX; ++i )
      {
        f32 dx = button_picture[i].center.x - (x-160.0f);
        f32 dy = button_picture[i].center.y - (-y+120.0f);
        f32 sr = button_picture[i].radius * BUTTON_PICTURE_SCALE_NOT_TOUCH * TOUCH_BUTTON_PICTURE_LARGER;
        if( dx*dx + dy*dy <= sr*sr )
        {
          touch_button_picture = i;
          break;
        }
      }

      if( touch_button_picture != BUTTON_PICTURE_NOT_TOUCH )
      {
        //GFL_PRINT("Touch (%d, %d), ButtonPicture %d\n", x, y, touch_button_picture);
        switch( touch_button_picture )
        {
        case BUTTON_PICTURE_MORNING: this->ChangeTime(skybox::PERIOD_TYPE_MORNING); break;
        case BUTTON_PICTURE_DAYTIME: this->ChangeTime(skybox::PERIOD_TYPE_DAYTIME); break;
        case BUTTON_PICTURE_EVENING: this->ChangeTime(skybox::PERIOD_TYPE_EVENING); break;
        case BUTTON_PICTURE_NIGHT:   this->ChangeTime(skybox::PERIOD_TYPE_NIGHT  ); break;
        }
      }
    }
  }

  return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃C`s֐
 *          zł͂܂B
 */
//------------------------------------------------------------------
void   SubWindowTimeChangeProc::DrawFunc(gfl::proc::Manager* /*pManager*/)
{
  field::Fieldmap*          p_fieldmap      = this->GetFieldmap();
  field::Graphics*          graphics        = p_fieldmap->GetGraphics();
  gfl::grp::GraphicsSystem* graphics_system = graphics->GetGraphicsSystem();
  skybox::Skybox*           l_skybox        = p_fieldmap->GetSkybox();

#if 0
  // ̊ȈՕ`
  {
    // tB[hőO㏈͍ς܂Ă̂ŁA`悷邾ł悢

    // 
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    graphics_system->BindCurrentCommandList( lower_frame_buffer );
    gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer ); 
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
    gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );   // オ(0, 0)

    s32 text_x_pos = 10;
    s32 text_y_pos = 10;
    const s32 text_y_pos_add = 20;

    gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"Time" );
    
    text_y_pos += text_y_pos_add;
    switch(l_skybox->GetPeriodType())
    {
    case skybox::PERIOD_TYPE_NIGHT:              gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"" );     break;
    case skybox::PERIOD_TYPE_MORNING:            gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"" );     break;
    case skybox::PERIOD_TYPE_DAYTIME:            gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"" );     break;
    case skybox::PERIOD_TYPE_EVENING:            gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"[" );     break;
    case skybox::PERIOD_TYPE_NIGHT_TO_MORNING:   gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"->" ); break;
    case skybox::PERIOD_TYPE_MORNING_TO_DAYTIME: gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"->" ); break;
    case skybox::PERIOD_TYPE_DAYTIME_TO_EVENING: gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"->[" ); break;
    case skybox::PERIOD_TYPE_EVENING_TO_NIGHT:   gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"[->" ); break;
    }
    
    text_y_pos += text_y_pos_add;

    gfl::grp::util::DrawUtil::EndRender();
  }
#endif
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowTimeChangeProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  {
    field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
    field::Graphics*         graphics         = p_fieldmap->GetGraphics();
    gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

    if( m_lyt_wk )
    {
      // [Nj
      lyt_sys->RemoveLytWk( m_lyt_wk );
      m_lyt_wk = NULL;

      // \[Xj
      lyt_sys->ReleaseLytRes( m_lyt_res_id );
      m_lyt_res_id = 0;  // 0ł낤
    }

    if( m_lyt_file )
    {
      // t@C
      GFL_DELETE m_lyt_file;
      m_lyt_file = NULL;
    }
  }

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	       Ԃdst_period_typeɕύX(dst_period_typeɂȂ܂ŎԂi߂)
 * @param[in]    dst_period_type    ύXĂ̎Ԃɂ
 */
//------------------------------------------------------------------
void SubWindowTimeChangeProc::ChangeTime(const skybox::PeriodType dst_period_type)
{
  field::Fieldmap*          p_fieldmap      = this->GetFieldmap();
  skybox::Skybox*           l_skybox        = p_fieldmap->GetSkybox();
  gfl::math::VEC3           field_control_pos;
  p_fieldmap->GetControlPos(&field_control_pos);

  while( l_skybox->GetPeriodType() != dst_period_type )
  {
    u32* year;
    u32* month;
    u32* day;
    u32* hour;
    u32* minute;
    u32* second;
    u32* frame;
    p_fieldmap->GetSkyboxCountPointer(&year, &month, &day, &hour, &minute, &second, &frame);

    if( dst_period_type == skybox::PERIOD_TYPE_NIGHT )
    {
      *hour   = 23;
      *minute = 0;
      *second = 0;
      *frame  = 0;
    }
    else if( dst_period_type == skybox::PERIOD_TYPE_DAYTIME )
    {
      *hour   = 11;
      *minute = 30;
      *second = 0;
      *frame  = 0;
    }
    else
    {
      EventPlayerView::UpdateSkyboxCount(
          60,  // 1i߂
          1,
          year,
          month,
          day,
          hour,
          minute,
          second,
          frame
      );
    }
 
    skybox::Weather weather;
    //weather.type = skybox::WEATHER_TYPE_CLOUDY;
    weather.type = skybox::WEATHER_TYPE_SUNNY;
    weather.end_rate = 0.0f;
    l_skybox->Calculate(
      field_control_pos,
      *year,
      *month,
      *day,
      *hour,
      *minute,
      *second,
      *frame,
      0.0f,
      0.0f,
      weather,
      0.0f
    );
  }
}


}  // namespace field

