#ifndef __FIELDSUBWINDOWCAMERACONTROLPROC_H__
#define __FIELDSUBWINDOWCAMERACONTROLPROC_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldSubWindowCameraControlProc.h
 *	@brief  J𑀍삷Cxg̉
 *	@author	Koji Kawada
 *	@date		2011.07.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "../FieldSubWindow.h"


namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	J𑀍삷Cxg̉ʃNX
//=====================================
class SubWindowCameraControlProc : public SubWindowProc
{
  GFL_FORBID_COPY_AND_ASSIGN(SubWindowCameraControlProc);


public:
  //-----------------------------------------------------------------------------
  /* 
   *    `
   */
  //-----------------------------------------------------------------------------
  struct RectU16
  {
    u16 left;    // left <=   < right
    u16 top;     // top  <=   < bottom
    u16 right;
    u16 bottom;
  };
  static b32 IsInRectU16( const RectU16& rect, const u16 x, const u16 y )
  {
    if(    rect.left<=x && x<rect.right
        && rect.top<=y && y<rect.bottom )
    {
      return true;
    }
    return false;
  }


public:
  //-----------------------------------------------------------------------------
  /* 
   *    萔
   */
  //-----------------------------------------------------------------------------
  static const RectU16 RETURN_BUTTON_RECT;


public:
  //-----------------------------------------------------------------------------
  /* 
   *    static֐
   */
  //-----------------------------------------------------------------------------
  static b32 IsProcEnd( const u16 touch_panel_x, const u16 touch_panel_y )
  {
    return IsInRectU16( RETURN_BUTTON_RECT, touch_panel_x, touch_panel_y );
  }


public:
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   */
  //-----------------------------------------------------------------------------
  SubWindowCameraControlProc( Fieldmap* p_fieldmap )
      : SubWindowProc(p_fieldmap),
        m_lyt_file(NULL),
        m_lyt_res_id(0),  // 0ł낤
        m_lyt_wk_common(NULL),
        m_lyt_wk(NULL),
        m_control_mode(CONTROL_MODE_EASY),
        m_display_mode(DISPLAY_MODE_INPUT),
        m_step(STEP_INITIALIZE),
        m_next_control_mode(m_control_mode),
        m_next_display_mode(m_display_mode),
        m_next_step(m_step)
  {
    // Ȃ
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   */
  //-----------------------------------------------------------------------------
  virtual ~SubWindowCameraControlProc()
  {
    // Ȃ
  }


public:
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏s֐
   * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result InitFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̃CXVs֐
   * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result UpdateFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̃C`s֐
   *          zł͂܂B
   */
  //------------------------------------------------------------------
  virtual void   DrawFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏Is֐
   * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result EndFunc(gfl::proc::Manager* pManager);


private:
  //------------------------------------------------------------------
  /**
   * @brief	  la(ȁꍇ͌)
   */
  //------------------------------------------------------------------
  static void AddCameraMemberRotateX(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraMemberRotateY(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraMemberRotateZ(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraMemberRotate(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a);  // [degree]

  static void AddCameraParameterRotateAroundTargetPositionBaseX(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraParameterRotateAroundTargetPositionBaseY(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraParameterRotateAroundTargetPositionBaseZ(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]
  static void AddCameraParameterRotateAroundTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a);  // [degree]

  static void AddCameraMemberFar(field::FieldStereoCamera* field_stereo_camera, const f32 a);
  static void AddCameraMemberNear(field::FieldStereoCamera* field_stereo_camera, const f32 a);
  static void AddCameraMemberFovy(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]

  static void AddCameraParameterPositionOffsetY(field::FieldStereoCamera* field_stereo_camera, const f32 a);
  static void AddCameraParameterDistance(field::FieldStereoCamera* field_stereo_camera, const f32 a);
  static void ToggleCameraParameterChaseEnable(field::FieldStereoCamera* field_stereo_camera);
  
  static void AddCameraParameterTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const f32 x, const f32 y, const f32 z);
  static void AddCameraParameterTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a);

  // CameraMemberCameraParameterύX
  static void AddCameraFovyKeepingHeight(field::FieldStereoCamera* field_stereo_camera, const f32 a);  // [degree]


private:
  // g2d
  enum
  {
    CC_LYTWK_COMMON,
    CC_LYTWK_INFO,
    CC_LYTWK_EASY_INPUT,
    CC_LYTWK_ALL_INPUT,
    
    CC_LYTWK_MAX
  };
  static const s32 CC_LYTRES_FOR_LYTWK[CC_LYTWK_MAX];
  gfl::fs::ArcFile*          m_lyt_file;
  gfl::grp::g2d::LytResID    m_lyt_res_id;
  gfl::grp::g2d::LytWk*      m_lyt_wk_common;
  gfl::grp::g2d::LytWk*      m_lyt_wk;

private:
  // S
  enum ControlMode
  {
    CONTROL_MODE_EASY,
    CONTROL_MODE_ALL,

    CONTROL_MODE_MAX
  };
  enum DisplayMode
  {
    DISPLAY_MODE_INPUT,
    DISPLAY_MODE_VALUE,
    DISPLAY_MODE_USAGE,

    DISPLAY_MODE_MAX
  };
  enum Step
  {
    STEP_INITIALIZE,
    STEP_UPDATE,
    STEP_FINALIZE,

    STEP_MAX
  };
  ControlMode m_control_mode;
  DisplayMode m_display_mode;
  Step m_step;
  ControlMode m_next_control_mode;
  DisplayMode m_next_display_mode;
  Step m_next_step;

  static const s32 CONTROL_DISPLAY_MODE_SERIAL_NO_MAX = CONTROL_MODE_MAX*DISPLAY_MODE_MAX;
      // CONTROL_MODE_EASYDISPLAY_MODE_INPUT
      // CONTROL_MODE_EASYDISPLAY_MODE_VALUE
      // CONTROL_MODE_EASYDISPLAY_MODE_USAGE
      // CONTROL_MODE_ALLDISPLAY_MODE_INPUT
      // CONTROL_MODE_ALLDISPLAY_MODE_VALUE
      // CONTROL_MODE_ALLDISPLAY_MODE_USAGE
      // ̏ɕׂ邱
  static const s32 CC_LYTWK_FOR_EACH_CONTROL_DISPLAY_MODE[CONTROL_DISPLAY_MODE_SERIAL_NO_MAX];
  static s32 GetControlDisplayModeSerialNo(ControlMode control_mode, DisplayMode display_mode)
  {
    return control_mode*DISPLAY_MODE_MAX+display_mode;
  }

  // Common
  gfl::proc::Result UpdateFuncForCommon(gfl::proc::Manager* pManager);  // UpdateFunc֐̍ŏɌĂ
  void   DrawFuncForCommon(gfl::proc::Manager* pManager);  // DrawFunc֐̍ŏɌĂ

  // ?, Value
  gfl::proc::Result UpdateFuncForValue(gfl::proc::Manager* pManager);
  void   DrawFuncForValue(gfl::proc::Manager* pManager);
  // ?, Usage
  gfl::proc::Result UpdateFuncForUsage(gfl::proc::Manager* pManager);

  // Easy
  gfl::proc::Result UpdateFuncForEasy(gfl::proc::Manager* pManager);  // UpdateFuncForCommon֐̎ɌĂ 
  void   DrawFuncForEasy(gfl::proc::Manager* pManager);  // DrawFuncForCommon֐̎ɌĂ
  // Easy, Input
  gfl::proc::Result UpdateFuncForEasyInput(gfl::proc::Manager* pManager);
  void   DrawFuncForEasyInput(gfl::proc::Manager* pManager);
  // Easy, Usage
  void   DrawFuncForEasyUsage(gfl::proc::Manager* pManager);

  // All
  gfl::proc::Result UpdateFuncForAll(gfl::proc::Manager* pManager);  // UpdateFuncForCommon֐̎ɌĂ 
  void   DrawFuncForAll(gfl::proc::Manager* pManager);  // DrawFuncForCommon֐̎ɌĂ
  // All, Input
  gfl::proc::Result UpdateFuncForAllInput(gfl::proc::Manager* pManager);
  void   DrawFuncForAllInput(gfl::proc::Manager* pManager);
  // All, Usage
  void   DrawFuncForAllUsage(gfl::proc::Manager* pManager);
};

}  // namespace field

#endif // __FIELDSUBWINDOWCAMERACONTROLPROC_H__
