//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldSubWindowCameraControlProc.cpp
 *	@brief  J𑀍삷Cxg̉
 *	@author	Koji Kawada
 *	@date		2011.07.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "FieldSubWindowCameraControlProc.h"

// arc
#include "arc/arc_def.h"           // ARCID_ 
#include "arc/camera_control.gaix"


namespace field {

// lyt
#include "camera_control.h"
#include "camera_control_pane.h"

enum
{
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_CONTROL_MODE,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISPLAY_MODE,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_END,

  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_CHASE,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OUT,
  
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OFFSET_Y_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OFFSET_Y_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_X_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_X_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_Y_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_Y_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FAR_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FAR_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_NEAR_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_NEAR_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FOVY_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FOVY_R,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISTANCE_L,
  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISTANCE_R,

  SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_MAX
};

static const char* SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_MAX] =
{
  "Window_BT_CtrlM",
  "Window_BT_DispM",
  "Window_BT_End",

  "Window_BT_Chase",
  "Window_BT_Out",

  "Window_BT_OfsYL",
  "Window_BT_OfsYR",
  "Window_BT_RotXL",
  "Window_BT_RotXR",
  "Window_BT_RotYL",
  "Window_BT_RotYR",
  "Window_BT_FarL",
  "Window_BT_FarR",
  "Window_BT_NearL",
  "Window_BT_NearR",
  "Window_BT_FOVYL",
  "Window_BT_FOVYR",
  "Window_BT_DistL",
  "Window_BT_DistR",
};


//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	J𑀍삷Cxg̉ʃNX
//=====================================

//-----------------------------------------------------------------------------
/* 
 *    萔
 */
//-----------------------------------------------------------------------------
const SubWindowCameraControlProc::RectU16 SubWindowCameraControlProc::RETURN_BUTTON_RECT = { 284, 220, 320, 240 };

const s32 SubWindowCameraControlProc::CC_LYTRES_FOR_LYTWK[CC_LYTWK_MAX] =
{
  LYTRES_CAMERA_CONTROL_CC_COMMON_BCLYT,
  LYTRES_CAMERA_CONTROL_CC_INFO_BCLYT,
  LYTRES_CAMERA_CONTROL_CC_EASY_INPUT_BCLYT,
  LYTRES_CAMERA_CONTROL_CC_ALL_INPUT_BCLYT,
};

const s32 SubWindowCameraControlProc::CC_LYTWK_FOR_EACH_CONTROL_DISPLAY_MODE[CONTROL_DISPLAY_MODE_SERIAL_NO_MAX] = 
{
      // CONTROL_MODE_EASYDISPLAY_MODE_INPUT
      // CONTROL_MODE_EASYDISPLAY_MODE_VALUE
      // CONTROL_MODE_EASYDISPLAY_MODE_USAGE
      // CONTROL_MODE_ALLDISPLAY_MODE_INPUT
      // CONTROL_MODE_ALLDISPLAY_MODE_VALUE
      // CONTROL_MODE_ALLDISPLAY_MODE_USAGE
      // ̏ɕׂ邱

  CC_LYTWK_EASY_INPUT,
  CC_LYTWK_INFO,
  CC_LYTWK_INFO,
  CC_LYTWK_ALL_INPUT,
  CC_LYTWK_INFO,
  CC_LYTWK_INFO,
};

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowCameraControlProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  // g2d
  {
    field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
    field::Graphics*         graphics         = p_fieldmap->GetGraphics();
    gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

    gfl::heap::HeapBase*     heap_memory      = this->GetSubWindowHeap();
    gfl::heap::HeapBase*     device_memory    = this->GetSubWindowDevice();
    gfl::heap::NwAllocator*  heap_allocator   = this->GetSubWindowHeapAllocator();
    gfl::heap::NwAllocator*  device_allocator = this->GetSubWindowDeviceAllocator();

    static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup = {
        gfl::math::VEC3(0,-290,0),  // pos 
        gfl::math::VEC2(1,1),       // scale
        gfl::math::VEC3(0,0,0),     // rotate
        0,                          // priority
        0                           // groupID
    };

    m_lyt_file   = GFL_NEW(heap_memory) gfl::fs::ArcFile( ARCID_CAMERA_CONTROL );
    m_lyt_res_id = lyt_sys->LoadLytRes( device_allocator, m_lyt_file, GARC_camera_control_camera_control_LYTDAT );
    lyt_sys->TransferAllTexture( m_lyt_res_id, gfl::grp::MEMORY_AREA_FCRAM );
    m_lyt_wk_common = lyt_sys->CreateLytWk( m_lyt_res_id, CC_LYTRES_FOR_LYTWK[CC_LYTWK_COMMON], NULL, 0, 0, &lyt_wk_setup, false );
  }

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃CXVs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowCameraControlProc::UpdateFunc(gfl::proc::Manager* pManager)
{
  if( this->IsReqEnd() ){
    return gfl::proc::RES_FINISH;
  }

  gfl::proc::Result res = gfl::proc::RES_FINISH;
 
  m_step = m_next_step;
  switch( m_step )
  {
  case STEP_INITIALIZE:
    {
      m_control_mode = m_next_control_mode;
      m_display_mode = m_next_display_mode;
    }
    break;
  }

  {
    // common
    res = UpdateFuncForCommon(pManager);
    if( res == gfl::proc::RES_FINISH ) return res;

    // 
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      // I
      if( touch_panel->IsTouchTrigger() )
      {
        u16 x, y;
        touch_panel->GetXY(&x, &y);
        if( field::SubWindowCameraControlProc::IsProcEnd( x, y ) )
        {
          // I͂PROC𐶐CxgŌm̂ŁAł͉Ȃ
        }
      }
    }
  }

  {
    // m_control_mode
    gfl::proc::Result (SubWindowCameraControlProc::*UpdateFuncForEachControlMode[CONTROL_MODE_MAX])(gfl::proc::Manager* pManager) =
    {
      &SubWindowCameraControlProc::UpdateFuncForEasy,
      &SubWindowCameraControlProc::UpdateFuncForAll,
    };

    res = (this->*UpdateFuncForEachControlMode[m_control_mode])(pManager);
    if( res == gfl::proc::RES_FINISH ) return res;
  }

  {
    // m_control_mode, m_display_mode
    gfl::proc::Result (SubWindowCameraControlProc::*UpdateFuncForEachControlDisplayMode[CONTROL_DISPLAY_MODE_SERIAL_NO_MAX])(gfl::proc::Manager* pManager) =
    {
      &SubWindowCameraControlProc::UpdateFuncForEasyInput,
      &SubWindowCameraControlProc::UpdateFuncForValue,
      &SubWindowCameraControlProc::UpdateFuncForUsage,
      &SubWindowCameraControlProc::UpdateFuncForAllInput,
      &SubWindowCameraControlProc::UpdateFuncForValue,
      &SubWindowCameraControlProc::UpdateFuncForUsage,
    };

    res = (this->*UpdateFuncForEachControlDisplayMode[GetControlDisplayModeSerialNo(m_control_mode, m_display_mode)])(pManager);
    if( res == gfl::proc::RES_FINISH ) return res;
  }

  return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃C`s֐
 *          zł͂܂B
 */
//------------------------------------------------------------------
void   SubWindowCameraControlProc::DrawFunc(gfl::proc::Manager* pManager)
{
  {
    // common
    DrawFuncForCommon(pManager);
  }

  {
    // m_control_mode
    void (SubWindowCameraControlProc::*DrawFuncForEachControlMode[CONTROL_MODE_MAX])(gfl::proc::Manager* pManager) =
    {
      &SubWindowCameraControlProc::DrawFuncForEasy,
      &SubWindowCameraControlProc::DrawFuncForAll,
    };

    (this->*DrawFuncForEachControlMode[m_control_mode])(pManager);
  }

  {
    // m_control_mode, m_display_mode
    void (SubWindowCameraControlProc::*DrawFuncForEachControlDisplayMode[CONTROL_DISPLAY_MODE_SERIAL_NO_MAX])(gfl::proc::Manager* pManager) =
    {
      &SubWindowCameraControlProc::DrawFuncForEasyInput,
      &SubWindowCameraControlProc::DrawFuncForValue,
      &SubWindowCameraControlProc::DrawFuncForEasyUsage,
      &SubWindowCameraControlProc::DrawFuncForAllInput,
      &SubWindowCameraControlProc::DrawFuncForValue,
      &SubWindowCameraControlProc::DrawFuncForAllUsage,
    };

    (this->*DrawFuncForEachControlDisplayMode[GetControlDisplayModeSerialNo(m_control_mode, m_display_mode)])(pManager);
  }
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowCameraControlProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  // g2d
  {
    field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
    field::Graphics*         graphics         = p_fieldmap->GetGraphics();
    gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

    {
      if( m_lyt_wk )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk );
        m_lyt_wk = NULL;
      }
      if( m_lyt_wk_common )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk_common );
        m_lyt_wk_common = NULL;
      }
    }

    {
      // \[Xj
      lyt_sys->ReleaseLytRes( m_lyt_res_id );
      m_lyt_res_id = 0;  // 0ł낤
    }

    if( m_lyt_file )
    {
      // t@C
      GFL_DELETE m_lyt_file;
      m_lyt_file = NULL;
    }
  }

  return gfl::proc::RES_FINISH;
}


//------------------------------------------------------------------
/**
 * @brief	  la(ȁꍇ͌)
 */
//------------------------------------------------------------------
void SubWindowCameraControlProc::AddCameraMemberRotateX(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(a, 0.0f, 0.0f);
  AddCameraMemberRotate(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraMemberRotateY(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(0.0f, a, 0.0f);
  AddCameraMemberRotate(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraMemberRotateZ(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(0.0f, 0.0f, a);
  AddCameraMemberRotate(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraMemberRotate(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a)  // [degree]
{
  gfl::math::VEC3 rotate_radian;
  gfl::math::VEC3 rotate_degree;
  
  field_stereo_camera->GetRotateXYZ( &rotate_radian );
  rotate_degree = gfl::math::VEC3( GFL_MATH_RAD_TO_DEG(rotate_radian.x), GFL_MATH_RAD_TO_DEG(rotate_radian.y), GFL_MATH_RAD_TO_DEG(rotate_radian.z) );

  rotate_degree = rotate_degree + a;
  rotate_radian = gfl::math::VEC3( GFL_MATH_DEG_TO_RAD(rotate_degree.x), GFL_MATH_DEG_TO_RAD(rotate_degree.y), GFL_MATH_DEG_TO_RAD(rotate_degree.z) );

  field_stereo_camera->SetRotateXYZ( rotate_radian );
}

void SubWindowCameraControlProc::AddCameraParameterRotateAroundTargetPositionBaseX(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(a, 0.0f, 0.0f);
  AddCameraParameterRotateAroundTargetPositionBase(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraParameterRotateAroundTargetPositionBaseY(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(0.0f, a, 0.0f);
  AddCameraParameterRotateAroundTargetPositionBase(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraParameterRotateAroundTargetPositionBaseZ(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  gfl::math::VEC3 b(0.0f, 0.0f, a);
  AddCameraParameterRotateAroundTargetPositionBase(field_stereo_camera, b);
}
void SubWindowCameraControlProc::AddCameraParameterRotateAroundTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a)  // [degree]
{
  gfl::math::VEC3 rotate_degree;
  field_stereo_camera->GetParameterRotateAroundTargetPositionBase( &rotate_degree );
  rotate_degree = rotate_degree + a;
  field_stereo_camera->SetParameterRotateAroundTargetPositionBase( rotate_degree );
}

void SubWindowCameraControlProc::AddCameraMemberFar(field::FieldStereoCamera* field_stereo_camera, const f32 a)
{
  f32 far = field_stereo_camera->GetFarClip();
  far += a;
  field_stereo_camera->SetFarClip(far);
}
void SubWindowCameraControlProc::AddCameraMemberNear(field::FieldStereoCamera* field_stereo_camera, const f32 a)
{
  f32 near = field_stereo_camera->GetNearClip();
  near += a;
  field_stereo_camera->SetNearClip(near);
}
void SubWindowCameraControlProc::AddCameraMemberFovy(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  f32 fovy_radian = field_stereo_camera->GetFovy();
  f32 fovy_degree = GFL_MATH_RAD_TO_DEG(fovy_radian);
  fovy_degree += a;
  fovy_radian = GFL_MATH_DEG_TO_RAD(fovy_degree);
  field_stereo_camera->SetFovy(fovy_radian);
}

void SubWindowCameraControlProc::AddCameraParameterPositionOffsetY(field::FieldStereoCamera* field_stereo_camera, const f32 a)
{
  f32 offset_y = field_stereo_camera->GetParameterPositionOffsetY();
  offset_y += a;
  field_stereo_camera->SetParameterPositionOffsetY( offset_y );
}
void SubWindowCameraControlProc::AddCameraParameterDistance(field::FieldStereoCamera* field_stereo_camera, const f32 a)
{
  f32 distance = field_stereo_camera->GetParameterDistance();
  distance += a;
  field_stereo_camera->SetParameterDistance( distance );
}
void SubWindowCameraControlProc::ToggleCameraParameterChaseEnable(field::FieldStereoCamera* field_stereo_camera)
{
  field_stereo_camera->SetParameterChaseEnable( !(field_stereo_camera->IsParameterChaseEnable()) );
}

void SubWindowCameraControlProc::AddCameraParameterTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const f32 x, const f32 y, const f32 z)
{
  gfl::math::VEC3 a(x, y, z);
  AddCameraParameterTargetPositionBase(field_stereo_camera, a);
}
void SubWindowCameraControlProc::AddCameraParameterTargetPositionBase(field::FieldStereoCamera* field_stereo_camera, const gfl::math::VEC3& a)
{
  gfl::math::VEC3 pos;
  field_stereo_camera->GetParameterTargetPositionBase(&pos);
  pos = pos + a;
  field_stereo_camera->SetParameterTargetPositionBase(pos);
}

// CameraMemberCameraParameterύX
void SubWindowCameraControlProc::AddCameraFovyKeepingHeight(field::FieldStereoCamera* field_stereo_camera, const f32 a)  // [degree]
{
  f32 fovy_radian = field_stereo_camera->GetFovy();
  f32 fovy_degree = GFL_MATH_RAD_TO_DEG(fovy_radian);
  fovy_degree += a;
  fovy_radian = GFL_MATH_DEG_TO_RAD(fovy_degree);
  field_stereo_camera->SetFovyKeepingHeight(fovy_radian);
}


//------------------------------------------------------------------
/**
 * @brief	  S
 */
//------------------------------------------------------------------
// Common
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForCommon(gfl::proc::Manager* /*pManager*/)  // UpdateFunc֐̍ŏɌĂ
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      do
      {
        // ^b`
        {
          if( touch_panel->IsTouchTrigger() )
          {
            u16 x, y;
            touch_panel->GetXY(&x, &y);
            gfl::grp::g2d::LytPane* lyt_pane = m_lyt_wk_common->GetHitPaneGroup( PANENAME_CC_COMMON_GROUP_GROUP_BUTTON, x, y, false );
            
            if( lyt_pane )
            {
              if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_CONTROL_MODE] ) == 0 )
              {
                // m_control_mode̕ύX
                m_next_control_mode = static_cast<ControlMode>( (m_control_mode + 1) % CONTROL_MODE_MAX );
                m_next_step = STEP_FINALIZE;
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISPLAY_MODE] ) == 0 )
              {
                // m_display_mode̕ύX
                m_next_display_mode = static_cast<DisplayMode>( (m_display_mode + 1) % DISPLAY_MODE_MAX );
                m_next_step = STEP_FINALIZE;
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_END] ) == 0 )
              {
                // I͂PROC𐶐CxgŌm̂ŁAł͉Ȃ
                break;
              }
            }
          }
        }
      }
      while(0);
    }
    break;
  }

  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForCommon(gfl::proc::Manager* pManager)  // DrawFunc֐̍ŏɌĂ
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      // \
      static const wchar_t* CONTROL_MODE_TEXT[CONTROL_MODE_MAX] =
      {
        L"ȒP",
        L"S",
      };
      static const wchar_t* DISPLAY_MODE_TEXT[DISPLAY_MODE_MAX] =
      {
        L"",
        L"l",
        L"g",
      };
      
      gfl::grp::g2d::LytTextBox* text_box;

      text_box = m_lyt_wk_common->GetTextBoxPane( PANENAME_CC_COMMON_PANE_TEXTBOX_DB_CTRLM );
      text_box->SetString( CONTROL_MODE_TEXT[m_control_mode] );

      text_box = m_lyt_wk_common->GetTextBoxPane( PANENAME_CC_COMMON_PANE_TEXTBOX_DB_DISPM );
      text_box->SetString( DISPLAY_MODE_TEXT[m_display_mode] );
    }
    break;
  }
}

// ?, Value
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForValue(gfl::proc::Manager* /*pManager*/)
{
  // Ȃ
  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForValue(gfl::proc::Manager* pManager)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      // \
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      field::Graphics*          graphics            = p_fieldmap->GetGraphics();
      gfl::grp::GraphicsSystem* graphics_system     = graphics->GetGraphicsSystem();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);
  
      // J̒l
      gfl::math::VEC3 camera_position;
      gfl::math::VEC3 target_position;
  
      // J̒l擾
      field_stereo_camera->GetCameraPosition( camera_position );
      field_stereo_camera->GetTargetPosition( target_position );

      // m_lyt_wk
      {
        // \Ă
        gfl::grp::g2d::LytTextBox* text_box;

        text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_INFO_PANE_TEXTBOX_LB_INFO );
        text_box->SetString( L" " );
      } 
  
      // ̊ȈՕ`
      {
        // tB[hőO㏈͍ς܂Ă̂ŁA`悷邾ł悢
  
        // 
        gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
        graphics_system->BindCurrentCommandList( lower_frame_buffer );
        gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer ); 
        gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
        gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );   // オ(0, 0)
  
        s32 text_x_pos = 5;
        s32 text_y_pos = 128;
        const s32 text_y_pos_add = 15;
  
        gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"J̈ʒu (%.2f, %.2f, %.2f)",
            camera_position.x, camera_position.y, camera_position.z );
        text_y_pos += text_y_pos_add;
  
        gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"_̈ʒu (%.2f, %.2f, %.2f)",
            target_position.x, target_position.y, target_position.z );
        text_y_pos += text_y_pos_add;
  
        gfl::grp::util::DrawUtil::EndRender();
      }
    }
    break;
  }
}
 
// ?, Usage
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForUsage(gfl::proc::Manager* /*pManager*/)
{
  // Ȃ
  return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  Easy
 */
//------------------------------------------------------------------
// Easy
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForEasy(gfl::proc::Manager* /*pManager*/)  // UpdateFuncForCommon֐̎ɌĂ
{
  field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
  field::Graphics*         graphics         = p_fieldmap->GetGraphics();
  gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

  switch( m_step )
  {
  case STEP_INITIALIZE:
    {
      // g2d
      if( m_lyt_wk )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk );
        m_lyt_wk = NULL;
      }
      else
      {
        // [N
        static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup = {
            gfl::math::VEC3(0,-290,0),  // pos 
            gfl::math::VEC2(1,1),       // scale
            gfl::math::VEC3(0,0,0),     // rotate
            0,                          // priority
            0                           // groupID
        };
        m_lyt_wk = lyt_sys->CreateLytWk(
            m_lyt_res_id,
            CC_LYTRES_FOR_LYTWK[CC_LYTWK_FOR_EACH_CONTROL_DISPLAY_MODE[GetControlDisplayModeSerialNo(m_control_mode, m_display_mode)]],
            NULL, 0, 0, &lyt_wk_setup, false );
        m_next_step = STEP_UPDATE; 
      }
    }
    break;
  case STEP_UPDATE:
    {
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      static const f32 translate_add = 1.0f;
      static const f32 rotate_add = 1.0f;  // [degree]
      static const f32 near_add = 0.1f;
      static const f32 far_add = 1.0f;

      do
      {
        // L[
        {
          if( cross_key->IsHold( gfl::ui::DIR_UP ) )
          {
            AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, 0.0f, -translate_add);
            break;
          }
          else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
          {
            AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, 0.0f, translate_add);
            break;
          }
          else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
          {
            AddCameraParameterTargetPositionBase(field_stereo_camera, -translate_add, 0.0f, 0.0f);
            break;
          }
          else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
          {
            AddCameraParameterTargetPositionBase(field_stereo_camera, translate_add, 0.0f, 0.0f);
            break;
          }
        }
      }
      while(0);
    }
    break;
  case STEP_FINALIZE:
    {
      // g2d
      if( m_lyt_wk )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk );
        m_lyt_wk = NULL;
      }
      
      m_next_step = STEP_INITIALIZE;
    }
    break;
  }

  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForEasy(gfl::proc::Manager* /*pManager*/)  // DrawFuncForCommon֐̎ɌĂ
{
  // Ȃ
}

// Easy, Input
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForEasyInput(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();
      field::Graphics*          graphics            = p_fieldmap->GetGraphics();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      static const f32 translate_add = 1.0f;
      static const f32 rotate_add = 1.0f;  // [degree]
      static const f32 near_add = 0.1f;
      static const f32 far_add = 1.0f;

      do
      {
        // ^b`
        {
          if( touch_panel->IsTouchTrigger() )
          {
            u16 x, y;
            touch_panel->GetXY(&x, &y);
            gfl::grp::g2d::LytPane* lyt_pane = m_lyt_wk->GetHitPaneGroup( PANENAME_CC_EASY_INPUT_GROUP_GROUP_BUTTON, x, y, false );
            
            if( lyt_pane )
            {
              if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_CHASE] ) == 0 )
              {
                ToggleCameraParameterChaseEnable(field_stereo_camera);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OUT] ) == 0 )
              {
                GFL_PRINT("@todo Print!\n");  // @todo o͂邩
                break;
              }
            }
          }
          else if( touch_panel->IsTouch() )
          {
            u16 x, y;
            touch_panel->GetXY(&x, &y);
            gfl::grp::g2d::LytPane* lyt_pane = m_lyt_wk->GetHitPaneGroup( PANENAME_CC_EASY_INPUT_GROUP_GROUP_BUTTON, x, y, false );

            if( lyt_pane )
            {
              if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OFFSET_Y_L] ) == 0 )
              {
                AddCameraParameterPositionOffsetY(field_stereo_camera, -translate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OFFSET_Y_R] ) == 0 )
              {
                AddCameraParameterPositionOffsetY(field_stereo_camera, translate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_X_L] ) == 0 )
              {
                AddCameraParameterRotateAroundTargetPositionBaseX(field_stereo_camera, -rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_X_R] ) == 0 )
              {
                AddCameraParameterRotateAroundTargetPositionBaseX(field_stereo_camera, rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_Y_L] ) == 0 )
              {
                AddCameraParameterRotateAroundTargetPositionBaseY(field_stereo_camera, -rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_ROTATE_Y_R] ) == 0 )
              {
                AddCameraParameterRotateAroundTargetPositionBaseY(field_stereo_camera, rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FAR_L] ) == 0 )
              {
                AddCameraMemberFar(field_stereo_camera, -far_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FAR_R] ) == 0 )
              {
                AddCameraMemberFar(field_stereo_camera, far_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_NEAR_L] ) == 0 )
              {
                AddCameraMemberNear(field_stereo_camera, -near_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_NEAR_R] ) == 0 )
              {
                AddCameraMemberNear(field_stereo_camera, near_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FOVY_L] ) == 0 )
              {
                AddCameraMemberFovy(field_stereo_camera, -rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_FOVY_R] ) == 0 )
              {
                AddCameraMemberFovy(field_stereo_camera, rotate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISTANCE_L] ) == 0 )
              {
                AddCameraParameterDistance(field_stereo_camera, -translate_add);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_DISTANCE_R] ) == 0 )
              {
                AddCameraParameterDistance(field_stereo_camera, translate_add);
                break;
              }
            }
          }
        }
      }
      while(0);
    }
    break;
  }

  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForEasyInput(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      field::Graphics*          graphics            = p_fieldmap->GetGraphics();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      // J̒l擾
      f32 offset_y = field_stereo_camera->GetParameterPositionOffsetY();
      gfl::math::VEC3 rotate;
      field_stereo_camera->GetParameterRotateAroundTargetPositionBase(&rotate);
      f32 far = field_stereo_camera->GetFarClip();
      f32 near = field_stereo_camera->GetNearClip(); 
      f32 fovy_radian = field_stereo_camera->GetFovy(); 
      f32 fovy_degree = GFL_MATH_RAD_TO_DEG(fovy_radian);
      f32 distance = field_stereo_camera->GetParameterDistance();
      b32 chase_enable = field_stereo_camera->IsParameterChaseEnable();

      // \
      static const size_t TEXT_LENGTH = 128;
      gfl::grp::g2d::LytTextBox* text_box;
      wchar_t text[TEXT_LENGTH];

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_DB_CHASE );
      if( chase_enable ) text_box->SetString( L"" );
      else               text_box->SetString( L"Ȃ" );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_OFSY );
      swprintf( text, TEXT_LENGTH, L"%.2f", offset_y );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_ROTX );
      swprintf( text, TEXT_LENGTH, L"%.2f", rotate.x );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_ROTY );
      swprintf( text, TEXT_LENGTH, L"%.2f", rotate.y );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_FAR );
      swprintf( text, TEXT_LENGTH, L"%.2f", far );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_NEAR );
      swprintf( text, TEXT_LENGTH, L"%.2f", near );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_FOVY );
      swprintf( text, TEXT_LENGTH, L"%.2f", fovy_degree );
      text_box->SetString( text );

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_EASY_INPUT_PANE_TEXTBOX_EB_DIST );
      swprintf( text, TEXT_LENGTH, L"%.2f", distance );
      text_box->SetString( text );
    }
    break;
  }
}

// Easy, Usage
void   SubWindowCameraControlProc::DrawFuncForEasyUsage(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      // m_lyt_wk
      {
        // \
        gfl::grp::g2d::LytTextBox* text_box;

        text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_INFO_PANE_TEXTBOX_LB_INFO );
        text_box->SetString( L"sړ@F@\L[()" );
      } 
    }
    break;
  }
}

//------------------------------------------------------------------
/**
 * @brief	  All
 */
//------------------------------------------------------------------
// All
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForAll(gfl::proc::Manager* /*pManager*/)  // UpdateFuncForCommon֐̎ɌĂ 
{
  field::Fieldmap*         p_fieldmap       = this->GetFieldmap();
  field::Graphics*         graphics         = p_fieldmap->GetGraphics();
  gfl::grp::g2d::LytSys*   lyt_sys          = graphics->GetLytSys();

  switch( m_step )
  {
  case STEP_INITIALIZE:
    {
      // g2d
      if( m_lyt_wk )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk );
        m_lyt_wk = NULL;
      }
      else
      {
        // [N
        static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup = {
            gfl::math::VEC3(0,-290,0),  // pos 
            gfl::math::VEC2(1,1),       // scale
            gfl::math::VEC3(0,0,0),     // rotate
            0,                          // priority
            0                           // groupID
        };
        m_lyt_wk = lyt_sys->CreateLytWk(
            m_lyt_res_id,
            CC_LYTRES_FOR_LYTWK[CC_LYTWK_FOR_EACH_CONTROL_DISPLAY_MODE[GetControlDisplayModeSerialNo(m_control_mode, m_display_mode)]],
            NULL, 0, 0, &lyt_wk_setup, false );
        m_next_step = STEP_UPDATE; 
      }
    }
    break;
  case STEP_UPDATE:
    {
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      static const f32 translate_add = 1.0f;
      static const f32 rotate_add = 1.0f;  // [degree]
      static const f32 near_add = 0.1f;
      static const f32 far_add = 1.0f;

      do
      {
        // L[
        {
          // JS]
          if( button->IsHold( gfl::ui::BUTTON_B ) )
          {
            if( cross_key->IsHold( gfl::ui::DIR_UP ) )
            {
              AddCameraMemberRotateX(field_stereo_camera, rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
            {
              AddCameraMemberRotateX(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
            {
              AddCameraMemberRotateY(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
            {
              AddCameraMemberRotateY(field_stereo_camera, rotate_add);
              break;
            }
          }
          // _S](㉺E])
          if( button->IsHold( gfl::ui::BUTTON_Y ) )
          {
            if( cross_key->IsHold( gfl::ui::DIR_UP ) )
            {
              AddCameraParameterRotateAroundTargetPositionBaseX(field_stereo_camera, rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
            {
              AddCameraParameterRotateAroundTargetPositionBaseX(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
            {
              AddCameraParameterRotateAroundTargetPositionBaseY(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
            {
              AddCameraParameterRotateAroundTargetPositionBaseY(field_stereo_camera, rotate_add);
              break;
            }
          }
          // jAAt@[
          if( button->IsHold( gfl::ui::BUTTON_X ) )
          {
            if( cross_key->IsHold( gfl::ui::DIR_UP ) )
            {
              AddCameraMemberNear(field_stereo_camera, near_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
            {
              AddCameraMemberNear(field_stereo_camera, -near_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
            {
              AddCameraMemberFar(field_stereo_camera, -far_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
            {
              AddCameraMemberFar(field_stereo_camera, far_add);
              break;
            }
          }
          // FOVYAFOVYƋ
          if( button->IsHold( gfl::ui::BUTTON_A ) )
          {
            if( cross_key->IsHold( gfl::ui::DIR_UP ) )
            {
              AddCameraMemberFovy(field_stereo_camera, rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
            {
              AddCameraMemberFovy(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
            {
              AddCameraFovyKeepingHeight(field_stereo_camera, -rotate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
            {
              AddCameraFovyKeepingHeight(field_stereo_camera, rotate_add);
              break;
            }
          }
          // sړ
          else
          {
            if( cross_key->IsHold( gfl::ui::DIR_UP ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, 0.0f, -translate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_DOWN ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, 0.0f, translate_add);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_LEFT ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, -translate_add, 0.0f, 0.0f);
              break;
            }
            else if( cross_key->IsHold( gfl::ui::DIR_RIGHT ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, translate_add, 0.0f, 0.0f);
              break;
            }
            else if( button->IsHold( gfl::ui::BUTTON_L ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, -translate_add, 0.0f);
              break;
            }
            else if( button->IsHold( gfl::ui::BUTTON_R ) )
            {
              AddCameraParameterTargetPositionBase(field_stereo_camera, 0.0f, translate_add, 0.0f);
              break;
            }
          }
        }
      }
      while(0);
    }
    break;
  case STEP_FINALIZE:
    {
      // g2d
      if( m_lyt_wk )
      {
        // [Nj
        lyt_sys->RemoveLytWk( m_lyt_wk );
        m_lyt_wk = NULL;
      }
      
      m_next_step = STEP_INITIALIZE;
    }
    break;
  }

  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForAll(gfl::proc::Manager* /*pManager*/)  // DrawFuncForCommon֐̎ɌĂ
{
  // Ȃ
}

// All, Input
gfl::proc::Result SubWindowCameraControlProc::UpdateFuncForAllInput(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      gamesystem::GameManager*  gmgr                = p_fieldmap->GetGameManager();
      field::Graphics*          graphics            = p_fieldmap->GetGraphics();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      const gfl::ui::Button*       button      = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      const gfl::ui::VectorDevice* cross_key   = gmgr->GetUiDeviceManager()->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
      const gfl::ui::VectorDevice* stick       = gmgr->GetUiDeviceManager()->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      const gfl::ui::TouchPanel*   touch_panel = gmgr->GetUiDeviceManager()->GetTouchPanel( gfl::ui::CTR_DeviceManager::STICK_STANDARD );

      do
      {
        // ^b`
        {
          if( touch_panel->IsTouchTrigger() )
          {
            u16 x, y;
            touch_panel->GetXY(&x, &y);
            gfl::grp::g2d::LytPane* lyt_pane = m_lyt_wk->GetHitPaneGroup( PANENAME_CC_ALL_INPUT_GROUP_GROUP_BUTTON, x, y, false );
            
            if( lyt_pane )
            {
              if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_CHASE] ) == 0 )
              {
                ToggleCameraParameterChaseEnable(field_stereo_camera);
                break;
              }
              else if( gfl::std::StringCmp( lyt_pane->GetName(), SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_NAME[SUB_WINDOW_CAMERA_CONTROL_PROC_PANE_BUTTON_OUT] ) == 0 )
              {
                GFL_PRINT("@todo Print!\n");  // @todo o͂邩
                break;
              }
            }
          }
        }
      }
      while(0);
    }
    break;
  }

  return gfl::proc::RES_CONTINUE;
}
void   SubWindowCameraControlProc::DrawFuncForAllInput(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      field::Fieldmap*          p_fieldmap          = this->GetFieldmap();
      field::Graphics*          graphics            = p_fieldmap->GetGraphics();
      gfl::grp::g3d::Camera*    camera              = graphics->GetDrawCamera();
      field::FieldStereoCamera* field_stereo_camera = reinterpret_cast<field::FieldStereoCamera*>(camera);

      // J̒l擾
      b32 chase_enable = field_stereo_camera->IsParameterChaseEnable();

      // \
      gfl::grp::g2d::LytTextBox* text_box;

      text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_ALL_INPUT_PANE_TEXTBOX_DB_CHASE );
      if( chase_enable ) text_box->SetString( L"" );
      else               text_box->SetString( L"Ȃ" );
    }
    break;
  }
}

// All, Usage
void   SubWindowCameraControlProc::DrawFuncForAllUsage(gfl::proc::Manager* /*pManager*/)
{
  switch( m_step )
  {
  case STEP_UPDATE:
    {
      // m_lyt_wk
      {
        // \
        gfl::grp::g2d::LytTextBox* text_box;

        text_box = m_lyt_wk->GetTextBoxPane( PANENAME_CC_INFO_PANE_TEXTBOX_LB_INFO );
        text_box->SetString(
            L"sړ@F@\L[()AL{^()AR{^()\n" \
            L"JS]@@@@@@@@F@B{^+\L[\n" \
            L"_S](㉺E])@F@Y{^+\L[\n" \
            L"jA@@F@X{^+㉺L[\n" \
            L"t@[@F@X{^+EL[\n" \
            L"FOVY@@@@F@A{^+㉺L[\n" \
            L"FOVYƋ@F@A{^+EL[\n" \
        );
      } 
    }
    break;
  }
}

}  // namespace field

