//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		DebugPerformanceMeter.cpp
 *	@brief  fobOpPerformanceMeter
 *	@author	tomoya takahashi 
 *	@date		2011.05.06
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "DebugPerformanceMeter.h"
#include "field_debug_performance.h"
#include "field_debug_performance_pane.h"

#include "field/Fieldmap.h"

#include "arc/arc_def.h"

namespace field{


wchar_t DebugPerformanceMeter::m_StrBufCpuTop[128];
wchar_t DebugPerformanceMeter::m_StrBufPosition[128];
wchar_t DebugPerformanceMeter::m_StrBufCpuBottom[128];
wchar_t DebugPerformanceMeter::m_StrBufGpu[128];
wchar_t DebugPerformanceMeter::m_StrBufFps[128];

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
DebugPerformanceMeter::DebugPerformanceMeter(Fieldmap* p_fieldmap) :
  SubWindowProc(p_fieldmap),
  m_pLytSys(NULL),
  m_pLytWk(NULL),
  m_Count(0),
  m_CpuTopMax(0),
  m_CpuBottomMax(0),
  m_GpuMax(0)
{
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DebugPerformanceMeter::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  Fieldmap* p_fieldmap = this->GetFieldmap();
  Graphics* p_graphics = p_fieldmap->GetGraphics();

  // 
  this->Initialize( this->GetSubWindowDeviceAllocator(), p_graphics->GetLytSys() );

  return gfl::proc::RES_FINISH;
}
//------------------------------------------------------------------
/**
 * @brief	  PROC̃CXVs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DebugPerformanceMeter::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  Fieldmap* p_fieldmap = this->GetFieldmap();
  s32 top, bottom, gpu;
  gfl::math::VEC3 position;

  if( this->IsReqEnd() ){
    return gfl::proc::RES_FINISH;
  }

  // fobO@ US̎擾
  p_fieldmap->GetDebugUs( &top, &bottom, &gpu );
  p_fieldmap->GetControlPos( &position );
  
  // XV
  this->Update( top, bottom, gpu, position.x, position.z );

  return gfl::proc::RES_CONTINUE;
}
//------------------------------------------------------------------
/**
 * @brief	  PROC̃C`s֐
 *          zł͂܂B
 */
//------------------------------------------------------------------
void   DebugPerformanceMeter::DrawFunc(gfl::proc::Manager* /*pManager*/)
{
}
//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result DebugPerformanceMeter::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  this->Finalize();

  return gfl::proc::RES_FINISH;
}


//----------------------------------------------------------------------------
/**
 *	@brief  
 *
 *	@param	p_device    foCXAP[^
 *	@param  p_lytsys    CAEgVXe
 */
//-----------------------------------------------------------------------------
void DebugPerformanceMeter::Initialize( gfl::heap::NwAllocator* p_device, gfl::grp::g2d::LytSys* p_lytsys )
{
  m_pLytSys = p_lytsys;

  {
    gfl::fs::ArcFile* p_arc = GFL_NEW_LOW(p_device->GetHeapBase()) gfl::fs::ArcFile( ARCID_FIELD_DEBUG_PERFORMANCE );
    m_LytResID = m_pLytSys->LoadLytRes( p_device, p_arc, 0 );
    GFL_DELETE p_arc;
    m_pLytSys->TransferAllTexture( m_LytResID, gfl::grp::MEMORY_AREA_FCRAM );
  }
  {
    gfl::grp::g2d::LytWkSetUp setup = {
      gfl::math::VEC3(0,-290,0),
      gfl::math::VEC2(1.0f,1.0f),
      gfl::math::VEC3(0,0,0),
      0,
      0,
    };
    
    m_pLytWk = m_pLytSys->CreateLytWk( m_LytResID, LYTRES_FIELD_DEBUG_PERFORMANCE_PERFORMANCE_BCLYT, NULL, 0,  0, &setup );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  j
 */
//-----------------------------------------------------------------------------
void DebugPerformanceMeter::Finalize( void )
{
  if(m_pLytWk){
    // [Nj 
    m_pLytSys->RemoveLytWk( m_pLytWk );
    m_pLytWk = NULL;

    // \[Xj
    m_pLytSys->ReleaseLytRes( m_LytResID );
  }
}




//----------------------------------------------------------------------------
/**
 *	@brief  `f[^XV
 */
//-----------------------------------------------------------------------------
void DebugPerformanceMeter::Update( s32 cpu_top, s32 cpu_bottom, s32 gpu, f32 x, f32 z )
{
  // UPDATE_CHANGE_COUNTt[1񂾂őlNAB
  if( ++m_Count > UPDATE_CHANGE_COUNT ){
    m_Count = 0;
  
    m_CpuTopMax     = 0;
    m_CpuBottomMax  = 0;
    m_GpuMax     = 0;
  }

  if( m_CpuTopMax < cpu_top ){
    m_CpuTopMax = cpu_top;
  }
  if( m_CpuBottomMax < cpu_bottom ){
    m_CpuBottomMax = cpu_bottom;
  }
  if( m_GpuMax < gpu ){
    m_GpuMax = gpu;
  }

  {
    gfl::grp::g2d::LytTextBox* lytbox_position = m_pLytWk->GetTextBoxPane( PANENAME_PERFORMANCE_PANE_TEXTBOX_01 );
    gfl::grp::g2d::LytTextBox* lytbox_cpu = m_pLytWk->GetTextBoxPane( PANENAME_PERFORMANCE_PANE_TEXTBOX_00 );
    gfl::grp::g2d::LytTextBox* lytbox_cpu_bottom = m_pLytWk->GetTextBoxPane( PANENAME_PERFORMANCE_PANE_TEXTBOX_08 );
    gfl::grp::g2d::LytTextBox* lytbox_gpu = m_pLytWk->GetTextBoxPane( PANENAME_PERFORMANCE_PANE_TEXTBOX_09 );
    gfl::grp::g2d::LytTextBox* lytbox_fps = m_pLytWk->GetTextBoxPane( PANENAME_PERFORMANCE_PANE_TEXTBOX_07 );

    
    // ύX
    if( m_GpuMax > m_CpuTopMax + m_CpuBottomMax ){
      swprintf( m_StrBufFps, 128, L"FPS=%d fps", 1000000 / m_GpuMax );
    }else{
      swprintf( m_StrBufFps, 128, L"FPS=%d fps", 1000000 / m_CpuTopMax + m_CpuBottomMax );
    }

    swprintf( m_StrBufPosition, 128, L"POS=(%.3f,%.3f)(%d, %d)", x, z, static_cast<s32>(x)/16, static_cast<s32>(z)/16 );

    swprintf( m_StrBufCpuTop, 128, L"CPU top=%d us", m_CpuTopMax );
    swprintf( m_StrBufCpuBottom, 128, L"CPU bottom=%d us", m_CpuBottomMax );
    swprintf( m_StrBufGpu, 128, L"GPU=%d us", m_GpuMax );

    lytbox_position->SetString( m_StrBufPosition );
    lytbox_cpu->SetString( m_StrBufCpuTop );
    lytbox_cpu_bottom->SetString( m_StrBufCpuBottom );
    lytbox_gpu->SetString( m_StrBufGpu );
    lytbox_fps->SetString( m_StrBufFps );
  }
}



} // namespace field
