//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldPlayerGrid.h
 *	@brief  tB[hvC[
 *	@author	tomoya takahashi
 *	@date		2011.05.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __FIELDPLAYERGRID_H__
#define __FIELDPLAYERGRID_H__


#include "gamesystem/GameEventManager.h"

#include "field/FieldmapWork.h"
#include "field/PlayerWork.h"

#include "field/movemodel/FieldMoveModelManager.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------
class PlayerGrid
{
  GFL_FORBID_COPY_AND_ASSIGN(PlayerGrid);


public:
  //--------------------------------------------------------------
  /// PLAYER_MOVE_VALUE
  //--------------------------------------------------------------
  enum PlayerMoveValue
  {
    PLAYER_MOVE_VALUE_STOP, ///<~
    PLAYER_MOVE_VALUE_WALK, ///<ړ
    PLAYER_MOVE_VALUE_TURN, ///<U
    PLAYER_MOVE_VALUE_HITCH, ///<ǂ蒆
    PLAYER_MOVE_VALUE_HIGHTURN, ///<RollerXP[gHIGHTURN
  };

  //--------------------------------------------------------------
  /// PLAYER_MOVE_STATE
  //--------------------------------------------------------------
  enum PlayerMoveState
  {
    PLAYER_MOVE_STATE_OFF,    ///<Ȃ
    PLAYER_MOVE_STATE_START,  ///<Jn
    PLAYER_MOVE_STATE_ON,     ///<쒆
    PLAYER_MOVE_STATE_END,    ///<I
  };



  // tH
  enum PlayerForm
  {
    MOVE_FORM_NORMAL,     ///<s
    MOVE_FORM_CYCLE,      ///<]ԏ
    MOVE_FORM_ROLLER,     ///<ROLLERXP[g


    MOVE_FORM_NON,        ///<NGXg̎dg݂Ŏgp
  };


  // bCxgȂ
  static const s32 INTEREST_EVENT_ID_NONE = -1;

  //@todo fobOp
  static b8 m_DebugWalkFastFlag;

public:

  // RXgN^
  PlayerGrid( void );

  // fXgN^
  ~PlayerGrid();


  // 
  void Initialize( PlayerWork* p_playerData, Fieldmap* p_fieldmap, const gfl::math::VEC3* cp_pos, u32 sex, gfl::heap::HeapBase* p_heap );

  // j
  void Finalize( void );


  // XV
  void Update( void );

  // Xe[^X̍XViEventCheck̒ōsj
  void UpdateMoveStatus( void );

  // CxgN`FbN
  bool CheckMoveEvent( gamesystem::GameEventManager* p_eventman );


  // Wݒ
  void SetPos( const gfl::math::VEC3& pos );

  // W擾
  void GetPos( gfl::math::VEC3* p_pos );


  // 샂f擾
  mmodel::MoveModel* GetModel( void ) const { return m_pMoveModel; }

  // ̋~
  void ForceStop( void );


  // Ԃ̎擾
  inline PlayerMoveValue GetMoveValue( void ) const { return m_MoveValue; }
  inline PlayerMoveState GetMoveState( void ) const { return m_MoveState; }


  // tH̎擾
  PlayerForm GetMoveForm( void ) const { return m_Form; }

  // tHύXNGXg
  void RequestChangeForm( PlayerForm form );


  // _xNg̓o^
  void SetInterestView( const gfl::math::VEC3& pos, mmodel::Move3DModel::InterestMode mode );
  void ClearInterestView( void );

  // ڂĂCxgID̎擾
  s32 GetInterestEventID( void ) const { return m_InterestEventID; }


private:
  
  enum 
  {
    ///ɖ
    MOVEBIT_NON = (0),
    ///ړ
    MOVEBIT_FORCE       = (1<<0),
    ///
    MOVEBIT_UNDER_OFF   = (1<<1),
    ///ړ
    MOVEBIT_STEP        = (1<<2),
    ///
    MOVEBIT_OZE_YURE    = (1<<3),
    ///
    MOVEBIT_OZE_FALLOUT = (1<<4),
    ///_bVړ
    MOVEBIT_DASH        = (1<<5),
    ///ő
    MOVEBIT_BITMAX      = (1<<6),


  };

  // sNGXgID
  enum
  {
    //{ړ
    MOVEORDER_NON = 0, ///<Zbg
    MOVEORDER_STOP,    ///<~Zbg
    MOVEORDER_WALK,    ///<Zbg
    MOVEORDER_TURN,    ///<UZbg
    MOVEORDER_HITCH,   ///<QqbgZbg
    MOVEORDER_JUMP,    ///<WvZbg

    MOVEORDER_ACCELE_LOW,     ///<
    MOVEORDER_ACCELE_HIGH,    ///<
    MOVEORDER_BRAKE,          ///<
    MOVEORDER_BRAKE_HIGH,     ///<
    MOVEORDER_ENDMOVE,        ///<
    MOVEORDER_TURNFIRST,      ///<RollerXP[gUŏ̏
    MOVEORDER_HIGHTURNFIRST,  ///<HIGHTURNFIRST
    MOVEORDER_HIGHTURN,       ///<HIGHTURN
    
  };


  // NGXgI[_[`FbN[N
  struct RequestInput{
    Dir             dir;
    gfl::math::VEC3 way;
    f32             speed;
    bool            speed_max_trg;  // Xs[h}bNX@gK
    bool            dash;
    bool            debug;
  };


  // ]
  //static const f32 CYCLE_MOVE_SPEED = 10.40f; // 1̈ړ
  static const f32 CYCLE_MOVE_SPEED = 8.0f; // 1̈ړ


  // RollerXP[g
  enum
  {
    // ʏ^[pAPx̉]px
    //@Xs[hƃ^[͏ȂB
    //  Xs[hxƃ^[͑B
    TURN_ROT_MIN  = 4,  // ^[łpx@ŏ
    TURN_ROT_MAX  = 45,  // ^[łpx@ő

    // ^[łpx@ő
    TURN_ROT_NUM  = TURN_ROT_MAX - TURN_ROT_MIN,  


    // }ȕ]p@Px̉]px
    //@Xs[hƃ^[͏ȂB
    //  Xs[hxƃ^[͑B
    HIGHTURN_ROT_MIN  = 13,  // ^[łpx@ŏ
    HIGHTURN_ROT_MAX  = 13,  // ^[łpx@ő

    // ^[łpx@ő
    HIGHTURN_ROT_NUM  = HIGHTURN_ROT_MAX - HIGHTURN_ROT_MIN,  
  };

  // ^[ɂn
  static const f32 TURN_ACCELE_NUM = 0.200f;
  static const f32 TURN_FIRST_DAMAGE = 0.20f; // ^[nɌl

  static const f32 ACCELERATOR_NUM = 0.200f;    // ʏANZl
  static const f32 ACCELERATOR_HIGH_NUM = 1.25f; // ANZl
  static const f32 BRAKE_NUM = 0.10f;           // ʏBRAKEl
  static const f32 HIGH_BRAKE_NUM = 1.00f;      // u[Ll

  static const f32 SPEED_MAX  = 4.50f;  //x}bNX

  static const f32 FULLTURN_SPEED_MAX = 2.50f;  //  ̃Xs[hȏ̂Ƃ^[ɈڍsB
  static const f32 FULLTURN_SPEED_MIN = 1.0f;  //   ^[Xs[h̍ŏ

  static const u32 ACCELE_AFTER_BRAKE_COUNT = 30;

  //----------ړ_̏---------------
  static const f32 INTERESTVIEW_LENGTH  = 3.0f * 16.0f;
  static const f32 INTERESTVIEW_HEIGHT  = 0.0f; // ␳


  // XeBbNXs[hl
  static const f32 STICK_SPEED_CONTROL = 2.0f; 

  // [[XP[g@Abvf[gJEg
  static const s32 ROLLER_STATE_UPDATE_COUNT = 4;
  
private:

  // vC[[N
  void UpdatePlayerWork( void );

  // RollerXP[gXV
  void UpdateRoller( void );

  // _̊Ǘ
  void UpdateInterestView(void);

  // L[񂩂AƐ擾
  const gfl::ui::VectorDevice* GetStickDir( const gfl::ui::VectorDevice* cp_Key, const gfl::ui::VectorDevice* cp_Stick, gfl::math::VEC3* p_way, f32* p_speed, Dir* p_dir ) const;

  Dir GetStickDirStick( const gfl::ui::VectorDevice* cp_Stick, gfl::math::VEC3* p_way, f32* p_speed ) const;
  Dir GetStickDirKey( const gfl::ui::VectorDevice* cp_Key, gfl::math::VEC3* p_way, f32* p_speed ) const;

  // łԂ`FbN
  bool IsStartMove( Dir dir ) const ;

  // ʃqbg`FbN
  mmodel::MoveModelBase::MoveHitBit HitCheckMove( Dir dir, Attr* p_attr ) const ;
  mmodel::MoveModelBase::MoveHitBit HitCheckMove( Dir dir, const gfl::math::VEC3& way, f32 dist, Attr* p_attr ) const ;

  // ͏񂩂ANGXgI[_[߂B
  u32 GetMoveOrder( const RequestInput& cp_input ) const;
  u32 GetMoveOrderNormal( const RequestInput& cp_input ) const;
  u32 GetMoveOrderRoller( const RequestInput& cp_input ) const;
  u32 GetMoveOrderCycle( const RequestInput& cp_input ) const;
  
  u32 GetMoveOrderNormal_Stop( const RequestInput& cp_input ) const;
  u32 GetMoveOrderNormal_Walk( const RequestInput& cp_input ) const;
  u32 GetMoveOrderNormal_Turn( const RequestInput& cp_input ) const;
  u32 GetMoveOrderNormal_Hitch( const RequestInput& cp_input ) const;

  // ]ԗp
  u32 GetMoveOrderCycle_Stop( const RequestInput& cp_input ) const;
  u32 GetMoveOrderCycle_Walk( const RequestInput& cp_input, u32* p_dir_sub = NULL ) const;
  u32 GetMoveOrderCycle_WalkBase( const RequestInput& cp_input, u32* p_dir_sub = NULL ) const;
  u32 GetMoveOrderCycle_HitCheck( const RequestInput& cp_input, u32 order ) const;
  u32 GetMoveOrderCycle_Turn( const RequestInput& cp_input ) const;
  u32 GetMoveOrderCycle_Hitch( const RequestInput& cp_input ) const;

  // ]ԁ@I[_[Ƃ̈ړ̊mF
  void GetOrderCycleDir( u32 order, const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderCycleDir_Stop( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderCycleDir_Walk( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderCycleDir_Turn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderCycleDir_Hitch( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderCycleDir_Jump( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;


  // [[XP[gp
  u32 GetMoveOrderRoller_Stop( const RequestInput& cp_input ) const;
  u32 GetMoveOrderRoller_Walk( const RequestInput& cp_input, u32* p_dir_sub = NULL ) const;
  u32 GetMoveOrderRoller_WalkBase( const RequestInput& cp_input, u32* p_dir_sub = NULL ) const;
  u32 GetMoveOrderRoller_Turn( const RequestInput& cp_input ) const;
  u32 GetMoveOrderRoller_HighTurn( const RequestInput& cp_input ) const;
  u32 GetMoveOrderRoller_Hitch( const RequestInput& cp_input ) const;
  u32 GetMoveOrderRoller_HitCheck( const RequestInput& cp_input, u32 order ) const;


  // [[XP[g@I[_[Ƃ̈ړmF
  void GetOrderRollerDir( u32 order, const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Stop( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Walk( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Turn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Hitch( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Jump( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;

  void GetOrderRollerDir_AcceleLow( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_AcceleHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_Brake( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_BrakeHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_EndMove( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_FirstTurn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_FirstTurnHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;
  void GetOrderRollerDir_TurnHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed = NULL, gfl::math::VEC3* p_calc = NULL ) const;

  // ]ԁ@
  

  // Jn
  void InitMove( u32 order, const RequestInput& cp_input );

  // NGXgs鏈
  void SetMove( u32 order, const RequestInput& cp_input );
  void SetMoveNormal( u32 order, const RequestInput& cp_input );
  void SetMoveRoller( u32 order, const RequestInput& cp_input );
  void SetMoveCycle( u32 order, const RequestInput& cp_input );

  void SetMoveNormal_Stop( const RequestInput& cp_input );
  void SetMoveNormal_Walk( const RequestInput& cp_input );
  void SetMoveNormal_Turn( const RequestInput& cp_input );
  void SetMoveNormal_Hitch( const RequestInput& cp_input );
  void SetMoveNormal_Jump( const RequestInput& cp_input );

  void SetMoveCycle_Stop( const RequestInput& cp_input );
  void SetMoveCycle_Walk( const RequestInput& cp_input );
  void SetMoveCycle_Turn( const RequestInput& cp_input );
  void SetMoveCycle_Hitch( const RequestInput& cp_input );
  void SetMoveCycle_Jump( const RequestInput& cp_input );

  void SetMoveRoller_Stop( const RequestInput& cp_input );
  void SetMoveRoller_Walk( const RequestInput& cp_input );
  void SetMoveRoller_Turn( const RequestInput& cp_input );
  void SetMoveRoller_Hitch( const RequestInput& cp_input );
  void SetMoveRoller_Jump( const RequestInput& cp_input );

  void SetMoveRoller_AcceleLow( const RequestInput& cp_input );
  void SetMoveRoller_AcceleHigh( const RequestInput& cp_input );
  void SetMoveRoller_Brake( const RequestInput& cp_input );
  void SetMoveRoller_BrakeHigh( const RequestInput& cp_input );
  void SetMoveRoller_EndMove( const RequestInput& cp_input );
  void SetMoveRoller_FirstTurn( const RequestInput& cp_input );
  void SetMoveRoller_FirstTurnHigh( const RequestInput& cp_input );
  void SetMoveRoller_TurnHigh( const RequestInput& cp_input );


  // PÕL[̊i[
  void SetLastKeyParam( const gfl::ui::VectorDevice* cp_key );

  // L[擾
  static Dir GetKeyDirX( const gfl::ui::VectorDevice* cp_Key );
  static Dir GetKeyDirZ( const gfl::ui::VectorDevice* cp_Key );


  // Ԃ̍XV
  void updateMoveState( void );

  // tHύX
  void updateFormRequest( void );

  // ̍擾
  static u32 getDirSub( Dir dir1, Dir dir2 );

  // @
  inline void SetMoveValue( PlayerMoveValue value ) { m_MoveValue = value; }
  
  // 
  inline void SetMoveState( PlayerMoveState value ) { m_MoveState = value; }


  // rbg
  inline void OnMoveBit( u32 movebit ) { m_MoveBit |= movebit; }
  inline void OffMoveBit( u32 movebit ) { m_MoveBit &= ~movebit; }
  inline bool IsMoveBit( u32 movebit ) const 
  { 
    if( (m_MoveBit & movebit) == movebit ){ return true; }
    return false;
  }
  
private:

  // tB[h}bv
  Fieldmap* m_pFieldmap;

  // ͏
  const gfl::ui::VectorDevice* m_cpStick;
  const gfl::ui::VectorDevice* m_cpKey;
  const gfl::ui::Button* m_cpButton;



  // vC[f[^
  PlayerWork* m_pPlayerData;


  // 샂f}l[W
  mmodel::Manager* m_pMoveModelManager;
  
  // 샂f
  mmodel::MoveModel* m_pMoveModel;


  // e
  PlayerMoveValue m_MoveValue;

  // 
  PlayerMoveState m_MoveState;
  s32 m_RollerMoveCount;

  // L[͏
  f32 m_Input_key_dist_x; //L[͉p[
  f32 m_Input_key_dist_z; //L[͏cp[
  f32 m_Input_last_speed; // L[͂PÕXs[h

  Dir m_Input_key_dir_x;  // L[͉
  Dir m_Input_key_dir_z;  // L[͏c

  // 
  u32 m_Sex;

  // tH
  PlayerForm m_Form;
  PlayerForm m_ChangeForm;


  // ڃCxgID
  s32 m_InterestEventID;


  //---------RollerXP[gƎ
  // RollerXP[g
  s32   m_RollerBreakCount;



  // [[[[[ObhIWi[[[[[[
  u32     m_MoveBit;
  
};


} // field

#endif	// __FIELDPLAYERGRID_H__

