//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldPlayerGrid.cpp
 *	@brief  tB[hvC[
 *	@author	tomoya takahashi
 *	@date		2011.05.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "field/FieldTypes.h"
#include "FieldPlayerGrid.h"

#include "field/event/EventPlayer.h"

#include "field/movemodel/FieldActionCmdAnalog.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  
  // fobOtO
  b8 PlayerGrid::m_DebugWalkFastFlag = false;

  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerGrid::PlayerGrid( void ) : 
    m_pFieldmap(NULL),
    m_cpStick(NULL),
    m_cpKey(NULL),
    m_cpButton(NULL),
    m_pPlayerData(NULL),
    m_pMoveModelManager(NULL),
    m_pMoveModel(NULL),
    m_MoveValue(PLAYER_MOVE_VALUE_STOP),
    m_MoveState(PLAYER_MOVE_STATE_OFF),
    m_Form(MOVE_FORM_NORMAL), 
    m_ChangeForm(MOVE_FORM_NON), 
    m_InterestEventID(INTEREST_EVENT_ID_NONE),
    m_MoveBit(MOVEBIT_NON)
  {
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerGrid::~PlayerGrid()
  {
    this->Finalize();
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  @@
   *
   *	@param	p_playerData      ێ
   *	@param	p_fieldmap        tB[h}bv
   *	@param	cp_pos            W
   *	@param	sex               
   *	@param	p_heap            q[vID
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::Initialize( PlayerWork* p_playerData, Fieldmap* p_fieldmap, const gfl::math::VEC3* cp_pos, u32 sex, gfl::heap::HeapBase* /*p_heap*/ )
  {
    // @Ƃēo^
    mmodel::MoveModelHeader param = 
    {
      mmodel::ID_PLAYER,
      mmodel::HERO,
      mmodel::MV_PLAYER,
      mmodel::EV_TYPE_NORMAL,
      0, 0,
      DIR_DOWN,
      0, 0, 0,
      -1, -1,
      mmodel::POSTYPE_GRID,
      {
        0,0,0
      },
    };

    param.pos_buf[0].gx  = static_cast<f32>(POS_TO_GRID<f32>(cp_pos->x));
    param.pos_buf[0].gz  = static_cast<f32>(POS_TO_GRID<f32>(cp_pos->z));
    param.pos_buf[0].y   = static_cast<s32>(cp_pos->y);
    

    // vC[f[^
    m_pPlayerData = p_playerData;

    // tB[h}bvێ
    m_pFieldmap = p_fieldmap;

    // 
    m_Sex = sex;

  

    // L[
    {
      gfl::ui::DeviceManager* p_device_man = p_fieldmap->GetDeviceManager();
      m_cpStick   = p_device_man->GetStick(0);
      m_cpKey     = p_device_man->GetCrossKey(0);
      m_cpButton  = p_device_man->GetButton(0);
    }


    // 샂f}l[W擾
    m_pMoveModelManager = p_fieldmap->GetMoveModelManager();

    // 샂f
    m_pMoveModel = m_pMoveModelManager->CreateModel( &param, m_pFieldmap->GetZoneID() );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  @@j
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::Finalize( void )
  {
    if( m_pMoveModel ){
      // 샂fj
      m_pMoveModelManager->DeleteModel( m_pMoveModel );
      m_pMoveModel = NULL;
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  @@XV
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::Update( void )
  {
    u32 order_id;
    RequestInput input;
    const gfl::ui::VectorDevice* cp_ui;
    
    // L[̓͂ړ@o
    cp_ui = this->GetStickDir( m_cpKey, m_cpStick, &input.way, &input.speed, &input.dir );
    
    if(m_cpButton->IsHold( gfl::ui::BUTTON_B )){
      input.dash = true;
    }else{
      input.dash = false;
    }

    // gbvXs[hgK
    if( (m_Input_last_speed <= 0.8f) && (input.speed >= 0.9f) ){
      input.speed_max_trg = true;
    }else{
      input.speed_max_trg = false;
    }

#if PM_DEBUG
    {
      if(m_cpButton->IsHold( gfl::ui::BUTTON_R )){
        input.debug = true;
      }else{
        input.debug = false;
      }
    }
#else
    {
      input.debug = false;
    }
#endif
    

    // Jn`FbN
    if( this->IsStartMove( input.dir ) ){

      // 1ÕL[ԕۑ
      this->SetLastKeyParam( cp_ui );

      // tHύXɑΉ
      this->updateFormRequest();

      // NGXg񐶐
      order_id = this->GetMoveOrder( input );

      // NGXgs
      this->InitMove( order_id, input );
      this->SetMove( order_id, input );
    }

    // RollerXP[gXV
    this->UpdateRoller();

    // PlayerWorkXV
    this->UpdatePlayerWork();

    // _ݒ菈B
    this->UpdateInterestView();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  @Xe[^X@XV
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::UpdateMoveStatus( void )
  {
    // ړ`FbN
    
    // ړȂAJnԂɋIɂA
    // FXȃCxgNȂȂB



    // XV
    this->updateMoveState();
  }


  // CxgN`FbN
  //----------------------------------------------------------------------------
  /**
   *	@brief  샂f@CxgN`FbN
   *
   *	@param	p_eventman  Cxg}l[W
   *
   *	@retval true    CxgN
   *	@retval false   CxgNȂ
   */
  //-----------------------------------------------------------------------------
  bool PlayerGrid::CheckMoveEvent( gamesystem::GameEventManager* p_eventman )
  {
    // g̋NȂǁB

    // FormύXCxg̋N
    {
      RequestInput input;
      const gfl::ui::VectorDevice* cp_ui;

      // L[̓͂ړ@o
      cp_ui = this->GetStickDir( m_cpKey, m_cpStick, &input.way, &input.speed, &input.dir );

      // L[ԂɂāAtHύXNGXgoB
      if( cp_ui == m_cpKey ){
        
        if( m_Form == MOVE_FORM_ROLLER ){

          // ̃ANVNAB
          m_pMoveModel->ClearAcmd();

          // XP[g̃p[^NA
          m_pMoveModel->SetMoveSpeed( gfl::math::VEC3(0,0,0) );
          m_pMoveModel->SetCalcSpeed( gfl::math::VEC3(0,0,0) );

          
          EventPlayerRollerOff* p_event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventPlayerRollerOff>( p_eventman, NULL );
          p_event->SetUp( this, input.dir );
          return true;
        }
        else if( m_Form == MOVE_FORM_CYCLE ){
          // ̃ANVNAB
          m_pMoveModel->ClearAcmd();

          // XP[g̃p[^NA
          m_pMoveModel->SetMoveSpeed( gfl::math::VEC3(0,0,0) );
          m_pMoveModel->SetCalcSpeed( gfl::math::VEC3(0,0,0) );

          
          EventPlayerCycleOff* p_event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventPlayerCycleOff>( p_eventman, NULL );
          p_event->SetUp( this, input.dir );
          return true;
        }
        
      }else if( cp_ui == m_cpStick ){

        if( m_Form == MOVE_FORM_NORMAL ){

          // analogXeBbNł̃tH擾
          PlayerForm analog_form = static_cast<PlayerForm>(m_pPlayerData->GetAnalogForm());

          // ̃ANVNAB
          m_pMoveModel->ClearAcmd();
          
          // XP[g̃p[^NA
          m_pMoveModel->SetMoveSpeed( gfl::math::VEC3(0,0,0) );
          m_pMoveModel->SetCalcSpeed( gfl::math::VEC3(0,0,0) );

          if( analog_form == MOVE_FORM_ROLLER ){

            EventPlayerRollerOn* p_event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventPlayerRollerOn>( p_eventman, NULL );
            p_event->SetUp( this, input.dir );
            return true;
          }
          else if( analog_form == MOVE_FORM_CYCLE ){

            EventPlayerCycleOn* p_event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventPlayerCycleOn>( p_eventman, NULL );
            p_event->SetUp( this, input.dir );
            return true;
          }
        }
      }
    }
    
    return false;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  W̐ݒ
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetPos( const gfl::math::VEC3& pos )
  {
    // WXV
    m_pMoveModel->UpdateVectorPos( pos );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  W̎擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetPos( gfl::math::VEC3* p_pos )
  {
    // W擾
    m_pMoveModel->GetVectorPos( p_pos );
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  ̋~
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::ForceStop( void )
  {
    m_pMoveModel->ClearAcmd();
    m_pMoveModel->SetDrawStatus( mmodel::DRAWSTA_DEFAULT_STOP );
    // Ԃ̐ݒ
    this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
    m_pMoveModel->SetMoveSpeed( gfl::math::VEC3(0,0,0) );
    m_pMoveModel->SetCalcSpeed( gfl::math::VEC3(0,0,0) );
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  tHύXNGXg
   *
   *	@param	form  tHύXNGXg
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::RequestChangeForm( PlayerForm form )
  {
    m_ChangeForm = form;
  }


  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  _xNg̓o^
   *
   *	@param	pos     _ʒu
   *	@param  length  
   *
   *	@retval true  NEAR  bOKGA
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetInterestView( const gfl::math::VEC3& pos, mmodel::Move3DModel::InterestMode mode )
  {
    m_pMoveModel->GetDrawModel()->SetInterestMode( mode );
    m_pMoveModel->GetDrawModel()->SetInterestView( pos );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  _B
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::ClearInterestView( void )
  {
    m_pMoveModel->GetDrawModel()->ClearInterestView();
  }




  //----------------------------------------------------------------------------
  /**
   *	@brief  vC[[N@XV
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::UpdatePlayerWork( void )
  {
    // ̎@Ԃi[
    gfl::math::VEC3 pos;
    Dir             dir;
    m_pMoveModel->GetVectorPos( &pos );
    m_pPlayerData->SetPos( &pos );
    m_pPlayerData->SetDir( m_pMoveModel->GetDirMove() );
  }


  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  _̊Ǘ
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::UpdateInterestView(void)
  {
    // MoveStateENDStart̃^C~OœB
    if( !((m_MoveState == PLAYER_MOVE_STATE_END) ||
        (m_MoveState != PLAYER_MOVE_STATE_START) ||
        (m_MoveState == PLAYER_MOVE_STATE_OFF)) ){
      return ;
    }
    
    // ړ_̐ݒ
    gamesystem::GameData* p_gamedata = m_pFieldmap->GetGameManager()->GetGameData();
    field::EventDataSystem* p_eventsys = p_gamedata->GetEventDataSystem();
    u32 bg_event_num = p_eventsys->GetBGEventNum();
    f32 length_min = INTERESTVIEW_LENGTH*INTERESTVIEW_LENGTH;
    bool in_data = false;
    gfl::math::VEC3 min_pos;
    
    gfl::math::VEC3 my_pos;
    const BG_TALK_DATA* cp_data = NULL;
    gfl::math::VEC3 pos;
    f32 length;

    // @̈ʒu
    m_pMoveModel->GetVectorPos(&my_pos);

    // 
    m_InterestEventID = INTEREST_EVENT_ID_NONE;
    
    // _̊Ǘ
    // @̎͂ɁABGCxg邩H
    for( u32 i=0; i<bg_event_num; ++i ){

      // Cxgf[^擾
      cp_data = p_eventsys->GetBGTalkByID(i);
      if( cp_data != NULL ){
        // |WV擾
        BGTalkData::GetCenterPos( cp_data, &pos );
        pos.y += INTERESTVIEW_HEIGHT;  // ␳B
        my_pos.y = pos.y; // ʂł̋߂


        // @Ƃ̋߂B
        length = gfl::math::VEC3SquareDist( &pos, &my_pos );
        if( length < length_min ){
          min_pos = pos;
          in_data = true;
          length_min = length; 
          m_InterestEventID = i;  // ڂĂCxgID̐ݒ
        }
      }
    }

    if( in_data ){
      mmodel::Move3DModel::InterestMode mode;
      mode = mmodel::Move3DModel::INTEREST_NEAR;
      
      this->SetInterestView( min_pos, mode );
      
    }else{

      this->ClearInterestView();
    }
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  RollerXP[gXV
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::UpdateRoller( void )
  {
    if( m_RollerBreakCount > 0 ){
      --m_RollerBreakCount;
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  L[񂩂AƐ擾
   *
   *	@param	cp_Key
   *	@param	cp_Stick
   *	@param	p_way
   *	@param	p_speed 
   *	@param  dir
   *
   *	@retval VectorDevice
   */
  //-----------------------------------------------------------------------------
  const gfl::ui::VectorDevice* PlayerGrid::GetStickDir( const gfl::ui::VectorDevice* cp_Key, const gfl::ui::VectorDevice* cp_Stick, gfl::math::VEC3* p_way, f32* p_speed, Dir* p_dir ) const
  {
    // ܂AXeBbND
    // ́ARDS̃XeBbN쒆
    // NXL[\邽߁B
    if( cp_Stick->GetHold() ){

      // XeBbN̏
      *p_dir  = this->GetStickDirStick( cp_Stick, p_way, p_speed );   
      return cp_Stick;
    }
    else if( cp_Key->GetHold() ){
      
      // NXL[̏
      
      *p_dir  = this->GetStickDirKey( cp_Key, p_way, p_speed );   
      return cp_Key;
    }
    
    // ȂB
    *p_dir = DIR_NOT;
    return NULL;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  XeBbN񂩂AƐ擾
   *
   *	@param	cp_Stick    XeBbN
   *	@param	p_way       
   *	@param	p_speed     Xs[h
   *
   *	@retval wayœK
   */
  //-----------------------------------------------------------------------------
  Dir PlayerGrid::GetStickDirStick( const gfl::ui::VectorDevice* cp_Stick, gfl::math::VEC3* p_way, f32* p_speed ) const
  {
    Dir ret = DIR_NOT;
    
    if( cp_Stick->GetHold() ){
      p_way->x = cp_Stick->GetX();
      p_way->y = 0.0f;
      p_way->z = -cp_Stick->GetY();
      *p_speed = p_way->Length();
      if( *p_speed ){

        // Xs[h (STICK_SPEED_CONTROL{j
        *p_speed *= STICK_SPEED_CONTROL;
        if( *p_speed > 1.0f ){
          *p_speed = 1.0f; 
        }

        p_way->Normalize();

        mmodel::MoveModelBase::CalcVecToDir( *p_way, &ret );

        return ret;
      }
    }
    
    return ret;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  NXL[񂩂AƐ擾
   *
   *	@param	cp_Ke       NXL[
   *	@param	p_way       
   *	@param	p_speed     Xs[h
   *
   *	@retval wayœK
   */
  //-----------------------------------------------------------------------------
  Dir PlayerGrid::GetStickDirKey( const gfl::ui::VectorDevice* cp_Key, gfl::math::VEC3* p_way, f32* p_speed ) const
  {
    Dir dir_x = GetKeyDirX( cp_Key );
    Dir dir_z = GetKeyDirZ( cp_Key );

    // Obh̏ꍇAXs[h͂P
    *p_speed = 1.0f;

    
    // ̏ꍇZD
    if( dir_x == DIR_NOT ){
      mmodel::MoveModelBase::CalcDirToVec( dir_z, p_way );
      return dir_z;
    }

    if( dir_z == DIR_NOT ){
      mmodel::MoveModelBase::CalcDirToVec( dir_x, p_way );
      return dir_x;
    }

    // B
    if( (dir_x == DIR_LEFT) && (dir_z == DIR_UP) ){
      return DIR_LEFTUP;
    }
    if( (dir_x == DIR_RIGHT) && (dir_z == DIR_UP) ){
      return DIR_RIGHTUP;
    }
    if( (dir_x == DIR_LEFT) && (dir_z == DIR_DOWN) ){
      return DIR_LEFTDOWN;
    }
    //if( (dir_x == DIR_RIGHT) && (dir_z == DIR_DOWN) )
    return DIR_RIGHTDOWN;


#if 0 // BW 4̏ꍇB
    // ĂꍇB
    // ړƈvȂAZDŕԂB
    {
      Dir move_dir = m_pMoveModel->GetDirMove();
      Dir last_input_x = m_Input_key_dir_x;
      Dir last_input_z = m_Input_key_dir_z;

      if( move_dir != DIR_NOT ){
        // 1OĂB
        
        // ߋɉp?
        if( (dir_x == last_input_x) && (dir_z == last_input_z) ){
          
          if( dir_z == move_dir ){ // ړƈvZDŕԂ
            mmodel::MoveModelBase::CalcDirToVec( dir_z, p_way );
            return dir_z;
          }
          else if( dir_x == move_dir ){
            mmodel::MoveModelBase::CalcDirToVec( dir_x, p_way );
            return dir_x;
          }
        }

        // ςقD
        if( dir_z != last_input_z ){
          mmodel::MoveModelBase::CalcDirToVec( dir_z, p_way );
          return dir_z;
        }

        // ςقD
        if( dir_x != last_input_x ){
          mmodel::MoveModelBase::CalcDirToVec( dir_x, p_way );
          return dir_x;
        }

        mmodel::MoveModelBase::CalcDirToVec( dir_z, p_way );
        return dir_z;
      }
    }

    // 1OĂȂ΁AZD
    mmodel::MoveModelBase::CalcDirToVec( dir_z, p_way );
    return dir_z;
#endif
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  PÕL[ێ
   *
   *	@param	cp_key  L[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetLastKeyParam( const gfl::ui::VectorDevice* cp_key )
  {
    if( cp_key == NULL ){
      m_Input_key_dir_x = DIR_NOT;
      m_Input_key_dir_z = DIR_NOT;
    
      m_Input_last_speed = 0.0f;
      m_Input_key_dist_x = 0;
      m_Input_key_dist_z = 0;
    }else{
      m_Input_key_dir_x = this->GetKeyDirX( cp_key );
      m_Input_key_dir_z = this->GetKeyDirZ( cp_key );
    
      gfl::math::VEC3 way;
      cp_key->GetVector(&way);
      m_Input_last_speed = way.Length();
      m_Input_key_dist_x = way.x;
      m_Input_key_dist_z = way.y;
    }
  }


  // L[擾
  //----------------------------------------------------------------------------
  /**
   *	@brief  L[X擾
   *
   *	@param	cp_Key  L[NX
   *
   *	@return 
   */
  //-----------------------------------------------------------------------------
  Dir PlayerGrid::GetKeyDirX( const gfl::ui::VectorDevice* cp_Key )
  {
    if( cp_Key->IsHold( gfl::ui::DIR_LEFT ) ){
      return DIR_LEFT;
    }

    if( cp_Key->IsHold( gfl::ui::DIR_RIGHT ) ){
      return DIR_RIGHT;
    }
    return DIR_NOT;
  }
  //----------------------------------------------------------------------------
  /**
   *	@brief  L[Z擾
   *
   *	@param	cp_Key  L[NX
   *
   *	@return 
   */
  //-----------------------------------------------------------------------------
  Dir PlayerGrid::GetKeyDirZ( const gfl::ui::VectorDevice* cp_Key )
  {
    if( cp_Key->IsHold( gfl::ui::DIR_UP ) ){
      return DIR_UP;
    }

    if( cp_Key->IsHold( gfl::ui::DIR_DOWN ) ){
      return DIR_DOWN;
    }
    return DIR_NOT;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  łԂ`FbN
   *
   *	@param	dir   
   *
   *	@retval true  łB
   *	@retval false łȂB
   */
  //-----------------------------------------------------------------------------
  bool PlayerGrid::IsStartMove( Dir dir ) const
  {
    // ANVR}hs͓s\
    if( m_pMoveModel->IsAcmdUse() )
    {
      return true;
    }

    // ǃqbg쒆́A
    // Ⴄ͂uԂɈړ\
    if( dir != DIR_NOT ){
      if( m_MoveValue == PLAYER_MOVE_VALUE_HITCH ){
        return true;
      }
    }
    
    return false;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ʃqbg`FbN
   *
   *	@param	dir       
   *	@param	p_attr    Agr[gi[
   *
   *	@return qbg
   */
  //-----------------------------------------------------------------------------
  mmodel::MoveModelBase::MoveHitBit PlayerGrid::HitCheckMove( Dir dir, Attr* p_attr ) const
  {
    s16 gx = m_pMoveModel->GetGridPosX();
    s16 gy = m_pMoveModel->GetGridPosY();
    s16 gz = m_pMoveModel->GetGridPosZ();
    s16 add_gx = gx;
    s16 add_gz = gz;
    gfl::math::VEC3 pos;
    mmodel::MoveModelBase::MoveHitBit ret;
    mmodel::MoveModelBase::MoveHitBit ret1;
    mmodel::MoveModelBase::MoveHitBit ret2;


    // Obhi߂
    add_gx += mmodel::MoveModelBase::GetDirAddValueGridX( dir );
    add_gz += mmodel::MoveModelBase::GetDirAddValueGridZ( dir );
    
    ret = m_pMoveModel->HitCheckMoveCurrent( add_gx, gy, add_gz, dir );
    ret1 = m_pMoveModel->HitCheckMoveCurrent( add_gx, gy, gz, dir );      // ΂߈ړ̂߁B
    ret2 = m_pMoveModel->HitCheckMoveCurrent( gx, gy, add_gz, dir );      // 3_`FbNB

    ret = static_cast<mmodel::MoveModelBase::MoveHitBit>(ret | ret1 | ret2);
        

    // ʒũAgr[g擾
    if( !m_pMoveModel->GetPosAttr( gx, gy, gz, p_attr ) ){
      *p_attr = ATTR_ERROR;
    }

    // ꕔƂ锻`FbN
    if( ret & mmodel::MoveModelBase::MOVEHITBIT_ATTR ){

      // BWł́A͌܂Ă邩ĂB
    }

    return ret;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ʃqbg`FbN
   *
   *	@param	way       
   *	@param  dist      
   *	@param	p_attr    Agr[gi[
   *
   *	@return qbg
   */
  //-----------------------------------------------------------------------------
  mmodel::MoveModelBase::MoveHitBit PlayerGrid::HitCheckMove( Dir dir, const gfl::math::VEC3& way, f32 dist, Attr* p_attr ) const 
  {
    // xNgŁAǗB
    gfl::math::VEC3 pos;
    gfl::math::VEC3 next_pos;

    m_pMoveModel->GetVectorPos( &pos );
    next_pos = pos;
    next_pos.x += way.x * dist;
    next_pos.y += way.y * dist;
    next_pos.z += way.z * dist;

    // ObhWɕύX
    s16 gx = m_pMoveModel->GetGridPosX();
    s16 gy = m_pMoveModel->GetGridPosY();
    s16 gz = m_pMoveModel->GetGridPosZ();

    mmodel::MoveModelBase::MoveHitBit ret;
    mmodel::MoveModelBase::MoveHitBit ret1;
    mmodel::MoveModelBase::MoveHitBit ret2;

    s16 add_gx = static_cast<s16>(POS_TO_GRID<f32>(next_pos.x));
    s16 add_gz = static_cast<s16>(POS_TO_GRID<f32>(next_pos.z));

    ret = m_pMoveModel->HitCheckMoveCurrent( add_gx, gy, add_gz, dir );
    ret1 = m_pMoveModel->HitCheckMoveCurrent( add_gx, gy, gz, dir );      // ΂߈ړ̂߁B
    ret2 = m_pMoveModel->HitCheckMoveCurrent( gx, gy, add_gz, dir );      // 3_`FbNB

    if( (ret & 0x8) ){
      TOMOYA_PRINT( "0 x=%d z=%d\n", add_gx, add_gz );
    }
    if( (ret1 & 0x8) ){
      TOMOYA_PRINT( "1 x=%d z=%d\n", add_gx, gz );
    }
    if( (ret2 & 0x8) ){
      TOMOYA_PRINT( "2 x=%d z=%d\n", gx, add_gz );
    }

    ret = static_cast<mmodel::MoveModelBase::MoveHitBit>(ret | ret1 | ret2);

    // ʒũAgr[g擾
    if( !m_pMoveModel->GetPosAttr( gx, gy, gz, p_attr ) ){
      *p_attr = ATTR_ERROR;
    }

    // ꕔƂ锻`FbN
    if( ret & mmodel::MoveModelBase::MOVEHITBIT_ATTR ){

      // BWł́A͌܂Ă邩ĂB
    }

    
    return ret;
  }


  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief    ͏񂩂ANGXgI[_[߂B
   *
   *	@param	  cp_input    ͏
   *
   *	@return   NGXgI[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrder( const RequestInput& cp_input ) const
  {
    u32 order = MOVEORDER_NON;
    PlayerForm form;

    
    // tHƂ̓I[_[`FbN
    form = this->GetMoveForm();

    switch( form ){
    case MOVE_FORM_NORMAL:     ///<s
      order = this->GetMoveOrderNormal( cp_input );
      break;

    case MOVE_FORM_CYCLE:      ///<]ԏ
      order = this->GetMoveOrderCycle( cp_input );
      break;

    case MOVE_FORM_ROLLER:     ///<ROLLERXP[g
      order = this->GetMoveOrderRoller( cp_input );
      break;
    }
    
    return order;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  NGXgI[_[߂@s[h
   *
   *	@param	  cp_input    ͏
   *
   *	@return NGXgI[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderNormal( const RequestInput& cp_input ) const
  {
    u32 ret = MOVEORDER_NON;
    
    switch( this->GetMoveValue() ){
    case PLAYER_MOVE_VALUE_STOP: ///<~
      ret = this->GetMoveOrderNormal_Stop( cp_input );
      break;

    case PLAYER_MOVE_VALUE_WALK: ///<ړ
      ret = this->GetMoveOrderNormal_Walk( cp_input );
      break;

    case PLAYER_MOVE_VALUE_TURN: ///<U
      ret = this->GetMoveOrderNormal_Turn( cp_input );
      break;

    case PLAYER_MOVE_VALUE_HITCH: ///<ǂ蒆
      ret = this->GetMoveOrderNormal_Hitch( cp_input );
      break;
    }

    return ret;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  NGXgI[_[߂@RollerXP[g[h
   *
   *	@param	  cp_input    ͏
   *
   *	@return NGXgI[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller( const RequestInput& cp_input ) const
  {
    u32 ret = MOVEORDER_NON;
    
    switch( this->GetMoveValue() ){
    case PLAYER_MOVE_VALUE_STOP: ///<~
      ret = this->GetMoveOrderRoller_Stop( cp_input );
      break;

    case PLAYER_MOVE_VALUE_WALK: ///<ړ
      ret = this->GetMoveOrderRoller_Walk( cp_input );
      break;

    case PLAYER_MOVE_VALUE_TURN: ///<U
      ret = this->GetMoveOrderRoller_Turn( cp_input );
      break;

    case PLAYER_MOVE_VALUE_HITCH: ///<ǂ蒆
      ret = this->GetMoveOrderRoller_Hitch( cp_input );
      break;

    case PLAYER_MOVE_VALUE_HIGHTURN: ///<U
      ret = this->GetMoveOrderRoller_HighTurn( cp_input );
      break;
    }

    return ret;
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  Ƃ܂ĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderNormal_Stop( const RequestInput& cp_input ) const
  {
    // dir̕ƍĂv̂ł΁AB
    Dir old_dir = m_pMoveModel->GetDirDisp(); 
    
    if( cp_input.dir != DIR_NOT ){
      if( old_dir != cp_input.dir ){
        // _bV́AU
        if( cp_input.dash == false ){
          return MOVEORDER_TURN;
        }
      }

      // sJn
      return this->GetMoveOrderNormal_Walk( cp_input );
    }

    if( this->GetMoveValue() != PLAYER_MOVE_VALUE_STOP ){
      return MOVEORDER_STOP;
    }
    
    return MOVEORDER_NON;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderNormal_Walk( const RequestInput& cp_input ) const
  {
    if( cp_input.dir == DIR_NOT ){
      return this->GetMoveOrderNormal_Stop( cp_input );
    }

    // ̕Ɉړł邩H
    {
      Attr attr;
      mmodel::MoveModelBase::MoveHitBit hit = this->HitCheckMove( cp_input.dir, &attr );

#if PM_DEBUG
      if( cp_input.debug ){

        // fobȌꍇAOutRengeȊONONɂĂ܂B
        if( !(hit & mmodel::MoveModelBase::MOVEHITBIT_OUTRANGE) ){
          hit = mmodel::MoveModelBase::MOVEHITBIT_NON;
          attr = 0;
        }
      }
#endif
      
      // Agr[gH
      if( attr != ATTR_ERROR ){
        
        // Agr[gŐi߂Ȃꍇ
        if( hit & mmodel::MoveModelBase::MOVEHITBIT_ATTR ){
          // WvH
        }

        if( hit == mmodel::MoveModelBase::MOVEHITBIT_NON ){
          // s\
          return MOVEORDER_WALK;
        }
      }
    }
    
    
    // qbg
    return MOVEORDER_HITCH;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  UĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderNormal_Turn( const RequestInput& cp_input ) const
  {
    return this->GetMoveOrderNormal_Walk( cp_input );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂɂԂĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderNormal_Hitch( const RequestInput& cp_input ) const
  {
    Dir dir_now = m_pMoveModel->GetDirDisp();
    
    // ႤɐiƂĂꍇB
    if( (cp_input.dir != DIR_NOT) && (cp_input.dir != dir_now) ){
      m_pMoveModel->ClearAcmd();
      return this->GetMoveOrderNormal_Walk( cp_input );
    }

    // \`FbN
    if( m_pMoveModel->IsAcmdUse() == false ){
      return MOVEORDER_NON;
    }
    

    return this->GetMoveOrderNormal_Walk( cp_input );
  }



  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp I[_[擾
   *
   *	@param	cp_input  ͏
   *
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle( const RequestInput& cp_input ) const
  {
    u32 ret = MOVEORDER_NON;
    
    switch( this->GetMoveValue() ){
    case PLAYER_MOVE_VALUE_STOP: ///<~
      ret = this->GetMoveOrderCycle_Stop( cp_input );
      break;

    case PLAYER_MOVE_VALUE_WALK: ///<ړ
      ret = this->GetMoveOrderCycle_Walk( cp_input );
      break;

    case PLAYER_MOVE_VALUE_TURN: ///<U
      ret = this->GetMoveOrderCycle_Turn( cp_input );
      break;

    case PLAYER_MOVE_VALUE_HITCH: ///<ǂ蒆
      ret = this->GetMoveOrderCycle_Hitch( cp_input );
      break;
    }

    return ret;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp@Ƃ܂ĂƂ̔
   *
   *	@param cp_input ͏	
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_Stop( const RequestInput& cp_input ) const
  {
    // ق
    if( cp_input.dir != DIR_NOT ){
      return this->GetMoveOrderCycle_Walk( cp_input );
    }
    return MOVEORDER_NON;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp@ĂƂ̔
   *
   *	@param cp_input   ͏	
   *	@param  p_dir_sub px̍@i[
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_Walk( const RequestInput& cp_input, u32* p_dir_sub ) const
  {
    u32 ret_order = this->GetMoveOrderCycle_WalkBase( cp_input, p_dir_sub );
    return this->GetMoveOrderCycle_HitCheck( cp_input, ret_order );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp@̃RA
   *
   *	@param	cp_input    ͏
   *	@param  p_dir_sub   px̍@i[
   *
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_WalkBase( const RequestInput& cp_input, u32* p_dir_sub ) const
  {
    gfl::math::VEC3 speed;
    f32 length;
    m_pMoveModel->GetMoveSpeed(&speed);
    length = speed.Length();

    // Ȃ
    if( cp_input.dir == DIR_NOT ){

      if( speed.Length() > 0.0f ){
        // Xs[hȂAIւ̑J
        return MOVEORDER_ENDMOVE;
      }
      return this->GetMoveOrderCycle_Stop(cp_input);
    }

    // ̈ړ߂B
    Dir old_dir = m_pMoveModel->GetDirMove();
    u32 dir_sub = getDirSub( old_dir, cp_input.dir );
    u32 ret_order = MOVEORDER_WALK;

    // px̍ۑ
    if( p_dir_sub ){
      *p_dir_sub = dir_sub;
    }
    
    //*
    if( (dir_sub <= 2) ){

      // ۂ̍̕B
      ret_order = MOVEORDER_WALK;
    }else if( dir_sub >= 3 ){

      // tɈCɓB
      ret_order = MOVEORDER_WALK;
    }
    /**/

    /*
    // ܂I[_[̏ꍇB
    if( ret_order == MOVEORDER_WALK ){
      // XeBbN̓|AAA`FbN
      // 
      if( cp_input.speed_max_trg && ((cp_input.speed * static_cast<f32>(SPEED_MAX)) >= length) ){
        //GFL_PRINT( "Accel High\n" );
        ret_order = MOVEORDER_ACCELE_HIGH;
      }
      else if( (cp_input.speed * static_cast<f32>(SPEED_MAX)) >= length ){
        //GFL_PRINT( "Accel Low\n" );
        ret_order = MOVEORDER_ACCELE_LOW;
      }
      // 
      // At[́ABRAKEȂB
      else if( (m_RollerBreakCount <= 0) &&
          ((cp_input.speed * static_cast<f32>(SPEED_MAX)) <= length - static_cast<f32>(ACCELERATOR_NUM)) ){
        //GFL_PRINT( "Brake\n" );
        ret_order = MOVEORDER_BRAKE;
      }
    }
    */

    return ret_order;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@蔻
   *
   *	@param	cp_input  ͏
   *	@param  order     I[_[
   *
   *	@return 蔻̃I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_HitCheck( const RequestInput& cp_input, u32 order ) const
  {
    Dir hit_check_dir;
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    f32 dist;

    this->GetOrderCycleDir( order, cp_input, &way, &speed, &calc );

    way = speed + calc;
    dist = way.Length();
    if( dist != 0.0f ){
      way.Normalize();
      mmodel::MoveModelBase::CalcVecToDir( way, &hit_check_dir );
    }else{
      // ړȂB
      return order;
    }


    // ̕Ɉړł邩H
    {
      Attr attr;
      mmodel::MoveModelBase::MoveHitBit hit = this->HitCheckMove( hit_check_dir, way, dist*static_cast<f32>(mmodel::ACTION_ANALOG_MOVE_FRAME), &attr );

#if PM_DEBUG
      if( cp_input.debug ){

        // fobȌꍇAOutRengeȊONONɂĂ܂B
        if( !(hit & mmodel::MoveModelBase::MOVEHITBIT_OUTRANGE) ){
          hit = mmodel::MoveModelBase::MOVEHITBIT_NON;
          attr = 0;
        }
      }
#endif
      
      // Agr[gH
      if( attr != ATTR_ERROR ){
        
        // Agr[gŐi߂Ȃꍇ
        if( hit & mmodel::MoveModelBase::MOVEHITBIT_ATTR ){
          // WvH
        }

        if( hit == mmodel::MoveModelBase::MOVEHITBIT_NON ){
          return order;
        }
      }
    }
    // qbg
    return MOVEORDER_HITCH;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp@^[̔
   *	@param	cp_input  ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_Turn( const RequestInput& cp_input ) const
  {
    u32 order = this->GetMoveOrderCycle_WalkBase( cp_input, NULL );

    // ̕Ɉړđv`FbN
    return this->GetMoveOrderRoller_HitCheck( cp_input, order ); 
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԗp@ǂ
   *	@param	cp_input  ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderCycle_Hitch( const RequestInput& cp_input ) const
  {
    Dir dir_now = m_pMoveModel->GetDirDisp();
    
    // ႤɐiƂĂꍇB
    if( (cp_input.dir != DIR_NOT) && (cp_input.dir != dir_now) ){
      m_pMoveModel->ClearAcmd();
      return this->GetMoveOrderCycle_Walk( cp_input );
    }

    // \`FbN
    if( m_pMoveModel->IsAcmdUse() == false ){
      return MOVEORDER_NON;
    }
    
    return this->GetMoveOrderCycle_Walk( cp_input );
  }




  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@I[_[Ƃ̈ړ̊mF
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir( u32 order, const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    switch( order ){
    case MOVEORDER_STOP:    ///<~Zbg
      this->GetOrderCycleDir_Stop( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_WALK:    ///<Zbg
      this->GetOrderCycleDir_Walk( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_TURN:    ///<UZbg
      this->GetOrderCycleDir_Turn( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_HITCH:   ///<QqbgZbg
      this->GetOrderCycleDir_Hitch( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_JUMP:    ///<WvZbg
      this->GetOrderCycleDir_Jump( cp_input, p_way, p_speed, p_calc );
      break;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@~̈ړAXs[hAx
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir_Stop( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    p_way->x = 0;
    p_way->y = 0;
    p_way->z = 0;

    if( p_speed ){
      p_speed->x = 0;
      p_speed->y = 0;
      p_speed->z = 0;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@̈ړAXs[hAx
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir_Walk( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    if( p_speed ){

      // Xs[hێ܂܁AL[ɓړB
      gfl::math::VEC3 speed;
      f32 length;
      length = CYCLE_MOVE_SPEED;
      speed = cp_input.way;
      speed.x *= length;
      speed.y *= length;
      speed.z *= length;

      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
    
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@]̈ړAXs[hAx
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir_Turn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    this->GetOrderCycleDir_Walk( cp_input, p_way, p_speed, p_calc );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@Ǖ̈ړAXs[hAx
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir_Hitch( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    this->GetOrderCycleDir_Stop( cp_input, p_way, p_speed, p_calc );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@Wv̈ړAXs[hAx
   *
   *	@param	cp_input    ͏
   *	@param  p_way       i[
   *	@param  p_speed     Xs[hi[
   *	@param  p_calc      AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderCycleDir_Jump( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    this->GetOrderCycleDir_Walk( cp_input, p_way, p_speed, p_calc );
  }







  //----------------------------------------------------------------------------
  /**
   *	@brief  Ƃ܂ĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_Stop( const RequestInput& cp_input ) const
  {
    // ق
    if( cp_input.dir != DIR_NOT ){
      return this->GetMoveOrderRoller_Walk( cp_input );
    }
    
    return MOVEORDER_NON;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  邢ĂƂ̔
   *	@param	  cp_input    ͏
   *	@param    p_dir_sub   px̍i[
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_Walk( const RequestInput& cp_input, u32* p_dir_sub ) const
  {
    u32 ret_order = this->GetMoveOrderRoller_WalkBase( cp_input, p_dir_sub );
    return this->GetMoveOrderRoller_HitCheck( cp_input, ret_order );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  @I[_[߂Ƃ܂ł̃x[X
   *
   *	@param	  cp_input    ͏
   *	@param    p_dir_sub   px̍i[
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_WalkBase( const RequestInput& cp_input, u32* p_dir_sub ) const
  {
    gfl::math::VEC3 speed;
    f32 length;
    m_pMoveModel->GetMoveSpeed(&speed);
    length = speed.Length();

    // Ȃ
    if( cp_input.dir == DIR_NOT ){

      if( speed.Length() > 0.0f ){
        // Xs[hȂAIւ̑J
        return MOVEORDER_ENDMOVE;
      }
      return this->GetMoveOrderRoller_Stop(cp_input);
    }

    // ̈ړ߂B
    Dir old_dir = m_pMoveModel->GetDirMove();
    u32 dir_sub = getDirSub( old_dir, cp_input.dir );
    u32 ret_order = MOVEORDER_WALK;

    // px̍ۑ
    if( p_dir_sub ){
      *p_dir_sub = dir_sub;
    }
    
    //*
    if( (dir_sub <= 1) ){

      // ۂ̍̕B
      gfl::math::VEC3 move_way;
      f32 cos;
      m_pMoveModel->GetDirMoveWay( &move_way );
      cos = move_way.Dot( cp_input.way );
      
      if( (dir_sub == 1) || (cos <= gfl::math::CosDeg( TURN_ROT_MIN )) ){
      
        if( length >= static_cast<f32>(FULLTURN_SPEED_MAX) ){ // Ԃ[LOȂɃ^[
          // ^[
          ret_order = MOVEORDER_TURNFIRST;
        }
      }
    }else if( dir_sub == 2 ){

      if( length >= static_cast<f32>(FULLTURN_SPEED_MAX) ){
        //GFL_PRINT( "HighTurnFirst\n" );
        ret_order = MOVEORDER_HIGHTURNFIRST;
      }

    }else if( dir_sub >= 3 ){

      // FULLTURN_SPEED܂Ō
      // ̌^[
      if( length >= static_cast<f32>(FULLTURN_SPEED_MIN) ){
        //GFL_PRINT( "Brake High\n" );
        ret_order = MOVEORDER_BRAKE_HIGH;
      }
      /*
      else if( length >= static_cast<f32>(FULLTURN_SPEED_MIN) ){
        return MOVEORDER_TURNFIRST;
      }
      */
    }
    /**/

    // ܂I[_[̏ꍇB
    if( ret_order == MOVEORDER_WALK ){
      // XeBbN̓|AAA`FbN
      // 
      if( cp_input.speed_max_trg && ((cp_input.speed * static_cast<f32>(SPEED_MAX)) >= length) ){
        //GFL_PRINT( "Accel High\n" );
        ret_order = MOVEORDER_ACCELE_HIGH;
      }
      else if( (cp_input.speed * static_cast<f32>(SPEED_MAX)) >= length ){
        //GFL_PRINT( "Accel Low\n" );
        ret_order = MOVEORDER_ACCELE_LOW;
      }
      // 
      // At[́ABRAKEȂB
      else if( (m_RollerBreakCount <= 0) &&
          ((cp_input.speed * static_cast<f32>(SPEED_MAX)) <= length - static_cast<f32>(ACCELERATOR_NUM)) ){
        //GFL_PRINT( "Brake\n" );
        ret_order = MOVEORDER_BRAKE;
      }
    }

    return ret_order;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  UĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_Turn( const RequestInput& cp_input ) const
  {
    u32 dir_sub;
    u32 order = this->GetMoveOrderRoller_WalkBase( cp_input, &dir_sub );

    // ^[p`FbN
    if( (order == MOVEORDER_TURNFIRST) || (order == MOVEORDER_HIGHTURNFIRST) ||
        ((order == MOVEORDER_BRAKE_HIGH) && (dir_sub < 4)) ){
      order = MOVEORDER_TURN;
    }

    // ̕Ɉړđv`FbN
    return this->GetMoveOrderRoller_HitCheck( cp_input, order ); 
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  UĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_HighTurn( const RequestInput& cp_input ) const
  {
    u32 dir_sub;
    u32 order = this->GetMoveOrderRoller_WalkBase( cp_input, &dir_sub );

    // ^[p`FbN
    if( (order == MOVEORDER_TURNFIRST) || (order == MOVEORDER_HIGHTURNFIRST) ||
        ((order == MOVEORDER_BRAKE_HIGH) && (dir_sub < 4)) ){
      order = MOVEORDER_HIGHTURN;
    }

    // ̕Ɉړđv`FbN
    return this->GetMoveOrderRoller_HitCheck( cp_input, order ); 
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂɂԂĂƂ̔
   *	@param	  cp_input    ͏
   *	@return I[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_Hitch( const RequestInput& cp_input ) const
  {
    Dir dir_now = m_pMoveModel->GetDirDisp();
    
    // ႤɐiƂĂꍇB
    if( (cp_input.dir != DIR_NOT) && (cp_input.dir != dir_now) ){
      m_pMoveModel->ClearAcmd();
      return this->GetMoveOrderRoller_Walk( cp_input );
    }

    // \`FbN
    if( m_pMoveModel->IsAcmdUse() == false ){
      return MOVEORDER_NON;
    }
    

    return this->GetMoveOrderRoller_Walk( cp_input );
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  I[_[ւ̃qbg`FbNB
   *
   *	@param	cp_input  ͏
   *	@param  order     I[_[
   *
   *	@return qbg`FbÑI[_[
   */
  //-----------------------------------------------------------------------------
  u32 PlayerGrid::GetMoveOrderRoller_HitCheck( const RequestInput& cp_input, u32 order ) const
  {
    Dir hit_check_dir;
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    f32 dist;

    this->GetOrderRollerDir( order, cp_input, &way, &speed, &calc );

    way = speed + calc;
    dist = way.Length();
    if( dist != 0.0f ){
      way.Normalize();
      mmodel::MoveModelBase::CalcVecToDir( way, &hit_check_dir );
    }else{
      // ړȂB
      return order;
    }


    // ̕Ɉړł邩H
    {
      Attr attr;
      mmodel::MoveModelBase::MoveHitBit hit = this->HitCheckMove( hit_check_dir, way, dist*static_cast<f32>(mmodel::ACTION_ANALOG_MOVE_FRAME), &attr );

#if PM_DEBUG
      if( cp_input.debug ){

        // fobȌꍇAOutRengeȊONONɂĂ܂B
        if( !(hit & mmodel::MoveModelBase::MOVEHITBIT_OUTRANGE) ){
          hit = mmodel::MoveModelBase::MOVEHITBIT_NON;
          attr = 0;
        }
      }
#endif
      
      // Agr[gH
      if( attr != ATTR_ERROR ){
        
        // Agr[gŐi߂Ȃꍇ
        if( hit & mmodel::MoveModelBase::MOVEHITBIT_ATTR ){
          // WvH
        }

        if( hit == mmodel::MoveModelBase::MOVEHITBIT_NON ){
          return order;
        }
      }
    }
    // qbg
    return MOVEORDER_HITCH;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  [[XP[g@I[_[Ƃ̈ړmF
   *
   *	@param	order     I[_[
   *	@param  cp_input  Cvbg
   *	@param  p_way     ړi[
   *	@param  p_speed   ړXs[hi[
   *	@param  p_calc    AXs[hi[
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir( u32 order, const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    switch( order ){
    case MOVEORDER_STOP:    ///<~Zbg
      this->GetOrderRollerDir_Stop( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_WALK:    ///<Zbg
      this->GetOrderRollerDir_Walk( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_TURN:    ///<UZbg
      this->GetOrderRollerDir_Turn( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_HITCH:   ///<QqbgZbg
      this->GetOrderRollerDir_Hitch( cp_input, p_way, p_speed, p_calc );
      break;
    case MOVEORDER_JUMP:    ///<WvZbg
      this->GetOrderRollerDir_Jump( cp_input, p_way, p_speed, p_calc );
      break;


    case MOVEORDER_ACCELE_LOW:     ///<
      this->GetOrderRollerDir_AcceleLow( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_ACCELE_HIGH:    ///<
      this->GetOrderRollerDir_AcceleHigh( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_BRAKE:          ///<
      this->GetOrderRollerDir_Brake( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_BRAKE_HIGH:
      this->GetOrderRollerDir_BrakeHigh( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_ENDMOVE:        ///<
      this->GetOrderRollerDir_EndMove( cp_input, p_way, p_speed, p_calc );
      break;
      
    case MOVEORDER_TURNFIRST:
      this->GetOrderRollerDir_FirstTurn( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_HIGHTURNFIRST:
      this->GetOrderRollerDir_FirstTurnHigh( cp_input, p_way, p_speed, p_calc );
      break;

    case MOVEORDER_HIGHTURN:
      this->GetOrderRollerDir_TurnHigh( cp_input, p_way, p_speed, p_calc );
      break;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Xgbv߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Stop( const RequestInput& /*cp_input*/, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    p_way->x = 0;
    p_way->y = 0;
    p_way->z = 0;

    if( p_speed ){
      p_speed->x = 0;
      p_speed->y = 0;
      p_speed->z = 0;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Walk( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    
    if( p_speed ){

      // Xs[hێ܂܁AL[ɓړB
      gfl::math::VEC3 speed;
      f32 length;
      m_pMoveModel->GetMoveSpeed(&speed); 
      length = speed.Length();
      speed = cp_input.way;
      speed.x *= length;
      speed.y *= length;
      speed.z *= length;

      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
    
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ^[߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Turn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    if(p_speed){
      // Xs[hێ܂܁AŒpxςB
      gfl::math::VEC3 speed;
      gfl::math::VEC3 nrm;
      f32 length;
      f32 rot_length;
      gfl::math::MTX34 rot_mtx;
      f32 cos;
      u32 rot_num;
      
      m_pMoveModel->GetMoveSpeed(&speed); 
      length = speed.Length();
      speed.Normalize();

      // Xs[hAPɉ]łpxoB
      {
        if(length >= SPEED_MAX){
          rot_length = 0;
        }else if( length <= FULLTURN_SPEED_MIN ){
          rot_length = SPEED_MAX - FULLTURN_SPEED_MIN;
        }else {
          rot_length = SPEED_MAX - length;
        }

        rot_num = TURN_ROT_MIN + ((TURN_ROT_NUM * static_cast<u32>(rot_length)) / static_cast<u32>(SPEED_MAX - FULLTURN_SPEED_MIN));
          
      }

      
      cos = speed.Dot(cp_input.way);
      if( cos >= gfl::math::CosDeg( rot_num ) ){
        // ̕ɂႤB
        speed = cp_input.way;
      }else{

        // speedTURN_ROT Y]
        nrm.Cross( speed, cp_input.way );
        if( nrm.Length() ){
          nrm.Normalize();
        }else{
          nrm.Set(0, 1.0f, 0);
        }
        gfl::math::MTX34RotAxisFIdx( &rot_mtx, &nrm, GFL_MATH_DEG_TO_FIDX(rot_num) );

        // ]
        gfl::math::VEC3Transform( &speed, &rot_mtx, &speed );
        speed.Normalize();
      }

      if( length < SPEED_MAX ){
        length += TURN_ACCELE_NUM;
      }
      
      speed.x *= length;
      speed.y *= length;
      speed.z *= length;

      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }

    *p_way = cp_input.way;
  }
  

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂ薽߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Hitch( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    return this->GetOrderRollerDir_Stop( cp_input, p_way, p_speed, p_calc );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Wv߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Jump( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    // @todo ܂Wv߁B
    return this->GetOrderRollerDir_Stop( cp_input, p_way, p_speed, p_calc );
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ANZ߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_AcceleLow( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    // ҁ[ǂꍇ́A
    // 킹B
    if(p_speed){
      gfl::math::VEC3 speed;
      f32 length;

      m_pMoveModel->GetMoveSpeed( &speed );
      length = speed.Length();
      
      {
        speed = cp_input.way;
        speed.x *= length;
        speed.y *= length;
        speed.z *= length;

        *p_speed = speed;
      }
    }
    

    // ړXs[hɒ
    if( p_calc ){
      gfl::math::VEC3 add = cp_input.way;
      
      add.x *= static_cast<f32>(ACCELERATOR_NUM);
      add.y *= static_cast<f32>(ACCELERATOR_NUM);
      add.z *= static_cast<f32>(ACCELERATOR_NUM);

      *p_calc = add;
    }
    

    // L[͕̓B
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_AcceleHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    if( p_speed ){
      // ҁ[ǂꍇ́A
      // 킹B
      gfl::math::VEC3 speed;
      f32 length;

      m_pMoveModel->GetMoveSpeed( &speed );
      length = speed.Length();
      
      {
        speed = cp_input.way;
        speed.x *= length;
        speed.y *= length;
        speed.z *= length;
        *p_speed = speed;
      }
    }

    if(p_calc){
      // ړXs[hɒ
      gfl::math::VEC3 add = cp_input.way;
      
      add.x *= static_cast<f32>(ACCELERATOR_HIGH_NUM);
      add.y *= static_cast<f32>(ACCELERATOR_HIGH_NUM);
      add.z *= static_cast<f32>(ACCELERATOR_HIGH_NUM);
      *p_calc = add;
    }


    // L[͕̓B
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_Brake( const RequestInput& /*cp_input*/, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    
    // ړXs[hɒ
    gfl::math::VEC3 add;
    gfl::math::VEC3 way;

    m_pMoveModel->GetMoveSpeed( &add );
    if( p_speed ){
      *p_speed = add;
    }

    add.Normalize();
    way = add;
    
    add.x *= -static_cast<f32>(BRAKE_NUM);
    add.y *= -static_cast<f32>(BRAKE_NUM);
    add.z *= -static_cast<f32>(BRAKE_NUM);

    if( p_calc ){
      *p_calc = add;
    }

    // ړB
    *p_way = way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_BrakeHigh( const RequestInput& /*cp_input*/, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    // ړXs[hɒ
    gfl::math::VEC3 add;
    gfl::math::VEC3 way;

    m_pMoveModel->GetMoveSpeed( &add );
    if( p_speed ){
      *p_speed = add;
    }


    {

      add.Normalize();

      way = add;
      
      add.x *= -HIGH_BRAKE_NUM;
      add.y *= -HIGH_BRAKE_NUM;
      add.z *= -HIGH_BRAKE_NUM;

      if( p_calc ){
        *p_calc = add;
      }
      
      // ړB
      *p_way = way;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ړI߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_EndMove( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    gfl::math::VEC3 speed;

    m_pMoveModel->GetMoveSpeed( &speed );

    if( speed.Length() > 1.0f ){

      if( p_speed ){
        *p_speed = speed;
      }

      speed.Normalize();
    
      speed.x *= -static_cast<f32>(BRAKE_NUM);
      speed.y *= -static_cast<f32>(BRAKE_NUM);
      speed.z *= -static_cast<f32>(BRAKE_NUM);

      if( p_calc ){
        *p_calc = speed;
      }
      
      m_pMoveModel->GetDirDispWay( p_way );
      
    }else{

      // ~
      this->GetOrderRollerDir_Stop( cp_input, p_way, p_speed, p_calc );
    }
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  ^[Jn߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_FirstTurn( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    if( p_speed ){
      // isƔׂƁAΕɁA
      // ̊pxɍŏ́AB
      // Xs[hB
      // 㔼́AB
      gfl::math::VEC3 speed;
      gfl::math::VEC3 nrm;
      f32 length;
      gfl::math::MTX34 rot_mtx;
      f32 cos;
      
      m_pMoveModel->GetMoveSpeed(&speed); 
      length = speed.Length();
      speed.Normalize();

      length -= TURN_FIRST_DAMAGE;

      
      cos = speed.Dot(cp_input.way);

      // speedTURN_ROT Y]
      nrm.Cross( speed, cp_input.way );
      if( nrm.Length() ){
        nrm.Normalize();
      }else{
        nrm.Set(0, 1.0f, 0);
      }
      nrm.Set( -nrm.x, -nrm.y, -nrm.z );
      gfl::math::MTX34RotAxisFIdx( &rot_mtx, &nrm, gfl::math::AcosFIdx( cos ) / 2.0f );

      // ]
      gfl::math::VEC3Transform( &speed, &rot_mtx, &speed );
      speed.Normalize();

      
      speed.x *= length;
      speed.y *= length;
      speed.z *= length;

      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
    
    // L[͕̓B
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  }^[Jn߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_FirstTurnHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    if( p_speed ){
      // isƔׂƁAΕɁA
      // ̊pxɍŏ́AB
      // Xs[hB
      // 㔼́AB
      gfl::math::VEC3 speed;
      gfl::math::VEC3 nrm;
      f32 length;
      gfl::math::MTX34 rot_mtx;
      f32 cos;
      
      m_pMoveModel->GetMoveSpeed(&speed); 
      length = speed.Length();
      speed.Normalize();

      //length -= TURN_FIRST_DAMAGE;

      
      cos = speed.Dot(cp_input.way);

      // speedTURN_ROT Y]
      nrm.Cross( speed, cp_input.way );
      if( nrm.Length() ){
        nrm.Normalize();
      }else{
        nrm.Set(0, 1.0f, 0);
      }
      nrm.Set( -nrm.x, -nrm.y, -nrm.z );
      gfl::math::MTX34RotAxisFIdx( &rot_mtx, &nrm, gfl::math::AcosFIdx( cos ) / 4.0f );

      // ]
      gfl::math::VEC3Transform( &speed, &rot_mtx, &speed );
      speed.Normalize();

      
      speed.x *= length;
      speed.y *= length;
      speed.z *= length;
    
      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
    
    // L[͕̓B
    *p_way = cp_input.way;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  }^[߁@ړ@Xs[h@@擾
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::GetOrderRollerDir_TurnHigh( const RequestInput& cp_input, gfl::math::VEC3* p_way, gfl::math::VEC3* p_speed, gfl::math::VEC3* p_calc ) const
  {
    // Xs[hێ܂܁AŒpxςB
    gfl::math::VEC3 speed;
    gfl::math::VEC3 nrm;
    f32 length;
    f32 rot_length;
    gfl::math::MTX34 rot_mtx;
    f32 cos;
    u32 rot_num;
    
    m_pMoveModel->GetMoveSpeed(&speed); 
    length = speed.Length();
    speed.Normalize();

    // Xs[hAPɉ]łpxoB
    {
      if(length >= SPEED_MAX){
        rot_length = 0;
      }else if( length <= FULLTURN_SPEED_MIN ){
        rot_length = SPEED_MAX - FULLTURN_SPEED_MIN;
      }else {
        rot_length = SPEED_MAX - length;
      }

      rot_num = HIGHTURN_ROT_MIN + ((HIGHTURN_ROT_NUM * static_cast<u32>(rot_length)) / static_cast<u32>(SPEED_MAX - FULLTURN_SPEED_MIN));
        
    }

    
    cos = speed.Dot(cp_input.way);
    if( cos >= gfl::math::CosDeg( rot_num ) ){
      // ̕ɂႤB
      speed = cp_input.way;
    }else{

      // speedTURN_ROT Y]
      nrm.Cross( speed, cp_input.way );
      if( nrm.Length() ){
        nrm.Normalize();
      }else{
        nrm.Set(0, 1.0f, 0);
      }
      gfl::math::MTX34RotAxisFIdx( &rot_mtx, &nrm, GFL_MATH_DEG_TO_FIDX(rot_num) );

      // ]
      gfl::math::VEC3Transform( &speed, &rot_mtx, &speed );
      speed.Normalize();
    }

    if( length < SPEED_MAX ){
      length += TURN_ACCELE_NUM;
    }

    // ꂪɂȂB
    *p_way = speed;
    
    // Xs[h߂
    speed.x *= length;
    speed.y *= length;
    speed.z *= length;

    if(p_speed){
      *p_speed = speed;
    }

    if( p_calc ){
      p_calc->x = 0;
      p_calc->y = 0;
      p_calc->z = 0;
    }
  }





  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief    Jn
   *
   *  @param  order     I[_[
   *	@param	cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::InitMove( u32 order, const RequestInput& /*cp_input*/ )
  {

    // ړԂ̃NA
    this->OffMoveBit( MOVEBIT_STEP | MOVEBIT_DASH );

    // @I[_[ȂA
    // tOOFF
    if( order == MOVEORDER_WALK ){
      this->OffMoveBit( MOVEBIT_UNDER_OFF );
    }
      

  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  NGXgs鏈
   *
   *	@param	order     I[_[
   *	@param	cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMove( u32 order, const RequestInput& cp_input )
  {
    PlayerForm form;

    form = this->GetMoveForm();

    // tHƂ̓Jn
    switch( form )
    {
    case MOVE_FORM_NORMAL:     ///<s
      this->SetMoveNormal( order, cp_input );
      break;

    case MOVE_FORM_CYCLE:      ///<]ԏ
      this->SetMoveCycle( order, cp_input );
      break;

    case MOVE_FORM_ROLLER:     ///<ROLLERXP[g
      this->SetMoveRoller( order, cp_input );
      break;
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  Ԃł̃I[_[ݒ
   *
   *	@param	order     I[_[
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal( u32 order, const RequestInput& cp_input )
  {
    switch( order )
    {
    case MOVEORDER_STOP:    ///<~Zbg
      this->SetMoveNormal_Stop( cp_input );
      break;
    case MOVEORDER_WALK:    ///<Zbg
      this->SetMoveNormal_Walk( cp_input );
      break;
    case MOVEORDER_TURN:    ///<UZbg
      this->SetMoveNormal_Turn( cp_input );
      break;
    case MOVEORDER_HITCH:   ///<QqbgZbg
      this->SetMoveNormal_Hitch( cp_input );
      break;
    case MOVEORDER_JUMP:    ///<WvZbg
      this->SetMoveNormal_Jump( cp_input );
      break;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  RollerXP[gԂ̂ł̃I[_[ݒ
   *
   *	@param	order     I[_[
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller( u32 order, const RequestInput& cp_input )
  {
    switch( order )
    {
    case MOVEORDER_STOP:    ///<~Zbg
      this->SetMoveRoller_Stop( cp_input );
      break;
    case MOVEORDER_WALK:    ///<Zbg
      this->SetMoveRoller_Walk( cp_input );
      break;
    case MOVEORDER_TURN:    ///<UZbg
      this->SetMoveRoller_Turn( cp_input );
      break;
    case MOVEORDER_HITCH:   ///<QqbgZbg
      this->SetMoveRoller_Hitch( cp_input );
      break;
    case MOVEORDER_JUMP:    ///<WvZbg
      this->SetMoveRoller_Jump( cp_input );
      break;


    case MOVEORDER_ACCELE_LOW:     ///<
      this->SetMoveRoller_AcceleLow( cp_input );
      break;

    case MOVEORDER_ACCELE_HIGH:    ///<
      this->SetMoveRoller_AcceleHigh( cp_input );
      break;

    case MOVEORDER_BRAKE:          ///<
      this->SetMoveRoller_Brake( cp_input );
      break;

    case MOVEORDER_BRAKE_HIGH:
      this->SetMoveRoller_BrakeHigh( cp_input );
      break;

    case MOVEORDER_ENDMOVE:        ///<
      this->SetMoveRoller_EndMove( cp_input );
      break;
      
    case MOVEORDER_TURNFIRST:
      this->SetMoveRoller_FirstTurn( cp_input );
      break;

    case MOVEORDER_HIGHTURNFIRST:
      this->SetMoveRoller_FirstTurnHigh( cp_input );
      break;

    case MOVEORDER_HIGHTURN:
      this->SetMoveRoller_TurnHigh( cp_input );
      break;

    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@I[_[ݒ菈
   *
   *	@param	order     I[_[
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle( u32 order, const RequestInput& cp_input )
  {
    switch( order )
    {
    case MOVEORDER_STOP:    ///<~Zbg
      this->SetMoveCycle_Stop( cp_input );
      break;
    case MOVEORDER_WALK:    ///<Zbg
      this->SetMoveCycle_Walk( cp_input );
      break;
    case MOVEORDER_TURN:    ///<UZbg
      this->SetMoveCycle_Turn( cp_input );
      break;
    case MOVEORDER_HITCH:   ///<QqbgZbg
      this->SetMoveCycle_Hitch( cp_input );
      break;
    case MOVEORDER_JUMP:    ///<WvZbg
      this->SetMoveCycle_Jump( cp_input );
      break;
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ~
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal_Stop( const RequestInput& cp_input )
  {
    Dir dir;

    if( cp_input.dir == DIR_NOT ){
      dir = m_pMoveModel->GetDirDisp();
    }else{
      dir = cp_input.dir;
    }

    // dir̕ŁA~
    m_pMoveModel->SetAcmd( mmodel::AC_DIR, dir );

    // Ԃ̐ݒ
    this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  PXebv
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal_Walk( const RequestInput& cp_input )
  {
    mmodel::Acmd cmd;
    bool flat_check = true;

    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }


    // fobO`FbN
    if( cp_input.debug ){
      cmd = mmodel::AC_WALK_1F;
      flat_check = false;
    }
    else if( cp_input.dash ){
      cmd = mmodel::AC_WALK_4F;
      
      if( m_DebugWalkFastFlag )
      {
        cmd = mmodel::AC_WALK_3F;
      }

      // _bVrbgON
      this->OnMoveBit( MOVEBIT_DASH );
    }
    else{

      // ʏ͂WFړ 
      cmd = mmodel::AC_WALK_8F;
      
      if( m_DebugWalkFastFlag )
      {
        cmd = mmodel::AC_WALK_6F;
      }
    }


    if( flat_check ){

      // ⓹ǂœt[ύX
    }

    // ̃R}h擾
//    cmd = mmodel::ActionCmdManager::GetDirAcmd( cp_input.dir, cmd );
    
    
    //R}hs
    m_pMoveModel->SetAcmd( cmd, cp_input.dir );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  U
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal_Turn( const RequestInput& cp_input )
  {
    // ȂA~ɂB
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    m_pMoveModel->SetAcmd( mmodel::AC_STAY_WALK_4F, cp_input.dir );

    this->SetMoveValue( PLAYER_MOVE_VALUE_TURN );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂ薽
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal_Hitch( const RequestInput& cp_input )
  {
    // ȂA~ɂB
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    m_pMoveModel->SetAcmd( mmodel::AC_STAY_WALK_32F, cp_input.dir );

    this->SetMoveValue( PLAYER_MOVE_VALUE_HITCH );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Wv
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveNormal_Jump( const RequestInput& cp_input )
  {
    mmodel::Acmd cmd;
    
    // ȂA~ɂB
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    
    m_pMoveModel->SetAcmd( mmodel::AC_JUMP_2G_16F, cp_input.dir );
    
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@~
   *
   *	@param	cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle_Stop( const RequestInput& cp_input )
  {
    Dir dir;

    if( cp_input.dir == DIR_NOT ){
      dir = m_pMoveModel->GetDirDisp();
    }else{
      dir = cp_input.dir;
    }

    // dir̕ŁA~
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_STOP, dir );
    
    // Ԃ̐ݒ
    this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ]ԁ@ړ
   *
   *	@param	cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle_Walk( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderCycleDir( MOVEORDER_WALK, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );
    

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_MOVE, DIR_NOT );

    // L[͕̓B
    m_pMoveModel->SetDirDisp( way );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  U
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle_Turn( const RequestInput& cp_input )
  {
    this->SetMoveCycle_Walk( cp_input );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Ǖ
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle_Hitch( const RequestInput& cp_input )
  {
    gfl::math::VEC3 speed(0,0,0);
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(speed);
    
    // ً}~
    // ȂA~ɂB
    if( cp_input.dir == DIR_NOT ){
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    m_pMoveModel->SetAcmd( mmodel::AC_STAY_WALK_32F, cp_input.dir );

    this->SetMoveValue( PLAYER_MOVE_VALUE_HITCH );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Wv
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveCycle_Jump( const RequestInput& cp_input )
  {
    this->SetMoveCycle_Walk(cp_input);
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  Xgbv
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Stop( const RequestInput& cp_input )
  {
    Dir dir;

    if( cp_input.dir == DIR_NOT ){
      dir = m_pMoveModel->GetDirDisp();
    }else{
      dir = cp_input.dir;
    }

    // dir̕ŁA~
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_STOP, dir );
    
    // Ԃ̐ݒ
    this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ړ
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Walk( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    //this->GetOrderRollerDir( MOVEORDER_TURN, cp_input, &way, &speed, &calc );
    this->GetOrderRollerDir( MOVEORDER_WALK, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );
    

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_MOVE, DIR_NOT );

    // L[͕̓B
    m_pMoveModel->SetDirDisp( way );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  U
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Turn( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_TURN, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_TURN, DIR_NOT );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_TURN );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Ǖ
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Hitch( const RequestInput& cp_input )
  {
    gfl::math::VEC3 speed(0,0,0);
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(speed);
    
    // ً}~
    // ȂA~ɂB
    if( cp_input.dir == DIR_NOT ){
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    m_pMoveModel->SetAcmd( mmodel::AC_STAY_WALK_32F, cp_input.dir );

    this->SetMoveValue( PLAYER_MOVE_VALUE_HITCH );

  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Wv
   *
   *	@param  cp_input  ͏
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Jump( const RequestInput& /*cp_input*/ )
  {
    // Ԃ̐ݒ
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_AcceleLow( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_ACCELE_LOW, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );
    
    

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_ACCELERATOR_LOW, DIR_NOT );

    // BRAKÊȂt[
    m_RollerBreakCount = ACCELE_AFTER_BRAKE_COUNT;

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_AcceleHigh( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    
    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_ACCELE_HIGH, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // BRAKÊȂt[
    m_RollerBreakCount = ACCELE_AFTER_BRAKE_COUNT;
    

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_ACCELERATOR_HIGH, DIR_NOT );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_Brake( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_BRAKE, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );
    

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_BRAKE, DIR_NOT );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  }BRAKE
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_BrakeHigh( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    
    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_BRAKE_HIGH, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_BRAKE_HIGH, DIR_NOT );


    // 쒆
    this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  I܂ł̓B
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_EndMove( const RequestInput& cp_input )
  {
    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_ENDMOVE, cp_input, &way, &speed, &calc );

    if( speed.Length() > 1.0f ){

      m_pMoveModel->SetMoveSpeed(speed);
      m_pMoveModel->SetCalcSpeed(calc);
      m_pMoveModel->SetDirDisp( way );
      
      // ړR}h
      //R}hs
      m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_BRAKE, DIR_NOT );

      // 쒆 
      this->SetMoveValue( PLAYER_MOVE_VALUE_WALK );

    }else{

      speed.Set(0,0,0);
      m_pMoveModel->SetMoveSpeed( speed );

      // ~
      this->SetMoveRoller_Stop( cp_input );
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ^[Jn
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_FirstTurn( const RequestInput& cp_input )
  {
    // ̓
    // L[͕̍A
    // ^[Jn̈ړ߂B



    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_TURNFIRST, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_TURN, DIR_NOT );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_TURN );

  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ^[Jn  HIGHTURN
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_FirstTurnHigh( const RequestInput& cp_input )
  {
    // ̓
    // L[͕̍A
    // ^[Jn̈ړ߂B

    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }


    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_HIGHTURNFIRST, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_TURN, DIR_NOT );

    // @ŁAEAɂ߂B
    gfl::math::VEC3 now_way;
    gfl::math::VEC3 nrm;

    m_pMoveModel->GetMoveSpeed(&now_way); 
    now_way.Normalize();
    nrm.Cross( now_way, cp_input.way );
    
    if( nrm.y < 0 ){
      m_pMoveModel->SetDrawStatus( mmodel::DRAWSTA_ROLLER_TURN_HIGH_L ); 
    }else{
      m_pMoveModel->SetDrawStatus( mmodel::DRAWSTA_ROLLER_TURN_HIGH_R );
    }

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_HIGHTURN );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  HIGHTURN  
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::SetMoveRoller_TurnHigh( const RequestInput& cp_input )
  {
    if( cp_input.dir == DIR_NOT ){
      GFL_ASSERT( cp_input.dir != DIR_NOT );
      this->SetMoveValue( PLAYER_MOVE_VALUE_STOP );
      return ;
    }
    

    // ړXs[hAlA`擾
    gfl::math::VEC3 way;
    gfl::math::VEC3 speed;
    gfl::math::VEC3 calc;
    this->GetOrderRollerDir( MOVEORDER_HIGHTURN, cp_input, &way, &speed, &calc );
    m_pMoveModel->SetMoveSpeed(speed);
    m_pMoveModel->SetCalcSpeed(calc);
    m_pMoveModel->SetDirDisp( way );

    // ړR}h
    //R}hs
    m_pMoveModel->SetAcmd( mmodel::AC_ANALOG_TURN, DIR_NOT );

    // 쒆 
    this->SetMoveValue( PLAYER_MOVE_VALUE_HIGHTURN );
  }



  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  Ԃ̍XV
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::updateMoveState( void )
  {
    
    PlayerMoveValue value = m_MoveValue;
    PlayerMoveState state = m_MoveState;
    
    m_MoveState = PLAYER_MOVE_STATE_OFF;
    
    if( m_pMoveModel->IsAcmdUse() == false ) //쒆
    {
      switch( value )
      {
      case PLAYER_MOVE_VALUE_STOP:
      case PLAYER_MOVE_VALUE_HITCH: ///<ǂ蒆
        break;

      case PLAYER_MOVE_VALUE_WALK:
      case PLAYER_MOVE_VALUE_HIGHTURN: ///<RollerXP[gHIGHTURN
        if( state == PLAYER_MOVE_STATE_OFF || state == PLAYER_MOVE_STATE_END )
        {
          m_MoveState = PLAYER_MOVE_STATE_START;
        }
        else
        {
          m_MoveState = PLAYER_MOVE_STATE_ON;
        }
        break;
      case PLAYER_MOVE_VALUE_TURN:
        if( (m_Form == MOVE_FORM_NORMAL) || (m_Form == MOVE_FORM_CYCLE) ){
          m_MoveState = PLAYER_MOVE_STATE_ON;
        }else{
          if( state == PLAYER_MOVE_STATE_OFF || state == PLAYER_MOVE_STATE_END )
          {
            m_MoveState = PLAYER_MOVE_STATE_START;
          }
          else
          {
            m_MoveState = PLAYER_MOVE_STATE_ON;
          }
        }
        break;

      }
    }
    
    if( m_pMoveModel->IsAcmdEnd() ) //I
    {
      switch( value )
      {
      case PLAYER_MOVE_VALUE_STOP:
      case PLAYER_MOVE_VALUE_HITCH: ///<ǂ蒆
        break;
      case PLAYER_MOVE_VALUE_WALK:
      case PLAYER_MOVE_VALUE_TURN:
      case PLAYER_MOVE_VALUE_HIGHTURN: ///<RollerXP[gHIGHTURN
        switch( state )
        {
        case PLAYER_MOVE_STATE_OFF:
          break;
        case PLAYER_MOVE_STATE_END:
          m_MoveState = PLAYER_MOVE_STATE_OFF;
          break;
        default:
          if( (m_Form == MOVE_FORM_NORMAL) || (m_Form == MOVE_FORM_CYCLE) ){
            m_MoveState = PLAYER_MOVE_STATE_END;
          }
          else {
            // [[XP[g̏ꍇB
            ++m_RollerMoveCount;
            
            if(m_RollerMoveCount >= ROLLER_STATE_UPDATE_COUNT){
              m_RollerMoveCount = 0;
              m_MoveState = PLAYER_MOVE_STATE_END;
            }else{
              m_MoveState = PLAYER_MOVE_STATE_OFF;
            }
          }
          break;
        }
        break;
      }
    }
  }



  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  tHύX鏈
   */
  //-----------------------------------------------------------------------------
  void PlayerGrid::updateFormRequest( void )
  {
    if( m_ChangeForm != MOVE_FORM_NON ){

      if(m_Form != m_ChangeForm){
        m_Form = m_ChangeForm;
      }
      m_ChangeForm = MOVE_FORM_NON;
    }
  }


  // ̍擾
  u32 PlayerGrid::getDirSub( Dir dir1, Dir dir2 )
  {
    static const u32 sc_DirSub[ DIR_MAX ][ DIR_MAX ] = 
    {
      // DIR_UP
      { 
        0,      ///<
        4,      ///<
        2,		  ///<
        2,		  ///<E
        1,		  ///<
        1,	    ///<E
        3,	    ///<
        3,      ///<E
      },
      // DIR_DOWN
      { 
        4,      ///<
        0,      ///<
        2,		  ///<
        2,		  ///<E
        3,		  ///<
        3,	    ///<E
        1,	    ///<
        1,      ///<E
      },
      // DIR_LEFT
      { 
        2,      ///<
        2,      ///<
        0,		  ///<
        4,		  ///<E
        1,		  ///<
        3,	    ///<E
        1,	    ///<
        3,      ///<E
      },
      // DIR_RIGHT
      { 
        2,      ///<
        2,      ///<
        4,		  ///<
        0,		  ///<E
        3,		  ///<
        1,	    ///<E
        3,	    ///<
        1,      ///<E
      },
      // DIR_LEFTUP
      { 
        1,      ///<
        3,      ///<
        1,		  ///<
        3,		  ///<E
        0,		  ///<
        2,	    ///<E
        2,	    ///<
        4,      ///<E
      },
      // DIR_RIGHTUP
      { 
        1,      ///<
        3,      ///<
        3,		  ///<
        1,		  ///<E
        2,		  ///<
        0,	    ///<E
        4,	    ///<
        2,      ///<E
      },
      // DIR_LEFTDOWN
      { 
        3,      ///<
        1,      ///<
        1,		  ///<
        3,		  ///<E
        2,		  ///<
        4,	    ///<E
        0,	    ///<
        2,      ///<E
      },
      // DIR_RIGHTDOWN
      { 
        3,      ///<
        1,      ///<
        3,		  ///<
        1,		  ///<E
        4,		  ///<
        2,	    ///<E
        2,	    ///<
        0,      ///<E
      },
    };

    if( dir1 >= DIR_MAX ){
      GFL_ASSERT(dir1 < DIR_MAX);
      dir1 = DIR_UP;
    }
    if( dir2 >= DIR_MAX ){
      GFL_ASSERT(dir2 < DIR_MAX);
      dir2 = DIR_UP;
    }

    return sc_DirSub[dir1][dir2];
  }

} // field
