//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		Move3DModelManager.h
 *	@brief  `惂f}l[W@@\[Xƃ[NǗ
 *	@author	tomoya takahashi
 *	@date		2011.05.16
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __MOVE3DMODELMANAGER_H__
#define __MOVE3DMODELMANAGER_H__

#include <gflib.h>

#include "FieldMoveModelTypes.h"
#include "Move3DModel.h"

#include "field/FieldMapper.h"
#include "field/FieldGraphics.h"


namespace field{
namespace mmodel{


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------
class Move3DModelManager
{
  GFL_FORBID_COPY_AND_ASSIGN(Move3DModelManager);

public:

  //-------------------------------------
  ///	VXe
  //=====================================
  enum SystemStatus
  {
    SYS_STATUS_IDL,     ///<ҋ@
    SYS_STATUS_MOVE,    ///<ғ
    SYS_STATUS_FINALIZE,///<폜
  };


  //-------------------------------------
  ///	\[Xǂݍݏ
  //=====================================
  enum LoadStatus
  {
    LOAD_STATUS_NONE,       // f[^͂܂B
    LOAD_STATUS_LOADREQ,    // ǂݍ݃NGXg
    LOAD_STATUS_LOADING,    // ǂݍݒłB
    LOAD_STATUS_LOADED,     // ǂݍݍς݂łB
    LOAD_STATUS_REMOVEREQ,  // jNGXg
    LOAD_STATUS_REMOVE,     // j
  };


  // `惂f[Np@q[vTCY
  // 3̂0x800gĂB32̒xoƍlA
  // 0x10000oCgB
  static const u32 HEAP_MOVE3DMODEL_SIZE = 0x10000;


public:

  // RXgN^
  Move3DModelManager( void );

  // fXgN^
  ~Move3DModelManager();

  
  //----------------------------------------------------------------------------
  /**
   *	@brief      
   *
   *	@param	  p_heap    q[v
   *	@param    p_device  foCXAP[^
   *	@param    work_max  [Nő吔
   *	@param    cp_mapper }bp[
   *	@param    p_graphics  `VXe
   */
  //-----------------------------------------------------------------------------
  void Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device, u32 work_max, const Mapper* cp_mapper, Graphics* p_graphics );

  //----------------------------------------------------------------------------
  /**
   *	@brief      jNGXg
   */
  //-----------------------------------------------------------------------------
  void FinalizeReq( void );

  //----------------------------------------------------------------------------
  /**
   *	@brief      j`FbN
   */
  //-----------------------------------------------------------------------------
  bool IsFinalize( void );


  //----------------------------------------------------------------------------
  /**
   *	@brief      `VXeXV
   */
  //-----------------------------------------------------------------------------
  void Update( void );

  //----------------------------------------------------------------------------
  /**
   *	@brief      IKAj[VXV
   */
  //-----------------------------------------------------------------------------
  void UpdateAnime( void );

  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNg\[X̓ǂݍ݊Jn
   *
   *	@param	IuWFNgR[h
   */
  //-----------------------------------------------------------------------------
  void LoadResource( ObjCode objcode );

  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNg\[X̔j
   *
   *	@param	IuWFNgR[h
   */
  //-----------------------------------------------------------------------------
  void RemoveResource( ObjCode objcode );

  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNg\[X̓ǂݍ݊`FbN
   *
   *	@param	IuWFNgR[h
   *
   *	@retval true    
   *	@retval false   ǂݍłȂAǂݍݒ
   */
  //-----------------------------------------------------------------------------
  bool IsLoaded( ObjCode objcode ) const;

  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNg\[X̓ǂݍݏԃ`FbN
   *
   *	@param	objcode IuWFNgR[h
   *
   *	@retval LOAD_STATUS_NONE,       // f[^͂܂B
   *	@retval LOAD_STATUS_LOADING,    // ǂݍݒłB
   *	@retval LOAD_STATUS_LOADED,     // ǂݍݍς݂łB
   */
  //-----------------------------------------------------------------------------
  LoadStatus GetLoadStatus( ObjCode objcode ) const;


  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNg
   *
   *	@param	objcode IuWFNgR[h
   *
   *	@retval f[N
   *	@retval NULL                  f\[X̓ǂݍݑ҂B
   */
  //-----------------------------------------------------------------------------
  Move3DModel* CreateModel( ObjCode objcode );

  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNgj
   *
   *	@param	objcode IuWFNgR[h
   *
   *	@retval f[N
   */
  //-----------------------------------------------------------------------------
  void DeleteModel( Move3DModel* p_model );


  //----------------------------------------------------------------------------
  /**
   *	@brief  IuWFNǧڕύX
   *
   *  @param  p_model f
   *	@param	objcode IuWFNgR[h
   */
  //-----------------------------------------------------------------------------
  void ChangeObjCode( Move3DModel* p_model, ObjCode objcode );


  //----------------------------------------------------------------------------
  /**
   *	@brief  f[Nő吔𓾂
   * 
   *	@retval f[Nő吔
   */
  //-----------------------------------------------------------------------------
  u32 GetWorkMax(void) const { return m_WorkMax; }

  //----------------------------------------------------------------------------
  /**
   *	@brief  f[N𓾂
   * 
   *  @param  index f[ÑCfbNX
   * 
   *	@retval f[N
   */
  //-----------------------------------------------------------------------------
  Move3DModel* GetWork(u32 index) const
  {
    if( index < m_WorkMax )
    {
      if( m_ppTbl )
      {
        return m_ppTbl[index];
      }
    }
    return NULL;
  }
    
  //-----------------------------------------------------------------------------
  /**
   *	@brief  `VXe擾
   *
   *	@retval  const Graphics* `VXe
   */
  //-----------------------------------------------------------------------------
  const Graphics* GetGraphics( void ) const {  return m_pGraphics; }


#if PM_DEBUG

  // SfONEOFF
  void DebugSetVisible( bool flag );
  
#endif
private:

  // ԏ
  void Clear( void );

  // [NXV
  void UpdateWork(void);
  void UpdateAnimeWork(void);

  // j
  void FinalizeWork(void);

  //----------------------------------------------------------------------------
  /**
   *	@brief  Ă郏[N̎擾
   *
   *	@return Ă郏[N
   */
  //-----------------------------------------------------------------------------
  Move3DModel* GetClearWork( void );
  


  // ǂݍ݊Ǘ
  void UpdateResource( void );    // \[XǂݍݍXV
  bool FinalizeResource( void );    // \[Xǂݍ݃LZ
  void LoadObjCodeResource( ObjCode objcode );
  void RemoveObjCodeResource( ObjCode objcode );

  
  

private:

  // Ǘ
  gfl::heap::HeapBase*      m_pHeap;
  gfl::heap::NwAllocator*   m_pAllocator;
  gfl::heap::HeapBase*      m_pMoveModelHeap;

  // VXe
  SystemStatus              m_SysStatus;    // VXe

  // n`
  const Mapper*             m_cpMapper;     // n`

  // `VXe
  Graphics*                 m_pGraphics;

  // A[JCut@C
  gfl::fs::ArcFile*         m_pArcFileMotion;   // [ṼA[JCut@C
  gfl::fs::ArcFile*         m_pArcFileGraphic;  // fÕA[JCut@C

  // \[X 
  void*                     m_pMotionBuffer[OBJCODE_MAX];     // [V\[Xf[^
  void*                     m_pGraphicBuffer[OBJCODE_MAX];    // OtBbN\[Xf[^
  gfl::grp::g3d::Resource   m_GraphicResource[OBJCODE_MAX];   // OtBbN\[Xwb_
  LoadStatus                m_LoadStatus[OBJCODE_MAX];        // ǂݍݏ
  LoadStatus                m_ReqStatus[OBJCODE_MAX];         // NGXg


  // f[N
  Move3DModel** m_ppTbl;
  u32           m_WorkMax;
};


} // mmodel
} // field

#endif	// __MOVE3DMODELMANAGER_H__

