//=================================================================================================
/**
 * @file ActionSelectBase.h
 * @brief 퓬 > sI > {`NX
 * @author obata_toshihiro
 * @date 2011.07.27
 */
//=================================================================================================
#ifndef __ACTIONSELECTBASE_H__
#define __ACTIONSELECTBASE_H__
#include <gflib.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;


  namespace app {

    class ActionSelectBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( ActionSelectBase );  // Rs[֎~

      public:

      //uobOvoruV[^[v
      enum BagButtonType {
        BAG_BUTTON_BAG,
        BAG_BUTTON_SHOOTER,
      };

      //uɂvoruǂv
      enum RunButtonType {
        RUN_BUTTON_RUN,
        RUN_BUTTON_RETURN,
      };

      // ݒ
      struct Setting {
        bool bag_button_enable;
        BagButtonType bag_button_type;
        RunButtonType run_button_type;
        const btl::BTL_PARTY* my_party;
        const btl::BTL_PARTY* en_party;
        u32 current_poke_index;
        u32 battle_poke_count;
        //-------------------------------
        Setting( void ) :
          bag_button_enable( false ), 
          bag_button_type( BAG_BUTTON_BAG ), 
          run_button_type( RUN_BUTTON_RUN ), 
          my_party( NULL ),
          en_party( NULL ),
          current_poke_index( 0 ) {}
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param settings          ݒ
       */
      //---------------------------------------------------------------------------------
      ActionSelectBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          const Setting& settings );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~ActionSelectBase();

      //---------------------------------------------------------------------------------
      /**
       * @brief AvP[V̊{
       */
      //---------------------------------------------------------------------------------
      virtual AppBase::InitResult Initialize( void );
      virtual void Update( void );
      virtual void ResetSequence( void );


      // I
      enum Result {
        RESULT_FIGHT,    //uvI
        RESULT_RUN,      //uɂvI
        RESULT_RETURN,   //uǂvI
        RESULT_POKEMON,  //u|PvI
        RESULT_BAG,      //uobOvI
        RESULT_SHOOTER,  //uV[^[vI
        RESULT_NULL,
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;





      protected:

      // I
      enum ButtonIndex {
        BUTTON_FIGHT,    //uv
        BUTTON_BAG,      //uobOvoruV[^[v
        BUTTON_POKEMON,  //u|Pv
        BUTTON_RUN,      //uɂvoruǂv
        BUTTON_NUM,      // 
        BUTTON_NULL,     // l
      };

      // og̃|Pő吔
      static const u32 MAX_BATTLE_MEMBER_COUNT = 3; 

      // ݒ擾
      const Setting& GetSetting( void ) const;

      // ݂̃J[\ʒu擾
      ButtonIndex GetCurrentCursorPos( void ) const;

      // ÕJ[\ʒu擾
      ButtonIndex GetPrevCursorPos( void ) const;




      private: 

      // V[PX
      enum Sequence {
        SEQ_WAIT_INPUT,            // ͑҂
        SEQ_WAIT_SELECT_ANIMATION, // Aj[V҂
        SEQ_FINISH,                // I
      }; 

      // J[\̈ړp^[
      enum CursorMovePattern {
        CURSOR_MOVE_PATTERN_FIGHT_TO_BAG,
        CURSOR_MOVE_PATTERN_FIGHT_TO_POKEMON,
        CURSOR_MOVE_PATTERN_NUM,
      }; 



      static const ::app::tool::CursorManager::MOVE_DATA 
        CURSOR_MOVE_DATA[ CURSOR_MOVE_PATTERN_NUM ][ BUTTON_NUM ];

      Setting m_settings;
      bool m_init_flag;
      ::app::tool::CursorManager* m_cursor_manager[ CURSOR_MOVE_PATTERN_NUM ];
      u32 m_cursor_move_pattern;
      Sequence m_seq;
      Sequence m_next_seq;
      Result m_result;


      void CreateCursorManager( void ); 
      void DeleteCursorManager( void );

      bool UpdateCursorMove( void );
      void ChangeCursorMovePattern( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
      Result GetResultFromSelectedButton( ButtonIndex selected_button_index ) const; 



      // hNXւ̈Ϗ
      virtual bool IsButtonHoldingByTouch( void ) const = 0;
      virtual bool IsButtonSelectedByTouch( void ) const = 0;
      virtual ButtonIndex GetSelectedButtonIndexByTouch( void ) const = 0;
      virtual void OnCursorMoved( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos ) = 0;
      virtual void OnButtonSelected( ButtonIndex button ) = 0;
      virtual bool IsSelectAnimationFinished( void ) const = 0;
    };

  }  // namespace app
}  // namespace btl


#endif // __ACTIONSELECTBASE_H__ 
