//=================================================================================================
/**
 * @file ActionSelectBase.cpp
 * @brief 퓬 > sI > {`NX
 * @author obata_toshihiro
 * @date 2011.07.27
 */
//=================================================================================================
#include <gflib.h>
#include <battle/btl_party.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppBase.h"
#include "ActionSelectBase.h"


namespace btl {
  namespace app {



    // J[\̈ړf[^
    const ::app::tool::CursorManager::MOVE_DATA ActionSelectBase::CURSOR_MOVE_DATA[ ActionSelectBase::CURSOR_MOVE_PATTERN_NUM ][ ActionSelectBase::BUTTON_NUM ] = 
    {
      /* CURSOR_MOVE_PATTERN_FIGHT_TO_BAG */
      {
        /*    id              up           down             left          right    */
        { BUTTON_FIGHT,   { BUTTON_FIGHT, BUTTON_BAG,     BUTTON_BAG, BUTTON_POKEMON } },
        { BUTTON_BAG,     { BUTTON_FIGHT, BUTTON_BAG,     BUTTON_BAG, BUTTON_RUN } },
        { BUTTON_POKEMON, { BUTTON_FIGHT, BUTTON_POKEMON, BUTTON_RUN, BUTTON_POKEMON } },
        { BUTTON_RUN,     { BUTTON_RUN,   BUTTON_RUN,     BUTTON_BAG, BUTTON_POKEMON } },
      },
      /* CURSOR_MOVE_PATTERN_FIGHT_TO_POKEMON */
      {
        /*    id              up           down             left          right    */
        { BUTTON_FIGHT,   { BUTTON_FIGHT, BUTTON_POKEMON, BUTTON_BAG, BUTTON_POKEMON } },
        { BUTTON_BAG,     { BUTTON_FIGHT, BUTTON_BAG,     BUTTON_BAG, BUTTON_RUN } },
        { BUTTON_POKEMON, { BUTTON_FIGHT, BUTTON_POKEMON, BUTTON_RUN, BUTTON_POKEMON } },
        { BUTTON_RUN,     { BUTTON_RUN,   BUTTON_RUN,     BUTTON_BAG, BUTTON_POKEMON } },
      },
    };




    //---------------------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------------------
    ActionSelectBase::ActionSelectBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        const Setting& settings ) :
      AppBase( app_heap, app_heap_size, device_heap, device_heap_size ),
      m_settings( settings ),
      m_init_flag( false ),
      m_cursor_manager(),
      m_cursor_move_pattern( CURSOR_MOVE_PATTERN_FIGHT_TO_BAG ),
      m_seq( SEQ_WAIT_INPUT ),
      m_next_seq( SEQ_WAIT_INPUT ),
      m_result( RESULT_NULL )
    {
      GFL_ASSERT( m_settings.my_party != NULL );
    } 

    //---------------------------------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------------------------------
    AppBase::InitResult ActionSelectBase::Initialize( void )
    {
      if( !m_init_flag ) {
        m_init_flag = true; 
        this->CreateCursorManager();
      }
      return AppBase::INIT_RESULT_FINISH;
    } 


    // J[\}l[W𐶐
    void ActionSelectBase::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      for( u32 i=0; i<CURSOR_MOVE_PATTERN_NUM; i++ ) {
        m_cursor_manager[i] = GFL_NEW( heap ) 
          ::app::tool::CursorManager( CURSOR_MOVE_DATA[i], BUTTON_NUM, heap, BUTTON_FIGHT );
      }
    }




    //---------------------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------------------
    ActionSelectBase::~ActionSelectBase()
    {
      this->DeleteCursorManager();
    } 

    // J[\}l[Wj
    void ActionSelectBase::DeleteCursorManager( void )
    {
      for( u32 i=0; i<CURSOR_MOVE_PATTERN_NUM; i++ ) {
        if( m_cursor_manager[i] ) {
          GFL_DELETE m_cursor_manager[i];
        }
      }
    }




    //---------------------------------------------------------------------------------------------
    // 󋵂Zbg
    //---------------------------------------------------------------------------------------------
    void ActionSelectBase::ResetSequence( void )
    {
      AppBase::ResetSequence();

      m_seq = SEQ_WAIT_INPUT;
      m_next_seq = SEQ_WAIT_INPUT;
      m_result = RESULT_NULL;
    } 






    //---------------------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------------------
    void ActionSelectBase::Update( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );


      switch( m_seq )
      {
      case SEQ_WAIT_INPUT:
        if( this->IsButtonSelectedByTouch() ) {
          ButtonIndex selected_button = this->GetSelectedButtonIndexByTouch();
          m_result = this->GetResultFromSelectedButton( selected_button );
          m_seq = SEQ_WAIT_SELECT_ANIMATION;
          m_next_seq = SEQ_FINISH;
        }
        else if( !this->IsButtonHoldingByTouch() )  { // {^^b`̓J[\ړȂ
          if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
            ButtonIndex cursor_pos = this->GetCurrentCursorPos();
            if( ( cursor_pos != BUTTON_BAG ) || ( m_settings.bag_button_enable != false ) ) {
              m_result = this->GetResultFromSelectedButton( cursor_pos );
              m_seq = SEQ_WAIT_SELECT_ANIMATION;
              m_next_seq = SEQ_FINISH;
              this->OnButtonSelected( cursor_pos );
            }
          }
          else {
            bool cursor_moved = this->UpdateCursorMove();
            if( cursor_moved ) {  // ړ
              ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
              ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
              this->ChangeCursorMovePattern( old_cursor_pos, new_cursor_pos );
              this->OnCursorMoved( old_cursor_pos, new_cursor_pos );
            }
          }
        }
        break;

      case SEQ_WAIT_SELECT_ANIMATION:
        {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectAnimationFinished() ) {
            m_seq = m_next_seq;
          }
        }
        break;

      case SEQ_FINISH:
        GFL_ASSERT( m_result != RESULT_NULL );
        this->Finish();
        break;
      }
    }


    // J[\̈ړp^[ύX
    void ActionSelectBase::ChangeCursorMovePattern( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos )
    {
      if( ( old_cursor_pos == BUTTON_BAG ) && ( new_cursor_pos == BUTTON_FIGHT ) ) { 
        m_cursor_move_pattern = CURSOR_MOVE_PATTERN_FIGHT_TO_BAG; //uobOvuvֈړ
      }
      else if( ( old_cursor_pos == BUTTON_POKEMON ) && ( new_cursor_pos == BUTTON_FIGHT ) ) { 
        m_cursor_move_pattern = CURSOR_MOVE_PATTERN_FIGHT_TO_POKEMON; //u|Pvuvֈړ
      }
    }


    // Iꂽ{^, ʂ擾
    ActionSelectBase::Result ActionSelectBase::GetResultFromSelectedButton( ButtonIndex selected_button_index ) const
    {
      Result result = RESULT_NULL;

      switch( selected_button_index )
      {
      case BUTTON_FIGHT:
        result = RESULT_FIGHT;
        break;

      case BUTTON_POKEMON:
        result = RESULT_POKEMON;
        break;

      case BUTTON_BAG:
        if( m_settings.bag_button_type == BAG_BUTTON_BAG ) {
          result = RESULT_BAG;
        }
        else {
          result = RESULT_SHOOTER;
        }
        break;

      case BUTTON_RUN:
        if( m_settings.current_poke_index == 0 ) {
          result = RESULT_RUN;
        }
        else {
          result = RESULT_RETURN;
        }
        break;
      }

      GFL_ASSERT( result != RESULT_NULL );
      return result;
    }



    // J[\̓XV
    bool ActionSelectBase::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager* cursor_manager = m_cursor_manager[ m_cursor_move_pattern ];
      ::app::tool::CursorManager::MOVE_RET move_result = cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    }

    //=============================================================================================
    // ݂̃J[\ʒu擾
    //=============================================================================================
    ActionSelectBase::ButtonIndex ActionSelectBase::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager[ m_cursor_move_pattern ]->GetPos() );
    }

    //=============================================================================================
    // ỖJ[\ʒu擾
    //=============================================================================================
    ActionSelectBase::ButtonIndex ActionSelectBase::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager[ m_cursor_move_pattern ]->GetOldPos() );
    }




    //=============================================================================================
    // ݒ擾
    //=============================================================================================
    const ActionSelectBase::Setting& ActionSelectBase::GetSetting( void ) const
    {
      return m_settings;
    }



  }  // namespace app
}  // namespace btl
