#ifndef __FIELDSTEREOCAMERA_H__
#define __FIELDSTEREOCAMERA_H__
//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldStereoCamera.h
 *	@brief  tB[hXeIJ
 *	@author	Koji Kawada
 *	@date		2011.07.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C
#include <nw/gfx.h>

// gflib
#include <gflib.h>

namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
///	tB[hXeIJNX
//=====================================
class FieldStereoCamera : public gfl::grp::g3d::StereoCamera
{
  GFL_FORBID_COPY_AND_ASSIGN(FieldStereoCamera);

public:
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  FieldStereoCamera(void)
    : gfl::grp::g3d::StereoCamera(),
      m_initial_rotate(0.0f, 0.0f, 0.0f),
      m_initial_target_pos(0.0f, 0.0f, 0.0f),
      m_initial_target_distance(DEFAULT_DISTANCE),
      m_initial_target_offset_y(0.0f),
      m_rotate(0.0f, 0.0f, 0.0f),
      m_target_pos(0.0f, 0.0f, 0.0f),
      m_target_distance(DEFAULT_DISTANCE),
      m_target_offset_y(0.0f)
  {
  }
  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~FieldStereoCamera()
  {
    Destroy();
  }
 
  //-----------------------------------------------------------------------------
  /*
   *  @brief        
   * 
   *  @param[in]    allocator          ɎgpAP[^[
   *  @param[in]    camera_position    J̈ʒuW
   *  @param[in]    target_position    J^[Qbg̍W
   *  @param[in]    near_clip          jANbv̒l
   *  @param[in]    far_clip           t@[Nbv̒l
   *  @param[in]    fovy_radian        FOVY̒l
   *  @param[in]    pivot_direction    ʂ̏
   *  @param[in]    w_scale            WScale̒l
   *  @param[in]    depth_level        x[XJʂ܂ł̋
   *  @param[in]    depth_range        ̕␳l
   *  @param[in]    real_switch        o߂Ɏp̕ύX(truêƂ)
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*          allocator,
      const gfl::math::VEC3&           camera_position   = CAMERA_POSITION_DEFAULT,
      const gfl::math::VEC3&           target_position   = TARGET_POSITION_DEFAULT,
      f32                              near_clip         = NEAR_CLIP_DEFAULT,
      f32                              far_clip          = FAR_CLIP_DEFAULT,
      f32                              fovy_radian       = FOVY_RADIAN_DEFAULT,
      f32                              w_scale           = 0.0f,
      f32                              depth_level       = NEAR_CLIP_DEFAULT + 5.0f,
      f32                              depth_range       = 1.0f,
      bool                             real_switch       = false
  );
  //-----------------------------------------------------------------------------
  /*
   *  @brief         j
   *                 ĂłvBfXgN^͌Ă΂܂B 
   */
  //-----------------------------------------------------------------------------
  virtual void Destroy(void);

  //-----------------------------------------------------------------------------
  /*
   *  @brief        J̈ʒuݒ肷
   *
   *  @param[in]    camera_position    J̈ʒu
   */
  //-----------------------------------------------------------------------------
  virtual void SetCameraPosition( const gfl::math::VEC3& camera_position );
  //-----------------------------------------------------------------------------
  /*
   *  @brief        J̒_̈ʒuݒ肷
   *
   *  @param[in]    target_position    J̒_̈ʒu
   */
  //-----------------------------------------------------------------------------
  virtual void SetTargetPosition( const gfl::math::VEC3& target_position );
  //-----------------------------------------------------------------------------
  /*
   *  @brief        J̈ʒuƒ_̈ʒuݒ肷
   *
   *  @param[in]    camera_position    J̈ʒu
   *  @param[in]    target_position    J̒_̈ʒu
   */
  //-----------------------------------------------------------------------------
  virtual void SetCameraAndTargetPosition( const gfl::math::VEC3& camera_position, const gfl::math::VEC3& target_position );

public:
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *                 Ă񂾃t[̑삪fBt[ĂׂΖt[\B
   *
   *  @param[in]     device_manager    foCX}l[W[
   *  @param[in]     target_position   J̒_̈ʒu
   */
  //-----------------------------------------------------------------------------
  void Control(const gfl::ui::DeviceManager* device_manager, const gfl::math::VEC3& target_position );
  void Control(const gfl::math::VEC3& target_position );

  //-----------------------------------------------------------------------------
  /*
   *  @brief         p[^o
   */
  //-----------------------------------------------------------------------------
  void PrintParameter(void) const;
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         p[^̎擾/ݒ
   */
  //-----------------------------------------------------------------------------
  void SetParameterRotate(const gfl::math::VEC3& rotate);
  void GetParameterRotate(gfl::math::VEC3* rotate) const;
  void SetParameterTargetPos(const gfl::math::VEC3& pos);
  void GetParameterTargetPos(gfl::math::VEC3* pos) const;
  void SetParameterTargetDistance(const f32 distance);
  f32  GetParameterTargetDistance(void) const;
  void SetParameterTargetOffsetY(const f32 y);
  f32  GetParameterTargetOffsetY(void) const;

private:
  //-----------------------------------------------------------------------------
  /*
   *  @brief        ݐݒ肳ĂJ̈ʒuƒ_̈ʒufobOJɔf
   */
  //-----------------------------------------------------------------------------
  void UpdateDebugCamera(void);

  //-----------------------------------------------------------------------------
  /*
   *  @brief        ݐݒ肳Ăp[^ŃfobOJXV
   */
  //-----------------------------------------------------------------------------
  void UpdateDebugCameraFromParameter(void);

private:
  static const f32 DOLLY_SPEED_BASE = 30.0f / 60.0f;
  static const f32 TUMBLE_SPEED     = 128.0f / 60.0f;
  static const f32 MOVE_SPEED_BASE  = 5.0f / 60.0f;
  static const f32 ROTATE_X_LIMIT   = 64.f - TUMBLE_SPEED;
  static const f32 DEFAULT_DISTANCE = 10.0f;
  static const f32 MIN_DISTANCE     = 0.01f;

private:
  gfl::math::VEC3    m_initial_rotate;
  gfl::math::VEC3    m_initial_target_pos;
  f32                m_initial_target_distance;
  f32                m_initial_target_offset_y;

  gfl::math::VEC3    m_rotate;
  gfl::math::VEC3    m_target_pos;
  f32                m_target_distance;
  f32                m_target_offset_y;
};

}  // namespace field

#endif // __FIELDSTEREOCAMERA_H__
