//=============================================================================
/**
 *
 *	@file		EventMMDLViewer.cpp
 *	@brief  샂fr[A[
 *	@author hosaka genya
 *	@data		2011.07.26
 *
 */
//=============================================================================

#include "EventMMDLViewer.h" 
#include "field/ZoneData.h"

GFL_NAMESPACE_BEGIN( field )

bool EventMMDLViewer::BootChk(gamesystem::GameManager* p_gman)
{ 
  GFL_UNUSED(p_gman);
  return true;
}

void EventMMDLViewer::InitFunc(gamesystem::GameManager* p_gman)
{
  GFL_UNUSED(p_gman);
}

gamesystem::GMEVENT_RESULT EventMMDLViewer::MainFunc(gamesystem::GameManager* p_gman)
{
  enum
  {
    SEQ_INIT,
    SEQ_MAIN,
    SEQ_END,
  };
  
  switch( m_Seq )
  {
  case SEQ_INIT:
    {
      gfl::math::VEC3 now_pos;
      mmodel::Manager* mng = p_gman->GetGameData()->GetFieldMoveModelManager();
      ZoneID zone_id = p_gman->GetFieldmap()->GetZoneID(); 

      p_gman->GetFieldmap()->GetControlPos( &now_pos );  
      
      mmodel::MoveModelHeader header = {
        1000,			      ///<ID    ][ƂɃIWiB
        mmodel::BIGMAN,	    ///<\OBJR[h ObjCode
        mmodel::MV_DIR_RND,	  ///<R[h        MvCode
        mmodel::EV_TYPE_NORMAL,	  ///<Cxg^Cv (Tuj  EventType
        0,	  ///<CxgtO
        0,	    ///<CxgID
        DIR_DOWN,					///<w          Dir
        0,		    ///<wp^ 0
        0,		    ///<wp^ 1
        0,		    ///<wp^ 2
        0,	///<Xړ
        0,	///<Zړ
        mmodel::POSTYPE_GRID,
        {
          94,           ///<ObhXW
          256,          ///<ObhZW
          0,            ///<YW
        },
      };
      header.pos_buf[0].gx = ( now_pos.x / GRID_SIZE ) + 2;
      header.pos_buf[0].gz = ( now_pos.z / GRID_SIZE );
      header.pos_buf[0].y = 0;//now_pos.y;

      m_MMDL = mng->CreateModel( &header, zone_id );
      GFL_ASSERT( m_MMDL );
      
    }
    m_Seq = SEQ_MAIN;
    break;
  case SEQ_MAIN:
    {
      const gfl::ui::Button* button = p_gman->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
      
      if( button->IsHold( gfl::ui::BUTTON_B ) )
      {
        m_Seq = SEQ_END;
      }
    }
    break;
  case SEQ_END:
    {
      mmodel::Manager* mng = p_gman->GetGameData()->GetFieldMoveModelManager();
      mng->DeleteModel( m_MMDL );
    }
    return gamesystem::GMEVENT_RES_FINISH;
  
  }

  return gamesystem::GMEVENT_RES_CONTINUE;
}
  
void EventMMDLViewer::EndFunc(gamesystem::GameManager* p_gman)
{
  GFL_UNUSED(p_gman);
}


GFL_NAMESPACE_END( field )
