//=================================================================================================
/**
 * @file LayoutUtil.cpp
 * @brief CAEg[eBeB֐Q
 * @author obata_toshihiro
 * @date 2011.07.26
 */
//=================================================================================================
#include <gflib.h>
#include "LayoutUtil.h"


namespace btl {
  namespace app {


    //---------------------------------------------------------------------------------------------
    // yC̉ԂύX
    //---------------------------------------------------------------------------------------------
    void LayoutUtil::SetPaneVisibility( 
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index, bool visibility )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layout_work->GetPane( pane_index ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetVisible( visibility );
      }
    }

    //---------------------------------------------------------------------------------------------
    // yC\
    //---------------------------------------------------------------------------------------------
    void LayoutUtil::SetPaneVisible(
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index )
    {
      SetPaneVisibility( layout_work, pane_index, true );
    }

    //---------------------------------------------------------------------------------------------
    // yC\ɂ
    //---------------------------------------------------------------------------------------------
    void LayoutUtil::SetPaneInvisible(
        gfl::grp::g2d::LytWk* layout_work, gfl::grp::g2d::LytPaneIndex pane_index )
    {
      SetPaneVisibility( layout_work, pane_index, false );
    }




    //---------------------------------------------------------------------------------------------
    // Aj[VJn
    //---------------------------------------------------------------------------------------------
    void LayoutUtil::StartAnimation( gfl::grp::g2d::LytWk* layout_work, u32 animation_index )
    {
      if( layout_work->IsBindAnime( animation_index ) == false ) {
        layout_work->BindAnime( animation_index );
      }
      layout_work->SetAutoAnime( animation_index, true );
      layout_work->SetAnimeFrame( animation_index, 0 );
    }

    //---------------------------------------------------------------------------------------------
    // Aj[V~
    //---------------------------------------------------------------------------------------------
    void LayoutUtil::StopAnimation( gfl::grp::g2d::LytWk* layout_work, u32 animation_index )
    {
      if( layout_work->IsBindAnime( animation_index ) ) {
        layout_work->UnBindAnime( animation_index );
      }
    }


  }  // namespace app
}  // namespace btl
