//=================================================================================================
/**
 * @file AppBase.h
 * @brief 퓬ʃAv̊{NX
 * @author obata_toshihiro
 * @date 2011.07.15
 */
//=================================================================================================
#ifndef __APPBASE_H__
#define __APPBASE_H__
#include <gflib.h>


namespace btl {
  namespace app {


    class AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( AppBase );  // Rs[֎~

      public:

      enum InitResult {
        INIT_RESULT_CONTINUE,  // p
        INIT_RESULT_FINISH,    // 
      };

      AppBase( 
          gfl::heap::HeapBase* parent_heap, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, u32 device_heap_size );
      virtual ~AppBase();
      virtual InitResult Initialize( void ) = 0;
      virtual void Reset( void ) = 0;
      virtual void Update( void ) = 0;
      virtual void Draw( void ) = 0;
      bool IsFinished( void ) const;

      protected:
      gfl::heap::HeapBase* GetHeap( void ) const;
      gfl::heap::HeapBase* GetDeviceHeap( void ) const;
      gfl::heap::NwAllocator* GetNwAllocator( void ) const;
      gfl::heap::NwAllocator* GetNwDeviceAllocator( void ) const;
      gfl::grp::GraphicsSystem* GetGraphicsSystem( void ) const;
      gfl::ui::DeviceManager* GetUiDeviceManager( void ) const;
      void Finish( void );

      private:
      void CreateHeap( 
          gfl::heap::HeapBase* parent_heap, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, u32 device_heap_size );
      void CreateNwAllocator( void );
      void DeleteHeap( void );
      void DeleteNwAllocator( void );
      gfl::heap::HeapBase* m_heap;
      gfl::heap::HeapBase* m_device_heap;
      gfl::heap::NwAllocator* m_nw_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;
      bool m_finish_flag;
    };


  } // namespace app 
} // namespace btl


#endif // __APPBASE_H__
