//=================================================================================================
/**
 * @file AppBase.cpp
 * @brief 퓬ʃAv̊{NX
 * @author obata_toshihiro
 * @date 2011.07.15
 */
//=================================================================================================
#include <gflib.h>
#include "AppBase.h"


namespace btl {
  namespace app {



    AppBase::AppBase( 
        gfl::heap::HeapBase* parent_heap, u32 app_heap_size, 
        gfl::heap::HeapBase* parent_device_heap, u32 device_heap_size ) :
      m_heap( NULL ),
      m_device_heap( NULL ),
      m_nw_allocator( NULL ),
      m_nw_device_allocator( NULL ),
      m_finish_flag( NULL )
    {
      this->CreateHeap( parent_heap, app_heap_size, parent_device_heap, device_heap_size );
      this->CreateNwAllocator();
    }

    void AppBase::CreateHeap( 
        gfl::heap::HeapBase* parent_heap, u32 app_heap_size, 
        gfl::heap::HeapBase* parent_device_heap, u32 device_heap_size )
    {
      GFL_ASSERT( !m_heap );
      if( !m_heap ) {
        m_heap = gfl::heap::Manager::CreateHeap( 
            parent_heap, HEAPID_BATTLE_APP, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }

      GFL_ASSERT( !m_device_heap );
      if( !m_device_heap ) {
        m_device_heap = gfl::heap::Manager::CreateHeap( 
            parent_device_heap, HEAPID_BATTLE_APP_DEVICE, device_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }
    }

    void AppBase::CreateNwAllocator( void )
    {
      GFL_ASSERT( !m_nw_allocator );
      if( !m_nw_allocator ) {
        m_nw_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_heap );
      }

      GFL_ASSERT( !m_nw_device_allocator );
      if( !m_nw_device_allocator ) {
        m_nw_device_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_device_heap );
      }
    }




    AppBase::~AppBase()
    {
      this->DeleteNwAllocator();
      this->DeleteHeap();
    }

    void AppBase::DeleteNwAllocator( void )
    {
      if( m_nw_allocator ) {
        GFL_DELETE m_nw_allocator;
        m_nw_allocator = NULL;
      }
      if( m_nw_device_allocator ) {
        GFL_DELETE m_nw_device_allocator;
        m_nw_device_allocator = NULL;
      }
    }

    void AppBase::DeleteHeap( void )
    {
      if( m_heap ) {
        gfl::heap::Manager::DeleteHeap( m_heap );
        m_heap = NULL;
      } 
      if( m_device_heap ) {
        gfl::heap::Manager::DeleteHeap( m_device_heap );
        m_device_heap = NULL;
      }
    }




    void AppBase::Reset( void )
    {
      m_finish_flag = false;
    }





    bool AppBase::IsFinished( void ) const
    {
      return m_finish_flag;
    } 

    void AppBase::Finish( void )
    {
      GFL_ASSERT( !m_finish_flag );
      m_finish_flag = true;
    }





    gfl::heap::HeapBase* AppBase::GetHeap( void ) const
    {
      return m_heap;
    }

    gfl::heap::HeapBase* AppBase::GetDeviceHeap( void ) const
    {
      return m_device_heap;
    }

    gfl::heap::NwAllocator* AppBase::GetNwAllocator( void ) const
    {
      return m_nw_allocator;
    }

    gfl::heap::NwAllocator* AppBase::GetNwDeviceAllocator( void ) const
    {
      return m_nw_device_allocator;
    } 

    gfl::grp::GraphicsSystem* AppBase::GetGraphicsSystem( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetGraphicsSystem();
    }

    gfl::ui::DeviceManager* AppBase::GetUiDeviceManager( void ) const
    {
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      return game_manager->GetUiDeviceManager();
    }



  } // namespace app 
} // namespace btl
