//=================================================================================================
/**
 * @file ActionSelect.h
 * @brief 퓬( sI )
 * @author obata_toshihiro
 * @date 2011.07.25
 */
//=================================================================================================
#ifndef __ACTIONSELECT_H__
#define __ACTIONSELECT_H__
#include <gflib.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;


  namespace app {

    class ActionSelect : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( ActionSelect );  // Rs[֎~

      public:

      //uobOvoruV[^[v
      enum BagButtonType {
        BAG_BUTTON_BAG,
        BAG_BUTTON_SHOOTER,
      };

      //uɂvoruǂv
      enum RunButtonType {
        RUN_BUTTON_RUN,
        RUN_BUTTON_RETURN,
      };

      enum Result {
        RESULT_FIGHT,    //uvI
        RESULT_RUN,      //uɂvI
        RESULT_RETURN,   //uǂvI
        RESULT_POKEMON,  //u|PvI
        RESULT_BAG,      //uobOvI
        RESULT_SHOOTER,  //uV[^[vI
        RESULT_NULL,
      };


      // ݒ
      struct Setting {
        BagButtonType bag_button_type;
        RunButtonType run_button_type;
        bool shooter_enable;
        const btl::BTL_PARTY* my_party;
        const btl::BTL_PARTY* en_party;
        u32 current_poke_index;
        u32 battle_poke_count;
        //-------------------------------
        Setting( void ) :
          bag_button_type( BAG_BUTTON_BAG ), 
          run_button_type( RUN_BUTTON_RUN ), 
          shooter_enable( false ), 
          my_party( NULL ),
          en_party( NULL ),
          current_poke_index( 0 ) {}
      };

      ActionSelect( 
          gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, const Setting& settings );
      ~ActionSelect();
      virtual AppBase::InitResult Initialize( void );
      virtual void Reset( void );
      virtual void Update( void );
      virtual void Draw( void );
      void GetResult( void ) const;


      private:

      // og̃|Pő吔
      static const u32 MAX_BATTLE_MEMBER_COUNT = 3;


      enum Sequence {
        SEQ_WAIT_INPUT,      // ͑҂
        SEQ_WAIT_ANIMATION,  // Aj[V҂
        SEQ_FINISH,          // I
      };


      enum ButtonIndex {
        BUTTON_FIGHT,    //uv
        BUTTON_BAG,      //uobOvoruV[^[v
        BUTTON_POKEMON,  //u|Pv
        BUTTON_RUN,      //uɂvoruǂv
        BUTTON_NUM,      // 
      };



      enum AnimationDataIndex {
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        ANIMATION_DATA_DUMMY_BALL_SICK,
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        ANIMATION_DATA_DUMMY_BALL_NULL,
        ANIMATION_DATA_DUMMY_POKEICON_ACTIVE,
        ANIMATION_DATA_DUMMY_POKEICON_PASSIVE,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_CURSOR_ON_FIGHT,
        ANIMATION_DATA_CURSOR_ON_BAG,
        ANIMATION_DATA_CURSOR_ON_POKEMON,
        ANIMATION_DATA_CURSOR_ON_RUN,
        ANIMATION_DATA_BUTTON_SWITCH_BAG,
        ANIMATION_DATA_BUTTON_SWITCH_SHOOTER,
        ANIMATION_DATA_BUTTON_SWITCH_RUN,
        ANIMATION_DATA_BUTTON_SWITCH_RETURN,
        ANIMATION_DATA_POKEICON_SINGLE,
        ANIMATION_DATA_POKEICON_DOUBLE,
        ANIMATION_DATA_POKEICON_TRIPLE,
        ANIMATION_DATA_NUM,
      };
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];

      enum AnimationIndex {
        ANIMATION_DUMMY_BALL_NORMAL,
        ANIMATION_DUMMY_BALL_SICK,
        ANIMATION_DUMMY_BALL_DEAD,
        ANIMATION_DUMMY_BALL_NULL,
        ANIMATION_DUMMY_POKEICON_ACTIVE,
        ANIMATION_DUMMY_POKEICON_PASSIVE,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BYTTON_RELEASE,
        ANIMATION_DUMMY_BYTTON_SELECT,
        ANIMATION_CURSOR_ON_FIGHT,
        ANIMATION_CURSOR_ON_BAG,
        ANIMATION_CURSOR_ON_POKEMON,
        ANIMATION_CURSOR_ON_RUN,
        ANIMATION_BUTTON_SWITCH_BAG,
        ANIMATION_BUTTON_SWITCH_SHOOTER,
        ANIMATION_BUTTON_SWITCH_RUN,
        ANIMATION_BUTTON_SWITCH_RETURN,
        ANIMATION_POKEICON_SINGLE,
        ANIMATION_POKEICON_DOUBLE,
        ANIMATION_POKEICON_TRIPLE,
        // ȉ, LAj[V
        ANIMATION_MYBALL00_NORMAL,  // ANIMATION_MYBALL00_NORMAL + ball_index
        ANIMATION_MYBALL00_SICK = ANIMATION_MYBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_MYBALL00_SICK + ball_index
        ANIMATION_MYBALL00_DEAD = ANIMATION_MYBALL00_SICK + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_MYBALL00_DEAD + ball_index
        ANIMATION_MYBALL00_NULL = ANIMATION_MYBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_MYBALL00_NULL + ball_index
        ANIMATION_ENBALL00_NORMAL = ANIMATION_MYBALL00_NULL + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_ENBALL00_NORMAL + ball_index
        ANIMATION_ENBALL00_SICK = ANIMATION_ENBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_ENBALL00_SICK + ball_index
        ANIMATION_ENBALL00_DEAD = ANIMATION_ENBALL00_SICK + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_ENBALL00_DEAD + ball_index
        ANIMATION_ENBALL00_NULL = ANIMATION_ENBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_ENBALL00_NULL + ball_index
        ANIMATION_POKEICON00_ACTIVE = ANIMATION_ENBALL00_NULL + pml::PokeParty::MAX_MEMBERS,  // ANIMATION_PIKEICON00_ACTIVE + poke_index
        ANIMATION_POKEICON00_PASSIVE = ANIMATION_POKEICON00_ACTIVE + MAX_BATTLE_MEMBER_COUNT,  // ANIMATION_PIKEICON00_PASSIVE + poke_index
        ANIMATION_BUTTON_HOLD = ANIMATION_POKEICON00_PASSIVE + MAX_BATTLE_MEMBER_COUNT,  // ANIMATION_BUTTON_HOLD + ButtonIndex
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + BUTTON_NUM,  // ANIMATION_BUTTON_RELEASE + ButtonIndex
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + BUTTON_NUM,  // ANIMATION_BUTTON_SELECT + ButtonIndex
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + BUTTON_NUM,  // 
        ANIMATION_NULL,  // l
      };

      enum ShareAnimationIndex {
        SHARE_ANIMATION_MYBALL_NORMAL,
        SHARE_ANIMATION_MYBALL_SICK,
        SHARE_ANIMATION_MYBALL_DEAD,
        SHARE_ANIMATION_MYBALL_NULL,
        SHARE_ANIMATION_ENBALL_NORMAL,
        SHARE_ANIMATION_ENBALL_SICK,
        SHARE_ANIMATION_ENBALL_DEAD,
        SHARE_ANIMATION_ENBALL_NULL,
        SHARE_ANIMATION_POKEICON_ACTIVE,
        SHARE_ANIMATION_POKEICON_PASSIVE,
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;
        AnimationDataIndex animation_data_index;
        u32 max_share_num;
        gfl::grp::g2d::LytPaneIndex share_group_index;
        gfl::grp::g2d::LytPaneIndex share_pane_index;
      };
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];


      struct ButtonDesc {
        gfl::grp::g2d::LytPaneIndex pane_index;
        AnimationIndex hold_animation_index;
        AnimationIndex release_animation_index;
        AnimationIndex select_animation_index;
      };
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];


      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const gfl::grp::g2d::LytSysSetUp LAYOUT_SYSTEM_SETUP;  // @todo ɔC
      static const gfl::grp::g2d::LytPaneIndex POKEICON_PANE[ MAX_BATTLE_MEMBER_COUNT ];
      gfl::grp::g2d::LytSys* m_layout_system;  // @todo ɔC
      gfl::grp::g2d::LytWk* m_layout_work;
      ::app::tool::ButtonManager* m_button_manager;
      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation;
      Setting m_settings;
      Result m_result;

      // ʂ̕\XV
      void UpdateBagButtonDisplay( void );
      void UpdateRunButtonDisplay( void );
      void UpdateMyBallDisplay( void );
      void UpdateEnemyBallDisplay( void );
      void UpdateAllPokeiconDisplay( void );
      void UpdatePokeiconDisplay( u32 poke_index );
      AnimationIndex GetMyBallAnimation( const btl::BTL_PARTY* btl_party, u32 poke_index ) const;
      AnimationIndex GetEnemyBallAnimation( const btl::BTL_PARTY* btl_party, u32 poke_index ) const;

      // Iꂽ{^, ʂ擾
      Result GetResultFromSelectedButton( ButtonIndex selected_button_index ) const;
    };

  }  // namespace app
}  // namespace btl


#endif // __ACTIONSELECT_H__
