//=================================================================================================
/**
 * @file ActionSelect.cpp
 * @brief 퓬( sI )
 * @author obata_toshihiro
 * @date 2011.07.25
 */
//=================================================================================================
#include <gflib.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <battle/btl_party.h>
#include "AppBase.h"
#include "ActionSelect.h"
#include "LayoutUtil.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include "action_select.h"
#include "action_select_pane.h"


namespace btl {
  namespace app {


    // CAEgVXẽZbgAbvf[^
    const gfl::grp::g2d::LytSysSetUp ActionSelect::LAYOUT_SYSTEM_SETUP = 
    {
      128, // Ǘ\[Xő吔
      10,  // ǗCAEg[Nő吔
    }; 


    // Aj[Vf[^
    const gfl::grp::g2d::LytArcIndex
      ActionSelect::ANIMATION_DATA_TABLE[ ActionSelect::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_DUMMY_BALL_NORMAL */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BALL_NORMAL_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_SICK */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BALL_SICK_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_DEAD */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BALL_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_NULL */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BALL_NULL_BCLAN,
      /* ANIMATION_DATA_DUMMY_POKEICON_ACTIVE */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_POKEICON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_DUMMY_POKEICON_PASSIVE */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_POKEICON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_ACTION_SELECT_ACTION_SELECT_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_FIGHT */ LYTRES_ACTION_SELECT_ACTION_SELECT_CURSOR_ON_FIGHT_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_BAG */ LYTRES_ACTION_SELECT_ACTION_SELECT_CURSOR_ON_BAG_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_POKEMON */ LYTRES_ACTION_SELECT_ACTION_SELECT_CURSOR_ON_POKEMON_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_RUN */ LYTRES_ACTION_SELECT_ACTION_SELECT_CURSOR_ON_RUN_BCLAN,
      /* ANIMATION_DATA_BUTTON_SWITCH_BAG */ LYTRES_ACTION_SELECT_ACTION_SELECT_BUTTON_SWITCH_BAG_BCLAN,
      /* ANIMATION_DATA_BUTTON_SWITCH_SHOOTER */ LYTRES_ACTION_SELECT_ACTION_SELECT_BUTTON_SWITCH_SHOOTER_BCLAN,
      /* ANIMATION_DATA_BUTTON_SWITCH_RUN */ LYTRES_ACTION_SELECT_ACTION_SELECT_BUTTON_SWITCH_RUN_BCLAN,
      /* ANIMATION_DATA_BUTTON_SWITCH_RETURN */ LYTRES_ACTION_SELECT_ACTION_SELECT_BUTTON_SWITCH_RETURN_BCLAN,
      /* ANIMATION_DATA_POKEICON_SINGLE */ LYTRES_ACTION_SELECT_ACTION_SELECT_POKEICON_SINGLE_BCLAN,
      /* ANIMATION_DATA_POKEICON_DOUBLE */ LYTRES_ACTION_SELECT_ACTION_SELECT_POKEICON_DOUBLE_BCLAN,
      /* ANIMATION_DATA_POKEICON_TRIPLE */ LYTRES_ACTION_SELECT_ACTION_SELECT_POKEICON_TRIPLE_BCLAN,
    };


    // LAj[V̐ݒ
    const ActionSelect::ShareAnimationDesc 
      ActionSelect::SHARE_ANIMATION_DESC[ ActionSelect::SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_MYBALL_NORMAL */
      {
        ANIMATION_MYBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_SICK */
      {
        ANIMATION_MYBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_DEAD */
      {
        ANIMATION_MYBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_NULL */
      {
        ANIMATION_MYBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NORMAL */
      {
        ANIMATION_ENBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_SICK */
      {
        ANIMATION_ENBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_DEAD */
      {
        ANIMATION_ENBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NULL */
      {
        ANIMATION_ENBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_ACTION_SELECT_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_POKEICON_ACTIVE */
      {
        ANIMATION_POKEICON00_ACTIVE, 
        ANIMATION_DATA_DUMMY_POKEICON_ACTIVE,
        MAX_BATTLE_MEMBER_COUNT,
        PANENAME_ACTION_SELECT_GROUP_POKEICON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_POKEICON_PASSIVE */
      {
        ANIMATION_POKEICON00_PASSIVE, 
        ANIMATION_DATA_DUMMY_POKEICON_PASSIVE,
        MAX_BATTLE_MEMBER_COUNT,
        PANENAME_ACTION_SELECT_GROUP_POKEICON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_HOLD */
      {
        ANIMATION_BUTTON_HOLD, 
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        BUTTON_NUM,
        PANENAME_ACTION_SELECT_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_RELEASE */
      {
        ANIMATION_BUTTON_RELEASE, 
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        BUTTON_NUM,
        PANENAME_ACTION_SELECT_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_SELECT */
      {
        ANIMATION_BUTTON_SELECT, 
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        BUTTON_NUM,
        PANENAME_ACTION_SELECT_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };



    // {^Ƃ̐ݒ
    const ActionSelect::ButtonDesc ActionSelect::BUTTON_DESC[ ActionSelect::BUTTON_NUM ] =
    {
      /* BUTTON_FIGHT */
      {
        PANENAME_ACTION_SELECT_PANE_FIGHT_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_FIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_FIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_FIGHT ),
      }, 
      /* BUTTON_BAG */
      {
        PANENAME_ACTION_SELECT_PANE_BAG_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_BAG ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_BAG ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_BAG ),
      }, 
      /* BUTTON_POKEMON */
      {
        PANENAME_ACTION_SELECT_PANE_POKE_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_POKEMON ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_POKEMON ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_POKEMON ),
      }, 
      /* BUTTON_RUN */
      {
        PANENAME_ACTION_SELECT_PANE_RUN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + BUTTON_RUN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + BUTTON_RUN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + BUTTON_RUN ),
      }, 
    };



    // |PACR̃yC
    const gfl::grp::g2d::LytPaneIndex ActionSelect::POKEICON_PANE[ ActionSelect::MAX_BATTLE_MEMBER_COUNT ] = 
    {
      PANENAME_ACTION_SELECT_PANE_POKEICON_00,
      PANENAME_ACTION_SELECT_PANE_POKEICON_01,
      PANENAME_ACTION_SELECT_PANE_POKEICON_02,
    };



    const u32 ActionSelect::APP_HEAPSIZE = 0x20000;
    const u32 ActionSelect::DEVICE_HEAPSIZE = 0x100000;
    //---------------------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------------------
    ActionSelect::ActionSelect( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, const Setting& settings ) :
      AppBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE ),
      m_layout_system( NULL ),
      m_layout_work( NULL ),
      m_button_manager( NULL ),
      m_seq( SEQ_WAIT_INPUT ),
      m_next_seq( SEQ_WAIT_INPUT ),
      m_wait_animation( ANIMATION_NULL ),
      m_settings( settings ),
      m_result( RESULT_NULL )
    {
      GFL_ASSERT( m_settings.my_party != NULL );
    }




    //---------------------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------------------
    ActionSelect::~ActionSelect()
    {
      GFL_DELETE m_layout_system;  // @todo ɔC

      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }

      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    } 





    //---------------------------------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------------------------------
    AppBase::InitResult ActionSelect::Initialize( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::HeapBase* device_heap = this->GetDeviceHeap();
      gfl::heap::NwAllocator* nw_allocator = this->GetNwAllocator();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager();
      
      graphics_system->InitializeApplicationMemory( nw_device_allocator );

      m_layout_system = GFL_NEW( heap ) gfl::grp::g2d::LytSys( 
          &LAYOUT_SYSTEM_SETUP, nw_allocator, nw_device_allocator );  // @todo ォ炤

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      gfl::grp::g2d::LytResID layout_resource_id = m_layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_action_select_LYTDAT );
      m_layout_system->TransferAllTexture( layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );
      m_layout_work = m_layout_system->CreateLytWk(
          layout_resource_id,
          LYTRES_ACTION_SELECT_ACTION_SELECT_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &gfl::grp::g2d::c_LytWkLowerDefaultSetUp,
          false );  // Aj[VoChȂ
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
      LayoutUtil::StartAnimation( m_layout_work, ANIMATION_CURSOR_ON_FIGHT );

      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM );
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        if( ( i == BUTTON_BAG ) &&
            ( m_settings.bag_button_type == BAG_BUTTON_SHOOTER ) &&
            ( m_settings.shooter_enable == false ) ) {  
          continue;  //uV[^[v̏ꍇ̓{^o^Ȃ
        }
        m_button_manager->AddButton( heap, i, m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation_index,
            BUTTON_DESC[i].release_animation_index,
            BUTTON_DESC[i].select_animation_index,
            NULL );  // R[obNȂ
      }

      this->UpdateBagButtonDisplay();
      this->UpdateRunButtonDisplay();
      this->UpdateMyBallDisplay();
      this->UpdateEnemyBallDisplay();
      this->UpdateAllPokeiconDisplay();

      return AppBase::INIT_RESULT_FINISH;
    }


    //uobOvuV[^[v̕\XV
    void ActionSelect::UpdateBagButtonDisplay( void )
    {
      //uV[^[voruobOv̐؂ւ
      if( m_settings.bag_button_type == BAG_BUTTON_BAG ) {
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_BAG );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_SHOOTER );
      }
      else {
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_BAG );
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_SHOOTER );
      }
      //uV[^[vgp\ǂ
      bool mask_visibility = 
        ( ( m_settings.shooter_enable == false ) && ( m_settings.bag_button_type == BAG_BUTTON_SHOOTER ) );
      LayoutUtil::SetPaneVisibility( 
          m_layout_work, PANENAME_ACTION_SELECT_PANE_BAG_BUTTON_MASK, mask_visibility );
    }


    //uɂvuǂv̕\XV
    void ActionSelect::UpdateRunButtonDisplay( void )
    {
      if( m_settings.run_button_type == RUN_BUTTON_RUN ) {
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_RUN );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_RETURN );
      }
      else {
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_RUN );
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_BUTTON_SWITCH_RETURN );
      }
    }


    // ̃{[̕\XV
    void ActionSelect::UpdateMyBallDisplay( void )
    {
      const btl::BTL_PARTY* btl_party = m_settings.my_party;
      if( btl_party ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          AnimationIndex animation_index = this->GetMyBallAnimation( btl_party, i );
          LayoutUtil::StartAnimation( m_layout_work, animation_index );
        }
      }
    }

    // ̃{[ɓKpAj[V擾
    ActionSelect::AnimationIndex ActionSelect::GetMyBallAnimation(
        const btl::BTL_PARTY* btl_party, u32 poke_index ) const
    {
      AnimationIndex animation_index = ANIMATION_NULL;
      u32 member_count = btl_party->GetMemberCount();
      if( member_count <= poke_index ) {
        animation_index = static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + poke_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( poke_index );
        if( btl_param->IsDead() ) {
          animation_index = static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + poke_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          animation_index = static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + poke_index );
        }
        else {
          animation_index = static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + poke_index );
        }
      }
      return animation_index;
    }


    // ̃{[̕\XV
    void ActionSelect::UpdateEnemyBallDisplay( void )
    {
      const btl::BTL_PARTY* btl_party = m_settings.en_party;
      if( btl_party ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          AnimationIndex animation_index = this->GetEnemyBallAnimation( btl_party, i );
          LayoutUtil::StartAnimation( m_layout_work, animation_index );
        }
      }
    }

    // ̃{[ɓKpAj[V擾
    ActionSelect::AnimationIndex ActionSelect::GetEnemyBallAnimation( 
        const btl::BTL_PARTY* btl_party, u32 poke_index ) const
    {
      AnimationIndex animation_index = ANIMATION_NULL;
      u32 member_count = btl_party->GetMemberCount();
      if( member_count <= poke_index ) {
        animation_index = static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + poke_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( poke_index );
        if( btl_param->IsDead() ) {
          animation_index = static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + poke_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          animation_index = static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + poke_index );
        }
        else {
          animation_index = static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + poke_index );
        }
      }
      return animation_index;
    }



    // SẴ|PACR̕\XV
    void ActionSelect::UpdateAllPokeiconDisplay( void )
    {
      // zu
      switch( m_settings.battle_poke_count ) {
      case 3:
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_POKEICON_TRIPLE );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_DOUBLE );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_SINGLE );
        break;
      case 2:
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_TRIPLE );
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_POKEICON_DOUBLE );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_SINGLE );
        break;
      default:
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_TRIPLE );
        LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON_DOUBLE );
        LayoutUtil::StartAnimation( m_layout_work, ANIMATION_POKEICON_SINGLE );
        break;
      }

      for( u32 i=0; i<MAX_BATTLE_MEMBER_COUNT; i++ ) {
        this->UpdatePokeiconDisplay(i);
      }
    }

    // w肵|PACR̕\XV
    void ActionSelect::UpdatePokeiconDisplay( u32 poke_index )
    {
      // \邩ǂ
      bool visibility = false;
      const btl::BTL_POKEPARAM* poke_param = m_settings.my_party->GetMemberDataConst( poke_index );
      if( ( 2 <= m_settings.battle_poke_count ) && 
          ( poke_index < m_settings.battle_poke_count ) &&
          ( !poke_param->IsDead() ) ) {
        visibility = true;
      }
      LayoutUtil::SetPaneVisibility( m_layout_work, POKEICON_PANE[ poke_index ], visibility );

      // Lǂ
      if( visibility ) {
        if( poke_index == m_settings.current_poke_index ) {
          LayoutUtil::StartAnimation( m_layout_work, ANIMATION_POKEICON00_ACTIVE + poke_index );
          LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON00_PASSIVE + poke_index ); 
        }
        else {
          LayoutUtil::StopAnimation( m_layout_work, ANIMATION_POKEICON00_ACTIVE + poke_index );
          LayoutUtil::StartAnimation( m_layout_work, ANIMATION_POKEICON00_PASSIVE + poke_index );
        }
      }
    }




    //---------------------------------------------------------------------------------------------
    // 󋵂Zbg
    //---------------------------------------------------------------------------------------------
    void ActionSelect::Reset( void )
    {
      m_seq = SEQ_WAIT_INPUT;
      m_next_seq = SEQ_WAIT_INPUT;
      m_result = RESULT_NULL;
      this->UpdateBagButtonDisplay();
      this->UpdateRunButtonDisplay();
      this->UpdateMyBallDisplay();
      this->UpdateEnemyBallDisplay();
      this->UpdateAllPokeiconDisplay();
    } 





    //---------------------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------------------
    void ActionSelect::Update( void )
    {
      m_layout_system->UpdateAll();
      u32 touched_button_id = m_button_manager->Update();

      switch( m_seq )
      {
      case SEQ_WAIT_INPUT:
        if( touched_button_id < BUTTON_NUM ) {
          m_seq = SEQ_WAIT_ANIMATION;
          m_next_seq = SEQ_FINISH;
          m_wait_animation = BUTTON_DESC[ touched_button_id ].select_animation_index;
          m_result = this->GetResultFromSelectedButton( static_cast<ButtonIndex>( touched_button_id ) );
        }
        break;

      case SEQ_WAIT_ANIMATION:
        GFL_ASSERT( m_wait_animation < ANIMATION_NUM );
        if( m_layout_work->IsAnimeEnd( m_wait_animation ) ) {
          m_seq = m_next_seq;
        }
        break;

      case SEQ_FINISH:
        GFL_ASSERT( m_result != RESULT_NULL );
        this->Finish();
        break;
      }
    }


    // Iꂽ{^, ʂ擾
    ActionSelect::Result 
      ActionSelect::GetResultFromSelectedButton( ButtonIndex selected_button_index ) const
    {
      Result result = RESULT_NULL;
      switch( selected_button_index ) {
      case BUTTON_FIGHT:
        result = RESULT_FIGHT;
        break;
      case BUTTON_POKEMON:
        result = RESULT_POKEMON;
        break;
      case BUTTON_BAG:
        result = RESULT_BAG; // @todo ʐMΐȂuV[^[v
        break;
      case BUTTON_RUN:
        result = RESULT_RUN; // @todo 2̖ڈȍ~Ȃuǂv
        break;
      default:
        GFL_ASSERT(0);
        break;
      }
      return result;
    }






    //---------------------------------------------------------------------------------------------
    // `揈
    //---------------------------------------------------------------------------------------------
    void ActionSelect::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_system->DrawAll( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }



  }  // namespace app
}  // namespace btl
