//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_config_ViewController.cpp
 *	@brief ݒʂ̕\ˑ̑NX
 *	@author	takada
 *	@date		2011.07.05
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <app/config/app_config_CoreData.h>
#include <app/config/app_config_LowerLayoutInformation.h>
#include <app/config/app_config_LowerDrawer.h>
#include <app/config/app_config_ViewController.h>

namespace app {
  namespace config {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    ViewController::ViewController( 
        gfl::heap::HeapBase* heap,
        const gfl::ui::DeviceManager* uiDeviceManager, 
        const CoreData* coreData, 
        const LowerDrawer* drawer ) :
      mUiDeviceManager( uiDeviceManager ),
      mTouchPanel( uiDeviceManager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD ) ),
      //mCrossKey( m_ui_device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD ) ),
      mLayoutWork( drawer->GetLayoutWork() ),
      mCoreData( coreData ),
      mDrawer( drawer ),
      mSettingsBasePositionTouchFlag( false ),
      mTouchedSettingsIndexByBasePosition( SETTINGS_NULL ),
      mRightArrowTouchFlag( false ),
      mLeftArrowTouchFlag( false ),
      mButtonManager( NULL )
    {
      mButtonManager = GFL_NEW( heap ) app::tool::ButtonManager( heap, uiDeviceManager, LowerLayout::BUTTON_NUM );

      for( u8 i=0; i<LowerLayout::BUTTON_NUM; i++ ) {
        mButtonManager->AddButton( 
            heap,
            i,
            const_cast<gfl::grp::g2d::LytWk*>( mLayoutWork ),            
            LowerLayout::buttonInfo[ i ].paneIndex,
            LowerLayout::buttonInfo[ i ].touchAnimeIndex,
            LowerLayout::buttonInfo[ i ].releaseAnimeIndex,
            LowerLayout::buttonInfo[ i ].selectAnimeIndex,
            NULL,
            this );
      }
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    ViewController::~ViewController()
    {
    }

    //------------------------------------------------------------------------------------
    // `nˑ̔XV
    //------------------------------------------------------------------------------------
    void ViewController::UpdateState( void )
    {
      app::tool::ButtonManager::ButtonId selectedButtonId = mButtonManager->Update();
      if( selectedButtonId != app::tool::ButtonManager::BUTTON_ID_NULL ){
        GFL_PRINT( "selectedButtonId = %d\n", selectedButtonId );
      }

      this->UpdateTouchState_Setting();
      this->UpdateTouchState_LeftArrow( selectedButtonId );
      this->UpdateTouchState_RightArrow( selectedButtonId );
    }

    // ݒ荀ڂ̃^b`XV
    void ViewController::UpdateTouchState_Setting( void )
    {
      if( !mLayoutWork->IsHitCheckOK() ) {  // x`悵Ȃƃ`FbNs
        return;
      }
      u16 touchX = mTouchPanel->GetX();
      u16 touchY = mTouchPanel->GetY();

      mSettingsBasePositionTouchFlag = false;
      //mTouchedSettingsIndexByBasePosition = SETTINGS_NULL;

      for( u8 i = 0; i < SETTINGS_NUM; i++ ) {
        gfl::grp::g2d::LytPaneIndex touchedPaneIndex = mLayoutWork->GetHitPaneIndexGroup( LowerLayout::information.groupIndexOfSettings[ i ], touchX, touchY, false );

        if( touchedPaneIndex != gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR ) {
          mSettingsBasePositionTouchFlag = true;

          mTouchedSettingsIndexByBasePosition = static_cast< Settings >( i );
        }
      }
    }

    void ViewController::UpdateTouchState_LeftArrow( app::tool::ButtonManager::ButtonId selectedButtonId )
    {
      if( LowerLayout::LEFTARROW01 <= selectedButtonId &&
          selectedButtonId <= LowerLayout::LEFTARROW08 )
      {
        mLeftArrowTouchFlag = true;
      }
      else
      {
        mLeftArrowTouchFlag = false;
      }
    }

    void ViewController::UpdateTouchState_RightArrow( app::tool::ButtonManager::ButtonId selectedButtonId )
    {
      if( LowerLayout::RIGHTARROW01 <= selectedButtonId &&
          selectedButtonId <= LowerLayout::RIGHTARROW08 )
      {
        mRightArrowTouchFlag = true;
      }
      else
      {
        mRightArrowTouchFlag = false;
      }
    }

    //------------------------------------------------------------------------------------
    // ݒ荀ڂ̒ʒu^b`Ă邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsSettingsBasePositionTouch( void ) const
    {
      return mSettingsBasePositionTouchFlag;
    }

    //------------------------------------------------------------------------------------
    // ʒu^b`Ăݒ荀ڂ̃CfbNX擾
    //------------------------------------------------------------------------------------
    Settings ViewController::GetTouchedSettingsIndexByBasePosition( void ) const
    {
      return mTouchedSettingsIndexByBasePosition;
    }

    // E󂪃^b`Ă邩ǂ𒲂ׂ
    bool ViewController::IsRightArrowTouch( void ) const
    {
      return mRightArrowTouchFlag;
    }

    // 󂪃^b`Ă邩ǂ𒲂ׂ
    bool ViewController::IsLeftArrowTouch( void ) const
    {
      return mLeftArrowTouchFlag;
    }

    //------------------------------------------------------------------------------------
    // IڂJ[\͈͂̏ɂ邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsBeyondUpperLimitOfControlArea( Settings crtIdx ) const
    {
      gfl::math::VEC3 panePos; 
      gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      this->GetGlobalPositionOfPane( paneIndex, &panePos );

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 upperLimitY = areaPane->GetTranslate().y + ( areaSize.height / 2.0f );

      return ( upperLimitY < panePos.y );
    }


    //------------------------------------------------------------------------------------
    // IڂJ[\͈͂̉艺ɂ邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsBeyondLowerLimitOfControlArea( Settings crtIdx ) const
    {
      gfl::math::VEC3 panePos; 
      gfl::grp::g2d::LytPaneIndex paneIndex =  LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      this->GetGlobalPositionOfPane( paneIndex, &panePos );

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 lowerLimitY = areaPane->GetTranslate().y - ( areaSize.height / 2.0f ); 
      return ( panePos.y < lowerLimitY );
    }

    //------------------------------------------------------------------------------------
    /**
     * @brief IڂJ[\͈͂̍ŏ㕔ɂȂ悤ȃXN[lZo
     * @param ctrIdx  J[\͈͂̍ŏ㕔ɔzuݒ荀
     */
    //------------------------------------------------------------------------------------
    f32 ViewController::CalculateScrollValueAtUpperLimitOfControlArea( Settings crtIdx ) const
    { 
      gfl::grp::g2d::LytPaneIndex settingPaneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      gfl::grp::g2d::LytPane* settingPane = mLayoutWork->GetPane( settingPaneIndex ); 
      const gfl::math::VEC3& settingLocalPos = settingPane->GetTranslate();
      const nw::lyt::Size& settingSize = settingPane->GetSize(); 
      f32 settingHalfHeight = settingSize.height / 2.0f;

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 upperLimitY = areaPane->GetTranslate().y + ( areaSize.height / 2.0f );

      return upperLimitY - settingHalfHeight - settingLocalPos.y;
    } 


    //------------------------------------------------------------------------------------
    /**
     * @brief IڂJ[\͈͂̍ŉɂȂ悤ȃXN[lZo
     * @param ctrIdx  J[\͈͂̍ŉɔzuݒ荀
     */
    //------------------------------------------------------------------------------------
    f32 ViewController::CalculateScrollValueAtLowerLimitOfControlArea( Settings crtIdx ) const
    {
      gfl::grp::g2d::LytPaneIndex settingPaneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      gfl::grp::g2d::LytPane* settingPane = mLayoutWork->GetPane( settingPaneIndex ); 
      const gfl::math::VEC3& settingLocalPos = settingPane->GetTranslate();
      const nw::lyt::Size& settingSize = settingPane->GetSize(); 
      f32 settingHalfHeight = settingSize.height / 2.0f;

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 lowerLimitY = areaPane->GetTranslate().y - ( areaSize.height / 2.0f );

      return lowerLimitY + settingHalfHeight - settingLocalPos.y;
    }

    // yC̃[JW擾
    void ViewController::GetLocalPositionOfPane( gfl::grp::g2d::LytPaneIndex paneIndex, gfl::math::VEC3* buffer ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( paneIndex ); 
      *buffer = pane->GetTranslate();
    }


    // yC̃O[oW擾
    void ViewController::GetGlobalPositionOfPane( gfl::grp::g2d::LytPaneIndex paneIndex, gfl::math::VEC3* buffer ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( paneIndex ); 
      const gfl::math::MTX34& globalMatrix = pane->GetGlobalMtx();
      buffer->x = globalMatrix._03;
      buffer->y = globalMatrix._13;
      buffer->z = globalMatrix._23;
    }

  } // namespace config
} // namespace app
