//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_config_UpperDrawer.cpp
 *	@brief ݒʂ̏ʕ`NX
 *	@author takada
 *	@date		2011.07.06
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <message/msg_option.h>
#include <app/config/app_config_CoreData.h>
#include <app/config/app_config_UpperDrawer.h>
#include <app/config/app_config_UpperLayoutInformation.h>

namespace app {
  namespace config {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // CAEg[ÑZbgAbvp[^
    const gfl::grp::g2d::LytWkSetUp UpperDrawer::mLayoutWorkSetupParameter =
    {
      gfl::math::VEC3( 0, 0, 0 ),   // pos
      gfl::math::VEC2( 1, 1 ),     // scale
      gfl::math::VEC3( 0, 0, 0 ),   // rotate
      1,                        // priority
    };


    // ˉeϊp[^
    const gfl::grp::ProjectionParam UpperDrawer::mProjectionParameter =
    {
      gfl::grp::PROJECTION_ORTHO,
      { -200.0f, 200.0f, -120.0f, 120.0f },
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP,
    };


    // r[ϊp[^
    const gfl::grp::ViewParam UpperDrawer::mViewParameter[ 2 ] = 
    {
      // ( ڗp )
      { 
        gfl::math::VEC3( 0, 0, 1 ),  // JW
        gfl::math::VEC3( 0, 1, 0 ),  // 
        gfl::math::VEC3( 0, 0, 0 ),  // ^[QbgW
      },
      // ( Eڗp )
      { 
        gfl::math::VEC3( 10, 0, 1),  // JW
        gfl::math::VEC3( 0, 1, 0 ),   // 
        gfl::math::VEC3( 10, 0, 0 ),  // ^[QbgW
      },
    }; 

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    UpperDrawer::UpperDrawer(
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* deviceHeapForTextureData,
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const void* layoutResourceData,
        gfl::str::MsgData* configMessageData,
        const app::config::CoreData* configCore ) : 
      Drawer( nwHeapAllocator, nwDeviceAllocator, graphicsSystem, layoutSystem, configCore ),
      mLayoutWork( NULL ),
      mUpperLayoutEnv( NULL ),
      mLowerLayoutEnv( NULL ),
      mConfigMessageData( configMessageData ),
      mDeviceHeapForTextureData( deviceHeapForTextureData ),
      mCurrentScene( CoreData::SCENE_NULL )
    {
      this->CreateLayoutWork( nwDeviceAllocator, layoutResourceData ); 
      
      this->CreateLayoutEnv( heap ); 
      this->SetupLayoutEnvForLayoutWork();

      this->SetupStaticStrings();
    }


    // CAEg[N𐶐
    void UpperDrawer::CreateLayoutWork( gfl::heap::NwAllocator* nwDeviceAllocator, const void* layoutResourceData )
    { 
      GFL_ASSERT( mLayoutWork == NULL );
      gfl::grp::g2d::LytSys* layoutSystem = this->LayoutSystem();
      mLayoutWork = UpperLayout::CreateLayoutWork( nwDeviceAllocator, layoutSystem, layoutResourceData, &mLayoutWorkSetupParameter );
      mLayoutWork->SetAutoDrawFlag( false ); 
    } 


    // CAEg[N̕`𐶐
    void UpperDrawer::CreateLayoutEnv(  gfl::heap::HeapBase* heap )
    { 
      GFL_ASSERT( mUpperLayoutEnv == NULL );
      mUpperLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env();
      mUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, mProjectionParameter, mViewParameter[ 0 ] );
      mUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, mProjectionParameter, mViewParameter[ 1 ] );

      GFL_ASSERT( mLowerLayoutEnv == NULL );
      mLowerLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env(); 
    }


    // CAEg[N̕`ݒ肷
    void UpperDrawer::SetupLayoutEnvForLayoutWork( void )
    {
      mLayoutWork->SetUserEnv( mUpperLayoutEnv, mLowerLayoutEnv );
    }


    // xݒ肵ύXȂZbgAbv
    void UpperDrawer::SetupStaticStrings( void )
    {
      /*
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_zukan_no_label, m_status_message_data, PARAM_ZUKAN_NO );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_mons_name_label, m_status_message_data, PARAM_NAME );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_type_label, m_status_message_data, PARAM_TYPE );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_oya_name_label, m_status_message_data, PARAM_OYA );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_id_no_label, m_status_message_data, PARAM_ID_NO );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_exp_label, m_status_message_data, PARAM_EXP );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_exp_for_levelup_label_01, m_status_message_data, PARAM_EXP_NEXT_01 );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_exp_for_levelup_label_02, m_status_message_data, PARAM_EXP_NEXT_02 );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_hp_label, m_status_message_data, PARAM_HP );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_atk_label, m_status_message_data, PARAM_ATK );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_def_label, m_status_message_data, PARAM_DEF );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_spatk_label, m_status_message_data, PARAM_SPATK );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_spdef_label, m_status_message_data, PARAM_SPDEF );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_agi_label, m_status_message_data, PARAM_AGI );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_tokusei_label, m_status_message_data, PARAM_TOKUSEI );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_waza_dmg_label, m_status_message_data, PARAM_WAZA_KIND );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_waza_atk_label, m_status_message_data, PARAM_WAZA_ATK );
      this->SetTextBoxPaneStringFromMessageData( m_layout_work, UpperLayout::information.pane_index_of_waza_hit_label, m_status_message_data, PARAM_WAZA_HIT );
      */
    }



    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    UpperDrawer::~UpperDrawer()
    {
      this->DeleteLayoutWork();
      this->DeleteLayoutEnv();
    }

    // CAEg[Nj
    void UpperDrawer::DeleteLayoutWork( void )
    {
      GFL_ASSERT( mLayoutWork ); 
      this->LayoutSystem()->RemoveLytWk( mLayoutWork ); 
    }

    // CAEg[N̕`j
    void UpperDrawer::DeleteLayoutEnv( void )
    {
      GFL_ASSERT( mUpperLayoutEnv );
      GFL_ASSERT( mLowerLayoutEnv );
      GFL_DELETE mUpperLayoutEnv;
      GFL_DELETE mLowerLayoutEnv; 
    } 
   
    //------------------------------------------------------------------------------------
    // vZX̂߂̍Œ̃ZbgAbv
    //------------------------------------------------------------------------------------
    void UpperDrawer::SetupForProcessStart( void )
    {
    }    

    //------------------------------------------------------------------------------------
    // \eXV
    //------------------------------------------------------------------------------------
    void UpperDrawer::UpdateView( void )
    {
      if( mCurrentScene < CoreData::SCENE_NUM ) {
        this->StopAnimation( UpperLayout::information.animation_index_of_scene_change_to[ mCurrentScene ] );
      }
      if( this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_UPPER, CoreData::DIRTY_BIT_SCENE ) ) {
        this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_UPPER, CoreData::DIRTY_BIT_SCENE );
        this->UpdateScene();
      }

      mLayoutWork->Update();
    } 


    // V[XV
    void UpperDrawer::UpdateScene( void )
    { 
      CoreData::SceneNo nextScene = this->CoreData()->GetScene();
      if( nextScene < CoreData::SCENE_NUM ) {
        this->StartAnimation( UpperLayout::information.animation_index_of_scene_change_to[ nextScene ] );
        mCurrentScene = nextScene;
      }
    }



    // Aj[VJn
    void UpperDrawer::StartAnimation( UpperLayout::AnimationIndex animationIndex )
    {
      if( animationIndex < UpperLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) == false ) {
          mLayoutWork->BindAnime( animationIndex );
        }
        mLayoutWork->SetAutoAnime( animationIndex, true );
        mLayoutWork->SetAnimeFrame( animationIndex, 0 );
      }
    }

    // Aj[V~
    void UpperDrawer::StopAnimation( UpperLayout::AnimationIndex animationIndex ) 
    {
      if( animationIndex < UpperLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) ) {
          mLayoutWork->UnBindAnime( animationIndex );
        }
      }
    }



    //------------------------------------------------------------------------------------
    // ʂ`悷
    //------------------------------------------------------------------------------------
    void UpperDrawer::Draw( void )
    {
      gfl::grp::RenderTarget* upperFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* rightFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      mLayoutWork->Draw( this->GraphicsSystem(), gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
    }

  } // namespace config
} // namespace app
