//========================================================================================
/**
 * @file app_config_LowerLayoutInformation.cpp
 * @brief ݒʂ̃CAEg
 * @author takada
 * @date 2011.07.06
 */
//======================================================================================== 
#include <app/config/config_layout_lower_pane.h>
#include <app/config/app_config_LowerLayoutInformation.h>


namespace app {
  namespace config {

    // CAEg
    const LowerLayout::Information LowerLayout::information = 
    {
      /* CAEgf[^̃CAEg\[XID */ LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_BCLYT, 

      PANENAME_CONFIG_LOWER_PANE_TITLE_BACK,
      PANENAME_CONFIG_LOWER_PANE_TITLE_WINDOW,
      PANENAME_CONFIG_LOWER_PANE_TITLE_TEXTBOX,

      {        
        {
          PANENAME_CONFIG_LOWER_PANE_SET01_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET01_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET01_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET01_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET01_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET01_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET01_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET02_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET02_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET02_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET02_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET02_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET02_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET02_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET03_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET03_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET03_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET03_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET03_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET03_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET03_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET04_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET04_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET04_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET04_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET04_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET04_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET04_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET05_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET05_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET05_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET05_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET05_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET05_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET05_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET06_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET06_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET06_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET06_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET06_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET06_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET06_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET07_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET07_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET07_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET07_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET07_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET07_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET07_TEXTBOX02,
        },

        {
          PANENAME_CONFIG_LOWER_PANE_SET08_BACK,
          PANENAME_CONFIG_LOWER_PANE_SET08_WINDOW01,
          PANENAME_CONFIG_LOWER_PANE_SET08_TEXTBOX01,
          PANENAME_CONFIG_LOWER_PANE_SET08_LEFTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET08_RIGHTARROW,
          PANENAME_CONFIG_LOWER_PANE_SET08_WINDOW02,
          PANENAME_CONFIG_LOWER_PANE_SET08_TEXTBOX02,
        },
      },

      PANENAME_CONFIG_LOWER_PANE_SCROLLROOT,

      PANENAME_CONFIG_LOWER_PANE_SLIDE_MIN,
      PANENAME_CONFIG_LOWER_PANE_SLIDE_MAX,

      PANENAME_CONFIG_LOWER_PANE_SLIDE_AREA,

      {
        PANENAME_CONFIG_LOWER_GROUP_SET01,
        PANENAME_CONFIG_LOWER_GROUP_SET02,
        PANENAME_CONFIG_LOWER_GROUP_SET03,
        PANENAME_CONFIG_LOWER_GROUP_SET04,
        PANENAME_CONFIG_LOWER_GROUP_SET05,
        PANENAME_CONFIG_LOWER_GROUP_SET06,
        PANENAME_CONFIG_LOWER_GROUP_SET07,
        PANENAME_CONFIG_LOWER_GROUP_SET08,
      },

      PANENAME_CONFIG_LOWER_GROUP_LEFTARROW,
      PANENAME_CONFIG_LOWER_GROUP_RIGHTARROW,

#if defined( BACK )
      PANENAME_CONFIG_LOWER_GROUP_BACK,
#endif

    };

    const gfl::grp::g2d::LytArcIndex LowerLayout::animDataIdTable[ LowerLayout::ANIMATION_DATA_NUM ] = 
    {
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_LEFTARROWTOUCHANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_LEFTARROWRELESEANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_LEFTARROWPASSIVEANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_LEFTARROWSELECTANIM_BCLAN,

      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_RIGHTARROWTOUCHANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_RIGHTARROWRELESEANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_RIGHTARROWPASSIVEANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_RIGHTARROWSELECTANIM_BCLAN,

#if defined( BACK )
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_BACKUNSELECTANIM_BCLAN,
      LYTRES_CONFIG_LAYOUT_LOWER_CONFIG_LOWER_BACKSELECTANIM_BCLAN,
#endif
    };

    /*
    for( s8 i=0; i<BUTTON_NUM; ++i )
    {
      mButtonInfo[i].xxxx;
    }
    */
    const LowerLayout::ButtonInfo LowerLayout::buttonInfo[ LowerLayout::BUTTON_NUM ]  = 
    {
      {
        PANENAME_CONFIG_LOWER_PANE_SET01_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW01_TOUCH,
        ANIMATIONINDEX_LEFTARROW01_RELEASE,
        ANIMATIONINDEX_LEFTARROW01_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET02_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW02_TOUCH,
        ANIMATIONINDEX_LEFTARROW02_RELEASE,
        ANIMATIONINDEX_LEFTARROW02_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET03_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW03_TOUCH,
        ANIMATIONINDEX_LEFTARROW03_RELEASE,
        ANIMATIONINDEX_LEFTARROW03_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET04_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW04_TOUCH,
        ANIMATIONINDEX_LEFTARROW04_RELEASE,
        ANIMATIONINDEX_LEFTARROW04_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET05_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW05_TOUCH,
        ANIMATIONINDEX_LEFTARROW05_RELEASE,
        ANIMATIONINDEX_LEFTARROW05_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET06_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW06_TOUCH,
        ANIMATIONINDEX_LEFTARROW06_RELEASE,
        ANIMATIONINDEX_LEFTARROW06_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET07_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW07_TOUCH,
        ANIMATIONINDEX_LEFTARROW07_RELEASE,
        ANIMATIONINDEX_LEFTARROW07_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET08_LEFTARROW,
        ANIMATIONINDEX_LEFTARROW08_TOUCH,
        ANIMATIONINDEX_LEFTARROW08_RELEASE,
        ANIMATIONINDEX_LEFTARROW08_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET01_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW01_TOUCH,
        ANIMATIONINDEX_RIGHTARROW01_RELEASE,
        ANIMATIONINDEX_RIGHTARROW01_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET02_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW02_TOUCH,
        ANIMATIONINDEX_RIGHTARROW02_RELEASE,
        ANIMATIONINDEX_RIGHTARROW02_SELECT,
      },

      {
        PANENAME_CONFIG_LOWER_PANE_SET03_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW03_TOUCH,
        ANIMATIONINDEX_RIGHTARROW03_RELEASE,
        ANIMATIONINDEX_RIGHTARROW03_SELECT,
      },
      
      {
        PANENAME_CONFIG_LOWER_PANE_SET04_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW04_TOUCH,
        ANIMATIONINDEX_RIGHTARROW04_RELEASE,
        ANIMATIONINDEX_RIGHTARROW04_SELECT,
      },
      
      {
        PANENAME_CONFIG_LOWER_PANE_SET05_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW05_TOUCH,
        ANIMATIONINDEX_RIGHTARROW05_RELEASE,
        ANIMATIONINDEX_RIGHTARROW05_SELECT,
      },
      
      {
        PANENAME_CONFIG_LOWER_PANE_SET06_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW06_TOUCH,
        ANIMATIONINDEX_RIGHTARROW06_RELEASE,
        ANIMATIONINDEX_RIGHTARROW06_SELECT,
      },
      
      {
        PANENAME_CONFIG_LOWER_PANE_SET07_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW07_TOUCH,
        ANIMATIONINDEX_RIGHTARROW07_RELEASE,
        ANIMATIONINDEX_RIGHTARROW07_SELECT,
      },
      
      {
        PANENAME_CONFIG_LOWER_PANE_SET08_RIGHTARROW,
        ANIMATIONINDEX_RIGHTARROW08_TOUCH,
        ANIMATIONINDEX_RIGHTARROW08_RELEASE,
        ANIMATIONINDEX_RIGHTARROW08_SELECT,
      },

    };

    const LowerLayout::BackAnimInfo LowerLayout::backAnimInfo =
    {
      {
        ANIMATIONINDEX_BACK01_UNSELECT,
        ANIMATIONINDEX_BACK02_UNSELECT,
        ANIMATIONINDEX_BACK03_UNSELECT,
        ANIMATIONINDEX_BACK04_UNSELECT,
        ANIMATIONINDEX_BACK05_UNSELECT,
        ANIMATIONINDEX_BACK06_UNSELECT,
        ANIMATIONINDEX_BACK07_UNSELECT,
        ANIMATIONINDEX_BACK08_UNSELECT,
      },

      {
        ANIMATIONINDEX_BACK01_SELECT,
        ANIMATIONINDEX_BACK02_SELECT,
        ANIMATIONINDEX_BACK03_SELECT,
        ANIMATIONINDEX_BACK04_SELECT,
        ANIMATIONINDEX_BACK05_SELECT,
        ANIMATIONINDEX_BACK06_SELECT,
        ANIMATIONINDEX_BACK07_SELECT,
        ANIMATIONINDEX_BACK08_SELECT,
      },
    };

    //------------------------------------------------------------------------------------
    // CAEg[N𐶐
    //------------------------------------------------------------------------------------
    gfl::grp::g2d::LytWk* LowerLayout::CreateLayoutWork( 
        gfl::heap::NwAllocator* device_allocator, gfl::grp::g2d::LytSys* layout_system, 
        const void* layout_resource_data, const gfl::grp::g2d::LytWkSetUp* layout_work_setup_data )
    {
      GFL_DEBUG_TICK_SETUP( tick, 11 );
      GFL_DEBUG_TICK_SET_FLAG( tick, true );

      GFL_DEBUG_TICK_START( tick, 0, "load resource" );
      gfl::grp::g2d::LytResID layout_resource_id = layout_system->LoadLytRes( device_allocator, layout_resource_data );
      layout_system->TransferAllTexture( layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );
      GFL_DEBUG_TICK_END( tick, 0 );

      GFL_DEBUG_TICK_START( tick, 1, "create lyt wk" );
      gfl::grp::g2d::LytWk* layout_work = layout_system->CreateLytWk(
          layout_resource_id, LowerLayout::information.layoutDataId,
          animDataIdTable, ANIMATION_DATA_NUM, ANIMATIONINDEX_NUM, 
          layout_work_setup_data, 
          false );  // Aj[VoChȂ

      u32 leftTouchNum = layout_work->CreateShareAnime( ANIMATIONINDEX_LEFTARROW01_TOUCH, 
          animDataIdTable[ ANIMATIONDATA_LEFTARROW_TOUCH ] );
      u32 leftReleaseNum = layout_work->CreateShareAnime( ANIMATIONINDEX_LEFTARROW01_RELEASE,
          animDataIdTable[ ANIMATIONDATA_LEFTARROW_RELEASE ] );
      u32 leftPassiveNum = layout_work->CreateShareAnime( ANIMATIONINDEX_LEFTARROW01_PASSIVE, 
          animDataIdTable[ ANIMATIONDATA_LEFTARROW_PASSIVE ] );
      u32 leftSelectNum = layout_work->CreateShareAnime( ANIMATIONINDEX_LEFTARROW01_SELECT, 
          animDataIdTable[ ANIMATIONDATA_LEFTARROW_SELECT ] );

      GFL_PRINT( "leftTouch = %d, leftRelease = %d, leftPassive = %d, leftSelect = %d\n",
          leftTouchNum, leftReleaseNum, leftPassiveNum, leftSelectNum );

      u32 touchNum = layout_work->CreateShareAnime( ANIMATIONINDEX_RIGHTARROW01_TOUCH, 
          animDataIdTable[ ANIMATIONDATA_RIGHTARROW_TOUCH ] );
      GFL_PRINT( "touch = %d\n", touchNum );
      u32 releaseNum = layout_work->CreateShareAnime( ANIMATIONINDEX_RIGHTARROW01_RELEASE,
          animDataIdTable[ ANIMATIONDATA_RIGHTARROW_RELEASE ] );
      GFL_PRINT( "release = %d\n", releaseNum );
      u32 passiveNum = layout_work->CreateShareAnime( ANIMATIONINDEX_RIGHTARROW01_PASSIVE, 
          animDataIdTable[ ANIMATIONDATA_RIGHTARROW_PASSIVE ] );
      GFL_PRINT( "passive = %d\n", passiveNum );
      u32 selectNum = layout_work->CreateShareAnime( ANIMATIONINDEX_RIGHTARROW01_SELECT, 
          animDataIdTable[ ANIMATIONDATA_RIGHTARROW_SELECT ] );
      GFL_PRINT( "select = %d\n", selectNum );

#if defined( BACK )
      layout_work->CreateShareAnime( ANIMATIONINDEX_BACK01_UNSELECT, 
          animDataIdTable[ ANIMATIONDATA_BACK_UNSELECT ] );
      u32 backNum = layout_work->CreateShareAnime( ANIMATIONINDEX_BACK01_SELECT, 
          animDataIdTable[ ANIMATIONDATA_BACK_SELECT ] );

      GFL_PRINT( "backAnimNum = %d\n", backNum );
#endif

      GFL_DEBUG_TICK_END( tick, 1 );

      return layout_work;
    }

  } // namespace config
} // namespace app
