//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_config_LowerDrawer.cpp
 *	@brief ݒʂ̉ʕ`NX
 *	@author	takada
 *	@date		2011.07.05
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <message/msg_option.h>
#include <message/message.gaix>
#include <app/config/app_config_LowerLayoutInformation.h>
#include <app/config/app_config_LowerDrawer.h>

namespace app {
  namespace config {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp LowerDrawer::mLayoutWorkSetupParameter =
    {
      gfl::math::VEC3( 0, -290, 0 ),   // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),      // rotate
      1,                           // priority
    };


    // ˉeϊp[^
    const gfl::grp::ProjectionParam LowerDrawer::mProjectionParameter =
    {
#if 1
      gfl::grp::PROJECTION_ORTHO,
      { -160.0f, 160.0f, -120.0f, 120.0f },
#else
      gfl::grp::PROJECTION_PERSPECTIVE,
      { 
        gfl::math::AtanRad( 120.0f / 100.0f ) * 2,   // zl0{ŕ\悤ɐݒ
        320.0f / 240.0f 
      },
#endif
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP,
    };


    // r[ϊp[^
    const gfl::grp::ViewParam LowerDrawer::mViewParameter = 
    {
      gfl::math::VEC3( 0, -290, 100 ),  // JW
      gfl::math::VEC3( 0, 1, 0 ),     // 
      gfl::math::VEC3( 0, -290, 0) ,  // ^[QbgW
    }; 

    // XN[o[̕\
    const LowerDrawer::ScrollBarParamter LowerDrawer::mScrollBarParameter = 
    { 
      /* [̒ */ 200.0f,
      /* x̍ől */ 1.0f, 
      /* x̍ŏl */ 0.0f, 
      /* x̃tF[hx */ 0.1f, 
      /* \xW */ 155, 
      /* \yW */ 15, 
    };

    // bZ[WEBhE̐ݒ
    const u32 LowerDrawer::MSGWIN_LINE_NUM = 2;
    const u32 LowerDrawer::MSGWIN_WAIT_FRAME = 3;

    // V[Ƃ̐ݒ
    const LowerDrawer::SceneSetting LowerDrawer::mSceneSettings[ CoreData::SCENE_NUM ] = 
    {
      /* ݒ */
      {
        /* XN[o[̍XVsǂ */ true,
        /* XN[o[`悷邩ǂ */ true,
      },
    };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap                          CX^X̐Ɏgpq[v
     * @param deviceHeapForTextureData      eNX`f[^̊mۂɎgpfoCXq[v
     * @param nwHeapAllocator               OtBbNXVXeŎgpAP[^
     * @param nwDeviceAllocator             OtBbNXVXeŎgpAP[^
     * @param graphicsSystem                `ɎgpOtBbNXVXe
     * @param layoutSystem                  `Ɏgp郌CAEgVXe
     * @param uiDeviceManager               bZ[WEBhE̐ɎgpUIfoCX
     * @param layoutReosurceData            CAEg\[X̃oCif[^
     * @param arcFile                       ݒʗp̃A[JCut@C
     * @param configMessageData             ݒʂ̃bZ[Wf[^
     * @param coreData                      `Ώۂ̃Xe[^XʃRAf[^
     */
    //--------------------------------------------------------------------------------
     LowerDrawer::LowerDrawer(
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* deviceHeapForTextureData,
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const gfl::ui::DeviceManager* uiDeviceManager,
        const void* layoutResourceData,
        gfl::str::MsgData* configMessageData,
        const app::config::CoreData* coreData ) :
      Drawer( nwHeapAllocator, nwDeviceAllocator, graphicsSystem, layoutSystem, coreData ),
      mLayoutWork( NULL ),
      mUpperLayoutEnv( NULL ),
      mLowerLayoutEnv( NULL ),
      mConfigMessageData( configMessageData ),
      mMessageWindow( NULL ),
      mDeviceHeapForTextureData( deviceHeapForTextureData ),
      mScrollBar( NULL ),
      mCurrentScene( CoreData::SCENE_NULL ),
      mScrollBarAlpha( 0.5f ),
      mSelectedSetting( SETTINGS_NULL )
    {
      this->CreateLayoutWork( nwDeviceAllocator, layoutResourceData );

      this->CreateLayoutEnv( heap ); 
      this->SetupLayoutEnvForLayoutWork();

      this->CreateMessageWindow( heap, uiDeviceManager );

      this->CreateScrollBar( heap );

      this->SetupStaticStrings();

      for( s8 i = 0; i < SETTINGS_NUM; ++i )
      {
        mSelectedOption[ i ] = NULL;
      }
    }

     // CAEg[N𐶐
    void LowerDrawer::CreateLayoutWork( gfl::heap::NwAllocator* nwDeviceAllocator, const void* layoutResourceData )
    { 
      GFL_ASSERT( mLayoutWork == NULL );
      mLayoutWork = LowerLayout::CreateLayoutWork( 
          nwDeviceAllocator, 
          this->LayoutSystem(), 
          layoutResourceData, 
          &mLayoutWorkSetupParameter );
      mLayoutWork->SetAutoDrawFlag( false );
    }


    // CAEg[N̕`𐶐
    void LowerDrawer::CreateLayoutEnv(  gfl::heap::HeapBase* heap )
    { 
      GFL_ASSERT( mUpperLayoutEnv == NULL );
      mUpperLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env();

      GFL_ASSERT( mLowerLayoutEnv == NULL );
      mLowerLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env(); 
      mLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, mProjectionParameter, mViewParameter );
      mLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, mProjectionParameter, mViewParameter );

      gfl::grp::FragmentOperationParam operationParam = gfl::grp::FragmentOperation::DefaultParam;
      operationParam.depth_test = true;
      operationParam.depth_func = gfl::grp::TEST_FUNC_LEQUAL;
      operationParam.frame_depth_read = true;
      operationParam.frame_depth_write = true;
      mLowerLayoutEnv->GetFragmentOperationPtr()->SetParam( operationParam );
    }


    // CAEg[N̕`ݒ肷
    void LowerDrawer::SetupLayoutEnvForLayoutWork( void )
    {
      mLayoutWork->SetUserEnv( mUpperLayoutEnv, mLowerLayoutEnv );
    }


    // bZ[WEBhE쐬
    void LowerDrawer::CreateMessageWindow( gfl::heap::HeapBase* heap, const gfl::ui::DeviceManager* uiDeviceManager )
    {
      GFL_ASSERT( mMessageWindow == NULL );
      GFL_ASSERT( mLayoutWork );
      mMessageWindow = GFL_NEW( heap ) print::MsgWin( uiDeviceManager, mLayoutWork, MSGWIN_LINE_NUM, MSGWIN_WAIT_FRAME, heap );
      //mMessageWindow->AddLinePaneIdx( LowerLayout::information.pane_index_of_message_line_1 );
      //mMessageWindow->AddLinePaneIdx( LowerLayout::information.pane_index_of_message_line_2 );
    }


    // XN[o[𐶐
    void LowerDrawer::CreateScrollBar( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mScrollBar == NULL );
      mScrollBar = GFL_NEW( heap ) app::tool::ScrollBar( heap, this->GraphicsSystem() );

      f32 railLen = mScrollBarParameter.railLength;
      f32 min = this->GetMinScrollValue();
      f32 max = this->GetMaxScrollValue();
      f32 range = max - min;
      f32 knobLen = railLen * ( 240.0f / range );  // @todo ʂ̍萔ɒu
      mScrollBar->SetDrawParam( gfl::grp::DISPLAY_LOWER, app::tool::ScrollBar::SCROLL_DIRECTION_VERTICAL, railLen, knobLen );
    }


    // sςȕݒ肷
    void LowerDrawer::SetupStaticStrings( void )
    {
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, LowerLayout::information.paneIndexOfTitleWindowLabel, mConfigMessageData, msg_option_title );

      // b̑
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_TALKING_SPEED ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_01 );
      
      // 퓬Aj
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_BATTLE_ANIMATION ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_02 );

      // ̃[
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_GAME_RULE ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_03 );

      // TEh
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_SOUND ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_04 );

      // [h
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_CHARACTER_MODE ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_05 );

      // CO̕
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_INTERNATIONAL_CHARACTERS ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_06 );

      // {^[h
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_BOTTON_MODE ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_07 );

      // IR̃|[g
      this->SetTextBoxPaneStringFromMessageData( mLayoutWork, 
          LowerLayout::information.settings[ SETTINGS_IR_REPORT ].paneIndexOfWindow1Label, 
          mConfigMessageData, 
          msg_option_08 );
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    LowerDrawer::~LowerDrawer()
    {
      this->DeleteMessageWindow();
      this->DeleteLayoutWork();
      this->DeleteLayoutEnv();
    } 


    // XN[o[j
    void LowerDrawer::DeleteScrollBar( void )
    {
      GFL_ASSERT( mScrollBar );
      GFL_DELETE mScrollBar;
    }


    // \EBhEj
    void LowerDrawer::DeleteMessageWindow( void )
    {
      GFL_ASSERT( mMessageWindow );
      GFL_DELETE mMessageWindow;
    }


    // CAEg[Nj
    void LowerDrawer::DeleteLayoutWork( void )
    {
      GFL_ASSERT( mLayoutWork );
      this->LayoutSystem()->RemoveLytWk( mLayoutWork );
    }


    // CAEg[N̕`j
    void LowerDrawer::DeleteLayoutEnv( void )
    {
      GFL_ASSERT( mUpperLayoutEnv );
      GFL_ASSERT( mLowerLayoutEnv );
      GFL_DELETE mUpperLayoutEnv;
      GFL_DELETE mLowerLayoutEnv; 
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief CAEg[N擾
     */
    //--------------------------------------------------------------------------------
    const gfl::grp::g2d::LytWk* LowerDrawer::GetLayoutWork( void ) const
    {
      return mLayoutWork;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief \EBhE擾
     */
    //--------------------------------------------------------------------------------
    print::MsgWin* LowerDrawer::GetMessageWindow( void )
    {
      return mMessageWindow;
    }

    //------------------------------------------------------------------------------------
    // XN[̏l擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetInitialScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMinPosition ); 
      return pane->GetTranslate().y;
    }
    
    //------------------------------------------------------------------------------------
    // XN[̍ŏl擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetMinScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMinPosition ); 
      return pane->GetTranslate().y;
    }

    //------------------------------------------------------------------------------------
    // XN[̍ől擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetMaxScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMaxPosition ); 
      return pane->GetTranslate().y;
    }

    //------------------------------------------------------------------------------------
    /**
     * @brefi vZX̂߂̍Œ̃ZbgAbv
     */
    //------------------------------------------------------------------------------------
    void LowerDrawer::SetupForProcessStart( void )
    {
      //this->UpdateScene(); // Zv[g̍W邽߂, V[XV
      //mLayoutWork->Update();
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief \eXV
     */
    //--------------------------------------------------------------------------------
    void LowerDrawer::UpdateView( void )
    { 
      CoreData::SceneNo currentScene = this->CoreData()->GetScene();
      if( mCurrentScene < CoreData::SCENE_NUM ) {
        //this->StopAnimation( LowerLayout::information.animation_index_of_scene_change_to[ mCurrentScene ] );
      } 
      if( this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCENE ) ) {
        this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCENE );
        this->UpdateScene();
      }

      if( mSceneSettings[ currentScene ].scrollbarUpdateEnable ) {
        this->UpdateScrollBarAlpha(); 
      }
 
      for( s8 i = 0; i < SETTINGS_NUM; ++i )
      {
        s8 index = this->CoreData()->GetCurrentSelectOption( i );

        // IAjo^
        if( index < mSelectedOption[ i ] )
        {
          s8 selectButtonIndex = static_cast<s8>( LowerLayout::LEFTARROW01 ) + i;

          if( ! ( mLayoutWork->IsBindAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex ) ) )
          {
            mLayoutWork->BindAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex );          
            mLayoutWork->SetAutoAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex, true );
          }
          else
          {
            mLayoutWork->SetAnimeFrame( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex, 0.0f );
          }
        }

        // EIAjo^
        else if( mSelectedOption[ i ] < index )
        {
          s8 selectButtonIndex = static_cast<s8>( LowerLayout::RIGHTARROW01 ) + i;

          if( ! ( mLayoutWork->IsBindAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex ) ) )
          {
            mLayoutWork->BindAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex );        
            mLayoutWork->SetAutoAnime( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex, true );
          }
          else
          {
            mLayoutWork->SetAnimeFrame( LowerLayout::buttonInfo[ selectButtonIndex ].selectAnimeIndex, 0.0f );
          }
        }
        
        // IXV
        this->SetTextBoxPaneStringFromMessageData( mLayoutWork,
            LowerLayout::information.settings[ i ].paneIndexOfWindow2Label,
            mConfigMessageData, 
            ( OPTIONS_MESSAGE_BASE_POSITION[ i ] + index ) );

        // ̑Iߋ̃mƂĕۑ
        mSelectedOption[ i ] = index;
      }

      // J[\Aj
      {
        Settings currentIndex = this->CoreData()->GetCurrentSelectSetting();
        
        if(  mSelectedSetting != SETTINGS_NULL && mSelectedSetting != currentIndex )
        {
          // ȎIڂ̃J[\IAj[V
          mLayoutWork->UnBindAnime( LowerLayout::backAnimInfo.selectAnimIndex[ mSelectedSetting ] );

          if( ! ( mLayoutWork->IsBindAnime( LowerLayout::backAnimInfo.unSelectAnimIndex[ mSelectedSetting ] ) ) )
          {
            // ȎIڂɃJ[\IAj[Vo^
            mLayoutWork->BindAnime( LowerLayout::backAnimInfo.unSelectAnimIndex[ mSelectedSetting ] );
            mLayoutWork->SetAnimeFrame( LowerLayout::backAnimInfo.unSelectAnimIndex[ mSelectedSetting ], 0.0f );          
            mLayoutWork->SetAutoAnime( LowerLayout::backAnimInfo.unSelectAnimIndex[ mSelectedSetting ], true );
          }
        }

        if( ! ( mLayoutWork->IsBindAnime( LowerLayout::backAnimInfo.selectAnimIndex[ currentIndex ] ) ) )
        {
          mLayoutWork->BindAnime( LowerLayout::backAnimInfo.selectAnimIndex[ currentIndex ] );
          mLayoutWork->SetAnimeFrame( LowerLayout::backAnimInfo.selectAnimIndex[ currentIndex ], 0.0f );          
          mLayoutWork->SetAutoAnime( LowerLayout::backAnimInfo.selectAnimIndex[ currentIndex ], true );
        }

        // ̑Iڂߋ̃mƂĕۑ
        mSelectedSetting = currentIndex;
      }

      // XN[lɈˑĈړyCBRootyC̈ʒuXV
      gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollRoot );
      gfl::math::VEC3 pos = pane->GetTranslate();
      pos.y = this->CoreData()->GetScrollValue();
      pane->SetTranslate( pos );
      
      mLayoutWork->Update();
    } 


    // V[XV
    void LowerDrawer::UpdateScene( void )
    { 
      CoreData::SceneNo nextScene = this->CoreData()->GetScene();
      if( nextScene < CoreData::SCENE_NUM ) {
        //this->StartAnimation( LowerLayout::information.animation_index_of_scene_change_to[ nextScene ] );
        mCurrentScene = nextScene;
      }
    }

#if 0
    // Aj[VJn
    void LowerDrawer::StartAnimation( LowerLayout::AnimationIndex animationIndex )
    {
      /*
      if( animationIndex < LowerLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) == false ) {
          mLayoutWork->BindAnime( animationIndex );
        }
        mLayoutWork->SetAutoAnime( animationIndex, true );
        mLayoutWork->SetAnimeFrame( animationIndex, 0 );
      }
      */
    }

    // Aj[V~
    void LowerDrawer::StopAnimation( LowerLayout::AnimationIndex animationIndex ) 
    {
      /*
      if( animationIndex < LowerLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) ) {
          mLayoutWork->UnBindAnime( animationIndex );
        }
      }
      */
    }
#endif

    // XN[o[̃At@lXV
    void LowerDrawer::UpdateScrollBarAlpha( void )
    {
      /*
      bool scrollBarIsUpdated = this->RibbonData()->IsDirty( RibbonData::DIRTY_FLAG_FOR_LOWER, RibbonData::DIRTY_BIT_SCROLL_VALUE );
      this->RibbonData()->RemoveDirtyBit( RibbonData::DIRTY_FLAG_FOR_LOWER, RibbonData::DIRTY_BIT_SCROLL_VALUE );

      if( scrollBarIsUpdated ) {
        mScrollBarAlpha += mScrollBarParameter.fadeSpeed;
        if( mScrollBarParameter.fadeMax < mScrollBarAlpha ) {
          mScrollBarAlpha = mScrollBarParameter.fadeMax;
        }
      }
      else {
        mScrollBarAlpha -= mScrollBarParameter.fadeSpeed;
        if( mScrollBarAlpha < mScrollBarParameter.fadeMin ) {
          mScrollBarAlpha = mScrollBarParameter.fadeMin;
        }
      }
      */
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ʂ`悷
     */
    //--------------------------------------------------------------------------------
    void LowerDrawer::Draw( void )
    { 
      gfl::grp::RenderTarget* lowerFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      mLayoutWork->Draw( this->GraphicsSystem(), gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      CoreData::SceneNo currentScene = this->CoreData()->GetScene();
      if( mSceneSettings[ currentScene ].scrollbarDrawEnable && ( 0.0f < mScrollBarAlpha ) ) {
        mScrollBar->Draw( mScrollBarParameter.x, mScrollBarParameter.y, this->CoreData()->GetScrollValueObject(), mScrollBarAlpha );
      }
    }

  } //config
} //app
