//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_config_Drawer.cpp
 *	@brief ݒʂ̕`{NX
 *	@author takada
 *	@date		2011.07.05
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <app/config/app_config_CoreData.h>
#include <app/config/app_config_Drawer.h>

namespace app {
  namespace config {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // ̈ꎞobt@̍ő啶
    const size_t Drawer::mTemporaryStrbufLength = 1024;

    // ̈ꎞobt@
    gfl::str::StrBuf* Drawer::mTemporaryStrbuf = NULL;
    wchar_t* Drawer::mTemporaryString = NULL;

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     *
     * @param nwHeapAllocator    OtBbNXVXeŎgpAP[^
     * @param nwDeviceAllocator  OtBbNXVXeŎgpAP[^
     * @param graphicsSystem      `ɎgpOtBbNXVXe
     * @param layoutSystem        `Ɏgp郌CAEgVXe
     * @param coreData            `Ώۂ̐ݒʃRA
     */
    //--------------------------------------------------------------------------------
    Drawer::Drawer( 
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const app::config::CoreData* coreData ) : 
      mNwHeapAllocator( nwHeapAllocator ),
      mNwDeviceAllocator( nwDeviceAllocator ),
      mGraphicsSystem( graphicsSystem ),
      mLayoutSystem( layoutSystem ),
      mCoreData( coreData )
    {
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    Drawer::~Drawer()
    {
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ̈ꎞobt@𐶐
     *
     * @param heap  obt@̊mۂɎgpq[v
     */
    //--------------------------------------------------------------------------------
    void Drawer::CreateTemporaryStrbuf( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mTemporaryStrbuf == NULL );
      GFL_ASSERT( mTemporaryString == NULL );
      mTemporaryStrbuf = GFL_NEW( heap ) gfl::str::StrBuf( mTemporaryStrbufLength, heap );
      mTemporaryString = GFL_NEW_ARRAY( heap ) wchar_t[ mTemporaryStrbufLength ];
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ̈ꎞobt@j
     */
    //--------------------------------------------------------------------------------
    void Drawer::DeleteTemporaryStrbuf( void )
    {
      GFL_ASSERT( mTemporaryStrbuf );
      GFL_ASSERT( mTemporaryString );
      GFL_DELETE mTemporaryStrbuf;
      GFL_DELETE_ARRAY mTemporaryString;
      mTemporaryStrbuf = NULL;
      mTemporaryString = NULL;
    }

    // eLXg{bNXyCɃbZ[Wf[^̕ݒ肷
    void Drawer::SetTextBoxPaneStringFromMessageData( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, gfl::str::MsgData* messageData, u32 stringId )
    {
      GFL_ASSERT( mTemporaryStrbuf );
      messageData->GetString( stringId, *mTemporaryStrbuf );
      const wchar_t* string = mTemporaryStrbuf->GetPtr();
      SetTextBoxPaneString( layoutWork, paneIndex, string );
    } 


    // eLXg{bNXyCɕݒ肷
    void Drawer::SetTextBoxPaneString( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, const wchar_t* string )
    {
      gfl::grp::g2d::LytTextBox* textBox;
      textBox = layoutWork->GetTextBoxPane( paneIndex ); 
      GFL_ASSERT( textBox );
      if( textBox ) {
        textBox->SetString( string );
      }
    }



    // yC̉ԂύX
    void Drawer::SetPaneVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, bool visible )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetVisible( visible );
      }
    }

    // O[v̉ԂύX
    void Drawer::SetGroupVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, bool visible )
    {
      gfl::grp::g2d::LytPaneList* paneList = layoutWork->GetPaneList( groupIndex );
      GFL_ASSERT( paneList );
      if( paneList ) {
        gfl::grp::g2d::LytPaneList::iterator it = paneList->begin();
        while( it != paneList->end() ) {
          it->target->SetVisible( visible );
          it++;
        }
      }
    }

    // O[vɏSẴyCZlύX
    void Drawer::SetGroupZPos( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, float z )
    {
      gfl::grp::g2d::LytPaneList* paneList = layoutWork->GetPaneList( groupIndex );
      GFL_ASSERT( paneList );
      if( paneList ) {
        gfl::grp::g2d::LytPaneList::iterator it = paneList->begin();
        while( it != paneList->end() ) {
          gfl::math::VEC3 pos = it->target->GetTranslate();
          pos.z = z;
          it->target->SetTranslate( pos );
          it++;
        }
      }
    }

  } // namespace config
} // namespace app
