//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file app_config_CoreData.cpp
 *	@brief ݒʂ̃RAf[^
 *	@author takada
 *	@date		2011.07.05
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <app/config/app_config_CoreData.h>

namespace app {
  namespace config {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

    // XN[̐ݒ
    const app::tool::ScrollValue::Settings CoreData::mScrollValueSettings = 
    {
      /* ŏl */ -100.0f,  // ɐlݒ肷邽, ͉̒l
      /* ől */ 100.0f,   // ɐlݒ肷邽, ͉̒l
      /* W */ 0.9f,
      /* I[o[ǂ */ false,
      /* St[ */ 20,
    };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     *
     * @param heap                   CX^X̐Ɏgpq[v
     */
    //--------------------------------------------------------------------------------
    CoreData::CoreData( gfl::heap::HeapBase* heap ) :
      mScene( SCENE_CONFIG_TOP ),
      mDirtyFlag(),
      mCurrentSelectSetting( SETTINGS_NULL )
    {
      this->InitializeDirtyFlags();

      for( s8 i = 0; i < SETTINGS_NUM; ++i )
      {
        mCurrentSelectOption[ i ] = NULL;
      }

      this->CreateScrollValueOfList( heap );
    }

    // {Xg̃XN[l𐶐
    void CoreData::CreateScrollValueOfList( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mScrollValue == NULL );
      mScrollValue = GFL_NEW( heap ) app::tool::ScrollValue( mScrollValueSettings );
    }

    // XVtO
    void CoreData::InitializeDirtyFlags( void )
    {
      for( u32 i=0; i<DIRTY_FLAG_NUM; i++ ) {
        mDirtyFlag[i] = 0;
      }
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    CoreData::~CoreData()
    {
      this->DeleteScrollValueOfList();
    }

    // {Xg̃XN[lj
    void CoreData::DeleteScrollValueOfList( void )
    {
      GFL_ASSERT( mScrollValue );
      GFL_DELETE mScrollValue;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief f[^XV
     */
    //--------------------------------------------------------------------------------
    void CoreData::UpdateData( void )
    {
      this->UpdateScrollValue();
    }

    //------------------------------------------------------------------------------------
    // XVNǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool CoreData::IsDirty( DirtyFlagIndex index, DirtyBit bit ) const 
    {
      return mDirtyFlag[ index ] & bit; 
    }

    //------------------------------------------------------------------------------------
    // XVtO菜
    //------------------------------------------------------------------------------------
    void CoreData::RemoveDirtyBit( DirtyFlagIndex index, DirtyBit bit ) const 
    { 
      const_cast< CoreData* >( this )->mDirtyFlag[ index ] = mDirtyFlag[ index ] & ( ~bit ); 
    }

    // XVtOZbg
    void CoreData::SetDirtyBit( DirtyBit bit ) 
    {
      for( u32 i=0; i<DIRTY_FLAG_NUM; i++ ) {
        mDirtyFlag[ i ] |= bit; 
      }
    }



    //------------------------------------------------------------------------------------
    // V[擾
    //------------------------------------------------------------------------------------
    CoreData::SceneNo CoreData::GetScene( void ) const 
    { 
      return mScene; 
    }

    //------------------------------------------------------------------------------------
    // V[ݒ肷
    //------------------------------------------------------------------------------------
    void CoreData::SetScene( SceneNo scene ) 
    {
      if( mScene != scene ) {
        mScene = scene; 
        this->SetDirtyBit( DIRTY_BIT_SCENE );
      }
    }

    //--------------------------------------------------------------------------------
    // I
    //--------------------------------------------------------------------------------
    Settings CoreData::GetCurrentSelectSetting( void ) const
    {
      return mCurrentSelectSetting;
    }
    void CoreData::ChangeCurrentSelectSetting( Settings value )
    {
      mCurrentSelectSetting = value;
    }

    //--------------------------------------------------------------------------------
    // I
    //--------------------------------------------------------------------------------
    s8 CoreData::GetCurrentSelectOption( s8 index ) const
    {
      return mCurrentSelectOption[ index ];
    }
    void CoreData::ChangeCurrentSelectOption( s8 index, u8 value )
    {
      mCurrentSelectOption[ index ] = value;
    }

    //------------------------------------------------------------------------------------
    // XN[lIuWFNg擾
    //------------------------------------------------------------------------------------
    const app::tool::ScrollValue& CoreData::GetScrollValueObject( void ) const
    {
      return *mScrollValue;
    }

    //------------------------------------------------------------------------------------
    // XN[ʒu擾
    //------------------------------------------------------------------------------------
    f32 CoreData::GetScrollValue( void ) const
    {
      return mScrollValue->GetCurrentValue();
    }

    //------------------------------------------------------------------------------------
    // XN[ʒuݒ肷
    //------------------------------------------------------------------------------------
    void CoreData::SetScrollValue( f32 value )
    {
      mScrollValue->SetCurrentValue( value );
      //this->SetDirtyBit( DIRTY_BIT_SCROLL_VALUE );
    }

    //------------------------------------------------------------------------------------
    // XN[Jn
    //------------------------------------------------------------------------------------
    void CoreData::StartScroll( f32 scroll_speed )
    {
      mScrollValue->StartScroll( scroll_speed );
    }

    //------------------------------------------------------------------------------------
    // XN[~߂
    //------------------------------------------------------------------------------------
    void CoreData::StopScroll( void )
    {
      mScrollValue->StopScroll();
    }

    //--------------------------------------------------------------------------------
    // ŏXN[lݒ肷
    //--------------------------------------------------------------------------------
    void CoreData::SetMinScrollValue( f32 min_value )
    {
      mScrollValue->SetMinValue( min_value );
    }

    //--------------------------------------------------------------------------------
    // őXN[lݒ肷
    //--------------------------------------------------------------------------------
    void CoreData::SetMaxScrollValue( f32 max_value )
    {
      mScrollValue->SetMaxValue( max_value );
    }

    //--------------------------------------------------------------------------------
    // XN[Œ肷
    //--------------------------------------------------------------------------------
    void CoreData::LockScroll( void )
    {
      mScrollValue->LockScroll();
    }

    //--------------------------------------------------------------------------------
    // XN[Œ
    //--------------------------------------------------------------------------------
    void CoreData::UnlockScroll( void )
    {
      mScrollValue->UnlockScroll();
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief XN[lXV
     */
    //--------------------------------------------------------------------------------
    void CoreData::UpdateScrollValue( void )
    {
      f32 oldValue = mScrollValue->GetCurrentValue();
      mScrollValue->UpdateScroll();
      f32 newValue = mScrollValue->GetCurrentValue();
      /*if( oldValue != newValue ) {
        this->SetDirtyBit( DIRTY_BIT_SCROLL_VALUE );
      }*/
    }

    //--------------------------------------------------------------------------------
    // {̍SXN[Jn
    //--------------------------------------------------------------------------------
    void CoreData::StartBindScroll( f32 bindValue, u32 bindFrame )
    {
      mScrollValue->StartBindScroll( bindValue, bindFrame );
    }

    //--------------------------------------------------------------------------------
    // {̍SXN[ǂ𒲂ׂ
    //--------------------------------------------------------------------------------
    bool CoreData::IsBindScroll( void ) const
    {
      return mScrollValue->IsBindScroll();
    }


  } // namespace config
} // namespace app
