//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_config_ArchiveDataLoadThread.cpp
 *	@brief ݒʂ̃A[JCuf[^ǂݍ݃Xbh
 *	@author takada
 *	@date		2011.07.05
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <arc/config.gaix>
#include <app/config/app_config_ArchiveData.h>
#include <app/config/app_config_ArchiveDataLoadThread.h>

namespace app {
  namespace config {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
//------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    ArchiveDataLoadThread::ArchiveDataLoadThread( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* deviceHeap, ArchiveData* archiveData ) :
      gfl::base::Thread( heap, 1024 ),
      mHeap( heap ),
      mDeviceHeap( deviceHeap ),
      mArchiveData( archiveData )
    {
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    ArchiveDataLoadThread::~ArchiveDataLoadThread()
    {
    }

    //------------------------------------------------------------------------------------
    // Xbh̃C
    //------------------------------------------------------------------------------------ 
    void ArchiveDataLoadThread::Main( void )
    {
      gfl::fs::ArcFile* arcFile = mArchiveData->GetArcFile();

      // [hɈڍs
      arcFile->SetupForFastMode( mHeap );

      // ݒʂ̃bZ[Wf[^
      GFL_ASSERT( !mArchiveData->IsDataExist( ArchiveData::DATA_CONFIG_MESSAGE ) );
      if( !mArchiveData->IsDataExist( ArchiveData::DATA_CONFIG_MESSAGE ) ) {
        gfl::fs::ArcFile::ARCDATID arcDataId = GARC_config_option_DAT;
        size_t dataSize = arcFile->GetDataSize( arcDataId );
        void* dataBuffer = GflHeapAllocMemory( mHeap, dataSize );
        size_t loadSize = arcFile->LoadData( arcDataId, dataBuffer );
        GFL_ASSERT( dataSize == loadSize );
        mArchiveData->SetData( ArchiveData::DATA_CONFIG_MESSAGE, dataBuffer );
      }
      //GFL_PRINT( "archive load > status message\n" );

      // ʃCAEg̃\[Xf[^
      GFL_ASSERT( !mArchiveData->IsDataExist( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ) );
      if( !mArchiveData->IsDataExist( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ) ) {
        gfl::fs::ArcFile::ARCDATID arcDataId = GARC_config_config_layout_lower_LYTDAT;
        size_t dataSize = arcFile->GetDataSize( arcDataId );
        void* dataBuffer = GflHeapAllocMemoryAlign( mDeviceHeap, dataSize, 128 );
        size_t loadSize = arcFile->LoadData( arcDataId, dataBuffer );
        GFL_ASSERT( dataSize == loadSize );
        mArchiveData->SetData( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE, dataBuffer );
      } 
      //GFL_PRINT( "archive load > lower layout\n" );

      // ʃCAEg̃\[Xf[^
      GFL_ASSERT( !mArchiveData->IsDataExist( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ) );
      if( !mArchiveData->IsDataExist( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ) ) {
        gfl::fs::ArcFile::ARCDATID arcDataId = GARC_config_config_layout_upper_LYTDAT;
        size_t dataSize = arcFile->GetDataSize( arcDataId );
        void* dataBuffer = GflHeapAllocMemoryAlign( mDeviceHeap, dataSize, 128 );
        size_t loadSize = arcFile->LoadData( arcDataId, dataBuffer );
        GFL_ASSERT( dataSize == loadSize );
        mArchiveData->SetData( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE, dataBuffer );
      }
      //GFL_PRINT( "archive load > upper layout\n" );

      // ^b`o[̃CAEg\[Xf[^
      GFL_ASSERT( !mArchiveData->IsDataExist( ArchiveData::DATA_TOUCHBAR_LAYOUT_REOUSRCE ) );
      if( !mArchiveData->IsDataExist( ArchiveData::DATA_TOUCHBAR_LAYOUT_REOUSRCE ) ) {
        gfl::fs::ArcFile::ARCDATID arcDataId = GARC_config_config_layout_touch_bar_LYTDAT;
        size_t dataSize = arcFile->GetDataSize( arcDataId );
        void* dataBuffer = GflHeapAllocMemoryAlign( mDeviceHeap, dataSize, 128 );
        size_t loadSize = arcFile->LoadData( arcDataId, dataBuffer );
        GFL_ASSERT( dataSize == loadSize );
        mArchiveData->SetData( ArchiveData::DATA_TOUCHBAR_LAYOUT_REOUSRCE, dataBuffer );
      } 
      //GFL_PRINT( "archive load > touchbar layout\n" );


      // E
      this->Kill();
      //GFL_PRINT( "archive load > kill\n" );
    }



  } // namespace config
} // namespace app 
