//========================================================================================
/**
 * @file app_config_UpperLayoutInformation.h
 * @brief ݒʂ̉ʃCAEg
 * @author takada
 * @date 2011.07.06
 */
//========================================================================================
#ifndef __APP_CONFIG_UPPER_LAYOUTINFORMATION_H__
#define __APP_CONFIG_UPPER_LAYOUTINFORMATION_H__
#include <gflib.h>
#include <pmlib.h>
#include <app/config/app_config_CoreData.h>


namespace app {
  namespace config { 


    class UpperLayout 
    { 
      public:

        // Aj[Vf[^
        enum AnimationData {
          ANIMATION_DATA_SCENE_STATUS_PARAMETER_TOP,                         // V[Aj( Xe[^X > p[^ > gbv )
          ANIMATION_DATA_SCENE_STATUS_PARAMETER_SELECT_WAZA_EXCHANGE_TARGET, // V[Aj( Xe[^X > p[^ > ւZI )
          ANIMATION_DATA_SCENE_STATUS_PARAMETER_SELECT_WAZA_EXCHANGE_AIM,    // V[Aj( Xe[^X > p[^ > ւ̋ZI )
          ANIMATION_DATA_SCENE_STATUS_INFORMATION,                           // V[Aj( Xe[^X >  )
          ANIMATION_DATA_SCENE_STATUS_RIBBON,                                // V[Aj( Xe[^X > { )
          ANIMATION_DATA_SCENE_STATUS_EGG,                                   // V[Aj( Xe[^X > ^}S )
          ANIMATION_DATA_SCENE_WAZAWASURE_SELECT,                            // V[Aj( ZY > ZI )
          ANIMATION_DATA_SCENE_WAZAWASURE_SEAL,                              // V[Aj( ZY > ZYmF )
          ANIMATION_DATA_SCENE_WAZAOBOE_WAZA_SELECT,                         // V[Aj( Zo > ZI )
          ANIMATION_DATA_SCENE_WAZAOBOE_FORGET_SEAL,                         // V[Aj( Zo > ZYmF )
          ANIMATION_DATA_SCENE_WAZAOBOE_RESULT_MESSAGE,                      // V[Aj( Zo > ʃbZ[W\ )
          ANIMATION_DATA_NUM,
        };


        // Aj[Vԍ
        enum AnimationIndex {
          ANIMATION_SCENE_STATUS_PARAMETER_TOP,
          ANIMATION_SCENE_STATUS_PARAMETER_SELECT_WAZA_EXCHANGE_TARGET,
          ANIMATION_SCENE_STATUS_PARAMETER_SELECT_WAZA_EXCHANGE_AIM,
          ANIMATION_SCENE_STATUS_INFORMATION,
          ANIMATION_SCENE_STATUS_RIBBON,
          ANIMATION_SCENE_STATUS_EGG,
          ANIMATION_SCENE_WAZAWASURE_SELECT,
          ANIMATION_SCENE_WAZAWASURE_SEAL,
          ANIMATION_SCENE_WAZAOBOE_WAZA_SELECT,
          ANIMATION_SCENE_WAZAOBOE_FORGET_SEAL,
          ANIMATION_SCENE_WAZAOBOE_RESULT_MESSAGE,
          ANIMATION_NUM,
          ANIMATION_NULL,
        };


        // CAEg
        struct Information {
          gfl::grp::g2d::LytArcIndex layout_data_id;                                   // CAEgf[^̃CAEg\[XID
          gfl::grp::g2d::LytArcIndex animation_data_table[ ANIMATION_DATA_NUM ];       // Aj[Vf[^̃A[JCuIDe[u
          AnimationIndex animation_index_of_scene_change_to[ CoreData::SCENE_NUM ];    // V[ύX̃Aj[V
          gfl::grp::g2d::LytPaneIndex pane_index_of_zukan_no_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_zukan_no;
          gfl::grp::g2d::LytPaneIndex pane_index_of_mons_name_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_mons_name;
          gfl::grp::g2d::LytPaneIndex pane_index_of_oya_name_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_oya_name;
          gfl::grp::g2d::LytPaneIndex pane_index_of_id_no_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_id_no;
          gfl::grp::g2d::LytPaneIndex pane_index_of_type_label; 
          gfl::grp::g2d::LytPaneIndex pane_index_of_type_01_icon;
          gfl::grp::g2d::LytPaneIndex pane_index_of_type_02_icon;
          gfl::grp::g2d::LytPaneIndex pane_index_of_exp_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_exp;
          gfl::grp::g2d::LytPaneIndex pane_index_of_exp_for_levelup_label_01;
          gfl::grp::g2d::LytPaneIndex pane_index_of_exp_for_levelup_label_02;
          gfl::grp::g2d::LytPaneIndex pane_index_of_exp_for_levelup;
          gfl::grp::g2d::LytPaneIndex pane_index_of_hp_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_hp;
          gfl::grp::g2d::LytPaneIndex pane_index_of_max_hp;
          gfl::grp::g2d::LytPaneIndex pane_index_of_atk_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_atk;
          gfl::grp::g2d::LytPaneIndex pane_index_of_def_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_def;
          gfl::grp::g2d::LytPaneIndex pane_index_of_spatk_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_spatk;
          gfl::grp::g2d::LytPaneIndex pane_index_of_spdef_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_spdef;
          gfl::grp::g2d::LytPaneIndex pane_index_of_agi_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_agi;
          gfl::grp::g2d::LytPaneIndex pane_index_of_tokusei_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_tokusei_name;
          gfl::grp::g2d::LytPaneIndex pane_index_of_tokusei_info;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_dmg_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_atk_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_hit_label;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_dmg_icon;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_atk;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_hit;
          gfl::grp::g2d::LytPaneIndex pane_index_of_waza_explanation;
          gfl::grp::g2d::LytPaneIndex pane_index_of_ribbon_name;
          gfl::grp::g2d::LytPaneIndex pane_index_of_ribbon_info; 
        };



        static const Information information;


        // CAEg[N𐶐
        static gfl::grp::g2d::LytWk* CreateLayoutWork( 
            gfl::heap::NwAllocator* device_allocator, gfl::grp::g2d::LytSys* layout_system, 
            const void* layout_resource_data, const gfl::grp::g2d::LytWkSetUp* layout_work_setup_data );
    };


  } // namespace config
} // namespace app


#endif // __APP_CONFIG_UPPER_LAYOUTINFORMATION_H__ 
