//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_setting_config_Process.h
 *	@brief ݒʃvZX
 *	@author	takada
 *	@date		2011.07.05
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __APP_CONFIG_PROCESS_H__
#define __APP_CONFIG_PROCESS_H__

#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <app/tool/app_tool_TouchBar.h>

namespace app {
  namespace config {

    class ArchiveData;
    class CoreData;
    class Operator;
    class Drawer;
    class LowerDrawer;
    class UpperDrawer;
    class ViewController;
    class ArchiveDataLoadThread;
    class ProcessInitThread;

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

    class Process : public gamesystem::GameProc
    {
      public:

        //----------------------------------------------------------------------------
        /**
         *	@brief RXgN^
         *
         *	@param heap
         *	@param deviceHeap
         *	@param graphicsSystem
         *	@param uiDeviceManager
         */
        //-----------------------------------------------------------------------------
        Process(
            gfl::heap::HeapBase* heap,
            gfl::heap::HeapBase* deviceHeap,
            gfl::grp::GraphicsSystem* graphicsSystem,
            gfl::ui::DeviceManager* uiDeviceManager );

        //----------------------------------------------------------------------------
        /**
         *	@brief fXgN^
         */
        //-----------------------------------------------------------------------------
        virtual ~Process();

        //--------------------------------------------------------------------------------
        /**
         * @brief	vZX̏
         *
         * @param procManager  vZX̃}l[W
         *
         * @retval RES_CONTINUE  p
         * @retval RES_FINISH    I
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result InitFunc( gfl::proc::Manager* procManager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̍XV
         *
         * @param procManager  vZX̃}l[W
         *
         * @retval RES_CONTINUE  Cp
         * @retval RES_FINISH    CI
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* procManager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̕`揈
         *
         * @param procManager  vZX̃}l[W
         */
        //--------------------------------------------------------------------------------
        virtual void DrawFunc( gfl::proc::Manager* procManager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̏I
         *
         * @param procManager  vZX̃}l[W
         *
         * @retval RES_CONTINUE  Ip
         * @retval RES_FINISH    II
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result EndFunc( gfl::proc::Manager* procManager );

        //------------------------------------------------------------------------------------
        /**
         * @breif vZX
         */
        //------------------------------------------------------------------------------------
        void Initialize( void );

      protected:

        static const gfl::grp::g2d::LytSysSetUp mLayoutSystemSetupData;
        static const wchar_t* mMessageFilename;
        static const char* mSystemfontFilename;

        u32 mInitSeq;
        ArchiveDataLoadThread* mArchiveDataLoadThread;
        ProcessInitThread* mProcessInitThread;

        const gfl::ui::DeviceManager* mUiDeviceManager;

        gfl::heap::HeapBase* mHeap;
        gfl::heap::HeapBase* mDeviceHeap;
        gfl::heap::NwAllocator* mNwHeapAllocator;
        gfl::heap::NwAllocator* mNwDeviceAllocator;
        gfl::grp::GraphicsSystem* mGraphicsSystem;
        //gfl::grp::g3d::System* mG3dSystem;
        gfl::grp::g2d::LytSys* mLayoutSystem;
        gfl::str::MsgData* mConfigMessageData;
        app::tool::TouchBar* mTouchBar;
        app::config::ArchiveData* mArchiveData;
        app::config::CoreData* mCoreData;
        app::config::Operator* mOperator;
        app::config::ViewController* mViewController;
        app::config::UpperDrawer* mUpperDrawer;
        app::config::LowerDrawer* mLowerDrawer;

        // A[JCuf[^̔񓯊ǂݍ
        void StartArchiveDataAsyncLoad( void );
        bool IsArchiveDataAsyncLoadFinished( void ) const;
        void EndArchiveDataAsyncLoad( void );

        // vZX̔񓯊
        void StartProcessAsyncInit( void );
        bool IsProcessAsyncInitFinished( void ) const;
        void EndProcessAsyncInit( void );

        // eVXe̐E
        void CreateArchiveData( void );
        void CreateNwAllocators( void );
        void CreateGraphicsSystem( void );
        //void CreateG3dSystem( void );
        void CreateLayoutSystem( void );
        void SetupFont( void );
        void CreateConfigMessageData( void );
        void InitializeDrawUtilLibrary( void );
        void CreateTouchBar( void );
        void CreateCoreData( void );
        void SetupCoreData( void );
        void CreateViewController( void );
        virtual Operator* CreateOperator( void ) = 0;
        void CreateUpperDrawer( void );
        void CreateLowerDrawer( void );

        // eVXe̔jEЕt
        void DeleteArchiveData( void );
        void DeleteNwAllocators( void );
        void DeleteGraphicsSystem( void );
        //void DeleteG3dSystem( void );
        void DeleteLayoutSystem( void ); 
        void CleanupFont( void ); 
        void DeleteMessageData( void ); 
        void FinalizeDrawUtilLibrary( void );
        void DeleteTouchBar( void );
        void DeleteCoreData( void );
        void DeleteViewController( void );
        void DeleteCoreOperator( void );
        void DeleteCoreDrawer( void ); 

        // ʂ̏o
        virtual void PutResult( void ) {}
    };

  } // namespace config
} // namespace app

#endif // __APP_CONFIG_PROCESS_H__
