//========================================================================================
/**
 * @file app_config_LowerLayoutInformation.h
 * @brief ݒʂ̉ʃCAEg
 * @author takada
 * @date 2011.07.06
 */
//========================================================================================
#ifndef __APP_CONFIG_LOWERLAYOUTINFORMATION_H__
#define __APP_CONFIG_LOWERLAYOUTINFORMATION_H__

#define BACK

#include <gflib.h>
#include <pmlib.h>
#include <app/config/app_config_CoreData.h>
#include <app/config/config_layout_lower.h>
#include <app/config/config_layout_lower_pane.h>

#include <app/config/app_config_CommonSettings.h>

namespace app {
  namespace config { 


    class LowerLayout 
    { 
      public:
      struct Setting {
        gfl::grp::g2d::LytPaneIndex paneIndexOfBack;
        gfl::grp::g2d::LytPaneIndex paneIndexOfWindow1Value;
        gfl::grp::g2d::LytPaneIndex paneIndexOfWindow1Label;
        gfl::grp::g2d::LytPaneIndex paneIndexOfLeftArrow;
        gfl::grp::g2d::LytPaneIndex paneIndexOfRightArrow;
        gfl::grp::g2d::LytPaneIndex paneIndexOfWindow2Value;
        gfl::grp::g2d::LytPaneIndex paneIndexOfWindow2Label;
      };

      // Aj[Vf[^
      enum AnimationData {
        ANIMATIONDATA_LEFTARROW_TOUCH,
        ANIMATIONDATA_LEFTARROW_RELEASE,
        ANIMATIONDATA_LEFTARROW_PASSIVE,
        ANIMATIONDATA_LEFTARROW_SELECT,

        ANIMATIONDATA_RIGHTARROW_TOUCH,
        ANIMATIONDATA_RIGHTARROW_RELEASE,
        ANIMATIONDATA_RIGHTARROW_PASSIVE,
        ANIMATIONDATA_RIGHTARROW_SELECT,

#if defined( BACK )
        ANIMATIONDATA_BACK_UNSELECT,
        ANIMATIONDATA_BACK_SELECT,
#endif

        ANIMATION_DATA_NUM,
      };

      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATIONINDEX_DUMMY_LEFTARROW_TOUCH,
        ANIMATIONINDEX_DUMMY_LEFTARROW_RELEASE,
        ANIMATIONINDEX_DUMMY_LEFTARROW_PASSIVE,
        ANIMATIONINDEX_DUMMY_LEFTARROW_SELECT,

        ANIMATIONINDEX_DUMMY_RIGHTARROW_TOUCH,
        ANIMATIONINDEX_DUMMY_RIGHTARROW_RELEASE,
        ANIMATIONINDEX_DUMMY_RIGHTARROW_PASSIVE,
        ANIMATIONINDEX_DUMMY_RIGHTARROW_SELECT,

#if defined( BACK )
        ANIMATIONINDEX_DUMMY_BACK_UNSELECT,
        ANIMATIONINDEX_DUMMY_BACK_SELECT,
#endif

        ANIMATIONINDEX_LEFTARROW01_TOUCH,
        ANIMATIONINDEX_LEFTARROW02_TOUCH,
        ANIMATIONINDEX_LEFTARROW03_TOUCH,
        ANIMATIONINDEX_LEFTARROW04_TOUCH,
        ANIMATIONINDEX_LEFTARROW05_TOUCH,
        ANIMATIONINDEX_LEFTARROW06_TOUCH,
        ANIMATIONINDEX_LEFTARROW07_TOUCH,
        ANIMATIONINDEX_LEFTARROW08_TOUCH,
        ANIMATIONINDEX_LEFTARROW01_RELEASE,
        ANIMATIONINDEX_LEFTARROW02_RELEASE,
        ANIMATIONINDEX_LEFTARROW03_RELEASE,
        ANIMATIONINDEX_LEFTARROW04_RELEASE,
        ANIMATIONINDEX_LEFTARROW05_RELEASE,
        ANIMATIONINDEX_LEFTARROW06_RELEASE,
        ANIMATIONINDEX_LEFTARROW07_RELEASE,
        ANIMATIONINDEX_LEFTARROW08_RELEASE,
        ANIMATIONINDEX_LEFTARROW01_PASSIVE,
        ANIMATIONINDEX_LEFTARROW02_PASSIVE,
        ANIMATIONINDEX_LEFTARROW03_PASSIVE,
        ANIMATIONINDEX_LEFTARROW04_PASSIVE,
        ANIMATIONINDEX_LEFTARROW05_PASSIVE,
        ANIMATIONINDEX_LEFTARROW06_PASSIVE,
        ANIMATIONINDEX_LEFTARROW07_PASSIVE,
        ANIMATIONINDEX_LEFTARROW08_PASSIVE,
        ANIMATIONINDEX_LEFTARROW01_SELECT,
        ANIMATIONINDEX_LEFTARROW02_SELECT,
        ANIMATIONINDEX_LEFTARROW03_SELECT,
        ANIMATIONINDEX_LEFTARROW04_SELECT,
        ANIMATIONINDEX_LEFTARROW05_SELECT,
        ANIMATIONINDEX_LEFTARROW06_SELECT,
        ANIMATIONINDEX_LEFTARROW07_SELECT,
        ANIMATIONINDEX_LEFTARROW08_SELECT,

        ANIMATIONINDEX_RIGHTARROW01_TOUCH,
        ANIMATIONINDEX_RIGHTARROW02_TOUCH,
        ANIMATIONINDEX_RIGHTARROW03_TOUCH,
        ANIMATIONINDEX_RIGHTARROW04_TOUCH,
        ANIMATIONINDEX_RIGHTARROW05_TOUCH,
        ANIMATIONINDEX_RIGHTARROW06_TOUCH,
        ANIMATIONINDEX_RIGHTARROW07_TOUCH,
        ANIMATIONINDEX_RIGHTARROW08_TOUCH,
        ANIMATIONINDEX_RIGHTARROW01_RELEASE,
        ANIMATIONINDEX_RIGHTARROW02_RELEASE,
        ANIMATIONINDEX_RIGHTARROW03_RELEASE,
        ANIMATIONINDEX_RIGHTARROW04_RELEASE,
        ANIMATIONINDEX_RIGHTARROW05_RELEASE,
        ANIMATIONINDEX_RIGHTARROW06_RELEASE,
        ANIMATIONINDEX_RIGHTARROW07_RELEASE,
        ANIMATIONINDEX_RIGHTARROW08_RELEASE,
        ANIMATIONINDEX_RIGHTARROW01_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW02_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW03_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW04_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW05_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW06_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW07_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW08_PASSIVE,
        ANIMATIONINDEX_RIGHTARROW01_SELECT,
        ANIMATIONINDEX_RIGHTARROW02_SELECT,
        ANIMATIONINDEX_RIGHTARROW03_SELECT,
        ANIMATIONINDEX_RIGHTARROW04_SELECT,
        ANIMATIONINDEX_RIGHTARROW05_SELECT,
        ANIMATIONINDEX_RIGHTARROW06_SELECT,
        ANIMATIONINDEX_RIGHTARROW07_SELECT,
        ANIMATIONINDEX_RIGHTARROW08_SELECT,

#if defined( BACK )
        ANIMATIONINDEX_BACK01_UNSELECT,
        ANIMATIONINDEX_BACK02_UNSELECT,
        ANIMATIONINDEX_BACK03_UNSELECT,
        ANIMATIONINDEX_BACK04_UNSELECT,
        ANIMATIONINDEX_BACK05_UNSELECT,
        ANIMATIONINDEX_BACK06_UNSELECT,
        ANIMATIONINDEX_BACK07_UNSELECT,
        ANIMATIONINDEX_BACK08_UNSELECT,

        ANIMATIONINDEX_BACK01_SELECT,
        ANIMATIONINDEX_BACK02_SELECT,
        ANIMATIONINDEX_BACK03_SELECT,
        ANIMATIONINDEX_BACK04_SELECT,
        ANIMATIONINDEX_BACK05_SELECT,
        ANIMATIONINDEX_BACK06_SELECT,
        ANIMATIONINDEX_BACK07_SELECT,
        ANIMATIONINDEX_BACK08_SELECT,
#endif

        ANIMATIONINDEX_NUM,
        
        ANIMATION_NULL,
      };

      // J[\Aj[V
      struct BackAnimInfo {
        AnimationIndex unSelectAnimIndex[ SETTINGS_NUM ];
        AnimationIndex selectAnimIndex[ SETTINGS_NUM ];
      };
      static const BackAnimInfo backAnimInfo;

      // CAEg
      struct Information {
        gfl::grp::g2d::LytArcIndex layoutDataId;  // CAEgf[^̃CAEg\[XID

        gfl::grp::g2d::LytPaneIndex paneIndexOfTitleBack;
        gfl::grp::g2d::LytPaneIndex paneIndexOfTitelWindowValue;
        gfl::grp::g2d::LytPaneIndex paneIndexOfTitleWindowLabel;
        
        Setting settings[ SETTINGS_NUM ];

        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollRoot;

        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollMinPosition; // XN[̍ŏl\yC
        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollMaxPosition; // XN[̍ől\yC
        gfl::grp::g2d::LytPaneIndex paneIndexOfCursorControlArea; // J[\̈

        gfl::grp::g2d::LytPaneIndex groupIndexOfSettings[ SETTINGS_NUM ];
        gfl::grp::g2d::LytPaneIndex groupIndexOfLeftArrow;
        gfl::grp::g2d::LytPaneIndex groupIndexOfRightArrow;
        gfl::grp::g2d::LytPaneIndex groupIndexOfBack;
      };
      static const Information information;

      static const gfl::grp::g2d::LytArcIndex animDataIdTable[ ANIMATION_DATA_NUM ];

      // CAEg[N𐶐
      static gfl::grp::g2d::LytWk* CreateLayoutWork( 
        gfl::heap::NwAllocator* device_allocator, gfl::grp::g2d::LytSys* layout_system, 
        const void* layout_resource_data, const gfl::grp::g2d::LytWkSetUp* layout_work_setup_data );

      enum Button {
        LEFTARROW01,
        LEFTARROW02,
        LEFTARROW03,
        LEFTARROW04,
        LEFTARROW05,
        LEFTARROW06,
        LEFTARROW07,
        LEFTARROW08,
        RIGHTARROW01,
        RIGHTARROW02,
        RIGHTARROW03,
        RIGHTARROW04,
        RIGHTARROW05,
        RIGHTARROW06,
        RIGHTARROW07,
        RIGHTARROW08,

        BUTTON_NUM,
      };

      struct ButtonInfo
      { 
        gfl::grp::g2d::LytPaneIndex paneIndex;
        AnimationIndex touchAnimeIndex;
        AnimationIndex releaseAnimeIndex;
        AnimationIndex selectAnimeIndex;
      };
      static const ButtonInfo buttonInfo[ BUTTON_NUM ];

    };

  } // namespace config
} // namespace app


#endif // __APP_CONFIG_LOWERLAYOUTINFORMATION_H__ 
