//============================================================================================
/**
 * @file		temp_main.cpp
 * @brief		C
 * @author	Game Freak inc.
 * @date		11.07.04
 *
 * namespace	app::temp::
 */
//============================================================================================
#include "temp_main.h"
#include "temp_ui.h"


namespace app {
namespace temp {


//============================================================================================
//	萔`
//============================================================================================
// CV[PX`
enum {
	MAINSEQ_INIT = 0,
	MAINSEQ_RELEASE,
	MAINSEQ_MAIN,
	MAINSEQ_END
};

typedef int (MainSystem::*pSeqFunc)(void);


// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&MainSystem::MainSeq_Init,
	&MainSystem::MainSeq_Release,
	&MainSystem::MainSeq_Main,
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm )
{
	mainWork.prm = prm;
	mainWork.mainSeq = MAINSEQ_INIT;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::Update(void)
{
	MAIN_WORK * wk = &mainWork;

	wk->mainSeq = (this->*MainSeq[wk->mainSeq])();

	if( wk->mainSeq == MAINSEQ_END ){
		return false;
	}
	return true;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
//	subWork->pG3d->Draw();
//	subWork->pG2d->Draw(0);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
	heap.Create();

	subWork = GFL_NEW( heap.Get() )	SUB_WORK;

	subWork->ui = GFL_NEW( heap.Get() )	UI( &heap );

	CreateGraphicsSystem();
	subWork->pG2d = GFL_NEW( heap.Get() )	G2DSystem( subWork->pGraSystem, 2, &heap );
	subWork->pG3d = GFL_NEW( heap.Get() )	G3DSystem( subWork->pGraSystem, 2, &heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
	GFL_DELETE	subWork->pG3d;
	GFL_DELETE	subWork->pG2d;
	DeleteGraphicsSystem();

	GFL_DELETE	subWork->ui;
	GFL_DELETE	subWork;

	heap.Delete();
}

void MainSystem::CreateGraphicsSystem(void)
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	subWork->pGraSystem = gm->GetGraphicsSystem();
	subWork->pGraSystem->InitializeApplicationMemory( heap.GetDeviceAllocator() );
}
void MainSystem::DeleteGraphicsSystem(void)
{
	subWork->pGraSystem->FinalizeApplicationMemory();
}




//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Init(void)
{
	CreateSubWork();

	return MAINSEQ_MAIN;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Release(void)
{
	DeleteSubWork();

	return mainWork.nextSeq;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Main(void)
{
	if( subWork->ui->DEBUG_GetEndButton() == true ){
		mainWork.nextSeq = MAINSEQ_END;
		return MAINSEQ_RELEASE;
	}
	return MAINSEQ_MAIN;
}


}		// temp
}		// app

