//============================================================================================
/**
 * @file		temp_heap.cpp
 * @brief		[Jq[v֘A
 * @author	Game Freak inc.
 * @date		11.07.04
 *
 * namespace	app::temp::
 */
//============================================================================================
#include "temp_heap.h"


namespace app {
namespace temp {


//============================================================================================
//	萔`
//============================================================================================
#define	APP_HEAP_SIZE				( 0x50000 )		// Avp[Jq[vTCY
#define	DEVICE_HEAP_SIZE		( 0x50000 )		// Avp[JfoCXq[vTCY


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
Heap::Heap(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Heap::~Heap(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		q[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Heap::Create(void)
{
	pAppHeap    = gfl::heap::Manager::CreateHeap(
									gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
									HEAPID_TEMP_APP, APP_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP );
	pDeviceHeap = gfl::heap::Manager::CreateHeap(
									gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ),
									HEAPID_TEMP_DEVICE, DEVICE_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP );

	pAppHeapAllocator    = GFL_NEW( pAppHeap ) gfl::heap::NwAllocator( pAppHeap );
	pDeviceHeapAllocator = GFL_NEW( pDeviceHeap ) gfl::heap::NwAllocator( pDeviceHeap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		q[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Heap::Delete(void)
{
	GFL_DELETE pDeviceHeapAllocator;
	GFL_DELETE pAppHeapAllocator;
	gfl::heap::Manager::DeleteHeap( pDeviceHeap );
	gfl::heap::Manager::DeleteHeap( pAppHeap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		q[v擾
 *
 * @param		none
 *
 * @return	q[v
 */
//--------------------------------------------------------------------------------------------
gfl::heap::HeapBase * Heap::Get(void)
{
	return pAppHeap;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		foCXq[v擾
 *
 * @param		none
 *
 * @return	foCXq[v
 */
//--------------------------------------------------------------------------------------------
gfl::heap::HeapBase * Heap::GetDevice(void)
{
	return pDeviceHeap;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		q[vAP[^擾
 *
 * @param		none
 *
 * @return	q[vAP[^
 */
//--------------------------------------------------------------------------------------------
gfl::heap::NwAllocator * Heap::GetAllocator(void)
{
	return pAppHeapAllocator;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		foCXq[vAP[^擾
 *
 * @param		none
 *
 * @return	foCXq[vAP[^
 */
//--------------------------------------------------------------------------------------------
gfl::heap::NwAllocator * Heap::GetDeviceAllocator(void)
{
	return pDeviceHeapAllocator;
}


}		// temp
}		// app
