//============================================================================================
/**
 * @file		temp_3d.h
 * @brief		3D֘A
 * @author	Game Freak inc.
 * @date		11.07.11
 *
 * namespace	app::temp::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include <gfl_Device.h>

#include "temp_heap.h"


namespace app {
namespace temp {

#define	ADD_MODEL_ID_FREE	( 0xffffffff )

#define	ANIME_DATA_NONE		( 0xffffffff )

typedef struct {
	u32	mts;
	u32	skl;
}ANIME_DATA;

class G3DSystem {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		gra				OtBbNVXe
	 * @param		modelMax	ǉ\ȃfő吔
	 * @param		heap			q[v
	 */
	//--------------------------------------------------------------------------------------------
	G3DSystem( gfl::grp::GraphicsSystem * gra, u32 modelMax, Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~G3DSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fǉ
	 *
	 * @param		af			ArcFile
	 * @param		datIdx	A[Nf[^CfbNX
	 * @param		heap		q[v
	 * @param		id			fIDiftHg = ADD_MODEL_ID_FREE j
	 * @param		anm			Ajf[^iftHg = NULL j
	 * @param		anmMax	Ajf[^iftHg = 0 j
	 *
	 * @return	fID
	 *
	 * @li	id = ADD_MODEL_ID_FREE ̏ꍇA󂢂Ăꏊɒǉ
	 * @li	KDelModel()ŏƁI
	 */
	//--------------------------------------------------------------------------------------------
	u32 AddModel( gfl::fs::ArcFile * af, u32 datIdx, Heap * heap, u32 id = ADD_MODEL_ID_FREE, const ANIME_DATA * anm = NULL, u32 anmMax = 0 );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		f폜
	 *
	 * @param		id		fID
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DelModel( u32 id );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fAjύX
	 *
	 * @param		id			fID
	 * @param		anmNo		Ajԍ
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void ChangeModelAnime( u32 id, u32 anmNo, Heap * heap );

private:

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		G3DVXe쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSystem( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		G3DVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateCamera( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteCamera(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Cg쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLight( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Cg폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLight(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		V[쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateScene( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		V[폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteScene(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		V[ZbgAbv
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetupScene(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		V[CjVCY
	 *
	 * @param		none
	 *
	 * @return	none
	 *
	 * @li	fǉȂǂɌĂԂ
	 */
	//--------------------------------------------------------------------------------------------
	void InitializeScene(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		f[N쐬
	 *
	 * @param		heap		q[v
	 * @param		max			ő쐬
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateModelWork( Heap * heap, u32 max );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		f[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteModelWork(void);

private:
	gfl::grp::GraphicsSystem * pGraSystem;		// OtBbNVXe

	gfl::grp::g3d::System * pG3dSystem;							// 3DVXe
	gfl::grp::g3d::StereoCamera * pG3dCameraUpper;	// ʃJ
	gfl::grp::g3d::StereoCamera * pG3dCameraLower;	// ʃJ
#if 0
	gfl::grp::g3d::Resource * pG3dCameraResUpper;		// ʃJ\[X
	gfl::grp::g3d::Resource * pG3dCameraResLower;		// ʃJ\[X
	gfl::grp::g3d::ResAnim * pG3dCameraAnmUpper;		// ʃJAj
	gfl::grp::g3d::ResAnim * pG3dCameraAnmLower;		// ʃJAj
#endif

	gfl::grp::g3d::Light * pG3dLight;					// Cg
	gfl::grp::g3d::Resource * pG3dLightRes;		// Cg\[X

	gfl::grp::g3d::Scene * pG3dScene;								// V[
	gfl::grp::g3d::Resource * pG3dEnvironmentRes;		// f[^\[X

	// fAj[N
	typedef struct {
		gfl::grp::g3d::ResAnim * pG3dAnm;				// Aj
		gfl::grp::g3d::Resource * pG3dAnmRes;		// Aj\[X
	}MODEL_ANM_WORK;

	// f[N
	typedef struct {
		gfl::grp::g3d::Model * pG3dModel;					// ff[^
		gfl::grp::g3d::Resource * pG3dModelRes;		// f\[X
		MODEL_ANM_WORK * mtsAnm;		// }eAAj[N
		MODEL_ANM_WORK * sklAnm;		// XP^Aj[N
		u32	anmMax;									// Aj
		u32	maxAnmCount;						// Ajvfől
	}MODEL_WORK;

	MODEL_WORK * modelWk;		// f[N
	u32	modelMax;						// f
};



}	// temp
}	// app
