//============================================================================================
/**
 * @file		temp_2d.cpp
 * @brief		2D֘A
 * @author	Game Freak inc.
 * @date		11.07.11
 *
 * namespace	app::temp::
 */
//============================================================================================
#include "temp_2d.h"
//#include "message/message.gaix"
//#include "message/msg_temp.h"


namespace app {
namespace temp {

//============================================================================================
//	萔`
//============================================================================================
#define	LYTSYS_SETUP_RES_MAX	( 128 )		// CAEgVXe̊Ǘ\[Xő吔
#define	LYTSYS_SETUP_WORK_MAX	( 10 )		// CAEgVXe̊Ǘ[Nő吔


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		gra			OtBbNVXe
 * @param		lytMax	CAEg[Nő吔
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
G2DSystem::G2DSystem( gfl::grp::GraphicsSystem * gra, u32 lytMax, Heap * heap ) :
	pGraSystem( gra )
{
	CreateMessageData( heap );
	CreateLayoutSystem( heap );
	CreateLayoutEnv( heap );
	CreateLayoutWork( lytMax, heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
G2DSystem::~G2DSystem()
{
	DeleteLayoutWork();
	DeleteLayoutEnv();
	DeleteLayoutSystem();
	DeleteMessageData();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg`
 *
 * @param		id		`悷郌CAEgID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::Draw( u32 id )
{
	if(	pLayoutWork[id].setupDisp == SETUP_UPPER ){
		gfl::grp::RenderTarget * upperFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
		gfl::grp::RenderTarget * rightFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );

		pLayoutWork[id].pLytWk->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER, upperFrame, rightFrame );
	}else{
		gfl::grp::RenderTarget * lowerFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

		pLayoutWork[id].pLytWk->Draw( pGraSystem, gfl::grp::DISPLAY_LOWER, lowerFrame );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutSystem( Heap * heap )
{
	const gfl::grp::g2d::LytSysSetUp setup = {
		LYTSYS_SETUP_RES_MAX,			// Ǘ\[Xő吔
		LYTSYS_SETUP_WORK_MAX			// ǗCAEg[Nő吔
	};
	pLayoutSystem = GFL_NEW( heap->Get() )	gfl::grp::g2d::LytSys( &setup, heap->GetAllocator(), heap->GetDeviceAllocator() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutSystem(void)
{
	GFL_DELETE	pLayoutSystem;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutEnv( Heap * heap )
{
	// ˉeݒiˉej
	const gfl::grp::ProjectionParam projection[] =
	{
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -200.0f, 200.0f, -120.0f, 120.0f },
			0.1f,
			800.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		},
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -160.0f, 160.0f, -120.0f, 120.0f },
			0.1f,
			800.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		}
	};
	// r[ݒ
	const gfl::grp::ViewParam view[] =
	{
		{	// ʁiځj
			gfl::math::VEC3(0,0,1),		// JW
			gfl::math::VEC3(0,1,0),		// 
			gfl::math::VEC3(0,0,0),		// ^[QbgW
		},
		{	// ʁiEځj
			gfl::math::VEC3(10,0,1),	// JW
			gfl::math::VEC3(0,1,0),		// 
			gfl::math::VEC3(10,0,0),	// ^[QbgW
		},
		{	// 
			gfl::math::VEC3(0,-290,1),	// JW
			gfl::math::VEC3(0,1,0),			// 
			gfl::math::VEC3(0,-290,0),	// ^[QbgW
		},
	};

	// 
	pUpperLayoutEnv = GFL_NEW( heap->Get() )	gfl::grp::g2d::Env();
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[0], view[0] );
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[0], view[1] );
	// 
	pLowerLayoutEnv = GFL_NEW( heap->Get() )	gfl::grp::g2d::Env();
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[1], view[2] );
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[1], view[2] );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutEnv(void)
{
	GFL_DELETE	pUpperLayoutEnv;
	GFL_DELETE	pLowerLayoutEnv;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		lytMax		쐬
 * @param		heap			q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutWork( u32 lytMax, Heap * heap )
{
/*
	{	// \[Xǂݍ
		gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_TEMP_GRA );
		layoutResID = pLayoutSystem->LoadLytRes( heap->GetDeviceAllocator(), af, 0 );
		GFL_DELETE af;
	}

	// FCRAMɃeNX`]
	pLayoutSystem->TransferAllTexture( layoutResID, gfl::grp::MEMORY_AREA_FCRAM );
*/

	pLayoutWork = GFL_NEW( heap->Get() )	LAYOUT_WORK[lytMax];
	lwkMax = lytMax;



#if 0
	{	// \[Xǂݍ
		gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_TEMP_GRA );
		layoutResID = pLayoutSystem->LoadLytRes( heap->GetDeviceAllocator(), af, 0 );
		GFL_DELETE af;
	}

	// FCRAMɃeNX`]
	pLayoutSystem->TransferAllTexture( layoutResID, gfl::grp::MEMORY_AREA_FCRAM );

	// [N쐬
	const gfl::grp::g2d::LytWkSetUp setup[] =
	{
		{	// 
			gfl::math::VEC3(0,0,0),		// pos
			gfl::math::VEC2(1,1),			// scale
			gfl::math::VEC3(0,0,0),		// rotate
			1,												// priority
		},
		{	// 
			gfl::math::VEC3(0,-290,0),	// pos
			gfl::math::VEC2(1,1),				// scale
			gfl::math::VEC3(0,0,0),			// rotate
			1,													// priority
		}
	};

	// Aj
	const gfl::grp::g2d::LytArcIndex anmIndex[] = {
		LYTRES_NAKAHIRO_TEST_RES_UPPER_BCLAN,
	};

	pUpperLayoutWork = pLayoutSystem->CreateLytWk(
											layoutResID,
											LYTRES_NAKAHIRO_TEST_RES_UPPER_BCLYT,
											anmIndex, NELEMS(anmIndex), NELEMS(anmIndex),
											&setup[0] );
	pLowerLayoutWork = pLayoutSystem->CreateLytWk(
											layoutResID,
											LYTRES_NAKAHIRO_TEST_RES_UPPER_BCLYT,
											anmIndex, NELEMS(anmIndex), NELEMS(anmIndex),
											&setup[1] );

//		pLowerLayoutWork->SetAutoDrawFlag( false );
//		pUpperLayoutWork->SetAutoAnime( ANMID_PAT, true );
#endif

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutWork(void)
{
	GFL_DELETE	[]pLayoutWork;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgݒ
 *
 * @param		dat		CAEgf[^
 * @param		id		ݒ肷郌CAEgID
 * @param		num		ݒ肷f[^iftHg = 1 j
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetLayoutWork( const LYTWK_DATA * dat, u32 id, u32 num )
{
	// [N쐬
	const gfl::grp::g2d::LytWkSetUp setup[] =
	{
		{	// 
			gfl::math::VEC3(0,0,0),		// pos
			gfl::math::VEC2(1,1),			// scale
			gfl::math::VEC3(0,0,0),		// rotate
			1,												// priority
		},
		{	// 
			gfl::math::VEC3(0,-290,0),	// pos
			gfl::math::VEC2(1,1),				// scale
			gfl::math::VEC3(0,0,0),			// rotate
			1,													// priority
		}
	};

	for( int i=id; i<id+num; i++ ){
		GFL_ASSERT( i < lwkMax );

		pLayoutWork[i].pLytWk = pLayoutSystem->CreateLytWk(
															layoutResID,
															dat[i].lytDataID,
															dat[i].anmDataIDTbl,
															dat[i].anmTblNum,
															dat[i].anmMax,
															&setup[ dat[i].setupDisp ] );

		// [NɊ֘At
		pLayoutWork[i].pLytWk->SetUserEnv( pUpperLayoutEnv, pLowerLayoutEnv );

		pLayoutWork[i].setupDisp = dat[i].setupDisp;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[W֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateMessageData( Heap * heap )
{
	gfl::heap::HeapBase * appHeap = heap->Get();

//	pMsgData = GFL_NEW( appHeap ) gfl::str::MsgData( L"rom:/message.garc", GARC_message_temp_DAT, appHeap, gfl::str::MsgData::LOAD_PART );
	pWordSet = GFL_NEW( appHeap ) WordSet( appHeap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[W֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteMessageData(void)
{
	GFL_DELETE	pWordSet;
//	GFL_DELETE	pMsgData;
}


}	// temp
}	// app
